# SPDX-License-Identifier: MIT

# This file is automatically generated by gen/solver_options.jl

Internals.set_options(::HYPRESolver, kwargs) = nothing

function Internals.set_options(solver::BiCGSTAB, kwargs)
    for (k, v) in kwargs
        if k === :ConvergenceFactorTol
            @check HYPRE_BiCGSTABSetConvergenceFactorTol(solver, v)
        elseif k === :AbsoluteTol
            @check HYPRE_ParCSRBiCGSTABSetAbsoluteTol(solver, v)
        elseif k === :Logging
            @check HYPRE_ParCSRBiCGSTABSetLogging(solver, v)
        elseif k === :MaxIter
            @check HYPRE_ParCSRBiCGSTABSetMaxIter(solver, v)
        elseif k === :MinIter
            @check HYPRE_ParCSRBiCGSTABSetMinIter(solver, v)
        elseif k === :Precond
            Internals.set_precond_defaults(v)
            Internals.set_precond(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_ParCSRBiCGSTABSetPrintLevel(solver, v)
        elseif k === :StopCrit
            @check HYPRE_ParCSRBiCGSTABSetStopCrit(solver, v)
        elseif k === :Tol
            @check HYPRE_ParCSRBiCGSTABSetTol(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.BiCGSTAB"))
        end
    end
end

function Internals.set_options(solver::BoomerAMG, kwargs)
    for (k, v) in kwargs
        if k === :ADropTol
            @check HYPRE_BoomerAMGSetADropTol(solver, v)
        elseif k === :ADropType
            @check HYPRE_BoomerAMGSetADropType(solver, v)
        elseif k === :AddLastLvl
            @check HYPRE_BoomerAMGSetAddLastLvl(solver, v)
        elseif k === :AddRelaxType
            @check HYPRE_BoomerAMGSetAddRelaxType(solver, v)
        elseif k === :AddRelaxWt
            @check HYPRE_BoomerAMGSetAddRelaxWt(solver, v)
        elseif k === :Additive
            @check HYPRE_BoomerAMGSetAdditive(solver, v)
        elseif k === :AggInterpType
            @check HYPRE_BoomerAMGSetAggInterpType(solver, v)
        elseif k === :AggNumLevels
            @check HYPRE_BoomerAMGSetAggNumLevels(solver, v)
        elseif k === :AggP12MaxElmts
            @check HYPRE_BoomerAMGSetAggP12MaxElmts(solver, v)
        elseif k === :AggP12TruncFactor
            @check HYPRE_BoomerAMGSetAggP12TruncFactor(solver, v)
        elseif k === :AggPMaxElmts
            @check HYPRE_BoomerAMGSetAggPMaxElmts(solver, v)
        elseif k === :AggTruncFactor
            @check HYPRE_BoomerAMGSetAggTruncFactor(solver, v)
        elseif k === :CGCIts
            @check HYPRE_BoomerAMGSetCGCIts(solver, v)
        elseif k === :CPoints
            @check HYPRE_BoomerAMGSetCPoints(solver, v...)
        elseif k === :CRRate
            @check HYPRE_BoomerAMGSetCRRate(solver, v)
        elseif k === :CRStrongTh
            @check HYPRE_BoomerAMGSetCRStrongTh(solver, v)
        elseif k === :CRUseCG
            @check HYPRE_BoomerAMGSetCRUseCG(solver, v)
        elseif k === :ChebyEigEst
            @check HYPRE_BoomerAMGSetChebyEigEst(solver, v)
        elseif k === :ChebyFraction
            @check HYPRE_BoomerAMGSetChebyFraction(solver, v)
        elseif k === :ChebyOrder
            @check HYPRE_BoomerAMGSetChebyOrder(solver, v)
        elseif k === :ChebyScale
            @check HYPRE_BoomerAMGSetChebyScale(solver, v)
        elseif k === :ChebyVariant
            @check HYPRE_BoomerAMGSetChebyVariant(solver, v)
        elseif k === :CoarsenCutFactor
            @check HYPRE_BoomerAMGSetCoarsenCutFactor(solver, v)
        elseif k === :CoarsenType
            @check HYPRE_BoomerAMGSetCoarsenType(solver, v)
        elseif k === :ConvergeType
            @check HYPRE_BoomerAMGSetConvergeType(solver, v)
        elseif k === :CoordDim
            @check HYPRE_BoomerAMGSetCoordDim(solver, v)
        elseif k === :Coordinates
            @check HYPRE_BoomerAMGSetCoordinates(solver, v)
        elseif k === :CpointsToKeep
            @check HYPRE_BoomerAMGSetCpointsToKeep(solver, v...)
        elseif k === :CycleNumSweeps
            @check HYPRE_BoomerAMGSetCycleNumSweeps(solver, v...)
        elseif k === :CycleRelaxType
            @check HYPRE_BoomerAMGSetCycleRelaxType(solver, v...)
        elseif k === :CycleType
            @check HYPRE_BoomerAMGSetCycleType(solver, v)
        elseif k === :DebugFlag
            @check HYPRE_BoomerAMGSetDebugFlag(solver, v)
        elseif k === :DofFunc
            @check HYPRE_BoomerAMGSetDofFunc(solver, v)
        elseif k === :DomainType
            @check HYPRE_BoomerAMGSetDomainType(solver, v)
        elseif k === :DropTol
            @check HYPRE_BoomerAMGSetDropTol(solver, v)
        elseif k === :EuBJ
            @check HYPRE_BoomerAMGSetEuBJ(solver, v)
        elseif k === :EuLevel
            @check HYPRE_BoomerAMGSetEuLevel(solver, v)
        elseif k === :EuSparseA
            @check HYPRE_BoomerAMGSetEuSparseA(solver, v)
        elseif k === :EuclidFile
            @check HYPRE_BoomerAMGSetEuclidFile(solver, v)
        elseif k === :FCycle
            @check HYPRE_BoomerAMGSetFCycle(solver, v)
        elseif k === :FPoints
            @check HYPRE_BoomerAMGSetFPoints(solver, v...)
        elseif k === :Filter
            @check HYPRE_BoomerAMGSetFilter(solver, v)
        elseif k === :FilterThresholdR
            @check HYPRE_BoomerAMGSetFilterThresholdR(solver, v)
        elseif k === :GMRESSwitchR
            @check HYPRE_BoomerAMGSetGMRESSwitchR(solver, v)
        elseif k === :GSMG
            @check HYPRE_BoomerAMGSetGSMG(solver, v)
        elseif k === :GridRelaxPoints
            @check HYPRE_BoomerAMGSetGridRelaxPoints(solver, v)
        elseif k === :GridRelaxType
            @check HYPRE_BoomerAMGSetGridRelaxType(solver, v)
        elseif k === :ILUDroptol
            @check HYPRE_BoomerAMGSetILUDroptol(solver, v)
        elseif k === :ILULevel
            @check HYPRE_BoomerAMGSetILULevel(solver, v)
        elseif k === :ILUMaxIter
            @check HYPRE_BoomerAMGSetILUMaxIter(solver, v)
        elseif k === :ILUMaxRowNnz
            @check HYPRE_BoomerAMGSetILUMaxRowNnz(solver, v)
        elseif k === :ILUType
            @check HYPRE_BoomerAMGSetILUType(solver, v)
        elseif k === :ISType
            @check HYPRE_BoomerAMGSetISType(solver, v)
        elseif k === :InterpType
            @check HYPRE_BoomerAMGSetInterpType(solver, v)
        elseif k === :InterpVecAbsQTrunc
            @check HYPRE_BoomerAMGSetInterpVecAbsQTrunc(solver, v)
        elseif k === :InterpVecQMax
            @check HYPRE_BoomerAMGSetInterpVecQMax(solver, v)
        elseif k === :InterpVecVariant
            @check HYPRE_BoomerAMGSetInterpVecVariant(solver, v)
        elseif k === :InterpVectors
            @check HYPRE_BoomerAMGSetInterpVectors(solver, v...)
        elseif k === :IsTriangular
            @check HYPRE_BoomerAMGSetIsTriangular(solver, v)
        elseif k === :IsolatedFPoints
            @check HYPRE_BoomerAMGSetIsolatedFPoints(solver, v...)
        elseif k === :JacobiTruncThreshold
            @check HYPRE_BoomerAMGSetJacobiTruncThreshold(solver, v)
        elseif k === :KeepSameSign
            @check HYPRE_BoomerAMGSetKeepSameSign(solver, v)
        elseif k === :KeepTranspose
            @check HYPRE_BoomerAMGSetKeepTranspose(solver, v)
        elseif k === :Level
            @check HYPRE_BoomerAMGSetLevel(solver, v)
        elseif k === :LevelNonGalerkinTol
            @check HYPRE_BoomerAMGSetLevelNonGalerkinTol(solver, v...)
        elseif k === :LevelOuterWt
            @check HYPRE_BoomerAMGSetLevelOuterWt(solver, v...)
        elseif k === :LevelRelaxWt
            @check HYPRE_BoomerAMGSetLevelRelaxWt(solver, v...)
        elseif k === :Logging
            @check HYPRE_BoomerAMGSetLogging(solver, v)
        elseif k === :MaxCoarseSize
            @check HYPRE_BoomerAMGSetMaxCoarseSize(solver, v)
        elseif k === :MaxIter
            @check HYPRE_BoomerAMGSetMaxIter(solver, v)
        elseif k === :MaxLevels
            @check HYPRE_BoomerAMGSetMaxLevels(solver, v)
        elseif k === :MaxNzPerRow
            @check HYPRE_BoomerAMGSetMaxNzPerRow(solver, v)
        elseif k === :MaxRowSum
            @check HYPRE_BoomerAMGSetMaxRowSum(solver, v)
        elseif k === :MeasureType
            @check HYPRE_BoomerAMGSetMeasureType(solver, v)
        elseif k === :MinCoarseSize
            @check HYPRE_BoomerAMGSetMinCoarseSize(solver, v)
        elseif k === :MinIter
            @check HYPRE_BoomerAMGSetMinIter(solver, v)
        elseif k === :ModuleRAP2
            @check HYPRE_BoomerAMGSetModuleRAP2(solver, v)
        elseif k === :MultAddPMaxElmts
            @check HYPRE_BoomerAMGSetMultAddPMaxElmts(solver, v)
        elseif k === :MultAddTruncFactor
            @check HYPRE_BoomerAMGSetMultAddTruncFactor(solver, v)
        elseif k === :MultAdditive
            @check HYPRE_BoomerAMGSetMultAdditive(solver, v)
        elseif k === :Nodal
            @check HYPRE_BoomerAMGSetNodal(solver, v)
        elseif k === :NodalDiag
            @check HYPRE_BoomerAMGSetNodalDiag(solver, v)
        elseif k === :NonGalerkTol
            @check HYPRE_BoomerAMGSetNonGalerkTol(solver, v...)
        elseif k === :NonGalerkinTol
            @check HYPRE_BoomerAMGSetNonGalerkinTol(solver, v)
        elseif k === :NumCRRelaxSteps
            @check HYPRE_BoomerAMGSetNumCRRelaxSteps(solver, v)
        elseif k === :NumFunctions
            @check HYPRE_BoomerAMGSetNumFunctions(solver, v)
        elseif k === :NumGridSweeps
            @check HYPRE_BoomerAMGSetNumGridSweeps(solver, v)
        elseif k === :NumPaths
            @check HYPRE_BoomerAMGSetNumPaths(solver, v)
        elseif k === :NumSamples
            @check HYPRE_BoomerAMGSetNumSamples(solver, v)
        elseif k === :NumSweeps
            @check HYPRE_BoomerAMGSetNumSweeps(solver, v)
        elseif k === :OldDefault
            @check HYPRE_BoomerAMGSetOldDefault(solver)
        elseif k === :Omega
            @check HYPRE_BoomerAMGSetOmega(solver, v)
        elseif k === :OuterWt
            @check HYPRE_BoomerAMGSetOuterWt(solver, v)
        elseif k === :Overlap
            @check HYPRE_BoomerAMGSetOverlap(solver, v)
        elseif k === :PMaxElmts
            @check HYPRE_BoomerAMGSetPMaxElmts(solver, v)
        elseif k === :PlotFileName
            @check HYPRE_BoomerAMGSetPlotFileName(solver, v)
        elseif k === :PlotGrids
            @check HYPRE_BoomerAMGSetPlotGrids(solver, v)
        elseif k === :PostInterpType
            @check HYPRE_BoomerAMGSetPostInterpType(solver, v)
        elseif k === :PrintFileName
            @check HYPRE_BoomerAMGSetPrintFileName(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_BoomerAMGSetPrintLevel(solver, v)
        elseif k === :RAP2
            @check HYPRE_BoomerAMGSetRAP2(solver, v)
        elseif k === :Redundant
            @check HYPRE_BoomerAMGSetRedundant(solver, v)
        elseif k === :RelaxOrder
            @check HYPRE_BoomerAMGSetRelaxOrder(solver, v)
        elseif k === :RelaxType
            @check HYPRE_BoomerAMGSetRelaxType(solver, v)
        elseif k === :RelaxWeight
            @check HYPRE_BoomerAMGSetRelaxWeight(solver, v)
        elseif k === :RelaxWt
            @check HYPRE_BoomerAMGSetRelaxWt(solver, v)
        elseif k === :Restriction
            @check HYPRE_BoomerAMGSetRestriction(solver, v)
        elseif k === :SCommPkgSwitch
            @check HYPRE_BoomerAMGSetSCommPkgSwitch(solver, v)
        elseif k === :Sabs
            @check HYPRE_BoomerAMGSetSabs(solver, v)
        elseif k === :SchwarzRlxWeight
            @check HYPRE_BoomerAMGSetSchwarzRlxWeight(solver, v)
        elseif k === :SchwarzUseNonSymm
            @check HYPRE_BoomerAMGSetSchwarzUseNonSymm(solver, v)
        elseif k === :SepWeight
            @check HYPRE_BoomerAMGSetSepWeight(solver, v)
        elseif k === :SeqThreshold
            @check HYPRE_BoomerAMGSetSeqThreshold(solver, v)
        elseif k === :Simple
            @check HYPRE_BoomerAMGSetSimple(solver, v)
        elseif k === :SmoothNumLevels
            @check HYPRE_BoomerAMGSetSmoothNumLevels(solver, v)
        elseif k === :SmoothNumSweeps
            @check HYPRE_BoomerAMGSetSmoothNumSweeps(solver, v)
        elseif k === :SmoothType
            @check HYPRE_BoomerAMGSetSmoothType(solver, v)
        elseif k === :StrongThreshold
            @check HYPRE_BoomerAMGSetStrongThreshold(solver, v)
        elseif k === :StrongThresholdR
            @check HYPRE_BoomerAMGSetStrongThresholdR(solver, v)
        elseif k === :Sym
            @check HYPRE_BoomerAMGSetSym(solver, v)
        elseif k === :Threshold
            @check HYPRE_BoomerAMGSetThreshold(solver, v)
        elseif k === :Tol
            @check HYPRE_BoomerAMGSetTol(solver, v)
        elseif k === :TruncFactor
            @check HYPRE_BoomerAMGSetTruncFactor(solver, v)
        elseif k === :Variant
            @check HYPRE_BoomerAMGSetVariant(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.BoomerAMG"))
        end
    end
end

function Internals.set_options(solver::FlexGMRES, kwargs)
    for (k, v) in kwargs
        if k === :ConvergenceFactorTol
            @check HYPRE_FlexGMRESSetConvergenceFactorTol(solver, v)
        elseif k === :AbsoluteTol
            @check HYPRE_ParCSRFlexGMRESSetAbsoluteTol(solver, v)
        elseif k === :KDim
            @check HYPRE_ParCSRFlexGMRESSetKDim(solver, v)
        elseif k === :Logging
            @check HYPRE_ParCSRFlexGMRESSetLogging(solver, v)
        elseif k === :MaxIter
            @check HYPRE_ParCSRFlexGMRESSetMaxIter(solver, v)
        elseif k === :MinIter
            @check HYPRE_ParCSRFlexGMRESSetMinIter(solver, v)
        elseif k === :ModifyPC
            @check HYPRE_ParCSRFlexGMRESSetModifyPC(solver, v)
        elseif k === :Precond
            Internals.set_precond_defaults(v)
            Internals.set_precond(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_ParCSRFlexGMRESSetPrintLevel(solver, v)
        elseif k === :Tol
            @check HYPRE_ParCSRFlexGMRESSetTol(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.FlexGMRES"))
        end
    end
end

function Internals.set_options(solver::GMRES, kwargs)
    for (k, v) in kwargs
        if k === :ConvergenceFactorTol
            @check HYPRE_GMRESSetConvergenceFactorTol(solver, v)
        elseif k === :RelChange
            @check HYPRE_GMRESSetRelChange(solver, v)
        elseif k === :SkipRealResidualCheck
            @check HYPRE_GMRESSetSkipRealResidualCheck(solver, v)
        elseif k === :AbsoluteTol
            @check HYPRE_ParCSRGMRESSetAbsoluteTol(solver, v)
        elseif k === :KDim
            @check HYPRE_ParCSRGMRESSetKDim(solver, v)
        elseif k === :Logging
            @check HYPRE_ParCSRGMRESSetLogging(solver, v)
        elseif k === :MaxIter
            @check HYPRE_ParCSRGMRESSetMaxIter(solver, v)
        elseif k === :MinIter
            @check HYPRE_ParCSRGMRESSetMinIter(solver, v)
        elseif k === :Precond
            Internals.set_precond_defaults(v)
            Internals.set_precond(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_ParCSRGMRESSetPrintLevel(solver, v)
        elseif k === :StopCrit
            @check HYPRE_ParCSRGMRESSetStopCrit(solver, v)
        elseif k === :Tol
            @check HYPRE_ParCSRGMRESSetTol(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.GMRES"))
        end
    end
end

function Internals.set_options(solver::Hybrid, kwargs)
    for (k, v) in kwargs
        if k === :AbsoluteTol
            @check HYPRE_ParCSRHybridSetAbsoluteTol(solver, v)
        elseif k === :AggInterpType
            @check HYPRE_ParCSRHybridSetAggInterpType(solver, v)
        elseif k === :AggNumLevels
            @check HYPRE_ParCSRHybridSetAggNumLevels(solver, v)
        elseif k === :CoarsenType
            @check HYPRE_ParCSRHybridSetCoarsenType(solver, v)
        elseif k === :ConvergenceTol
            @check HYPRE_ParCSRHybridSetConvergenceTol(solver, v)
        elseif k === :CycleNumSweeps
            @check HYPRE_ParCSRHybridSetCycleNumSweeps(solver, v...)
        elseif k === :CycleRelaxType
            @check HYPRE_ParCSRHybridSetCycleRelaxType(solver, v...)
        elseif k === :CycleType
            @check HYPRE_ParCSRHybridSetCycleType(solver, v)
        elseif k === :DSCGMaxIter
            @check HYPRE_ParCSRHybridSetDSCGMaxIter(solver, v)
        elseif k === :DofFunc
            @check HYPRE_ParCSRHybridSetDofFunc(solver, v)
        elseif k === :GridRelaxPoints
            @check HYPRE_ParCSRHybridSetGridRelaxPoints(solver, v)
        elseif k === :GridRelaxType
            @check HYPRE_ParCSRHybridSetGridRelaxType(solver, v)
        elseif k === :InterpType
            @check HYPRE_ParCSRHybridSetInterpType(solver, v)
        elseif k === :KDim
            @check HYPRE_ParCSRHybridSetKDim(solver, v)
        elseif k === :KeepTranspose
            @check HYPRE_ParCSRHybridSetKeepTranspose(solver, v)
        elseif k === :LevelOuterWt
            @check HYPRE_ParCSRHybridSetLevelOuterWt(solver, v...)
        elseif k === :LevelRelaxWt
            @check HYPRE_ParCSRHybridSetLevelRelaxWt(solver, v...)
        elseif k === :Logging
            @check HYPRE_ParCSRHybridSetLogging(solver, v)
        elseif k === :MaxCoarseSize
            @check HYPRE_ParCSRHybridSetMaxCoarseSize(solver, v)
        elseif k === :MaxLevels
            @check HYPRE_ParCSRHybridSetMaxLevels(solver, v)
        elseif k === :MaxRowSum
            @check HYPRE_ParCSRHybridSetMaxRowSum(solver, v)
        elseif k === :MeasureType
            @check HYPRE_ParCSRHybridSetMeasureType(solver, v)
        elseif k === :MinCoarseSize
            @check HYPRE_ParCSRHybridSetMinCoarseSize(solver, v)
        elseif k === :Nodal
            @check HYPRE_ParCSRHybridSetNodal(solver, v)
        elseif k === :NonGalerkinTol
            @check HYPRE_ParCSRHybridSetNonGalerkinTol(solver, v...)
        elseif k === :NumFunctions
            @check HYPRE_ParCSRHybridSetNumFunctions(solver, v)
        elseif k === :NumGridSweeps
            @check HYPRE_ParCSRHybridSetNumGridSweeps(solver, v)
        elseif k === :NumPaths
            @check HYPRE_ParCSRHybridSetNumPaths(solver, v)
        elseif k === :NumSweeps
            @check HYPRE_ParCSRHybridSetNumSweeps(solver, v)
        elseif k === :Omega
            @check HYPRE_ParCSRHybridSetOmega(solver, v)
        elseif k === :OuterWt
            @check HYPRE_ParCSRHybridSetOuterWt(solver, v)
        elseif k === :PCGMaxIter
            @check HYPRE_ParCSRHybridSetPCGMaxIter(solver, v)
        elseif k === :PMaxElmts
            @check HYPRE_ParCSRHybridSetPMaxElmts(solver, v)
        elseif k === :Precond
            Internals.set_precond_defaults(v)
            Internals.set_precond(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_ParCSRHybridSetPrintLevel(solver, v)
        elseif k === :RecomputeResidual
            @check HYPRE_ParCSRHybridSetRecomputeResidual(solver, v)
        elseif k === :RecomputeResidualP
            @check HYPRE_ParCSRHybridSetRecomputeResidualP(solver, v)
        elseif k === :RelChange
            @check HYPRE_ParCSRHybridSetRelChange(solver, v)
        elseif k === :RelaxOrder
            @check HYPRE_ParCSRHybridSetRelaxOrder(solver, v)
        elseif k === :RelaxType
            @check HYPRE_ParCSRHybridSetRelaxType(solver, v)
        elseif k === :RelaxWeight
            @check HYPRE_ParCSRHybridSetRelaxWeight(solver, v)
        elseif k === :RelaxWt
            @check HYPRE_ParCSRHybridSetRelaxWt(solver, v)
        elseif k === :SeqThreshold
            @check HYPRE_ParCSRHybridSetSeqThreshold(solver, v)
        elseif k === :SetupType
            @check HYPRE_ParCSRHybridSetSetupType(solver, v)
        elseif k === :SolverType
            @check HYPRE_ParCSRHybridSetSolverType(solver, v)
        elseif k === :StopCrit
            @check HYPRE_ParCSRHybridSetStopCrit(solver, v)
        elseif k === :StrongThreshold
            @check HYPRE_ParCSRHybridSetStrongThreshold(solver, v)
        elseif k === :Tol
            @check HYPRE_ParCSRHybridSetTol(solver, v)
        elseif k === :TruncFactor
            @check HYPRE_ParCSRHybridSetTruncFactor(solver, v)
        elseif k === :TwoNorm
            @check HYPRE_ParCSRHybridSetTwoNorm(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.Hybrid"))
        end
    end
end

function Internals.set_options(solver::ILU, kwargs)
    for (k, v) in kwargs
        if k === :DropThreshold
            @check HYPRE_ILUSetDropThreshold(solver, v)
        elseif k === :DropThresholdArray
            @check HYPRE_ILUSetDropThresholdArray(solver, v)
        elseif k === :LevelOfFill
            @check HYPRE_ILUSetLevelOfFill(solver, v)
        elseif k === :LocalReordering
            @check HYPRE_ILUSetLocalReordering(solver, v)
        elseif k === :Logging
            @check HYPRE_ILUSetLogging(solver, v)
        elseif k === :MaxIter
            @check HYPRE_ILUSetMaxIter(solver, v)
        elseif k === :MaxNnzPerRow
            @check HYPRE_ILUSetMaxNnzPerRow(solver, v)
        elseif k === :NSHDropThreshold
            @check HYPRE_ILUSetNSHDropThreshold(solver, v)
        elseif k === :NSHDropThresholdArray
            @check HYPRE_ILUSetNSHDropThresholdArray(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_ILUSetPrintLevel(solver, v)
        elseif k === :SchurMaxIter
            @check HYPRE_ILUSetSchurMaxIter(solver, v)
        elseif k === :Tol
            @check HYPRE_ILUSetTol(solver, v)
        elseif k === :Type
            @check HYPRE_ILUSetType(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.ILU"))
        end
    end
end

function Internals.set_options(solver::ParaSails, kwargs)
    for (k, v) in kwargs
        if k === :Filter
            @check HYPRE_ParCSRParaSailsSetFilter(solver, v)
        elseif k === :Loadbal
            @check HYPRE_ParCSRParaSailsSetLoadbal(solver, v)
        elseif k === :Logging
            @check HYPRE_ParCSRParaSailsSetLogging(solver, v)
        elseif k === :Params
            @check HYPRE_ParCSRParaSailsSetParams(solver, v...)
        elseif k === :Reuse
            @check HYPRE_ParCSRParaSailsSetReuse(solver, v)
        elseif k === :Sym
            @check HYPRE_ParCSRParaSailsSetSym(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.ParaSails"))
        end
    end
end

function Internals.set_options(solver::PCG, kwargs)
    for (k, v) in kwargs
        if k === :AbsoluteTolFactor
            @check HYPRE_PCGSetAbsoluteTolFactor(solver, v)
        elseif k === :ConvergenceFactorTol
            @check HYPRE_PCGSetConvergenceFactorTol(solver, v)
        elseif k === :RecomputeResidual
            @check HYPRE_PCGSetRecomputeResidual(solver, v)
        elseif k === :RecomputeResidualP
            @check HYPRE_PCGSetRecomputeResidualP(solver, v)
        elseif k === :ResidualTol
            @check HYPRE_PCGSetResidualTol(solver, v)
        elseif k === :AbsoluteTol
            @check HYPRE_ParCSRPCGSetAbsoluteTol(solver, v)
        elseif k === :Logging
            @check HYPRE_ParCSRPCGSetLogging(solver, v)
        elseif k === :MaxIter
            @check HYPRE_ParCSRPCGSetMaxIter(solver, v)
        elseif k === :Precond
            Internals.set_precond_defaults(v)
            Internals.set_precond(solver, v)
        elseif k === :PrintLevel
            @check HYPRE_ParCSRPCGSetPrintLevel(solver, v)
        elseif k === :RelChange
            @check HYPRE_ParCSRPCGSetRelChange(solver, v)
        elseif k === :StopCrit
            @check HYPRE_ParCSRPCGSetStopCrit(solver, v)
        elseif k === :Tol
            @check HYPRE_ParCSRPCGSetTol(solver, v)
        elseif k === :TwoNorm
            @check HYPRE_ParCSRPCGSetTwoNorm(solver, v)
        else
            throw(ArgumentError("unknown option $k for HYPRE.PCG"))
        end
    end
end
