# HYPRE.jl changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v1.7.0] - 2024-10-09
### Changed
 - Support for Julia 1.6 have been dropped and for this and future releases Julia 1.10 or
   later will be required. ([#27])
 - Constant struct fields of `HYPREMatrix` and `HYPREVector` are now marked with `const`.
   ([#28])

## [v1.6.0] - 2024-09-29
### Changed
 - PartitionedArrays.jl dependency upgraded from release series 0.3.x to release series
   0.5.x. ([#17], [#18])
 - CEnum.jl dependency upgraded to release series 0.5.x (release series 0.4.x still
   allowed). ([#17], [#18])
 - PartitionedArrays.jl support (`PSparseMatrix`, `PVector`) is now provided by a package
   extension. ([#23])
 - SparseMatricesCSR.jl support (`SparseMatrixCSR`) is now provided by a package extension.
   ([#24])
 - SparseArrays.jl support (`SparseMatrixCSC`) is now provided by a package extension.
   ([#25])

## [v1.5.0] - 2023-05-26
### Changed
 - PartitionedArrays.jl dependency upgraded from version 0.2.x to version 0.3.x.
   ([#16])

## [v1.4.0] - 2023-01-20
### Added
 - New function `HYPRE.GetFinalRelativeResidualNorm(s::HYPRESolver)` for getting the final
   residual norm from a solver. This function dispatches on the solver to the corresponding
   C API wrapper `LibHYPRE.HYPRE_${Solver}GetFinalRelativeResidualNorm`. ([#14])
 - New function `HYPRE.GetNumIterations(s::HYPRESolver)` for getting the number of
   iterations from a solver. This function dispatches on the solver to the corresponding C
   API wrapper `LibHYPRE.HYPRE_${Solver}GetNumIterations`. ([#14])

## [v1.3.1] - 2023-01-14
### Fixed
 - Solvers now keep an reference to the added preconditioner to make sure the preconditioner
   is not finalized before the solver. This fixes crashes (segfaults) that could happen in
   case no other reference to the preconditioner existed in the program. ([#12])
 - The proper conversion methods for `ccall` are now defined for `HYPREMatrix`,
   `HYPREVector`, and `HYPRESolver` such that they can be passed direcly to `HYPRE_*`
   functions and let `ccall` guarantee the GC preservation of these objects. Although not
   observed in practice, this fixes a possible race condition where the matrix/vector/solver
   could be finalized too early. ([#13])

## [v1.3.0] - 2022-12-30
### Added
 - Rectangular matrices can now be assembled by the new method
   `HYPRE.assemble!(::HYPREMatrixAssembler, i::Vector, j::Vector, a::Matrix)` where `i` are
   the rows and `j` the columns. ([#7])
### Fixed
 - All created HYPRE objects (`HYPREMatrix`, `HYPREVector`, and `HYPRESolver`s) are now kept
   track of internally and explicitly `finalize`d (if they haven't been GC'd) before
   finalizing HYPRE. This fixes a "race condition" where MPI and/or HYPRE would finalize
   before these Julia objects are garbage collected and finalized. ([#8])
### Deprecated
 - The method `HYPRE.assemble!(A::HYPREMatrixAssembler, ij::Vector, a::Matrix)` have been
   deprecated in favor of `HYPRE.assemble!(A::HYPREMatrixAssembler, i::Vector, j::Vector,
   a::Matrix)`, i.e. it is now required to explicitly pass rows and column indices
   individually. The motivation behind this is to support assembling of rectangular
   matrices. Note that `HYPRE.assemble!(A::HYPREAssembler, ij::Vector, a::Matrix,
   b::Vector)` is still supported, where `ij` are used as row and column indices for `a`, as
   well as row indices for `b`. ([#6])

## [v1.2.0] - 2022-10-12
### Added
 - Added assembler interface to assemble `HYPREMatrix` and/or `HYPREVector` directly without
   an intermediate sparse structure in Julia. ([#5])

## [v1.1.0] - 2022-10-05
### Added
 - Added support for MPI.jl version 0.20.x (in addition to the existing version 0.19.x
   support). ([#2])

## [v1.0.0] - 2022-07-28
Initial release of HYPRE.jl.


<!-- Links generated by Changelog.jl -->

[v1.0.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.0.0
[v1.1.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.1.0
[v1.2.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.2.0
[v1.3.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.3.0
[v1.3.1]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.3.1
[v1.4.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.4.0
[v1.5.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.5.0
[v1.6.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.6.0
[v1.7.0]: https://github.com/fredrikekre/HYPRE.jl/releases/tag/v1.7.0
[#2]: https://github.com/fredrikekre/HYPRE.jl/issues/2
[#5]: https://github.com/fredrikekre/HYPRE.jl/issues/5
[#6]: https://github.com/fredrikekre/HYPRE.jl/issues/6
[#7]: https://github.com/fredrikekre/HYPRE.jl/issues/7
[#8]: https://github.com/fredrikekre/HYPRE.jl/issues/8
[#12]: https://github.com/fredrikekre/HYPRE.jl/issues/12
[#13]: https://github.com/fredrikekre/HYPRE.jl/issues/13
[#14]: https://github.com/fredrikekre/HYPRE.jl/issues/14
[#16]: https://github.com/fredrikekre/HYPRE.jl/issues/16
[#17]: https://github.com/fredrikekre/HYPRE.jl/issues/17
[#18]: https://github.com/fredrikekre/HYPRE.jl/issues/18
[#23]: https://github.com/fredrikekre/HYPRE.jl/issues/23
[#24]: https://github.com/fredrikekre/HYPRE.jl/issues/24
[#25]: https://github.com/fredrikekre/HYPRE.jl/issues/25
[#27]: https://github.com/fredrikekre/HYPRE.jl/issues/27
[#28]: https://github.com/fredrikekre/HYPRE.jl/issues/28
