bothat_ref(img, dims, r) = bothat_ref(img, strel_box(img, dims; r))
bothat_ref(img, se) = float.(closing(img, se)) - float.(img)

@testset "bothat" begin
    test_ranges = [Bool, 1:10, Float64, Gray{N0f8}, Gray{Float64}]
    for T in test_ranges
        for N in (1, 2, 3)
            sz = ntuple(_ -> 32, N)
            img = rand(T, sz...)

            out = bothat(img)
            @test out == bothat(img, strel_box(img, ntuple(identity, N); r=1))
            @test out == bothat_ref(img, ntuple(identity, N), 1)

            @test bothat(img; dims=(1,), r=2) == bothat_ref(img, (1,), 2)

            se = centered(rand(Bool, ntuple(_ -> 3, N)))
            @test bothat(img, se) == bothat_ref(img, se)
        end
    end

    img = rand(1:5, 7, 7)
    out = similar(img)
    bothat!(out, img, similar(img))
    @test out == bothat(img)

    img = rand(RGB, 7, 7)
    @test_throws ArgumentError("color image is not supported") bothat(img)
end
