var documenterSearchIndex = {"docs":
[{"location":"#LinearAlgebraX","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"This module implements basic linear algebra methods for matrices with exact entries (e.g., Rational{Int} values).  The function names typically match the standard ones in Julia but with an x (for \"exact\") appended.","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"The functions in this module work for all types of  Integer, Rational, Complex{Integer}, Complex{Rational}, and Mod entries in matrices. Other exact numbers may work as well, but are not tested. ","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"As the goal of this module is always to give exact answers and, at the same time, be type stable, the results of many of these functions are big. That is, the detx of an integer matrix returns a BigInt. ","category":"page"},{"location":"#Functions","page":"LinearAlgebraX","title":"Functions","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"These functions in this module end with the letter x and have the same definitions as their counterparts that do not have an x. For exact types (such as Ints) these functions give exact results.","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"detx – exact determinant \ncofactor_det– slower exact determinant (via cofactor expansion)\nnullspacex – exact nullspace\nrankx – exact rank\ninvx – exact inverse\nrrefx – row reduced echelon form\neye – lovingly restored\nchar_poly – characteristic polynomial\npermanent – permanent of a square matrix","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"Examples follow.","category":"page"},{"location":"#Determinant","page":"LinearAlgebraX","title":"Determinant","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> A = ones(Int,10,10)+eye(Int,10);\n\njulia> det(A)\n10.999999999999998\n\njulia> detx(A)\n11\n\njulia> A = rand(Int,20,20) .% 20;\n\njulia> det(A)\n3.3905496651565455e29\n\njulia> detx(A)\n339054966515654744413389494504","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"For certain Mod matrices, there may be noninvertible nonzero elements in which  case the Gaussian elimination algorithm may fail. If that happens, detx  falls back to using cofactor expansion which may be very slow. Should that  happen, a warning is generated.","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> using Mods\n\njulia> A = rand(Mod{10},5,5)\n5×5 Array{Mod{10},2}:\n Mod{10}(6)  Mod{10}(1)  Mod{10}(8)  Mod{10}(7)  Mod{10}(9)\n Mod{10}(6)  Mod{10}(4)  Mod{10}(6)  Mod{10}(9)  Mod{10}(0)\n Mod{10}(9)  Mod{10}(8)  Mod{10}(7)  Mod{10}(8)  Mod{10}(0)\n Mod{10}(9)  Mod{10}(1)  Mod{10}(9)  Mod{10}(1)  Mod{10}(3)\n Mod{10}(5)  Mod{10}(4)  Mod{10}(5)  Mod{10}(9)  Mod{10}(0)\n\njulia> detx(A)\n┌ Warning: Using cofactor expansion to calculate determinant; may be very slow.\n└ @ LinearAlgebraX ~/.julia/dev/LinearAlgebraX/src/detx.jl:41\nMod{10}(4)","category":"page"},{"location":"#Nullspace","page":"LinearAlgebraX","title":"Nullspace","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> A = reshape(collect(1:12),3,4)\n3×4 Array{Int64,2}:\n 1  4  7  10\n 2  5  8  11\n 3  6  9  12\n\njulia> nullspacex(A)\n4×2 Array{Rational{BigInt},2}:\n  1//1   2//1\n -2//1  -3//1\n  1//1   0//1\n  0//1   1//1\n\njulia> nullspace(A)\n4×2 Array{Float64,2}:\n -0.475185  -0.272395\n  0.430549   0.717376\n  0.564458  -0.617566\n -0.519821   0.172585","category":"page"},{"location":"#Rank","page":"LinearAlgebraX","title":"Rank","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"Consider the 12-by-12 Hibert matrix, H (see hilbert.jl in the extras folder):","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"12×12 Array{Rational{Int64},2}:\n 1//1   1//2   1//3   1//4   1//5   1//6   1//7   1//8   1//9   1//10  1//11  1//12\n 1//2   1//3   1//4   1//5   1//6   1//7   1//8   1//9   1//10  1//11  1//12  1//13\n 1//3   1//4   1//5   1//6   1//7   1//8   1//9   1//10  1//11  1//12  1//13  1//14\n 1//4   1//5   1//6   1//7   1//8   1//9   1//10  1//11  1//12  1//13  1//14  1//15\n 1//5   1//6   1//7   1//8   1//9   1//10  1//11  1//12  1//13  1//14  1//15  1//16\n 1//6   1//7   1//8   1//9   1//10  1//11  1//12  1//13  1//14  1//15  1//16  1//17\n 1//7   1//8   1//9   1//10  1//11  1//12  1//13  1//14  1//15  1//16  1//17  1//18\n 1//8   1//9   1//10  1//11  1//12  1//13  1//14  1//15  1//16  1//17  1//18  1//19\n 1//9   1//10  1//11  1//12  1//13  1//14  1//15  1//16  1//17  1//18  1//19  1//20\n 1//10  1//11  1//12  1//13  1//14  1//15  1//16  1//17  1//18  1//19  1//20  1//21\n 1//11  1//12  1//13  1//14  1//15  1//16  1//17  1//18  1//19  1//20  1//21  1//22\n 1//12  1//13  1//14  1//15  1//16  1//17  1//18  1//19  1//20  1//21  1//22  1//23","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"We compare the results of rank (from the LinearAlgebra module) and rankx (in this module):","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> rank(H)\n11\n\njulia> rankx(H)\n12","category":"page"},{"location":"#Inverse","page":"LinearAlgebraX","title":"Inverse","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> using Mods\n\njulia> A = rand(Mod{11},5,5)\n5×5 Array{Mod{11},2}:\n Mod{11}(2)   Mod{11}(4)  Mod{11}(4)  Mod{11}(0)   Mod{11}(2)\n Mod{11}(9)   Mod{11}(4)  Mod{11}(5)  Mod{11}(1)  Mod{11}(10)\n Mod{11}(3)   Mod{11}(4)  Mod{11}(5)  Mod{11}(6)   Mod{11}(0)\n Mod{11}(5)  Mod{11}(10)  Mod{11}(4)  Mod{11}(5)   Mod{11}(4)\n Mod{11}(9)  Mod{11}(10)  Mod{11}(7)  Mod{11}(8)   Mod{11}(9)\n\njulia> B = invx(A)\n5×5 Array{Mod{11},2}:\n Mod{11}(4)  Mod{11}(5)  Mod{11}(0)   Mod{11}(6)   Mod{11}(8)\n Mod{11}(7)  Mod{11}(4)  Mod{11}(9)  Mod{11}(10)   Mod{11}(3)\n Mod{11}(6)  Mod{11}(0)  Mod{11}(2)   Mod{11}(5)   Mod{11}(5)\n Mod{11}(3)  Mod{11}(4)  Mod{11}(9)  Mod{11}(10)  Mod{11}(10)\n Mod{11}(9)  Mod{11}(9)  Mod{11}(0)   Mod{11}(8)   Mod{11}(9)\n\njulia> A*B\n5×5 Array{Mod{11},2}:\n Mod{11}(1)  Mod{11}(0)  Mod{11}(0)  Mod{11}(0)  Mod{11}(0)\n Mod{11}(0)  Mod{11}(1)  Mod{11}(0)  Mod{11}(0)  Mod{11}(0)\n Mod{11}(0)  Mod{11}(0)  Mod{11}(1)  Mod{11}(0)  Mod{11}(0)\n Mod{11}(0)  Mod{11}(0)  Mod{11}(0)  Mod{11}(1)  Mod{11}(0)\n Mod{11}(0)  Mod{11}(0)  Mod{11}(0)  Mod{11}(0)  Mod{11}(1)","category":"page"},{"location":"#Characteristic-polynomial","page":"LinearAlgebraX","title":"Characteristic polynomial","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> using SimplePolynomials, LinearAlgebra\n\njulia> x = getx()\nx\n\njulia> A = triu(ones(Int,5,5))\n5×5 Array{Int64,2}:\n 1  1  1  1  1\n 0  1  1  1  1\n 0  0  1  1  1\n 0  0  0  1  1\n 0  0  0  0  1\n\njulia> char_poly(A)\n-1 + 5*x - 10*x^2 + 10*x^3 - 5*x^4 + x^5\n\njulia> ans == (x-1)^5\ntrue\n\njulia> using Mods\n\njulia> A = rand(Mod{17},4,4)\n4×4 Array{Mod{17},2}:\n Mod{17}(16)  Mod{17}(10)   Mod{17}(9)  Mod{17}(12)\n Mod{17}(15)   Mod{17}(1)   Mod{17}(1)   Mod{17}(6)\n  Mod{17}(3)   Mod{17}(2)   Mod{17}(5)  Mod{17}(11)\n  Mod{17}(5)  Mod{17}(15)  Mod{17}(15)   Mod{17}(7)\n\njulia> char_poly(A)\nMod{17}(1) + Mod{17}(1)*x + Mod{17}(16)*x^2 + Mod{17}(5)*x^3 + Mod{17}(1)*x^4\n\njulia> detx(A)\nMod{17}(1)","category":"page"},{"location":"#Row-reduced-echelon-form","page":"LinearAlgebraX","title":"Row reduced echelon form","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":" julia> A = rand(Int,4,6) .% 10\n4×6 Array{Int64,2}:\n 6   8  0  -6  -5   4\n 0  -5  2   0  -3  -4\n 0  -4  2  -8   7  -8\n 1  -3  7   2  -6   2\n\njulia> c = A[:,1] + A[:,2] - A[:,3]\n4-element Array{Int64,1}:\n 14\n -7\n -6\n -9\n\njulia> A = [c A]\n4×7 Array{Int64,2}:\n 14  6   8  0  -6  -5   4\n -7  0  -5  2   0  -3  -4\n -6  0  -4  2  -8   7  -8\n -9  1  -3  7   2  -6   2\n\njulia> rrefx(A)\n4×7 Array{Rational{Int64},2}:\n 1//1  0//1  0//1  -1//1  0//1   -23//130  -36//65\n 0//1  1//1  0//1   1//1  0//1  -883//325  158//325\n 0//1  0//1  1//1   1//1  0//1   551//650  512//325\n 0//1  0//1  0//1   0//1  1//1  -379//325  204//325","category":"page"},{"location":"#Homogeneous-Vectors","page":"LinearAlgebraX","title":"Homogeneous Vectors","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"A point in projective space is represented by a homogeneous vector. This is   a list of numbers (like an ordinary vector) but two such vectors are equal   if and only if one is a nonzero multiple of the other. ","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"We provide the HVector type to represent homogeneous vectors. The entries   in an HVector are scaled so that the last nonzero coordinate is 1.   (Technically, we should forbid the all zero vector, but we don't implement  that restriction.)","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"To create an HVector provide either a list (one-dimensional array) of values   or a list of arguments:","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":" julia> v = HVector([1,-2,3])\n[1//3 : -2//3 : 1//1]\n\njulia> w = HVector(2,-4,6)\n[1//3 : -2//3 : 1//1]\n\njulia> v==w\ntrue","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"Entries in an HVector can be retrieved individually, or the entire vector can  be converted to an array:","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> v[2]\n-2//3\n\njulia> Vector(v)\n3-element Array{Rational{Int64},1}:\n  1//3\n -2//3\n  1//1","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"However, entries cannot be assigned:","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> v[2] = 3//4\nERROR: MethodError: no method matching setindex!(::HVector{Rational{Int64}}, ::Rational{Int64}, ::Int64)","category":"page"},{"location":"#Operations-for-HVectors","page":"LinearAlgebraX","title":"Operations for HVectors","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"The product of a matrix and a homogeneous vector is a homogeneous vector:","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> A = rand(Int,3,3) .% 5\n3×3 Array{Int64,2}:\n -1   0   0\n  3   0  -2\n  3  -1  -2\n\njulia> A*v\n[1//1 : 3//1 : 1//1]\n\njulia> A*Vector(v)\n3-element Array{Rational{Int64},1}:\n -1//3\n -1//1\n -1//3","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"The dot product of two homogeneous vectors is a scalar. Since homogeneous vectors are unchanged by scaling, we only distinguish between zero and nonzero results. Specifically, the dot product is 0 if the two vectors are orthogonal and  1 otherwise. ","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> using Mods\n\njulia> u = Mod{3}(1)\nMod{3}(1)\n\njulia> v = HVector(u,u,u)\n[Mod{3}(1) : Mod{3}(1) : Mod{3}(1)]\n\njulia> dot(v,v)\n0\n\njulia> w = HVector(-1,2,1)\n[-1//1 : 2//1 : 1//1]\n\njulia> dot(v,w)\n1","category":"page"},{"location":"#Homogeneous-Matrices","page":"LinearAlgebraX","title":"Homogeneous Matrices","text":"","category":"section"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"We also provide HMatrix to represent a homogeneous matrix. These are  constructed by passing an (ordinary) matrix.","category":"page"},{"location":"","page":"LinearAlgebraX","title":"LinearAlgebraX","text":"julia> A = rand(Int,3,3).%5\n3×3 Array{Int64,2}:\n 0  -4   3\n 1   4  -2\n 3   0  -3\n\njulia> HMatrix(A)\nHMatrix: Rational{Int64}[0//1 4//3 -1//1; -1//3 -4//3 2//3; -1//1 0//1 1//1]\n\njulia> Matrix(ans)\n3×3 Array{Rational{Int64},2}:\n  0//1   4//3  -1//1\n -1//3  -4//3   2//3\n -1//1   0//1   1//1","category":"page"}]
}
