var documenterSearchIndex = {"docs":
[{"location":"#Multisets","page":"Multisets","title":"Multisets","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"A Set is an unordered collection of things in which an item may appear at most once.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"A Multiset is an unordered collection of things with repetition permitted.","category":"page"},{"location":"#Creating-a-Multiset","page":"Multisets","title":"Creating a Multiset","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> using Multisets\njulia> M = Multiset{Type}()","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"where Type is the type of elements to be held in M (e.g., Int or String). If Type is omitted, this defaults to Any.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"Given a collection list of elements (such as a Vector or Set) invoking Multiset(list) creates a new Multiset in which the elements of list appear with the appropriate multiplicity. For example, Multiset(ones(Int,3)) creates the multiset {1,1,1}.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> M = Multiset([1,1,2,3,5])\n{1,1,2,3,5}\n\njulia> M = Multiset(5,3,2,1,1)\n{1,1,2,3,5}\n\njulia> eltype(M)\nInt64","category":"page"},{"location":"#Adding/Deleting-Elements","page":"Multisets","title":"Adding/Deleting Elements","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"push!(M,x) increases the multiplicity of x in M by 1. If x is not already in M, then it is added to M.\npush!(M,x,incr) increases the multiplicity of x in M by incr. We allow incr to be negative to decrease the multiplicity of x (but not below 0).\nM[x]=m explicitly sets the multiplicty of x to m.\ndelete!(M,x) removes x from M. M[x]=0 has the same effect.","category":"page"},{"location":"#Keys/Values/Pairs","page":"Multisets","title":"Keys/Values/Pairs","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"keys(M) returns an iterator for the elements of M (that have multiplicyt at least one).\nvalues(M) returns an iterator for the multiplicities of the elements of M.\npairs(M) returns an iterator over element => multiplicity pairs for M.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> M = Multiset(\"alpha\", \"beta\", \"beta\", \"gamma\", \"gamma\", \"gamma\")\n{alpha,beta,beta,gamma,gamma,gamma}\n\njulia> collect(keys(M))\n3-element Array{String,1}:\n \"alpha\"\n \"gamma\"\n \"beta\"\n\njulia> collect(values(M))\n3-element Array{Int64,1}:\n 1\n 3\n 2\n\njulia> pairs(M)\nDict{String,Int64} with 3 entries:\n  \"alpha\" => 1\n  \"gamma\" => 3\n  \"beta\"  => 2","category":"page"},{"location":"#Access","page":"Multisets","title":"Access","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"To determine the multiplicity of x in M use M[x]. This returns 0 if x was never added to M.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"To get a list of all the elements in M, use collect:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> collect(M)\n6-element Array{Int64,1}:\n 1\n 1\n 2\n 2\n 3\n 4","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"Notice that elements are repeated per their multiplicity. To get a list of the elements in which elements appear only once each use collect(keys(M)).","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"To convert M into a Julia Set (effectively, set all multiplicities to 1) use Set(M):","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> Set(M)\nSet([4,2,3,1])","category":"page"},{"location":"#Printing","page":"Multisets","title":"Printing","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"The result of println(M) can be controlled by the following functions. Suppose a multiset is created as follows:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> M = Multiset{String}();\njulia> push!(M,\"alpha\");\njulia> push!(M,\"beta\", 2);","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"set_braces_show() causes multisets to be printed as a list enclosed in curly braces: {alpha,beta,beta}. This is the default. If the multiset is empty, ∅ is printed.\nset_short_show() causes multisets to be printed in an abbreviated format like this: Multiset{String} with 3 elements.\nset_julia_show() causes multisets to be printed in a form that would be a proper Julia definition of that multiset: Multiset(String[\"alpha\",\"beta\",\"beta\"]).\nset_key_value_show() causes multisets to be printed in a way that shows each element and its multiplicity as key-value pairs: Multiset{String}(\"alpha\" => 1, \"beta\" => 2).","category":"page"},{"location":"#Operations","page":"Multisets","title":"Operations","text":"","category":"section"},{"location":"#Union/Intersection","page":"Multisets","title":"Union/Intersection","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"The functions union and intersect compute the union and intersection of multisets. For example:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> A = Multiset(1,2,2,3)\n{1,2,2,3}\n\njulia> B = Multiset(1,1,1,2,4)\n{1,1,1,2,4}\n\njulia> union(A,B)\n{1,1,1,2,2,3,4}\n\njulia> intersect(A,B)\n{1,2}","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"The multiplicity of x in union(A,B) is max(A[x],B[x]) and the multiplicity in intersect(A,B) is min(A[x],B[x]).","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"See + below (disjoint union) which behaves differently.","category":"page"},{"location":"#Product/Sum/Difference","page":"Multisets","title":"Product/Sum/Difference","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"The Cartesian product of multisets A and B is computed with A*B. If a is an element of A and b is an element of B then the multiplicity of (a,b) in A*B is A[x]*B[x].\nFor a nonnegative integer n and a multiset A the result of n*A is a new multiset in which the multiplicy of x is n*A[x].\nThe disjoint union of A and B is computed with A+B. If a is an element of A and b is an element of B then the multiplicity of (a,b) in A*B is A[x]+B[x].\nThe difference of multisets is computed as A-B. In the result, the multiplicity of x is max(0, A[x]-B[x]). This is not the same as setdiff because setdiff(A,B) gives a multiset in which any element of B is completely removed from A.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> A = Multiset(1,1,2,3)\n{1,1,2,3}\njulia> B = Multiset(1,2)\n{1,2}\njulia> A-B\n{1,3}\njulia> setdiff(A,B)\n{3}","category":"page"},{"location":"#Cardinality","page":"Multisets","title":"Cardinality","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"The function length computes the cardinality (number of elements) in a multiset (including multiplicities).","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"The function isempty returns true exactly when length(M)==0.","category":"page"},{"location":"#Comparison","page":"Multisets","title":"Comparison","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"The operator A==B and the function issubset(A,B) are provided to determine if A and B are equal or Ais a submultiset of B. This can also be expressed as A ⊆ B or B ⊇ A. ","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"Note that A==B holds when A[x]==B[x] for all x and issubset(A,B) holds when A[x] <= B[x] for all x.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"To test if x is an element of a multiset A, one may use any of the following:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"x ∈ A\nin(x,A)\nA ∋ x\nA[x] > 0","category":"page"},{"location":"#Iteration","page":"Multisets","title":"Iteration","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"When iterating over a Multiset each element is repeated according to its  multiplicity. ","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> A = Multiset(1,2,1,2,3)\n{1,1,2,2,3}\n\njulia> for a in A\n       println(a)\n       end\n2\n2\n3\n1\n1\n\njulia> sum(A)\n9","category":"page"},{"location":"#Multisets-as-Counters","page":"Multisets","title":"Multisets as Counters","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"Multisets are useful devices for counting. For example, suppose a program reads in words from a text file and we want to count how often each word appears in that file. We can let M = Multiset{String}() and then step through the words in the file pushing each instance into M. The basic structure looks like this:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"for word in FILE\n  push!(M,word)\nend","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"In the end, M[word] will return how often word was seen in the file. See also my Counters module.","category":"page"},{"location":"#Miscellaneous","page":"Multisets","title":"Miscellaneous","text":"","category":"section"},{"location":"#Implementation","page":"Multisets","title":"Implementation","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"A Multiset consists of a single data field called data that is a dictionary mapping elements to their multiplicities. The various Multiset functions ensure the integrity of data (enforcing nonnegativity).","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"The function clean! purges the data field of any elements with multiplicity equal to 0. This is used by the hash function which is provided so a Multiset  can be used as a key in a dictionary, etc. The hash of a Multiset is simply the hash of its cleaned data field.","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"Note: The clean! function is not exported. There probably should be no reason for the user to invoke it, but if desired use Multisets.clean!(M).","category":"page"},{"location":"#Making-a-copy-of-a-Multiset","page":"Multisets","title":"Making a copy of a Multiset","text":"","category":"section"},{"location":"","page":"Multisets","title":"Multisets","text":"If A is a Multiset, then B=A assigns B to be the same object as A. That is, any changes to one affects the other:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> A = Multiset(1,1,2,3,5)\n{1,1,2,3,5}\njulia> B = A\n{1,1,2,3,5}\njulia> A[8]=2;\n\njulia> A\n{1,1,2,3,5,8,8}\njulia> B\n{1,1,2,3,5,8,8}","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"To make an independent copy, use copy or deepcopy:","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"julia> A = Multiset(1,1,2,3,5)\n{1,1,2,3,5}\njulia> B = deepcopy(A)\n{1,1,2,3,5}\njulia> A[8]=2;\n\njulia> A\n{1,1,2,3,5,8,8}\njulia> B\n{1,1,2,3,5}","category":"page"},{"location":"","page":"Multisets","title":"Multisets","text":"Note that deepcopy duplicates all elements of the multiset. If the elements are immutable, then deepcopy is more efficient than copy. On the other hand, if the elements are  mutable, then deepcopy is slower because it creates independent copies of the elements. ","category":"page"}]
}
