struct Tsit5ConstantCache <: OrdinaryDiffEqConstantCache end
struct Tsit5ConstantCacheActual{T, T2}
    c1::T2
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    a21::T
    a31::T
    a32::T
    a41::T
    a42::T
    a43::T
    a51::T
    a52::T
    a53::T
    a54::T
    a61::T
    a62::T
    a63::T
    a64::T
    a65::T
    a71::T
    a72::T
    a73::T
    a74::T
    a75::T
    a76::T
    btilde1::T
    btilde2::T
    btilde3::T
    btilde4::T
    btilde5::T
    btilde6::T
    btilde7::T
end

@fold function Tsit5ConstantCacheActual(::Type{T},
        ::Type{T2}) where {T <: CompiledFloats,
        T2 <: CompiledFloats}
    c1 = convert(T2, 0.161)
    c2 = convert(T2, 0.327)
    c3 = convert(T2, 0.9)
    c4 = convert(T2, 0.9800255409045097)
    c5 = convert(T2, 1)
    c6 = convert(T2, 1)
    a21 = convert(T, 0.161)
    a31 = convert(T, -0.008480655492356989)
    a32 = convert(T, 0.335480655492357)
    a41 = convert(T, 2.8971530571054935)
    a42 = convert(T, -6.359448489975075)
    a43 = convert(T, 4.3622954328695815)
    a51 = convert(T, 5.325864828439257)
    a52 = convert(T, -11.748883564062828)
    a53 = convert(T, 7.4955393428898365)
    a54 = convert(T, -0.09249506636175525)
    a61 = convert(T, 5.86145544294642)
    a62 = convert(T, -12.92096931784711)
    a63 = convert(T, 8.159367898576159)
    a64 = convert(T, -0.071584973281401)
    a65 = convert(T, -0.028269050394068383)
    a71 = convert(T, 0.09646076681806523)
    a72 = convert(T, 0.01)
    a73 = convert(T, 0.4798896504144996)
    a74 = convert(T, 1.379008574103742)
    a75 = convert(T, -3.290069515436081)
    a76 = convert(T, 2.324710524099774)
    # b1 =       convert(T,0.09468075576583945)
    # b2 =       convert(T,0.009183565540343254)
    # b3 =       convert(T,0.4877705284247616)
    # b4 =       convert(T,1.234297566930479)
    # b5 =       convert(T,-2.7077123499835256)
    # b6 =       convert(T,1.866628418170587)
    # b7 =       convert(T,0.015151515151515152)
    btilde1 = convert(T, -0.00178001105222577714)
    btilde2 = convert(T, -0.0008164344596567469)
    btilde3 = convert(T, 0.007880878010261995)
    btilde4 = convert(T, -0.1447110071732629)
    btilde5 = convert(T, 0.5823571654525552)
    btilde6 = convert(T, -0.45808210592918697)
    btilde7 = convert(T, 0.015151515151515152)

    Tsit5ConstantCacheActual(
        c1, c2, c3, c4, c5, c6, a21, a31, a32, a41, a42, a43, a51, a52,
        a53,
        a54, a61, a62, a63, a64, a65, a71, a72, a73, a74, a75, a76,
        btilde1,
        btilde2, btilde3, btilde4, btilde5, btilde6, btilde7)
end

@fold function Tsit5ConstantCacheActual(::Type{T}, ::Type{T2}) where {T, T2}
    c1 = convert(T2, 161 // 1000)
    c2 = convert(T2, 327 // 1000)
    c3 = convert(T2, 9 // 10)
    c4 = convert(T2,
        big".9800255409045096857298102862870245954942137979563024768854764293221195950761080302604")
    c5 = convert(T2, 1)
    c6 = convert(T2, 1)
    a21 = convert(T, 161 // 1000)
    a31 = convert(T,
        big"-.8480655492356988544426874250230774675121177393430391537369234245294192976164141156943e-2")
    a32 = convert(T,
        big".3354806554923569885444268742502307746751211773934303915373692342452941929761641411569")
    a41 = convert(T,
        big"2.897153057105493432130432594192938764924887287701866490314866693455023795137503079289")
    a42 = convert(T,
        big"-6.359448489975074843148159912383825625952700647415626703305928850207288721235210244366")
    a43 = convert(T,
        big"4.362295432869581411017727318190886861027813359713760212991062156752264926097707165077")
    a51 = convert(T,
        big"5.325864828439256604428877920840511317836476253097040101202360397727981648835607691791")
    a52 = convert(T,
        big"-11.74888356406282787774717033978577296188744178259862899288666928009020615663593781589")
    a53 = convert(T,
        big"7.495539342889836208304604784564358155658679161518186721010132816213648793440552049753")
    a54 = convert(T,
        big"-.9249506636175524925650207933207191611349983406029535244034750452930469056411389539635e-1")
    a61 = convert(T,
        big"5.861455442946420028659251486982647890394337666164814434818157239052507339770711679748")
    a62 = convert(T,
        big"-12.92096931784710929170611868178335939541780751955743459166312250439928519268343184452")
    a63 = convert(T,
        big"8.159367898576158643180400794539253485181918321135053305748355423955009222648673734986")
    a64 = convert(T,
        big"-.7158497328140099722453054252582973869127213147363544882721139659546372402303777878835e-1")
    a65 = convert(T,
        big"-.2826905039406838290900305721271224146717633626879770007617876201276764571291579142206e-1")
    a71 = convert(T,
        big".9646076681806522951816731316512876333711995238157997181903319145764851595234062815396e-1")
    a72 = convert(T, 1 // 100)
    a73 = convert(T,
        big".4798896504144995747752495322905965199130404621990332488332634944254542060153074523509")
    a74 = convert(T,
        big"1.379008574103741893192274821856872770756462643091360525934940067397245698027561293331")
    a75 = convert(T,
        big"-3.290069515436080679901047585711363850115683290894936158531296799594813811049925401677")
    a76 = convert(T,
        big"2.324710524099773982415355918398765796109060233222962411944060046314465391054716027841")
    # b1 =       convert(T,big".9468075576583945807478876255758922856117527357724631226139574065785592789071067303271e-1")
    # b2 =       convert(T,big".9183565540343253096776363936645313759813746240984095238905939532922955247253608687270e-2")
    # b3 =       convert(T,big".4877705284247615707855642599631228241516691959761363774365216240304071651579571959813")
    # b4 =       convert(T,big"1.234297566930478985655109673884237654035539930748192848315425833500484878378061439761")
    # b5 =       convert(T,big"-2.707712349983525454881109975059321670689605166938197378763992255714444407154902012702")
    # b6 =       convert(T,big"1.866628418170587035753719399566211498666255505244122593996591602841258328965767580089")
    # b7 =       convert(T,1//66)
    btilde1 = convert(T,
        big"-1.780011052225771443378550607539534775944678804333659557637450799792588061629796e-03")
    btilde2 = convert(T,
        big"-8.164344596567469032236360633546862401862537590159047610940604670770447527463931e-04")
    btilde3 = convert(T,
        big"7.880878010261996010314727672526304238628733777103128603258129604952959142646516e-03")
    btilde4 = convert(T,
        big"-1.44711007173262907537165147972635116720922712343167677619514233896760819649515e-01")
    btilde5 = convert(T,
        big"5.823571654525552250199376106520421794260781239567387797673045438803694038950012e-01")
    btilde6 = convert(T,
        big"-4.580821059291869466616365188325542974428047279788398179474684434732070620889539e-01")
    btilde7 = convert(T, 1 // 66)

    Tsit5ConstantCacheActual(
        c1, c2, c3, c4, c5, c6, a21, a31, a32, a41, a42, a43, a51, a52,
        a53,
        a54, a61, a62, a63, a64, a65, a71, a72, a73, a74, a75, a76,
        btilde1,
        btilde2, btilde3, btilde4, btilde5, btilde6, btilde7)
end

"""
Coefficients for the polynomial
bᵢΘ = ri1*Θ + ri2*Θ^2 + ri3*Θ^3 + ...

These are the coefficients of the expanded form of the polynomials from

Runge–Kutta pairs of order 5(4) satisfying only the first column
simplifying assumption

Ch. Tsitouras
"""
@fold function Tsit5Interp(::Type{T}) where {T <: CompiledFloats}
    r11 = convert(T, 1.0)
    r12 = convert(T, -2.763706197274826)
    r13 = convert(T, 2.9132554618219126)
    r14 = convert(T, -1.0530884977290216)

    r22 = convert(T, 0.13169999999999998)
    r23 = convert(T, -0.2234)
    r24 = convert(T, 0.1017)

    r32 = convert(T, 3.9302962368947516)
    r33 = convert(T, -5.941033872131505)
    r34 = convert(T, 2.490627285651253)

    r42 = convert(T, -12.411077166933676)
    r43 = convert(T, 30.33818863028232)
    r44 = convert(T, -16.548102889244902)

    r52 = convert(T, 37.50931341651104)
    r53 = convert(T, -88.1789048947664)
    r54 = convert(T, 47.37952196281928)

    r62 = convert(T, -27.896526289197286)
    r63 = convert(T, 65.09189467479366)
    r64 = convert(T, -34.87065786149661)

    r72 = convert(T, 1.5)
    r73 = convert(T, -4)
    r74 = convert(T, 2.5)

    return r11, r12, r13, r14, r22, r23, r24, r32, r33, r34, r42, r43, r44, r52, r53, r54,
    r62, r63, r64, r72, r73, r74
end

"""
Coefficients for the polynomial
bᵢΘ = ri1*Θ + ri2*Θ^2 + ri3*Θ^3 + ...

These are the coefficients of the expanded form of the polynomials from

Runge–Kutta pairs of order 5(4) satisfying only the first column
simplifying assumption

Ch. Tsitouras
"""
@fold function Tsit5Interp(::Type{T}) where {T}
    r11 = convert(T, big"0.999999999999999974283372471559910888475488471328")
    r12 = convert(T, big"-2.763706197274825911336735930481400260916070804192")
    r13 = convert(T, big"2.91325546182191274375068099306808")
    r14 = convert(T, -1.0530884977290216)

    r22 = convert(T, big"0.13169999999999999727")
    r23 = convert(T, big"-0.22339999999999999818")
    r24 = convert(T, 0.1017)

    r32 = convert(T, big"3.93029623689475152850687446709813398")
    r33 = convert(T, big"-5.94103387213150473470249202589458001")
    r34 = convert(T, big"2.490627285651252793")

    r42 = convert(T, big"-12.411077166933676983734381540685453484102414134010752")
    r43 = convert(T, big"30.3381886302823215981729903691836576")
    r44 = convert(T, big"-16.54810288924490272")

    r52 = convert(T, big"37.50931341651103919496903965334519631242339792120440212")
    r53 = convert(T, big"-88.1789048947664011014276693541209817")
    r54 = convert(T, big"47.37952196281928122")

    r62 = convert(T, big"-27.896526289197287805948263144598643896")
    r63 = convert(T, big"65.09189467479367152629021928716553658")
    r64 = convert(T, big"-34.87065786149660974")

    r72 = convert(T, 1.5)
    r73 = convert(T, -4)
    r74 = convert(T, 2.5)

    return r11, r12, r13, r14, r22, r23, r24, r32, r33, r34, r42, r43, r44, r52, r53, r54,
    r62, r63, r64, r72, r73, r74
end
