var documenterSearchIndex = {"docs":
[{"location":"#Permutations","page":"Permutations","title":"Permutations","text":"","category":"section"},{"location":"#Introduction","page":"Permutations","title":"Introduction","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"This package defines a Permutation  type for Julia. We only consider permutations of sets of the form {1,2,3,...,n} where n is a positive integer.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"A Permutation object is created from a one-dimensional array of integers containing each of the values 1 through n exactly once.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> a = [4,1,3,2,6,5];\njulia> p = Permutation(a)\n(1,4,2)(3)(5,6)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Observe the Permutation is printed in disjoint cycle format.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The number of elements in a Permutation is determined using the length function:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> length(p)\n6","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"A Permutation can be converted to an array (equal to the array used to construct the Permutation in the first place) or can be presented as a two-row matrix as follows:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p.data\n6-element Array{Int64,1}:\n 4\n 1\n 3\n 2\n 6\n 5\njulia> two_row(p)\n2x6 Array{Int64,2}:\n 1  2  3  4  5  6\n 4  1  3  2  6  5","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The evaluation of a Permutation on a particular element is performed using square bracket or parenthesis notation:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p[2]\n1\njulia> p(2)\n1","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Of course, bad things happen if an inappropriate element is given:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p[7]\nERROR: BoundsError()\n in getindex at ....","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"To get the cycle structure of a Permutation (not as a character string, but as an array of arrays), use cycles:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> cycles(p)\n3-element Array{Array{Int64,1},1}:\n [1,4,2]\n [3]\n [5,6]","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Given a list of disjoint cycles of 1:n, we can recover the Permutation:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(12)\n(1,6,3,4,11,12,7,2,10,8,9,5)\n\njulia> p = RandomPermutation(12)\n(1,12,3,9,4,10,2,7)(5,11,8)(6)\n\njulia> c = cycles(p)\n3-element Vector{Vector{Int64}}:\n [1, 12, 3, 9, 4, 10, 2, 7]\n [5, 11, 8]\n [6]\n\njulia> Permutation(c)\n(1,12,3,9,4,10,2,7)(5,11,8)(6)","category":"page"},{"location":"#Operations","page":"Permutations","title":"Operations","text":"","category":"section"},{"location":"#Composition","page":"Permutations","title":"Composition","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"Composition is denoted by *:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> q = Permutation([1,6,2,3,4,5])\n(1)(2,6,5,4,3)\njulia> p*q\n(1,4,3)(2,5)(6)\njulia> q*p\n(1,3,2)(4,6)(5)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Repeated composition is calculated using ^, like this: p^n. The exponent may be negative.","category":"page"},{"location":"#Inverse","page":"Permutations","title":"Inverse","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"The inverse of a Permutation is computed using inv or as p':","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> q = inv(p)\n(1,2,4)(3)(5,6)\njulia> p*q\n(1)(2)(3)(4)(5)(6)","category":"page"},{"location":"#Square-Root","page":"Permutations","title":"Square Root","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"The sqrt function returns a compositional square root of the permutation. That is, if q=sqrt(p) then q*q==p. Note that not all permutations have square roots and square roots are not unique.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p\n(1,12,7,4)(2,8,3)(5,15,11,14)(6,10,13)(9)\n\njulia> q = sqrt(p)\n(1,5,12,15,7,11,4,14)(2,3,8)(6,13,10)(9)\n\njulia> q*q == p\ntrue","category":"page"},{"location":"#Matrix-Form","page":"Permutations","title":"Matrix Form","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"The function Matrix converts a permutation p to a square matrix whose i,j-entry is 1 when i == p[j] and 0 otherwise.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(6)\n(1,5,2,6)(3)(4)\n\njulia> Matrix(p)\n6×6 Array{Int64,2}:\n 0  0  0  0  0  1\n 0  0  0  0  1  0\n 0  0  1  0  0  0\n 0  0  0  1  0  0\n 1  0  0  0  0  0\n 0  1  0  0  0  0","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Note that a permutation matrix M can be converted back to a Permutation by calling Permutation(M):","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(8)\n(1,4,5,2,6,8,7)(3)\n\njulia> M = Matrix(p);\n\njulia> q = Permutation(M)\n(1,4,5,2,6,8,7)(3)","category":"page"},{"location":"#Sign","page":"Permutations","title":"Sign","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"The sign of a Permutation is +1 for an even permutation and -1 for an odd permutation.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = Permutation([2,3,4,1])\n(1,2,3,4)\n\njulia> sign(p)\n-1\n\njulia> sign(p*p)\n1","category":"page"},{"location":"#Reverse","page":"Permutations","title":"Reverse","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"If one thinks of a permutation as a sequence, then applying reverse to that permutation returns a new permutation based on the reversal of that sequence. Here's an example:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(8)\n(1,5,8,4,6)(2,3)(7)\n\njulia> two_row(p)\n2x8 Array{Int64,2}:\n 1  2  3  4  5  6  7  8\n 5  3  2  6  8  1  7  4\n\njulia> two_row(reverse(p))\n2x8 Array{Int64,2}:\n 1  2  3  4  5  6  7  8\n 4  7  1  8  6  2  3  5","category":"page"},{"location":"#Extension","page":"Permutations","title":"Extension","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"Permutations of different lengths cannot be composed:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> using Permutations\n\njulia> p = RandomPermutation(8)\n(1,4,2)(3,5)(6,8,7)\n\njulia> q = RandomPermutation(10)\n(1,2,9,4)(3,8,7,10)(5,6)\n\njulia> p*q\nERROR: Cannot compose Permutations of different lengths","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"However, the extend function can be used to create a new Permutation  that has greater length:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p\n(1,4,2)(3,5)(6,8,7)\n\njulia> extend(p,10)\n(1,4,2)(3,5)(6,8,7)(9)(10)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The extended Permutation is now able to be composed with the longer one:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> extend(p,10) * q\n(1)(2,9)(3,7,10,5,8,6)(4)","category":"page"},{"location":"#Additional-Constructors","page":"Permutations","title":"Additional Constructors","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"For convenience, identity and random permutations can be constructed like this:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> Permutation(10)\n(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)\n\njulia> RandomPermutation(10)\n(1,7,6,10,3,2,8,4)(5,9)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"In addition, we can use Permutation(n,k) to create the k'th permutation of the set {1,2,...,n}. Of course, this requires k to be between 1 and n!.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> Permutation(6,701)\n(1,6,3)(2,5)(4)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The function CyclePermutation creates a permutation containing a  single cycle of the form (1,2,...,n).","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> CyclePermutation(5)\n(1,2,3,4,5)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The function Transposition is used to create a permutation containing a single two-cycle. Use Transposition(n,a,b) to create a permutation of  1:n that swaps a and b.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = Transposition(10,3,5)\n(1)(2)(3,5)(4)(6)(7)(8)(9)(10)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"This function requires 1 ≤ a ≠ b ≤ n.","category":"page"},{"location":"#Properties","page":"Permutations","title":"Properties","text":"","category":"section"},{"location":"#Fixed-point","page":"Permutations","title":"Fixed point","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"A fixed point of a permutation p is a value k such that p[k]==k. The function fixed_points returns a list of the fixed points of a given permutation.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(20)\n(1,15,10,9,11,13,12,8,5,7,18,6,2)(3)(4,16,17,19)(14)(20)\n\njulia> fixed_points(p)\n3-element Array{Int64,1}:\n  3\n 14\n 20","category":"page"},{"location":"#Longest-increasing-and-decreasing-subsequence","page":"Permutations","title":"Longest increasing and decreasing subsequence","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"The function longest_increasing finds a subsequence of a permutation whose elements are in increasing order. Likewise, longest_decreasing finds a longest decreasing subsequence. For example:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(10)\n(1,3,10)(2)(4)(5,6)(7)(8)(9)\n\njulia> two_row(p)\n2x10 Array{Int64,2}:\n 1  2   3  4  5  6  7  8  9  10\n 3  2  10  4  6  5  7  8  9   1\n\njulia> longest_increasing(p)\n6-element Array{Int64,1}:\n 3\n 4\n 6\n 7\n 8\n 9\n\njulia> longest_decreasing(p)\n4-element Array{Int64,1}:\n 10\n  6\n  5\n  1","category":"page"},{"location":"#Test-for-identity-permutation","page":"Permutations","title":"Test for identity permutation","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"For a Permutation, p, the function isone(p) returns true exactly when  p is an identity Permutation.","category":"page"},{"location":"#Iteration","page":"Permutations","title":"Iteration","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"The function PermGen creates a Permutation iterator.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"With an integer argument, PermGen(n) creates an iterator for all permutations of length n.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> for p in PermGen(3)\n           println(p)\n       end\n(1)(2)(3)\n(1)(2,3)\n(1,2)(3)\n(1,2,3)\n(1,3,2)\n(1,3)(2)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Alternatively, PermGen may be called with a dictionary of lists or list of lists argument, d.  The permutations generated will have the property that the value of the permutation at argument k must be one of the values stored in d[k].  For example, to find all derangements of {1,2,3,4} we do this:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> d = [ [2,3,4], [1,3,4], [1,2,4], [1,2,3] ]\n4-element Vector{Vector{Int64}}:\n [2, 3, 4]\n [1, 3, 4]\n [1, 2, 4]\n [1, 2, 3]","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Thus d[1] gives all allowable values for the first position in the permutation, and so forth. We could equally well have done this:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> d = Dict{Int, Vector{Int}}();\n\njulia> for k=1:4\n           d[k] = setdiff(1:4,k)\n       end\n\njulia> d\nDict{Int64, Vector{Int64}} with 4 entries:\n  4 => [1, 2, 3]\n  2 => [1, 3, 4]\n  3 => [1, 2, 4]\n  1 => [2, 3, 4]","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"In either case, here we create the nine derangements of {1,2,3,4}:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> [p for p in PermGen(d)]\n9-element Vector{Permutation}:\n (1,4)(2,3)\n (1,3,2,4)\n (1,2,3,4)\n (1,4,2,3)\n (1,3)(2,4)\n (1,3,4,2)\n (1,2,4,3)\n (1,4,3,2)\n (1,2)(3,4)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The PermGen iterator generates permutations one at a time. So this calculation does not use much memory:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> sum(length(fixed_points(p)) for p in PermGen(10))\n3628800","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Aside: Notice that the answer is 10!. It is a fun exerice to show that among all the n! permutations of {1,2,...,n}, the number of fixed points is n!.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"We provide DerangeGen(n) which generates all derangements of {1,2,...,n}, i.e., all permutations without fixed points.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> for p in DerangeGen(4)\n           println(p)\n       end\n(1,2)(3,4)\n(1,2,3,4)\n(1,2,4,3)\n(1,3,4,2)\n(1,3)(2,4)\n(1,3,2,4)\n(1,4,3,2)\n(1,4,2,3)\n(1,4)(2,3)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"Thanks to Jonah Scheinerman for the implementation of PermGen for restricted permutations. ","category":"page"},{"location":"#Conversion-to-a-Dict","page":"Permutations","title":"Conversion to a Dict","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"For a permutation p, calling dict(p) returns a dictionary that behaves just like p.","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = RandomPermutation(12)\n(1,11,6)(2,8,7)(3)(4,5,9,12,10)\n\njulia> d = dict(p)\nDict{Int64,Int64} with 12 entries:\n  2  => 8\n  11 => 6\n  7  => 2\n  9  => 12\n  10 => 4\n  8  => 7\n  6  => 1\n  4  => 5\n  3  => 3\n  5  => 9\n  12 => 10\n  1  => 11","category":"page"},{"location":"#Coxeter-Decomposition","page":"Permutations","title":"Coxeter Decomposition","text":"","category":"section"},{"location":"","page":"Permutations","title":"Permutations","text":"Every permutation can be expressed as a product of transpositions. In a Coxeter decomposition the permutation is the product of transpositions of the form (j,j+1). Given a permutation p, we get this form with CoxeterDecomposition(p):","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> p = Permutation([2,4,3,5,1,6,8,7])\n(1,2,4,5)(3)(6)(7,8)\n\njulia> pp = CoxeterDecomposition(p)\nPermutation of 1:8: (1,2)(2,3)(3,4)(2,3)(4,5)(7,8)","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"The original permutation can be recovered like this:","category":"page"},{"location":"","page":"Permutations","title":"Permutations","text":"julia> Permutation(pp)\n(1,2,4,5)(3)(6)(7,8)","category":"page"}]
}
