Preliminaries
===============

!!! tip "Julia differences"

    This is a translation of the `Python` tutorial for SymPy, described below, to use the `Julie` intefaces to SymPy provided in `SymPyCore`.


This tutorial assumes that the reader already knows the basics of the Python programming
language.  If you do not, the
[official Python tutorial](https://docs.python.org/3/tutorial/index.html>) is excellent.

This tutorial assumes a decent mathematical background.  Most examples require
knowledge lower than a calculus level, and some require knowledge at a
calculus level.  Some of the advanced features require more than this. If you
come across a section that uses some mathematical function you are not
familiar with, you can probably skip over it, or replace it with a similar one
that you are more familiar with.  Or look up the function on Wikipedia and
learn something new.  Some important mathematical concepts that are not common
knowledge will be introduced as necessary.

Installation
============

You will need to install SymPy first.  See the [installation guide](installation).

Exercises
=========

This tutorial was the basis for a tutorial given at the 2013 SciPy conference
in Austin, TX.  The website for that tutorial is
[here](https://certik.github.io/scipy-2013-tutorial/html/index.html). It has links
to videos, materials, and IPython notebook exercises.  The IPython notebook
exercises in particular are recommended to anyone going through this tutorial.
