/*
 * Decompiled with CFR 0.152.
 */
package snailgun.protocol;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import snailgun.logging.Logger;
import snailgun.protocol.Action;
import snailgun.protocol.Action$SendStdin$;
import snailgun.protocol.ChunkTypes;
import snailgun.protocol.ChunkTypes$Argument$;
import snailgun.protocol.ChunkTypes$Command$;
import snailgun.protocol.ChunkTypes$Directory$;
import snailgun.protocol.ChunkTypes$Environment$;
import snailgun.protocol.ChunkTypes$Exit$;
import snailgun.protocol.ChunkTypes$Heartbeat$;
import snailgun.protocol.ChunkTypes$SendInput$;
import snailgun.protocol.ChunkTypes$Stderr$;
import snailgun.protocol.ChunkTypes$Stdin$;
import snailgun.protocol.ChunkTypes$StdinEOF$;
import snailgun.protocol.ChunkTypes$Stdout$;
import snailgun.protocol.Defaults$Time$;
import snailgun.protocol.Protocol$;
import snailgun.protocol.Streams;

@ScalaSignature(bytes="\u0006\u0005\tMc\u0001\u0002\u0013&\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dDQA\u001c\u0001\u0005\u0002=Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004\u0000\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fAq!!\u0005\u0001A\u0003%\u0001\fC\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0010!9\u0011Q\u0003\u0001!\u0002\u0013A\u0006\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\t\t\u0003\u0001Q\u0001\n\u0005m\u0001\u0002CA\u0012\u0001\t\u0007I\u0011A=\t\u000f\u0005\u0015\u0002\u0001)A\u0005u\"A\u0011q\u0005\u0001C\u0002\u0013\u0005\u0011\u0010C\u0004\u0002*\u0001\u0001\u000b\u0011\u0002>\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002x\u0002!I!!?\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!1\u0003\u0001\u0005\n\tUq!\u0003B\u001aK\u0005\u0005\t\u0012\u0001B\u001b\r!!S%!A\t\u0002\t]\u0002B\u00028\"\t\u0003\u0011I\u0004C\u0005\u0003<\u0005\n\n\u0011\"\u0001\u0003>\tA\u0001K]8u_\u000e|GN\u0003\u0002'O\u0005A\u0001O]8u_\u000e|GNC\u0001)\u0003!\u0019h.Y5mOVt7\u0001A\n\u0003\u0001-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017aB:ue\u0016\fWn\u001d\t\u0003gQj\u0011!J\u0005\u0003k\u0015\u0012qa\u0015;sK\u0006l7/A\u0002do\u0012\u0004\"\u0001O \u000e\u0003eR!AO\u001e\u0002\t\u0019LG.\u001a\u0006\u0003yu\n1A\\5p\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001d\u0003\tA\u000bG\u000f[\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u0005\u0003D\u00156keB\u0001#I!\t)U&D\u0001G\u0015\t9\u0015&\u0001\u0004=e>|GOP\u0005\u0003\u00136\na\u0001\u0015:fI\u00164\u0017BA&M\u0005\ri\u0015\r\u001d\u0006\u0003\u00136\u0002\"a\u0011(\n\u0005=c%AB*ue&tw-\u0001\u0004m_\u001e<WM\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u001e\nq\u0001\\8hO&tw-\u0003\u0002W'\n1Aj\\4hKJ\fQc\u001d;pa\u001a+(\u000f\u001e5feB\u0013xnY3tg&tw\r\u0005\u0002ZA6\t!L\u0003\u0002\\9\u00061\u0011\r^8nS\u000eT!!\u00180\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002`{\u0005!Q\u000f^5m\u0013\t\t'LA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0013S:$XM]1di&4XmU3tg&|g\u000e\u0005\u0002-I&\u0011Q-\f\u0002\b\u0005>|G.Z1o\u00035!\bN]3bIB{w\u000e\\(qiB\u0019A\u0006\u001b6\n\u0005%l#AB(qi&|g\u000e\u0005\u0002lY6\tA,\u0003\u0002n9\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\taF\u00148\u000f^;woB\u00111\u0007\u0001\u0005\u0006c!\u0001\rA\r\u0005\u0006m!\u0001\ra\u000e\u0005\u0006\u0003\"\u0001\rA\u0011\u0005\u0006!\"\u0001\r!\u0015\u0005\u0006/\"\u0001\r\u0001\u0017\u0005\u0006E\"\u0001\ra\u0019\u0005\bM\"\u0001\n\u00111\u0001h\u0003-\t'm]8mkR,7i\u001e3\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!!`\u001f\u0002\t1\fgnZ\u0005\u0003\u001fr\fA\"\u00192t_2,H/Z\"xI\u0002\n\u0001\"\u001a=ji\u000e{G-Z\u000b\u0003\u0003\u000b\u00012!WA\u0004\u0013\r\tIA\u0017\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u0013\u0015D\u0018\u000e^\"pI\u0016\u0004\u0013!C5t%Vtg.\u001b8h+\u0005A\u0016AC5t%Vtg.\u001b8hA\u0005y\u0011M\\=UQJ,\u0017\r\u001a$bS2,G-\u0001\tb]f$\u0006N]3bI\u001a\u000b\u0017\u000e\\3eA\u0005yq/Y5u)\u0016\u0014X.\u001b8bi&|g.\u0006\u0002\u0002\u001cA\u00191.!\b\n\u0007\u0005}ALA\u0005TK6\f\u0007\u000f[8sK\u0006\u0001r/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eI\u0001\u0015\u001d\u0006LGnZ;o\r&dWmU3qCJ\fGo\u001c:\u0002+9\u000b\u0017\u000e\\4v]\u001aKG.Z*fa\u0006\u0014\u0018\r^8sA\u0005!b*Y5mOVt\u0007+\u0019;i'\u0016\u0004\u0018M]1u_J\fQCT1jY\u001e,h\u000eU1uQN+\u0007/\u0019:bi>\u0014\b%\u0001\bbY2,eN^5s_:lWM\u001c;\u0016\u0003\t\u000b1b]3oI\u000e{W.\\1oIRQ\u00111GA\u001d\u0003{\t9%a\u0016\u0011\u00071\n)$C\u0002\u000285\u00121!\u00138u\u0011\u0019\tY\u0004\u0007a\u0001\u001b\u0006\u00191-\u001c3\t\u000f\u0005}\u0002\u00041\u0001\u0002B\u000591-\u001c3Be\u001e\u001c\b\u0003\u0002\u0017\u0002D5K1!!\u0012.\u0005\u0015\t%O]1z\u0011\u001d\tI\u0005\u0007a\u0001\u0003\u0017\nAa\\;uaA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Ru\n!![8\n\t\u0005U\u0013q\n\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u00033B\u0002\u0019AA.\u0003\rIg\u000e\r\t\u0005\u0003\u001b\ni&\u0003\u0003\u0002`\u0005=#aC%oaV$8\u000b\u001e:fC6\f\u0011b]3oI\u000eCWO\\6\u0015\u0011\u0005\u0015\u00141NA?\u0003\u0003\u00032\u0001LA4\u0013\r\tI'\f\u0002\u0005+:LG\u000fC\u0004\u0002ne\u0001\r!a\u001c\u0002\u0007Q\u0004X\r\u0005\u0003\u0002r\u0005]dbA\u001a\u0002t%\u0019\u0011QO\u0013\u0002\u0015\rCWO\\6UsB,7/\u0003\u0003\u0002z\u0005m$!C\"ik:\\G+\u001f9f\u0015\r\t)(\n\u0005\u0007\u0003\u007fJ\u0002\u0019A'\u0002\u00075\u001cx\rC\u0004\u0002\u0004f\u0001\r!!\"\u0002\u0007=,H\u000f\u0005\u0003\u0002N\u0005\u001d\u0015\u0002BAE\u0003\u001f\u0012\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\u0002-A\u0014xnY3tg\u000eCWO\\6Ge>l7+\u001a:wKJ$B!a$\u0002\u0016B\u00191'!%\n\u0007\u0005MUE\u0001\u0004BGRLwN\u001c\u0005\b\u0003/S\u0002\u0019AAM\u0003\tIg\u000e\u0005\u0003\u0002N\u0005m\u0015\u0002BAO\u0003\u001f\u0012q\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0001!GJ,\u0017\r^3IK\u0006\u0014HOY3bi\u0006sGm\u00155vi\u0012|wO\u001c+ie\u0016\fG\r\u0006\u0004\u0002$\u0006e\u00171\u001c\t\t\u0003K\u000by+!.\u0002T:!\u0011qUAV\u001d\r)\u0015\u0011V\u0005\u0002]%\u0019\u0011QV\u0017\u0002\u000fA\f7m[1hK&!\u0011\u0011WAZ\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011QV\u00171\t\u0005]\u0016\u0011\u0019\t\u0006W\u0006e\u0016QX\u0005\u0004\u0003wc&A\u0002$viV\u0014X\r\u0005\u0003\u0002@\u0006\u0005G\u0002\u0001\u0003\f\u0003\u0007\\\u0012\u0011!A\u0001\u0006\u0003\t)MA\u0002`II\nB!a2\u0002NB\u0019A&!3\n\u0007\u0005-WFA\u0004O_RD\u0017N\\4\u0011\u00071\ny-C\u0002\u0002R6\u00121!\u00118z!\rY\u0018Q[\u0005\u0004\u0003/d(A\u0002+ie\u0016\fG\rC\u0004\u0002\u0018n\u0001\r!!'\t\u000f\u0005\r5\u00041\u0001\u0002\u0006\u0006\t2M]3bi\u0016\u001cF\u000fZ5o)\"\u0014X-\u00193\u0015\t\u0005\u0005\u0018Q\u001f\t\u0005Y!\f\u0019\u000fE\u0004-\u0003K\fI/a\u0007\n\u0007\u0005\u001dXF\u0001\u0004UkBdWM\r\t\t\u0003K\u000by+a;\u0002TB\"\u0011Q^Ay!\u0015Y\u0017\u0011XAx!\u0011\ty,!=\u0005\u0017\u0005MH$!A\u0001\u0002\u000b\u0005\u0011Q\u0019\u0002\u0004?\u0012\u001a\u0004bBAB9\u0001\u0007\u0011QQ\u0001\"g^\fG\u000e\\8x\u000bb\u001cW\r\u001d;j_:\u001c\u0018JZ*feZ,'OR5oSNDW\r\u001a\u000b\u0005\u0003K\nY\u0010\u0003\u0005\u0002~v!\t\u0019AA\u0000\u0003\u00051\u0007#\u0002\u0017\u0003\u0002\u0005\u0015\u0014b\u0001B\u0002[\tAAHY=oC6,g(\u0001\bqe&tG/\u0012=dKB$\u0018n\u001c8\u0015\t\u0005\u0015$\u0011\u0002\u0005\b\u0005\u0017q\u0002\u0019\u0001B\u0007\u0003%)\u0007pY3qi&|g\u000e\u0005\u0003\u0002&\n=\u0011\u0002\u0002B\t\u0003g\u0013\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0019\u0011\fW-\\8o)\"\u0014X-\u00193\u0015\t\t]!q\u0006\u000b\u0005\u00053\u0011)\u0003\u0005\u0005\u0002&\u0006=&1DAja\u0011\u0011iB!\t\u0011\u000b-\fILa\b\u0011\t\u0005}&\u0011\u0005\u0003\f\u0005Gy\u0012\u0011!A\u0001\u0006\u0003\t)MA\u0002`IQBqAa\n \u0001\u0004\u0011I#\u0001\u0003sk:\u0004\u0004#\u0002\u0017\u0003,\u0005\u0015\u0014b\u0001B\u0017[\tIa)\u001e8di&|g\u000e\r\u0005\u0007\u0005cy\u0002\u0019A'\u0002\t9\fW.Z\u0001\t!J|Go\\2pYB\u00111'I\n\u0003C-\"\"A!\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011yDK\u0002h\u0005\u0003Z#Aa\u0011\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001bj\u0013AC1o]>$\u0018\r^5p]&!!\u0011\u000bB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class Protocol {
    private final Streams streams;
    private final Map<String, String> environment;
    private final Logger logger;
    private final AtomicBoolean stopFurtherProcessing;
    private final Option<ExecutorService> threadPoolOpt;
    private final String absoluteCwd;
    private final AtomicInteger exitCode;
    private final AtomicBoolean isRunning;
    private final AtomicBoolean anyThreadFailed;
    private final Semaphore waitTermination;
    private final String NailgunFileSeparator;
    private final String NailgunPathSeparator;

    public static Option<ExecutorService> $lessinit$greater$default$7() {
        return Protocol$.MODULE$.$lessinit$greater$default$7();
    }

    private String absoluteCwd() {
        return this.absoluteCwd;
    }

    private AtomicInteger exitCode() {
        return this.exitCode;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private AtomicBoolean anyThreadFailed() {
        return this.anyThreadFailed;
    }

    private Semaphore waitTermination() {
        return this.waitTermination;
    }

    public String NailgunFileSeparator() {
        return this.NailgunFileSeparator;
    }

    public String NailgunPathSeparator() {
        return this.NailgunPathSeparator;
    }

    public Map<String, String> allEnvironment() {
        return (Map)this.environment.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_FILESEPARATOR"), (Object)this.NailgunFileSeparator()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_PATHSEPARATOR"), (Object)this.NailgunPathSeparator()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_TTY_0"), (Object)Integer.toString(this.streams.inIsATty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_TTY_1"), (Object)Integer.toString(this.streams.outIsATty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NAILGUN_TTY_2"), (Object)Integer.toString(this.streams.errIsATty()))})));
    }

    public int sendCommand(String cmd, String[] cmdArgs, OutputStream out0, InputStream in0) {
        Object object;
        Either<Future<?>, Thread> scheduleHeartbeat;
        Option<Tuple2<Either<Future<?>, Thread>, Semaphore>> sendStdinOpt;
        block20: {
            this.isRunning().set(true);
            DataInputStream in = new DataInputStream(in0);
            DataOutputStream out = new DataOutputStream(out0);
            sendStdinOpt = Option$.MODULE$.empty();
            scheduleHeartbeat = this.createHeartbeatAndShutdownThread(in, out);
            try {
                try {
                    this.logger.debug(new StringBuilder(38).append("Sending arguments '").append(Predef$.MODULE$.wrapRefArray((Object[])cmdArgs).mkString(" ")).append("' to Nailgun server").toString());
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Function1 & Serializable)x$1 -> {
                        this.sendChunk(ChunkTypes$Argument$.MODULE$, x$1, out);
                        return BoxedUnit.UNIT;
                    });
                    this.logger.debug("Sending environment variables to Nailgun server");
                    this.allEnvironment().foreach((Function1 & Serializable)kv -> {
                        this.sendChunk(ChunkTypes$Environment$.MODULE$, new StringBuilder(1).append(kv._1()).append("=").append(kv._2()).toString(), out);
                        return BoxedUnit.UNIT;
                    });
                    this.logger.debug(new StringBuilder(44).append("Sending working directory ").append(this.absoluteCwd()).append(" to Nailgun server").toString());
                    this.sendChunk(ChunkTypes$Directory$.MODULE$, this.absoluteCwd(), out);
                    this.logger.debug(new StringBuilder(34).append("Sending command to ").append(cmd).append(" Nailgun server").toString());
                    this.sendChunk(ChunkTypes$Command$.MODULE$, cmd, out);
                    this.logger.debug("Finished sending command information to Nailgun server");
                    this.logger.debug("Starting thread to read stdin...");
                    sendStdinOpt = this.createStdinThread(out);
                    while (this.exitCode().get() == -1) {
                        Boolean bl;
                        Action action = this.processChunkFromServer(in);
                        this.logger.debug(new StringBuilder(36).append("Received action ").append(action).append(" from Nailgun server").toString());
                        Action action2 = action;
                        if (action2 instanceof Action.Exit) {
                            Action.Exit exit = (Action.Exit)action2;
                            int code = exit.code();
                            bl = BoxesRunTime.boxToBoolean((boolean)this.exitCode().compareAndSet(-1, code));
                            continue;
                        }
                        if (action2 instanceof Action.ExitForcefully) {
                            Boolean bl2;
                            Action.ExitForcefully exitForcefully = (Action.ExitForcefully)action2;
                            Throwable error = exitForcefully.error();
                            String string = cmd;
                            String string2 = "ng-stop";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                bl2 = BoxesRunTime.boxToBoolean((boolean)this.exitCode().compareAndSet(-1, 0));
                            } else {
                                this.exitCode().compareAndSet(-1, 1);
                                this.printException(error);
                                bl2 = BoxedUnit.UNIT;
                            }
                            bl = bl2;
                            continue;
                        }
                        if (action2 instanceof Action.Print) {
                            Action.Print print = (Action.Print)action2;
                            byte[] bytes = print.bytes();
                            OutputStream out2 = print.out();
                            out2.write(bytes);
                            bl = BoxedUnit.UNIT;
                            continue;
                        }
                        if (Action$SendStdin$.MODULE$.equals(action2)) {
                            sendStdinOpt.foreach((Function1 & Serializable)x$2 -> {
                                Protocol.$anonfun$sendCommand$3(x$2);
                                return BoxedUnit.UNIT;
                            });
                            bl = BoxedUnit.UNIT;
                            continue;
                        }
                        throw new MatchError((Object)action2);
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable exception = (Throwable)option.get();
                        this.exitCode().compareAndSet(-1, 1);
                        if (!this.stopFurtherProcessing.get()) {
                            this.printException(exception);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block20;
                    }
                    throw throwable;
                }
            }
            finally {
                this.isRunning().compareAndSet(true, false);
                this.waitTermination().release(Integer.MAX_VALUE);
                sendStdinOpt.foreach((Function1 & Serializable)x$3 -> {
                    Protocol.$anonfun$sendCommand$4(x$3);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (this.stopFurtherProcessing.get()) {
            sendStdinOpt.map((Function1 & Serializable)x$4 -> (Either)x$4._1()).foreach((Function1 & Serializable)x0$1 -> {
                Boolean bl;
                Either either = x0$1;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Future f = (Future)left.value();
                    bl = BoxesRunTime.boxToBoolean((boolean)f.cancel(true));
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    Thread t = (Thread)right.value();
                    t.interrupt();
                    bl = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)either);
                }
                return bl;
            });
        }
        this.logger.debug("Waiting for stdin thread to finish...");
        sendStdinOpt.map((Function1 & Serializable)x$5 -> (Either)x$5._1()).foreach((Function1 & Serializable)x0$2 -> {
            Object object;
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                Future f = (Future)left.value();
                object = f.get();
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Thread t = (Thread)right.value();
                t.join();
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        });
        this.logger.debug("Waiting for heartbeat thread to finish...");
        Either<Future<?>, Thread> either = scheduleHeartbeat;
        if (either instanceof Left) {
            Left left = (Left)either;
            Future f = (Future)left.value();
            object = f.get();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Thread t = (Thread)right.value();
            t.join();
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
        this.logger.debug("Returning exit code...");
        return this.exitCode().get();
    }

    public void sendChunk(ChunkTypes.ChunkType tpe, String msg, DataOutputStream out) {
        byte[] payload = msg.getBytes(StandardCharsets.UTF_8);
        out.writeInt(payload.length);
        out.writeByte(tpe.toByteRepr());
        out.write(payload);
        out.flush();
    }

    public Action processChunkFromServer(DataInputStream in) {
        Action action;
        Try readAction = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Action action;
            byte chunkType;
            int bytesToRead = in.readInt();
            byte by = chunkType = in.readByte();
            if (ChunkTypes$SendInput$.MODULE$.toByteRepr() == by) {
                action = Action$SendStdin$.MODULE$;
            } else if (ChunkTypes$Stdout$.MODULE$.toByteRepr() == by) {
                action = new Action.Print(Protocol.readPayload$1(bytesToRead, in), $this.streams.out());
            } else if (ChunkTypes$Stderr$.MODULE$.toByteRepr() == by) {
                action = new Action.Print(Protocol.readPayload$1(bytesToRead, in), $this.streams.err());
            } else if (ChunkTypes$Exit$.MODULE$.toByteRepr() == by) {
                byte[] bytes = Protocol.readPayload$1(bytesToRead, in);
                int code = Integer.parseInt(new String(bytes, StandardCharsets.US_ASCII).trim());
                action = new Action.Exit(code);
            } else {
                RuntimeException error = new RuntimeException(new StringBuilder(23).append("Unexpected chunk type: ").append(chunkType).toString());
                action = new Action.ExitForcefully(error);
            }
            return action;
        });
        Try try_ = readAction;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Product action2 = (Product)success.value();
            action = (Action)action2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            action = new Action.ExitForcefully(exception);
        } else {
            throw new MatchError((Object)try_);
        }
        return action;
    }

    public Either<Future<?>, Thread> createHeartbeatAndShutdownThread(DataInputStream in, DataOutputStream out) {
        return this.daemonThread("snailgun-heartbeat", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            while (bl) {
                boolean acquired = this.waitTermination().tryAcquire(Defaults$Time$.MODULE$.DefaultHeartbeatIntervalMillis(), TimeUnit.MILLISECONDS);
                if (acquired) {
                    bl = false;
                    continue;
                }
                this.swallowExceptionsIfServerFinished((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    if ($this.stopFurtherProcessing.get()) {
                        DataOutputStream dataOutputStream = out;
                        synchronized (dataOutputStream) {
                            out.flush();
                            try {
                                in.close();
                            }
                            finally {
                                out.close();
                            }
                        }
                    }
                    DataOutputStream dataOutputStream = out;
                    synchronized (dataOutputStream) {
                        this.sendChunk(ChunkTypes$Heartbeat$.MODULE$, "", out);
                    }
                });
            }
        });
    }

    public Option<Tuple2<Either<Future<?>, Thread>, Semaphore>> createStdinThread(DataOutputStream out) {
        return this.streams.in().map((Function1 & Serializable)in -> {
            Semaphore sendStdinSemaphore = new Semaphore(0);
            Either<Future<?>, Thread> threadOrFuture = this.daemonThread("snailgun-stdin", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));){
                    boolean bl = true;
                    while (bl) {
                        if (this.shouldStop$1()) {
                            bl = false;
                            continue;
                        }
                        sendStdinSemaphore.acquire();
                        if (this.shouldStop$1()) {
                            bl = false;
                            continue;
                        }
                        String line = reader.readLine();
                        if (this.shouldStop$1()) {
                            bl = false;
                            continue;
                        }
                        if (line.length() == 0) continue;
                        this.swallowExceptionsIfServerFinished((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            DataOutputStream dataOutputStream = out;
                            synchronized (dataOutputStream) {
                                if (line == null) {
                                    this.sendChunk(ChunkTypes$StdinEOF$.MODULE$, "", out);
                                } else {
                                    this.sendChunk(ChunkTypes$Stdin$.MODULE$, line, out);
                                }
                            }
                        });
                    }
                }
            });
            return new Tuple2(threadOrFuture, (Object)sendStdinSemaphore);
        });
    }

    private void swallowExceptionsIfServerFinished(Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable exception = (Throwable)option.get();
                boolean acquired = this.waitTermination().tryAcquire(Defaults$Time$.MODULE$.SendThreadWaitTerminationMillis(), TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw exception;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void printException(Throwable exception) {
        this.logger.error("Unexpected error forces client exit!");
        this.logger.trace(exception);
    }

    private Either<Future<?>, Thread> daemonThread(String name, Function0<BoxedUnit> run0) {
        Left left;
        Runnable runnable = () -> {
            try {
                run0.apply$mcV$sp();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable exception = (Throwable)option.get();
                    if (this.anyThreadFailed().compareAndSet(false, true)) {
                        this.printException(exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
                throw throwable;
            }
        };
        Option<ExecutorService> option = this.threadPoolOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            ExecutorService threadPool = (ExecutorService)some.value();
            Future<?> f = threadPool.submit(runnable);
            left = package$.MODULE$.Left().apply(f);
        } else if (None$.MODULE$.equals(option)) {
            Thread t = new Thread(runnable, name);
            t.setDaemon(true);
            t.start();
            left = package$.MODULE$.Right().apply((Object)t);
        } else {
            throw new MatchError(option);
        }
        return left;
    }

    public static final /* synthetic */ void $anonfun$sendCommand$3(Tuple2 x$2) {
        ((Semaphore)x$2._2()).release();
    }

    public static final /* synthetic */ void $anonfun$sendCommand$4(Tuple2 x$3) {
        ((Semaphore)x$3._2()).release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] readPayload$1(int length, DataInputStream in) {
        void var3_3;
        int read;
        byte[] bytes = new byte[length];
        for (int total = 0; total < length; total += read) {
            read = in.read(bytes, total, length - total);
            if (read >= 0) continue;
            throw new EOFException("Couldn't read bytes from server");
        }
        return var3_3;
    }

    private final boolean shouldStop$1() {
        return !this.isRunning().get() || this.stopFurtherProcessing.get();
    }

    public Protocol(Streams streams, Path cwd, Map<String, String> environment, Logger logger, AtomicBoolean stopFurtherProcessing, boolean interactiveSession, Option<ExecutorService> threadPoolOpt) {
        this.streams = streams;
        this.environment = environment;
        this.logger = logger;
        this.stopFurtherProcessing = stopFurtherProcessing;
        this.threadPoolOpt = threadPoolOpt;
        this.absoluteCwd = ((Object)cwd.toAbsolutePath()).toString();
        this.exitCode = new AtomicInteger(-1);
        this.isRunning = new AtomicBoolean(false);
        this.anyThreadFailed = new AtomicBoolean(false);
        this.waitTermination = new Semaphore(0);
        this.NailgunFileSeparator = File.separator;
        this.NailgunPathSeparator = File.pathSeparator;
    }
}

