/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexarchambault.windowsansi;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import org.fusesource.jansi.internal.Kernel32;

public final class WindowsAnsi {
    public static Size terminalSize() {
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.GetConsoleScreenBufferInfo((long)l, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)cONSOLE_SCREEN_BUFFER_INFO);
        return Size.of(cONSOLE_SCREEN_BUFFER_INFO.windowWidth(), cONSOLE_SCREEN_BUFFER_INFO.windowHeight());
    }

    public static boolean setup() throws IOException {
        int[] nArray;
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        if (Kernel32.GetConsoleMode((long)l, (int[])(nArray = new int[1])) == 0) {
            throw new IOException("Failed to get console mode: " + Kernel32.getLastErrorMessage());
        }
        return Kernel32.SetConsoleMode((long)l, (int)(nArray[0] | 4)) != 0;
    }

    static {
        String string = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT);
        if (string.equals("arm64") || string.equals("aarch64")) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL uRL = classLoader.getResource("org/fusesource/jansi/internal/native/Windows/arm64/jansi.dll");
            URL uRL2 = classLoader.getResource("org/fusesource/jansi/internal/native/Windows/arm64/libjansi.so");
            if (uRL == null && uRL2 != null) {
                System.setProperty("library.jansi.name", "libjansi.so");
            }
        }
        if (System.getProperty("com.ibm.vm.bitmode") == null) {
            System.setProperty("com.ibm.vm.bitmode", "64");
        }
    }

    public static final class Size {
        private final int width;
        private final int height;

        Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public static Size of(int n, int n2) {
            return new Size(n, n2);
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Size size = (Size)object;
            return this.width == size.width && this.height == size.height;
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height);
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

