/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.IOException;
import org.scalasbt.ipcsocket.Handle;
import org.scalasbt.ipcsocket.NativeLoader;
import org.scalasbt.ipcsocket.Overlapped;
import org.scalasbt.ipcsocket.Win32NamedPipeLibraryProvider;

class JNIWin32NamedPipeLibraryProvider
implements Win32NamedPipeLibraryProvider {
    private static final JNIWin32NamedPipeLibraryProvider instance;

    JNIWin32NamedPipeLibraryProvider() {
    }

    static JNIWin32NamedPipeLibraryProvider instance() {
        return instance;
    }

    @Override
    public Handle CreateNamedPipe(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        return new JNIHandle(this.CreateNamedPipeNative(string, n, n2, n3, n4, n5, n6, n7, n8));
    }

    native long CreateNamedPipeNative(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9) throws IOException;

    @Override
    public Handle CreateFile(String string) throws IOException {
        return new JNIHandle(this.CreateFileNative(string));
    }

    native long CreateFileNative(String var1) throws IOException;

    @Override
    public int ConnectNamedPipe(Handle handle, Overlapped overlapped) {
        return this.ConnectNamedPipeNative(this.getHandlePointer(handle), this.getOverlappedPointer(overlapped));
    }

    native int ConnectNamedPipeNative(long var1, long var3);

    @Override
    public boolean DisconnectNamedPipe(Handle handle) {
        return this.DisconnectNamedPipe(this.getHandlePointer(handle));
    }

    native boolean DisconnectNamedPipe(long var1);

    @Override
    public int read(Handle handle, Handle handle2, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        return this.readNative(this.getHandlePointer(handle), this.getHandlePointer(handle2), byArray, n, n2, bl);
    }

    native int readNative(long var1, long var3, byte[] var5, int var6, int var7, boolean var8) throws IOException;

    @Override
    public void write(Handle handle, Handle handle2, byte[] byArray, int n, int n2) throws IOException {
        this.writeNative(this.getHandlePointer(handle), this.getHandlePointer(handle2), byArray, n, n2);
    }

    native void writeNative(long var1, long var3, byte[] var5, int var6, int var7) throws IOException;

    @Override
    public boolean CloseHandle(Handle handle) {
        return this.CloseHandleNative(this.getHandlePointer(handle));
    }

    native boolean CloseHandleNative(long var1);

    @Override
    public boolean GetOverlappedResult(Handle handle, Overlapped overlapped) {
        return this.GetOverlappedResultNative(this.getHandlePointer(handle), this.getOverlappedPointer(overlapped));
    }

    native boolean GetOverlappedResultNative(long var1, long var3);

    @Override
    public boolean CancelIoEx(Handle handle) {
        return this.CancelIoEx(this.getHandlePointer(handle));
    }

    native boolean CancelIoEx(long var1);

    @Override
    public Handle CreateEvent(boolean bl, boolean bl2, String string) throws IOException {
        return new JNIHandle(this.CreateEventNative(bl, bl2, string));
    }

    native long CreateEventNative(boolean var1, boolean var2, String var3);

    @Override
    public native int GetLastError();

    @Override
    public Overlapped NewOverlapped(Handle handle) {
        return new JNIOverlapped(this.NewOverlappedNative(this.getHandlePointer(handle)));
    }

    native long NewOverlappedNative(long var1);

    @Override
    public void DeleteOverlapped(Overlapped overlapped) {
        this.DeleteOverlappedNative(this.getOverlappedPointer(overlapped));
    }

    native boolean FlushFileBuffersNative(long var1);

    @Override
    public boolean FlushFileBuffers(Handle handle) {
        return this.FlushFileBuffersNative(this.getHandlePointer(handle));
    }

    native void DeleteOverlappedNative(long var1);

    native String getErrorMessage(int var1);

    @Override
    public native int ERROR_IO_PENDING();

    @Override
    public native int ERROR_NO_DATA();

    @Override
    public native int ERROR_PIPE_CONNECTED();

    @Override
    public native int FILE_ALL_ACCESS();

    @Override
    public native int FILE_FLAG_FIRST_PIPE_INSTANCE();

    @Override
    public native int FILE_FLAG_OVERLAPPED();

    @Override
    public native int FILE_GENERIC_READ();

    @Override
    public native int GENERIC_READ();

    @Override
    public native int GENERIC_WRITE();

    @Override
    public native int PIPE_ACCESS_DUPLEX();

    private long getHandlePointer(Handle handle) {
        if (handle instanceof JNIHandle) {
            return ((JNIHandle)handle).pointer;
        }
        throw new IllegalStateException("Invalid handle " + handle + " of type " + handle.getClass());
    }

    private long getOverlappedPointer(Overlapped overlapped) {
        if (overlapped instanceof JNIOverlapped) {
            return ((JNIOverlapped)overlapped).pointer;
        }
        throw new IllegalStateException("Invalid overlapped " + overlapped + " of type " + overlapped.getClass());
    }

    static {
        NativeLoader.load();
        instance = new JNIWin32NamedPipeLibraryProvider();
    }

    static class JNIOverlapped
    implements Overlapped {
        final long pointer;

        JNIOverlapped(long l) {
            if (l < 0L) {
                throw new IllegalStateException("Bad pointer");
            }
            this.pointer = l;
        }
    }

    static class JNIHandle
    implements Handle {
        final long pointer;

        JNIHandle(long l) throws IOException {
            if (l < 0L) {
                throw new IOException("Bad pointer: " + l);
            }
            this.pointer = l;
        }
    }
}

