/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AdapterUtils {
    private static final String OS_NAME = System.getProperty("os.name", "").toLowerCase();
    private static final Pattern ENCLOSING_CLASS_REGEX = Pattern.compile("^([^\\$]*)");
    public static final boolean isWin = AdapterUtils.isWindows();
    public static final boolean isMac = OS_NAME.contains("mac") || OS_NAME.contains("darwin");

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static String sourceLookup(String[] stringArray, String string) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                Path path = Paths.get(string2, string);
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                return path.toString();
            }
        }
        return null;
    }

    public static String parseEnclosingType(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = ENCLOSING_CLASS_REGEX.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static int convertLineNumber(int n, boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? n : n - 1;
        }
        return bl2 ? n + 1 : n;
    }

    public static String convertPath(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (bl == bl2) {
            return string;
        }
        if (bl && !bl2) {
            return AdapterUtils.toPath(string);
        }
        return AdapterUtils.toUri(string);
    }

    public static String toPath(String string) {
        try {
            return Paths.get(new URI(string)).toString();
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException exception) {
            return null;
        }
    }

    public static String toUri(String string) {
        try {
            return Paths.get(string, new String[0]).toUri().toString();
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    public static String toUrl(String string) throws MalformedURLException {
        File file = new File(string);
        return file.toURI().toURL().toString();
    }

    public static boolean isUri(String string) {
        try {
            URI uRI = new URI(string);
            return StringUtils.isNotBlank((CharSequence)uRI.getScheme());
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException exception) {
            return false;
        }
    }

    public static Messages.Response setErrorResponse(Messages.Response response, ErrorCode errorCode, String string) {
        response.body = new Responses.ErrorResponseBody(new Types.Message(errorCode.getId(), string));
        response.message = string;
        response.success = false;
        return response;
    }

    public static Messages.Response setErrorResponse(Messages.Response response, ErrorCode errorCode, Exception exception) {
        String string = exception.toString();
        response.body = new Responses.ErrorResponseBody(new Types.Message(errorCode.getId(), string));
        response.message = string;
        response.success = false;
        return response;
    }

    public static CompletableFuture<Messages.Response> createAsyncErrorResponse(Messages.Response response, ErrorCode errorCode, String string) {
        return CompletableFuture.completedFuture(AdapterUtils.setErrorResponse(response, errorCode, string));
    }

    public static CompletableFuture<Messages.Response> createAsyncErrorResponse(Messages.Response response, ErrorCode errorCode, Exception exception) {
        return CompletableFuture.completedFuture(AdapterUtils.setErrorResponse(response, errorCode, exception));
    }

    public static CompletionException createCompletionException(String string, ErrorCode errorCode, Throwable throwable) {
        return new CompletionException(new DebugException(string, throwable, errorCode.getId()));
    }

    public static CompletionException createCompletionException(String string, ErrorCode errorCode) {
        return new CompletionException(new DebugException(string, errorCode.getId()));
    }

    public static DebugException createUserErrorDebugException(String string, ErrorCode errorCode) {
        return new DebugException(string, errorCode.getId(), true);
    }

    public static String getSHA256HexDigest(String string) {
        byte[] byArray = null;
        try {
            byArray = MessageDigest.getInstance("SHA-256").digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (byte by : byArray) {
                stringBuffer.append(Integer.toHexString((by & 0xFF) + 256).substring(1));
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeURIComponent(String string) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }
}

