/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.google.gson.JsonElement;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.DebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapter;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.handler.AttachRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.CompletionsHandler;
import com.microsoft.java.debug.core.adapter.handler.ConfigurationDoneRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.DataBreakpointInfoRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.DisconnectRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.DisconnectRequestWithoutDebuggingHandler;
import com.microsoft.java.debug.core.adapter.handler.EvaluateRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ExceptionInfoRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.HotCodeReplaceHandler;
import com.microsoft.java.debug.core.adapter.handler.InitializeRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.InlineValuesRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.LaunchRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.RefreshVariablesHandler;
import com.microsoft.java.debug.core.adapter.handler.RestartFrameHandler;
import com.microsoft.java.debug.core.adapter.handler.ScopesRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetDataBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetExceptionBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetVariableRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SourceRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.StackTraceRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.StepRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ThreadsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.VariablesRequestHandler;
import com.microsoft.java.debug.core.protocol.IProtocolServer;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugAdapter
implements IDebugAdapter {
    private final Logger logger;
    private IDebugAdapterContext debugContext = null;
    private Map<Requests.Command, List<IDebugRequestHandler>> requestHandlersForDebug = null;
    private Map<Requests.Command, List<IDebugRequestHandler>> requestHandlersForNoDebug = null;

    public DebugAdapter(IProtocolServer iProtocolServer, IProviderContext iProviderContext, Logger logger) {
        this.logger = logger;
        this.debugContext = new DebugAdapterContext(iProtocolServer, iProviderContext, logger);
        this.requestHandlersForDebug = new HashMap<Requests.Command, List<IDebugRequestHandler>>();
        this.requestHandlersForNoDebug = new HashMap<Requests.Command, List<IDebugRequestHandler>>();
        this.initialize();
    }

    @Override
    public CompletableFuture<Messages.Response> dispatchRequest(Messages.Request request) {
        List<IDebugRequestHandler> list;
        Messages.Response response2 = new Messages.Response();
        response2.request_seq = request.seq;
        response2.command = request.command;
        response2.success = true;
        Requests.Command command = Requests.Command.parse(request.command);
        Requests.Arguments arguments = JsonUtils.fromJson((JsonElement)request.arguments, command.getArgumentType());
        if (this.debugContext.isVmTerminated() && command != Requests.Command.DISCONNECT) {
            return CompletableFuture.completedFuture(response2);
        }
        List<IDebugRequestHandler> list2 = list = this.debugContext.getLaunchMode() == LaunchMode.DEBUG ? this.requestHandlersForDebug.get((Object)command) : this.requestHandlersForNoDebug.get((Object)command);
        if (list != null && !list.isEmpty()) {
            CompletionStage<Messages.Response> completionStage = CompletableFuture.completedFuture(response2);
            for (IDebugRequestHandler iDebugRequestHandler : list) {
                completionStage = completionStage.thenCompose(response -> iDebugRequestHandler.handle(command, arguments, (Messages.Response)response, this.debugContext));
            }
            return completionStage;
        }
        String string = String.format("Unrecognized request: { _request: %s }", request.command);
        this.logger.log(Level.SEVERE, string);
        return AdapterUtils.createAsyncErrorResponse(response2, ErrorCode.UNRECOGNIZED_REQUEST_FAILURE, string);
    }

    private void initialize() {
        this.registerHandler(new InitializeRequestHandler());
        this.registerHandler(new LaunchRequestHandler(this.logger));
        this.registerHandlerForDebug(new AttachRequestHandler(this.logger));
        this.registerHandlerForDebug(new ConfigurationDoneRequestHandler(this.logger));
        this.registerHandlerForDebug(new DisconnectRequestHandler(this.logger));
        this.registerHandlerForDebug(new SetBreakpointsRequestHandler(this.logger));
        this.registerHandlerForDebug(new SetExceptionBreakpointsRequestHandler());
        this.registerHandlerForDebug(new SourceRequestHandler());
        this.registerHandlerForDebug(new ThreadsRequestHandler());
        this.registerHandlerForDebug(new StepRequestHandler());
        this.registerHandlerForDebug(new StackTraceRequestHandler());
        this.registerHandlerForDebug(new ScopesRequestHandler());
        this.registerHandlerForDebug(new VariablesRequestHandler(this.logger));
        this.registerHandlerForDebug(new SetVariableRequestHandler());
        this.registerHandlerForDebug(new EvaluateRequestHandler(this.logger));
        this.registerHandlerForDebug(new HotCodeReplaceHandler());
        this.registerHandlerForDebug(new RestartFrameHandler());
        this.registerHandlerForDebug(new CompletionsHandler());
        this.registerHandlerForDebug(new ExceptionInfoRequestHandler(this.logger));
        this.registerHandlerForDebug(new DataBreakpointInfoRequestHandler());
        this.registerHandlerForDebug(new SetDataBreakpointsRequestHandler(this.logger));
        this.registerHandlerForDebug(new InlineValuesRequestHandler(this.logger));
        this.registerHandlerForDebug(new RefreshVariablesHandler());
        this.registerHandlerForNoDebug(new DisconnectRequestWithoutDebuggingHandler(this.logger));
    }

    private void registerHandlerForDebug(IDebugRequestHandler iDebugRequestHandler) {
        this.registerHandler(this.requestHandlersForDebug, iDebugRequestHandler);
    }

    private void registerHandlerForNoDebug(IDebugRequestHandler iDebugRequestHandler) {
        this.registerHandler(this.requestHandlersForNoDebug, iDebugRequestHandler);
    }

    private void registerHandler(IDebugRequestHandler iDebugRequestHandler) {
        this.registerHandler(this.requestHandlersForDebug, iDebugRequestHandler);
        this.registerHandler(this.requestHandlersForNoDebug, iDebugRequestHandler);
    }

    private void registerHandler(Map<Requests.Command, List<IDebugRequestHandler>> map, IDebugRequestHandler iDebugRequestHandler) {
        for (Requests.Command command : iDebugRequestHandler.getTargetCommands()) {
            List<IDebugRequestHandler> list = map.get((Object)command);
            if (list == null) {
                list = new ArrayList<IDebugRequestHandler>();
                map.put(command, list);
            }
            iDebugRequestHandler.initialize(this.debugContext);
            list.add(iDebugRequestHandler);
        }
    }
}

