/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HotCodeReplaceHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.REDEFINECLASSES);
    }

    @Override
    public void initialize(IDebugAdapterContext iDebugAdapterContext) {
        IDebugRequestHandler.super.initialize(iDebugAdapterContext);
        IHotCodeReplaceProvider iHotCodeReplaceProvider = iDebugAdapterContext.getProvider(IHotCodeReplaceProvider.class);
        iHotCodeReplaceProvider.getEventHub().subscribe(hotCodeReplaceEvent -> {
            if (hotCodeReplaceEvent.getEventType() == HotCodeReplaceEvent.EventType.BUILD_COMPLETE) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.BUILD_COMPLETE, hotCodeReplaceEvent.getMessage()));
            } else if (hotCodeReplaceEvent.getEventType() == HotCodeReplaceEvent.EventType.STARTING) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.STARTING, hotCodeReplaceEvent.getMessage()));
            } else if (hotCodeReplaceEvent.getEventType() == HotCodeReplaceEvent.EventType.END) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.END, hotCodeReplaceEvent.getMessage()));
            } else if (hotCodeReplaceEvent.getEventType() == HotCodeReplaceEvent.EventType.ERROR) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.ERROR, hotCodeReplaceEvent.getMessage()));
            } else if (hotCodeReplaceEvent.getEventType() == HotCodeReplaceEvent.EventType.WARNING) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.WARNING, hotCodeReplaceEvent.getMessage()));
            }
        });
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        IHotCodeReplaceProvider iHotCodeReplaceProvider = iDebugAdapterContext.getProvider(IHotCodeReplaceProvider.class);
        return ((CompletableFuture)iHotCodeReplaceProvider.redefineClasses().thenCompose(list -> {
            response.body = new Responses.RedefineClassesResponse(list.toArray(new String[0]));
            return CompletableFuture.completedFuture(response);
        })).exceptionally(throwable -> {
            String string = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
            response.body = new Responses.RedefineClassesResponse(new String[0], string);
            return response;
        });
    }
}

