/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.google.gson.JsonObject;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSession;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManagerProvider;
import com.microsoft.java.debug.core.adapter.handler.AbstractLaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.VMHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.TransportTimeoutException;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class LaunchWithDebuggingDelegate
extends AbstractLaunchDelegate {
    private static final int ATTACH_TERMINAL_TIMEOUT = 20000;
    private static final String TERMINAL_TITLE = "Java Debug Console";
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;
    private VMHandler vmHandler = new VMHandler();

    public LaunchWithDebuggingDelegate(Logger logger) {
        super(logger);
    }

    @Override
    public CompletableFuture<Messages.Response> launchInTerminal(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        CompletableFuture<Messages.Response> completableFuture = new CompletableFuture<Messages.Response>();
        IVirtualMachineManagerProvider iVirtualMachineManagerProvider = iDebugAdapterContext.getProvider(IVirtualMachineManagerProvider.class);
        this.vmHandler.setVmProvider(iVirtualMachineManagerProvider);
        try {
            List<ListeningConnector> list = iVirtualMachineManagerProvider.getVirtualMachineManager().listeningConnectors();
            ListeningConnector listeningConnector = list.get(0);
            Map<String, Connector.Argument> map = listeningConnector.defaultArguments();
            ((Connector.IntegerArgument)map.get("timeout")).setValue(20000);
            String string = listeningConnector.startListening(map);
            String[] stringArray = LaunchRequestHandler.constructLaunchCommands(launchArguments, false, string);
            Requests.RunInTerminalRequestArguments runInTerminalRequestArguments = null;
            runInTerminalRequestArguments = launchArguments.console == Requests.CONSOLE.integratedTerminal ? Requests.RunInTerminalRequestArguments.createIntegratedTerminal(stringArray, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE) : Requests.RunInTerminalRequestArguments.createExternalTerminal(stringArray, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE);
            Messages.Request request = new Messages.Request(Requests.Command.RUNINTERMINAL.getName(), (JsonObject)JsonUtils.toJsonTree(runInTerminalRequestArguments, Requests.RunInTerminalRequestArguments.class));
            iDebugAdapterContext.getProtocolServer().sendRequest(request, 10000L).whenComplete((response2, throwable) -> {
                if (response2 != null) {
                    if (response2.success) {
                        try {
                            VirtualMachine virtualMachine = listeningConnector.accept(map);
                            this.vmHandler.connectVirtualMachine(virtualMachine);
                            iDebugAdapterContext.setDebugSession(new DebugSession(virtualMachine, this.logger));
                            this.logger.info("Launching debuggee in terminal console succeeded.");
                            completableFuture.complete(response);
                        }
                        catch (TransportTimeoutException transportTimeoutException) {
                            int n = StringUtils.length((CharSequence)launchArguments.cwd) + 1;
                            for (String string : stringArray) {
                                n += StringUtils.length((CharSequence)string) + 1;
                            }
                            int n2 = SystemUtils.IS_OS_WINDOWS ? 8092 : 32768;
                            String string = String.format("Failed to launch debuggee in terminal. Reason: %s", transportTimeoutException.toString());
                            if (n >= n2) {
                                string = "Failed to launch debuggee in terminal. The possible reason is the command line too long. More details: " + transportTimeoutException.toString();
                                this.logger.severe(string + "\r\nThe estimated command line length is " + n + ". Try to enable shortenCommandLine option in the debug launch configuration.");
                            }
                            completableFuture.completeExceptionally(new DebugException(string, ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                        }
                        catch (IllegalConnectorArgumentsException | IOException exception) {
                            completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", exception.toString()), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                        }
                    } else {
                        completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", response2.message), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                    }
                } else {
                    if (throwable instanceof CompletionException && throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    String string = String.format("Failed to launch debuggee in terminal. Reason: %s", throwable != null ? throwable.toString() : "Null response");
                    completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", string), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                }
            });
        }
        catch (IllegalConnectorArgumentsException | IOException exception) {
            completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", exception.toString()), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
        }
        return completableFuture;
    }

    @Override
    public Process launch(Requests.LaunchArguments launchArguments, IDebugAdapterContext iDebugAdapterContext) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        IVirtualMachineManagerProvider iVirtualMachineManagerProvider = iDebugAdapterContext.getProvider(IVirtualMachineManagerProvider.class);
        this.vmHandler.setVmProvider(iVirtualMachineManagerProvider);
        IDebugSession iDebugSession = DebugUtility.launch(iVirtualMachineManagerProvider.getVirtualMachineManager(), launchArguments.mainClass, launchArguments.args, launchArguments.vmArgs, Arrays.asList(launchArguments.modulePaths), Arrays.asList(launchArguments.classPaths), launchArguments.cwd, this.constructEnvironmentVariables(launchArguments), launchArguments.javaExec, this.logger);
        iDebugAdapterContext.setDebugSession(iDebugSession);
        this.vmHandler.connectVirtualMachine(iDebugSession.getVM());
        this.logger.info("Launching debuggee VM succeeded.");
        return iDebugSession.process();
    }

    @Override
    public void postLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext iDebugAdapterContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("debuggeeEncoding", iDebugAdapterContext.getDebuggeeEncoding());
        if (launchArguments.projectName != null) {
            hashMap.put("projectName", launchArguments.projectName);
        }
        if (launchArguments.mainClass != null) {
            hashMap.put("mainClass", launchArguments.mainClass);
        }
        ISourceLookUpProvider iSourceLookUpProvider = iDebugAdapterContext.getProvider(ISourceLookUpProvider.class);
        iSourceLookUpProvider.initialize(iDebugAdapterContext, hashMap);
        IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
        iEvaluationProvider.initialize(iDebugAdapterContext, hashMap);
        IHotCodeReplaceProvider iHotCodeReplaceProvider = iDebugAdapterContext.getProvider(IHotCodeReplaceProvider.class);
        iHotCodeReplaceProvider.initialize(iDebugAdapterContext, hashMap);
        ICompletionsProvider iCompletionsProvider = iDebugAdapterContext.getProvider(ICompletionsProvider.class);
        iCompletionsProvider.initialize(iDebugAdapterContext, hashMap);
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.InitializedEvent());
    }

    @Override
    public void preLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext iDebugAdapterContext) {
        iDebugAdapterContext.setAttached(false);
        iDebugAdapterContext.setSourcePaths(launchArguments.sourcePaths);
        iDebugAdapterContext.setVmStopOnEntry(launchArguments.stopOnEntry);
        iDebugAdapterContext.setMainClass(LaunchRequestHandler.parseMainClassWithoutModuleName(launchArguments.mainClass));
        iDebugAdapterContext.setStepFilters(launchArguments.stepFilters);
    }
}

