/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.config;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.config.ConfigTransfer;
import com.ghostchu.peerbanhelper.config.UpdateScript;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.MemoryConfiguration;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainConfigUpdateScript {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainConfigUpdateScript.class);
    private final YamlConfiguration conf;

    public MainConfigUpdateScript(YamlConfiguration conf) {
        this.conf = conf;
        this.validate();
    }

    private void validate() {
        String installationId = this.conf.getString("installation-id");
        if (installationId == null || installationId.isBlank()) {
            this.conf.set("installation-id", (Object)UUID.randomUUID().toString());
        }
    }

    @UpdateScript(version=40)
    public void banlistRemapping(YamlConfiguration bundle) {
        this.conf.set("banlist-remapping", bundle.get("banlist-remapping"));
    }

    @UpdateScript(version=38)
    public void pbhKeyString2List() {
        String key = this.conf.getString("pbh-plus-key");
        ArrayList<String> keys = new ArrayList<String>();
        if (key != null && !key.isBlank()) {
            keys.add(key);
        }
        this.conf.set("pbh-plus-key", keys);
    }

    @UpdateScript(version=37)
    public void synologyNetworkModeChangeTweaks() {
        if (!ExternalSwitch.parseBoolean("pbh.pkg.synology", false)) {
            return;
        }
        ConfigurationSection client = this.conf.getConfigurationSection("client");
        if (client == null) {
            return;
        }
        for (String key : client.getKeys(false)) {
            URI uri;
            String host;
            String endpoint;
            ConfigurationSection downloaderSection = client.getConfigurationSection(key);
            if (downloaderSection == null || (endpoint = downloaderSection.getString("endpoint")) == null || !(host = (uri = URI.create(endpoint)).getHost()).startsWith("172.")) continue;
            try {
                log.info("Updating endpoint for downloader {} for Synology DSM package upgrade from {} to {}.", new Object[]{key, endpoint, downloaderSection.getString("endpoint")});
                downloaderSection.set("endpoint", (Object)new URL(uri.getScheme(), "127.0.0.1", uri.getPort(), uri.getPath()).toString());
            }
            catch (MalformedURLException e) {
                log.error("Unable to update endpoint for downloader {} on Synology DSM: {}", (Object)key, (Object)e.getMessage());
            }
        }
    }

    @UpdateScript(version=36)
    public void stunSettings(YamlConfiguration bundle) {
        this.conf.set("stun", (Object)bundle.getConfigurationSection("stun"));
        this.conf.set("auto-stun", (Object)bundle.getConfigurationSection("auto-stun"));
    }

    @UpdateScript(version=35)
    public void migrateProxySettings() {
        switch (this.conf.getInt("proxy.setting", 0)) {
            case 0: {
                break;
            }
            case 1: {
                this.conf.set("proxy.setting", (Object)0);
                break;
            }
            case 2: {
                this.conf.set("proxy.setting", (Object)1);
                break;
            }
            case 3: {
                this.conf.set("proxy.setting", (Object)2);
            }
        }
    }

    @UpdateScript(version=34)
    public void cleanupUnusedFiles() {
        File decentralized = new File(Main.getDataDirectory(), "decentralized");
        CommonUtil.deleteFileOrDirectory(decentralized);
        File ipfs = new File(Main.getDataDirectory(), "ipfs");
        CommonUtil.deleteFileOrDirectory(ipfs);
        File p2p = new File(Main.getDataDirectory(), "p2p");
        CommonUtil.deleteFileOrDirectory(p2p);
    }

    @UpdateScript(version=33)
    public void cleanupDownloadedJCEFComponents() {
        File jcefDirectory = new File(Main.getDataDirectory(), "jcef");
        CommonUtil.deleteFileOrDirectory(jcefDirectory);
    }

    @UpdateScript(version=32)
    public void assignUniqueIdForDownloader() {
        ConfigurationSection clients = this.conf.getConfigurationSection("client");
        if (clients == null) {
            return;
        }
        MemoryConfiguration newClients = new MemoryConfiguration();
        for (String name : clients.getKeys(false)) {
            String uuid = UUID.randomUUID().toString();
            ConfigurationSection oldSection = clients.getConfigurationSection(name);
            if (oldSection == null) continue;
            oldSection.set("name", (Object)name);
            newClients.set(uuid, (Object)oldSection);
            log.info("[Downloader Id Re-assign] {} -> {}", (Object)name, (Object)uuid);
            ConfigTransfer.downloaderNameToUUID.put(name, uuid);
        }
        this.conf.set("client", (Object)newClients);
    }

    @UpdateScript(version=31)
    public void removeBanInvoker() {
        this.conf.set("banlist-invoker", null);
    }

    @UpdateScript(version=30)
    public void addGuiSettings() {
        this.conf.set("gui", (Object)"auto");
    }

    @UpdateScript(version=28)
    public void updateBtnNetworkAddress() {
        List<String> outdatedBtnAddress = List.of("https://btn-prod.ghostchu-services.top/ping/config", "https://btn-dev.ghostchu-services.top/ping/config", "https://btn-dev2.ghostchu-services.top/ping/config", "https://sparkle.ghostchu-services.top/ping/config", "http://btn-prod.ghostchu-services.top/ping/config", "http://btn-dev.ghostchu-services.top/ping/config", "http://btn-dev2.ghostchu-services.top/ping/config", "http://sparkle.ghostchu-services.top/ping/config");
        if (outdatedBtnAddress.contains(this.conf.getString("btn.config-url"))) {
            this.conf.set("btn.config-url", (Object)"https://sparkle.pbh-btn.com/ping/config");
        }
    }

    @UpdateScript(version=27)
    public void updateVacuum() {
        this.conf.set("persist.vacuum-interval-days", (Object)60);
    }

    @UpdateScript(version=26)
    public void pushProvidersSMTPStructUpgrade() {
        ConfigurationSection pushNotification = this.conf.getConfigurationSection("push-notification");
        if (pushNotification == null) {
            return;
        }
        for (String key : pushNotification.getKeys(false)) {
            ConfigurationSection single = pushNotification.getConfigurationSection(key);
            if (single == null) continue;
            if (single.getBoolean("enabled", false)) {
                pushNotification.set(key, null);
            } else {
                String type = single.getString("type");
                if ("smtp".equals(type)) {
                    single.set("auth", (Object)true);
                    if (single.getBoolean("ssl")) {
                        single.set("encryption", (Object)"STARTTLS");
                    } else {
                        single.set("encryption", (Object)"NONE");
                    }
                    single.set("ssl", null);
                    single.set("sendPartial", (Object)true);
                }
                pushNotification.set(key, (Object)single);
            }
            this.conf.set("push-notification", (Object)pushNotification);
        }
    }

    @UpdateScript(version=25)
    public void pushProvidersCleanup() {
        ConfigurationSection pushNotification = this.conf.getConfigurationSection("push-notification");
        if (pushNotification == null) {
            return;
        }
        for (String key : pushNotification.getKeys(false)) {
            Object chatId;
            ConfigurationSection single = pushNotification.getConfigurationSection(key);
            if (single == null) continue;
            single.set("enabled", null);
            Object sendKey = single.get("send-key");
            if (sendKey != null) {
                single.set("sendkey", sendKey);
                single.set("send-key", null);
            }
            if ((chatId = single.get("chat-id")) != null) {
                single.set("chatid", chatId);
                single.set("chat-id", null);
            }
            pushNotification.set(key, (Object)single);
        }
        this.conf.set("push-notification", (Object)pushNotification);
    }

    @UpdateScript(version=24)
    public void decentralizedConfiguration() {
        this.conf.set("decentralized.enabled", (Object)false);
        this.conf.set("decentralized.kubo-rpc", (Object)"/ip4/127.0.0.1/tcp/5001");
        this.conf.set("decentralized.features.publish-banlist", (Object)3600000);
    }

    @UpdateScript(version=23)
    public void btnScriptExecuteSwitch() {
        this.conf.set("btn.allow-script-execute", (Object)false);
    }

    @UpdateScript(version=22)
    public void miscChanges() {
        this.conf.set("privacy", null);
    }

    @UpdateScript(version=21)
    public void addPushProvider(YamlConfiguration bundle) {
        this.conf.set("push-notification", bundle.get("push-notification"));
    }

    @UpdateScript(version=19)
    public void telemetryErrorReporting() {
        this.conf.set("privacy.error-reporting", (Object)true);
    }

    @UpdateScript(version=18)
    public void noMaxmindDownload() {
        this.conf.set("ip-database.account-id", null);
        this.conf.set("ip-database.license-key", null);
    }

    @UpdateScript(version=17)
    public void windowsEcoQoSApi() {
        this.conf.set("performance.windows-ecoqos-api", (Object)true);
    }

    @UpdateScript(version=16)
    public void fixNonProxyHosts() {
        if (!this.conf.isSet("proxy.non-proxy-hosts")) {
            this.conf.set("proxy.non-proxy-hosts", this.conf.get("proxy.non-proxy-host", (Object)"localhost|127.*|192.168.*|10.*|172.16.*|172.17.*|172.18.*|172.19.*|172.20.*|172.21.*|172.22.*|172.23.*|172.24.*|172.25.*|172.26.*|172.27.*|172.28.*|172.29.*|172.30.*|172.31.*"));
        }
        this.conf.set("proxy.non-proxy-host", null);
    }

    @UpdateScript(version=15)
    public void pbhPlusKeyConfig() {
        this.conf.set("pbh-plus-key", (Object)"");
    }

    @UpdateScript(version=14)
    public void proxyServerConfigSectionEnhanced() {
        this.conf.set("proxy.non-proxy-host", (Object)"127.0.0.1|localhost");
    }

    @UpdateScript(version=13)
    public void proxyServerConfigSection() {
        this.conf.set("proxy.setting", (Object)0);
        this.conf.set("proxy.host", (Object)"127.0.0.1");
        this.conf.set("proxy.port", (Object)7890);
    }

    @UpdateScript(version=12)
    public void externalWebUI() {
        this.conf.set("server.external-webui", (Object)false);
    }

    @UpdateScript(version=11)
    public void corsSetting() {
        this.conf.set("server.allow-cors", (Object)false);
    }

    @UpdateScript(version=10)
    public void languageSetting() {
        this.conf.set("language", (Object)"default");
    }

    @UpdateScript(version=9)
    public void firewallIntegration() {
        this.conf.set("firewall-integration", null);
        this.conf.set("firewall-integration.windows-adv-firewall", (Object)true);
    }

    @UpdateScript(version=8)
    public void webToken() {
        this.conf.set("server.token", (Object)UUID.randomUUID().toString());
    }

    @UpdateScript(version=7)
    public void virtualThreads() {
        this.conf.set("threads", null);
    }

    @UpdateScript(version=6)
    public void maxmindIpDatabase() {
        this.conf.set("ip-database.account-id", (Object)"");
        this.conf.set("ip-database.license-key", (Object)"");
        this.conf.set("ip-database.database-city", (Object)"GeoLite2-City");
        this.conf.set("ip-database.database-asn", (Object)"GeoLite2-ASN");
        this.conf.set("ip-database.auto-update", (Object)true);
        File file = new File(Main.getDataDirectory(), "banlist.dump");
        if (file.exists()) {
            file.delete();
        }
    }

    @UpdateScript(version=5)
    public void optionForDnsReverseLookup() {
        this.conf.set("lookup.dns-reverse-lookup", (Object)false);
    }

    @UpdateScript(version=4)
    public void defTurnOffIncrementBans() {
        ConfigurationSection section = this.conf.getConfigurationSection("client");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection downloader = section.getConfigurationSection(key);
            if (downloader == null || !downloader.getString("type", "").equalsIgnoreCase("qBittorrent")) continue;
            downloader.set("increment-ban", (Object)false);
        }
    }

    @UpdateScript(version=3)
    public void transmissionCustomRPCUrl() {
        ConfigurationSection section = this.conf.getConfigurationSection("client");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection downloader = section.getConfigurationSection(key);
            if (downloader == null || !downloader.getString("type", "").equalsIgnoreCase("Transmission")) continue;
            downloader.set("rpc-url", (Object)"/transmission/rpc");
        }
    }

    @UpdateScript(version=2)
    public void addPersistBanlist() {
        this.conf.set("persist.banlist", (Object)true);
    }

    @UpdateScript(version=1)
    public void addIncrementBan() {
        ConfigurationSection section = this.conf.getConfigurationSection("client");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection downloader = section.getConfigurationSection(key);
            if (downloader == null || !downloader.getString("type", "").equalsIgnoreCase("qBittorrent")) continue;
            downloader.set("increment-ban", (Object)true);
        }
    }
}

