/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.database.table.TorrentEntity;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Deque;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PeerRecordDao
extends AbstractPBHDao<PeerRecordEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerRecordDao.class);

    public PeerRecordDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, PeerRecordEntity.class);
    }

    public void syncPendingTasks(Deque<BatchHandleTasks> tasks, TorrentDao torrentDao) throws SQLException {
        this.callBatchTasks(() -> {
            while (!tasks.isEmpty()) {
                BatchHandleTasks t = (BatchHandleTasks)tasks.pop();
                try {
                    this.writeToDatabase(torrentDao, t.timestamp, t.downloader, t.torrent, t.peer);
                }
                catch (SQLException e) {
                    log.error("Unable save peer record to database, please report to developer: {}, {}, {}, {}", new Object[]{t.timestamp, t.downloader, t.torrent, t.peer});
                }
            }
            return null;
        });
    }

    public long sessionBetween(@NotNull String downloader, @NotNull Timestamp startAt, @NotNull Timestamp endAt) throws SQLException {
        QueryBuilder queryBuilder = this.queryBuilder();
        Where where = queryBuilder.selectColumns(new String[]{"address"}).distinct().where();
        where.and(where.like("downloader", (Object)downloader), where.or(where.between("firstTimeSeen", (Object)startAt, (Object)endAt), where.between("lastTimeSeen", (Object)startAt, (Object)endAt)));
        return queryBuilder.countOf();
    }

    private int writeToDatabase(TorrentDao torrentDao, long timestamp, String downloader, TorrentWrapper torrent, PeerWrapper peer) throws SQLException {
        TorrentEntity torrentEntity = torrentDao.createIfNotExists(new TorrentEntity(null, torrent.getHash(), torrent.getName(), torrent.getSize(), torrent.isPrivateTorrent()));
        PeerRecordEntity currentSnapshot = new PeerRecordEntity(null, peer.toPeerAddress().getAddress().toNormalizedString(), peer.toPeerAddress().getPort(), torrentEntity, downloader, peer.getId().length() > 8 ? peer.getId().substring(0, 8) : peer.getId(), peer.getClientName(), 0L, 0L, 0L, 0L, 0L, 0L, peer.getFlags(), new Timestamp(timestamp), new Timestamp(timestamp));
        PeerRecordEntity databaseSnapshot = this.createIfNotExists(currentSnapshot);
        if (databaseSnapshot.getLastTimeSeen().after(new Timestamp(timestamp))) {
            return 0;
        }
        long downloadedIncremental = peer.getDownloaded() - databaseSnapshot.getDownloadedOffset();
        long uploadedIncremental = peer.getUploaded() - databaseSnapshot.getUploadedOffset();
        if (downloadedIncremental < 0L || uploadedIncremental < 0L) {
            databaseSnapshot.setDownloaded(databaseSnapshot.getDownloaded() + peer.getDownloaded());
            databaseSnapshot.setUploaded(databaseSnapshot.getUploaded() + peer.getUploaded());
        } else {
            databaseSnapshot.setDownloaded(databaseSnapshot.getDownloaded() + downloadedIncremental);
            databaseSnapshot.setUploaded(databaseSnapshot.getUploaded() + uploadedIncremental);
        }
        databaseSnapshot.setDownloadedOffset(peer.getDownloaded());
        databaseSnapshot.setUploadedOffset(peer.getUploaded());
        databaseSnapshot.setDownloadSpeed(peer.getDownloadSpeed());
        databaseSnapshot.setUploadSpeed(peer.getUploadSpeed());
        databaseSnapshot.setPeerId(currentSnapshot.getPeerId());
        databaseSnapshot.setClientName(currentSnapshot.getClientName());
        databaseSnapshot.setLastFlags(currentSnapshot.getLastFlags());
        databaseSnapshot.setLastTimeSeen(currentSnapshot.getLastTimeSeen());
        return this.update(databaseSnapshot);
    }

    public Page<PeerRecordEntity> getPendingSubmitPeerRecords(Pageable pageable, Timestamp afterThan) throws SQLException {
        QueryBuilder queryBuilder = this.queryBuilder().where().gt("lastTimeSeen", (Object)afterThan).or().isNull("lastTimeSeen").queryBuilder().orderBy("lastTimeSeen", true);
        return this.queryByPaging(queryBuilder, pageable);
    }

    public synchronized PeerRecordEntity createIfNotExists(PeerRecordEntity data) throws SQLException {
        PeerRecordEntity existing = (PeerRecordEntity)this.queryBuilder().where().eq("address", (Object)new SelectArg((Object)data.getAddress())).and().eq("torrent_id", (Object)data.getTorrent().getId()).and().eq("downloader", (Object)new SelectArg((Object)data.getDownloader())).queryForFirst();
        if (existing == null) {
            this.create(data);
            return data;
        }
        return existing;
    }

    public record BatchHandleTasks(long timestamp, String downloader, TorrentWrapper torrent, PeerWrapper peer) {
    }
}

