/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.transmission;

import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.bittorrent.tracker.TrackerImpl;
import com.ghostchu.peerbanhelper.downloader.impl.transmission.TRPeer;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import cordelia.rpc.types.Peers;
import cordelia.rpc.types.Torrents;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class TRTorrent
implements Torrent {
    private final Torrents backend;
    private final Function<PeerAddress, PeerAddress> natConverter;

    public TRTorrent(Torrents backend, Function<PeerAddress, PeerAddress> natConverter) {
        this.backend = backend;
        this.natConverter = natConverter;
    }

    @Override
    @NotNull
    public String getId() {
        return String.valueOf(this.backend.getId());
    }

    @Override
    @NotNull
    public String getName() {
        return this.backend.getName();
    }

    @Override
    @NotNull
    public String getHash() {
        return this.backend.getHashString();
    }

    @Override
    public double getProgress() {
        return this.backend.getPercentDone();
    }

    @Override
    public long getSize() {
        return this.backend.getTotalSize();
    }

    @Override
    public long getCompletedSize() {
        return (long)((double)this.backend.getSizeWhenDone().longValue() * this.backend.getPercentDone());
    }

    @Override
    public long getRtUploadSpeed() {
        return this.backend.getRateUpload();
    }

    @Override
    public long getRtDownloadSpeed() {
        return this.backend.getRateDownload();
    }

    @Override
    public boolean isPrivate() {
        return this.backend.getIsPrivate();
    }

    @NotNull
    public List<Peer> getPeers() {
        return this.backend.getPeers().stream().map(backend -> new TRPeer((Peers)backend, this.natConverter)).collect(Collectors.toList());
    }

    public Integer getPeerLimit() {
        return this.backend.getPeerLimit();
    }

    public List<Tracker> getTrackers() {
        return TrackerImpl.parseFromTrackerList(this.backend.getTrackerList());
    }
}

