/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.metric.impl.inmemory;

import com.ghostchu.peerbanhelper.metric.BasicMetrics;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import inet.ipaddr.IPAddress;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="inMemoryMetrics")
public final class InMemoryMetrics
implements BasicMetrics {
    private long checks = 0L;
    private long bans = 0L;
    private long unbans = 0L;
    private long wastedTraffic = 0L;
    private long savedTraffic = 0L;

    @Override
    public long getCheckCounter() {
        return this.checks;
    }

    @Override
    public long getPeerBanCounter() {
        return this.bans;
    }

    @Override
    public long getPeerUnbanCounter() {
        return this.unbans;
    }

    @Override
    public long getSavedTraffic() {
        return this.savedTraffic;
    }

    @Override
    public long getWastedTraffic() {
        return this.wastedTraffic;
    }

    @Override
    public void recordCheck() {
        ++this.checks;
    }

    @Override
    public synchronized void recordPeerBan(@NotNull IPAddress address, @NotNull BanMetadata metadata) {
        if (metadata.isBanForDisconnect()) {
            return;
        }
        ++this.bans;
        this.savedTraffic += Math.max(0L, metadata.getTorrent().getSize() - metadata.getPeer().getUploaded());
        this.wastedTraffic += metadata.getPeer().getUploaded();
    }

    @Override
    public synchronized void recordPeerUnban(@NotNull IPAddress address, @NotNull BanMetadata metadata) {
        if (metadata.isBanForDisconnect()) {
            return;
        }
        ++this.unbans;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

