/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module;

import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.websocket.WsCloseContext;
import io.javalin.websocket.WsCloseStatus;
import io.javalin.websocket.WsConfig;
import io.javalin.websocket.WsContext;
import io.javalin.websocket.WsErrorContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class AbstractWebSocketFeatureModule
extends AbstractFeatureModule {
    protected final List<WsContext> wsSessions = Collections.synchronizedList(new ArrayList());

    public void acceptWebSocket(WsConfig wsConfig, Consumer<WsContext> loggedInCallback) {
        wsConfig.onConnect(ctx -> {
            InetSocketAddress inetSocketAddress;
            SocketAddress patt0$temp = ctx.session.getRemoteAddress();
            if (patt0$temp instanceof InetSocketAddress && !this.javalinWebContainer.allowAttemptLogin((inetSocketAddress = (InetSocketAddress)patt0$temp).getHostString(), ctx.getUpgradeCtx$javalin().userAgent())) {
                ctx.closeSession(WsCloseStatus.TRY_AGAIN_LATER, JsonUtil.standard().toJson((Object)new StdResp(false, "Too many failed retries, IP banned.", null)));
                return;
            }
            JavalinWebContainer.TokenAuthResult authResult = this.javalinWebContainer.isContextAuthorized(ctx.getUpgradeCtx$javalin());
            if (authResult == JavalinWebContainer.TokenAuthResult.NO_AUTH_TOKEN_PROVIDED) {
                ctx.closeSession(WsCloseStatus.POLICY_VIOLATION, JsonUtil.standard().toJson((Object)new StdResp(false, TextManager.tlUI(Lang.WS_LOGS_STREAM_ACCESS_DENIED, new Object[0]), null)));
                return;
            }
            if (authResult == JavalinWebContainer.TokenAuthResult.FAILED) {
                ctx.closeSession(WsCloseStatus.POLICY_VIOLATION, JsonUtil.standard().toJson((Object)new StdResp(false, TextManager.tlUI(Lang.WS_LOGS_STREAM_ACCESS_DENIED, new Object[0]), null)));
                this.javalinWebContainer.markLoginFailed(this.userIp(ctx.getUpgradeCtx$javalin()), ctx.getUpgradeCtx$javalin().userAgent());
                return;
            }
            this.javalinWebContainer.markLoginSuccess(this.userIp(ctx.getUpgradeCtx$javalin()), ctx.getUpgradeCtx$javalin().userAgent(), false);
            ctx.enableAutomaticPings(15L, TimeUnit.SECONDS);
            this.wsSessions.add((WsContext)ctx);
            wsConfig.onMessage(ctx2 -> {
                if (ctx2.message().equalsIgnoreCase("PING")) {
                    ctx2.send("PONG");
                }
            });
            wsConfig.onClose(this::revokeWebSocketSession);
            wsConfig.onError(this::revokeWebSocketSession);
            loggedInCallback.accept((WsContext)ctx);
        });
    }

    private void revokeWebSocketSession(WsErrorContext wsErrorContext) {
        this.wsSessions.remove(wsErrorContext);
        wsErrorContext.closeSession(WsCloseStatus.SERVER_ERROR, JsonUtil.standard().toJson((Object)new StdResp(false, "Internal Server Error, Connection must be closed, check the console for details", null)));
    }

    private void revokeWebSocketSession(WsCloseContext wsCloseContext) {
        this.wsSessions.remove(wsCloseContext);
    }
}

