/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.impl.ScriptStorageDao;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.SharedObject;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.util.scriptengine.CompiledScript;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.exception.ExpressionSyntaxErrorException;
import com.googlecode.aviator.exception.TimeoutException;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public final class ExpressionRule
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpressionRule.class);
    private static final String VERSION = "2";
    private final long maxScriptExecuteTime = 1500L;
    private final JavalinWebContainer javalinWebContainer;
    private final ScriptEngine scriptEngine;
    private final List<CompiledScript> scripts = Collections.synchronizedList(new ArrayList());
    private final ScriptStorageDao scriptStorageDao;
    private long banDuration;
    private final ExecutorService parallelService = Executors.newWorkStealingPool();

    public ExpressionRule(JavalinWebContainer javalinWebContainer, ScriptEngine scriptEngine, ScriptStorageDao scriptStorageDao) {
        this.scriptEngine = scriptEngine;
        this.javalinWebContainer = javalinWebContainer;
        this.scriptStorageDao = scriptStorageDao;
    }

    @Override
    public void onEnable() {
        try {
            this.reloadConfig();
        }
        catch (Exception e) {
            log.error("Failed to load scripts", (Throwable)e);
        }
        ((Javalin)((Javalin)((Javalin)((Javalin)this.javalinWebContainer.javalin().get("/api/" + this.getConfigName() + "/scripts", this::listScripts, new RouteRole[]{Role.USER_READ})).get("/api/" + this.getConfigName() + "/editable", this::editable, new RouteRole[]{Role.USER_READ})).get("/api/" + this.getConfigName() + "/{scriptId}", this::readScript, new RouteRole[]{Role.USER_READ})).put("/api/" + this.getConfigName() + "/{scriptId}", this::writeScript, new RouteRole[]{Role.USER_WRITE})).delete("/api/" + this.getConfigName() + "/{scriptId}", this::deleteScript, new RouteRole[]{Role.USER_WRITE});
    }

    private void editable(Context context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean editable = this.isSafeNetworkEnvironment(context);
        map.put("editable", editable);
        map.put("reason", editable ? null : TextManager.tl(this.locale(context), Lang.EXPRESS_RULE_ENGINE_DISALLOW_UNSAFE_SOURCE_ACCESS, context.ip()));
        context.json((Object)new StdResp(true, null, map));
    }

    private void deleteScript(Context context) throws IOException {
        if (!this.isSafeNetworkEnvironment(context)) {
            context.status(HttpStatus.FORBIDDEN);
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), Lang.EXPRESS_RULE_ENGINE_DISALLOW_UNSAFE_SOURCE_ACCESS, context.ip()), null));
            return;
        }
        String scriptId = context.pathParam("scriptId");
        File readFile = this.getIfAllowedScriptId(scriptId);
        if (readFile == null) {
            context.status(HttpStatus.BAD_REQUEST);
            context.json((Object)new StdResp(false, "Access to this resource is disallowed", null));
            return;
        }
        if (!readFile.exists()) {
            context.status(HttpStatus.NOT_FOUND);
            context.json((Object)new StdResp(false, "This script are not exists", null));
            return;
        }
        readFile.delete();
        context.json((Object)new StdResp(true, "OK!", null));
        this.reloadConfig();
    }

    private void writeScript(Context context) throws IOException {
        if (!this.isSafeNetworkEnvironment(context)) {
            context.status(HttpStatus.FORBIDDEN);
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), Lang.EXPRESS_RULE_ENGINE_DISALLOW_UNSAFE_SOURCE_ACCESS, context.ip()), null));
            return;
        }
        String scriptId = context.pathParam("scriptId");
        File readFile = this.getIfAllowedScriptId(scriptId);
        if (readFile == null) {
            context.status(HttpStatus.BAD_REQUEST);
            context.json((Object)new StdResp(false, "Access to this resource is disallowed", null));
            return;
        }
        Files.write(readFile.toPath(), context.bodyAsBytes(), StandardOpenOption.CREATE);
        context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.EXPRESS_RULE_ENGINE_SAVED, new Object[0]), null));
        this.reloadConfig();
    }

    private void readScript(Context context) throws IOException {
        String scriptId = context.pathParam("scriptId");
        File readFile = this.getIfAllowedScriptId(scriptId);
        if (readFile == null) {
            context.status(HttpStatus.BAD_REQUEST);
            context.json((Object)new StdResp(false, "Access to this resource is disallowed", null));
            return;
        }
        if (!readFile.exists()) {
            context.status(HttpStatus.NOT_FOUND);
            context.json((Object)new StdResp(false, "This script are not exists", null));
            return;
        }
        context.json((Object)new StdResp(true, null, Files.readString(readFile.toPath(), StandardCharsets.UTF_8)));
    }

    @Nullable
    private File getIfAllowedScriptId(String scriptId) {
        File readFile;
        if (scriptId.isBlank()) {
            throw new IllegalArgumentException("ScriptId cannot be null or blank");
        }
        if (!scriptId.endsWith(".av")) {
            return null;
        }
        File scriptDir = new File(Main.getDataDirectory(), "scripts");
        if (this.insideDirectory(scriptDir, readFile = new File(scriptDir, scriptId))) {
            return readFile;
        }
        return null;
    }

    private boolean isSafeNetworkEnvironment(Context context) {
        String value = ExternalSwitch.parse("pbh.please-disable-safe-network-environment-check-i-know-this-is-very-dangerous-and-i-may-lose-my-data-and-hacker-may-attack-me-via-this-endpoint-and-steal-my-data-or-destroy-my-computer-i-am-fully-responsible-for-this-action-and-i-will-not-blame-the-developer-for-any-loss");
        if (value != null && value.equals("true")) {
            return true;
        }
        IPAddress ip = IPAddressUtil.getIPAddress(context.ip());
        if (ip == null) {
            throw new IllegalArgumentException("Safe check for IPAddress failed, the IP cannot be null");
        }
        return (ip.isLocal() || ip.isLoopback()) && !WebUtil.isUsingReserveProxy(context);
    }

    private boolean insideDirectory(File allowRange, File targetFile) {
        Path path = allowRange.toPath().normalize().toAbsolutePath();
        Path target = targetFile.toPath().normalize().toAbsolutePath();
        return target.startsWith(path);
    }

    private void listScripts(Context context) {
        Pageable pageable = new Pageable(context);
        ArrayList<ExpressionMetadataDto> list = new ArrayList<ExpressionMetadataDto>();
        for (CompiledScript script : this.scripts) {
            list.add(new ExpressionMetadataDto(script.file().getName(), script.name(), script.author(), script.cacheable(), script.threadSafe(), script.version()));
        }
        List r = list.stream().skip(pageable.getZeroBasedPage() * pageable.getSize()).limit(pageable.getSize()).toList();
        context.json((Object)new StdResp(true, null, new Page(pageable, list.size(), r)));
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Expression Engine";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "expression-engine";
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        AtomicReference<CheckResult> checkResult = new AtomicReference<CheckResult>(this.pass());
        for (CompletableFuture future : this.scripts.stream().map(compiledScript -> CompletableFuture.runAsync(() -> {
            CheckResult expressionRun = this.runExpression((CompiledScript)compiledScript, torrent, peer, downloader);
            if (expressionRun.action() == PeerAction.SKIP) {
                checkResult.set(expressionRun);
                return;
            }
            if (expressionRun.action() == PeerAction.BAN && ((CheckResult)checkResult.get()).action() != PeerAction.SKIP) {
                checkResult.set(expressionRun);
            }
        }, this.parallelService)).toList()) {
            future.join();
        }
        return checkResult.get();
    }

    public CheckResult runExpression(CompiledScript script, @NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        return this.getCache().readCacheButWritePassOnly(this, script.expression().hashCode() + peer.getCacheKey(), () -> {
            CheckResult result;
            try {
                Object returns;
                Map env = script.expression().newEnv(new Object[0]);
                env.put("torrent", torrent);
                env.put("peer", peer);
                env.put("downloader", downloader);
                env.put("cacheable", new AtomicBoolean(false));
                env.put("server", this.getServer());
                env.put("moduleInstance", this);
                env.put("banDuration", this.banDuration);
                env.put("persistStorage", this.scriptStorageDao);
                env.put("ramStorage", SharedObject.SCRIPT_THREAD_SAFE_MAP);
                if (script.threadSafe()) {
                    returns = script.expression().execute(env);
                } else {
                    Expression expression = script.expression();
                    synchronized (expression) {
                        returns = script.expression().execute(env);
                    }
                }
                result = this.scriptEngine.handleResult(script, this.banDuration, returns);
            }
            catch (TimeoutException timeoutException) {
                return this.pass();
            }
            catch (Exception ex) {
                log.error(TextManager.tlUI(Lang.RULE_ENGINE_ERROR, script.name()), (Throwable)ex);
                return this.pass();
            }
            if (result != null && result.action() != PeerAction.NO_ACTION) {
                return result;
            }
            return this.pass();
        }, script.cacheable());
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() throws IOException {
        this.scripts.clear();
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.initScripts();
        log.info(TextManager.tlUI(Lang.RULE_ENGINE_COMPILING, new Object[0]));
        long start = System.currentTimeMillis();
        try (ExecutorService executor = Executors.newWorkStealingPool();){
            File scriptDir = new File(Main.getDataDirectory(), "scripts");
            File[] scripts = scriptDir.listFiles();
            if (scripts != null) {
                for (File script : scripts) {
                    executor.submit(() -> {
                        try {
                            if (!script.getName().endsWith(".av") || script.isHidden()) {
                                return;
                            }
                            try {
                                String scriptContent = Files.readString(script.toPath(), StandardCharsets.UTF_8);
                                CompiledScript compiledScript = this.scriptEngine.compileScript(script, script.getName(), scriptContent);
                                if (compiledScript == null) {
                                    return;
                                }
                                this.scripts.add(compiledScript);
                            }
                            catch (IOException e) {
                                log.error("Unable to load script file", (Throwable)e);
                            }
                        }
                        catch (ExpressionSyntaxErrorException err) {
                            log.error(TextManager.tlUI(Lang.RULE_ENGINE_BAD_EXPRESSION, new Object[0]), (Throwable)err);
                        }
                    });
                }
            }
        }
        this.getCache().invalidateAll();
        log.info(TextManager.tlUI(Lang.RULE_ENGINE_COMPILED, this.scripts.size(), System.currentTimeMillis() - start));
    }

    private void initScripts() throws IOException {
        Resource[] res;
        String version;
        File scriptDir = new File(Main.getDataDirectory(), "scripts");
        scriptDir.mkdirs();
        File versionFile = new File(scriptDir, "version");
        if (!versionFile.exists()) {
            versionFile.createNewFile();
        }
        if (VERSION.equals(version = Files.readString(versionFile.toPath(), StandardCharsets.UTF_8))) {
            return;
        }
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(Main.class.getClassLoader());
        for (Resource re : res = resourcePatternResolver.getResources("classpath:scripts/**/*.*")) {
            String content = new String(re.getContentAsByteArray(), StandardCharsets.UTF_8);
            File file = new File(scriptDir, re.getFilename());
            if (file.exists()) continue;
            file.createNewFile();
            Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        Files.writeString(versionFile.toPath(), (CharSequence)VERSION, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    record ExpressionMetadataDto(String id, String name, String author, boolean cacheable, boolean threadSafe, String version) {
    }
}

