/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;

public final class GotifyPushProvider
extends AbstractPushProvider {
    private final Config config;
    private final String name;
    private final HTTPUtil httpUtil;

    public GotifyPushProvider(String name, Config config, HTTPUtil httpUtil) {
        this.name = name;
        this.config = config;
        this.httpUtil = httpUtil;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "gotify";
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"gotify");
        section.set("endpoint", (Object)this.config.getEndpoint());
        section.set("priority", (Object)this.config.getPriority());
        return section;
    }

    public static GotifyPushProvider loadFromJson(String name, JsonObject json, HTTPUtil httpUtil) {
        return new GotifyPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class), httpUtil);
    }

    public static GotifyPushProvider loadFromYaml(String name, ConfigurationSection section, HTTPUtil httpUtil) {
        String backendUrl = section.getString("endpoint", "https://push.example.de/message?token=<apptoken>");
        int priority = section.getInt("priority", 5);
        Config config = new Config(backendUrl, priority);
        return new GotifyPushProvider(name, config, httpUtil);
    }

    @Override
    public boolean push(String title, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("message", content);
        FormBody.Builder formBody = new FormBody.Builder();
        FormBody form = formBody.add("title", title).add("message", content).add("priority", String.valueOf(this.config.getPriority())).build();
        Request request = new Request.Builder().url(this.config.getEndpoint()).post((RequestBody)form).header("Content-Type", "application/x-www-form-urlencoded").build();
        try (Response response = this.httpUtil.newBuilder().build().newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException("HTTP Failed while sending push messages to Gotify: " + response.body().string());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send push message to Gotify", e);
        }
        return true;
    }

    public static class Config {
        @SerializedName(value="endpoint")
        private String endpoint;
        @SerializedName(value="priority")
        private int priority;

        @Generated
        public Config(String endpoint, int priority) {
            this.endpoint = endpoint;
            this.priority = priority;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setPriority(int priority) {
            this.priority = priority;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPriority() != other.getPriority()) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPriority();
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GotifyPushProvider.Config(endpoint=" + this.getEndpoint() + ", priority=" + this.getPriority() + ")";
        }
    }
}

