/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.Host;
import raccoonfink.deluge.responses.DelugeResponse;

public final class HostResponse
extends DelugeResponse {
    private final List<Host> m_hosts = new ArrayList<Host>();

    public HostResponse(Integer httpResponseCode, JSONObject response, boolean singleResult) throws DelugeException {
        super(httpResponseCode, response);
        try {
            JSONArray result = response.getJSONArray("result");
            if (singleResult) {
                this.m_hosts.add(this.getHost(result));
            } else {
                for (int i = 0; i < result.length(); ++i) {
                    JSONArray host = result.getJSONArray(i);
                    this.m_hosts.add(this.getHost(host));
                }
            }
        }
        catch (JSONException e) {
            throw new DelugeException(e);
        }
    }

    public List<Host> getHosts() {
        return Collections.unmodifiableList(this.m_hosts);
    }

    private Host getHost(JSONArray host) throws JSONException {
        return new Host(host.getString(0), host.getString(1), host.getInt(2), host.getString(3), host.optString(4));
    }

    @Override
    public JSONObject toResponseJSON() throws JSONException {
        JSONObject ret = super.toResponseJSON();
        for (Host host : this.m_hosts) {
            ret.append("result", (Object)host.toJSON());
        }
        return ret;
    }
}

