/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.mapgenerator.MapLandmassGenerator;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\n\u00a6\u0001\u00a7\u0001\u00a8\u0001\u00a9\u0001\u00aa\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B#\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB+\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0006\u0010`\u001a\u00020\u0000J\u0011\u0010a\u001a\u00020\n2\u0006\u0010b\u001a\u00020cH\u0087\u0002J\u0011\u0010a\u001a\u00020\n2\u0006\u0010d\u001a\u00020eH\u0087\u0002J\u0018\u0010a\u001a\u00020\n2\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u0003H\u0007J\u0011\u0010h\u001a\u00020\u00172\u0006\u0010b\u001a\u00020cH\u0087\u0002J\u0011\u0010h\u001a\u00020\u00172\u0006\u0010d\u001a\u00020eH\u0087\u0002J\u0019\u0010h\u001a\u00020\u00172\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u0003H\u0087\u0002J\u001a\u0010i\u001a\u0004\u0018\u00010\u00172\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u0003H\u0003J\u0006\u0010j\u001a\u00020\nJ\u001e\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00170l2\u0006\u0010m\u001a\u00020e2\u0006\u0010n\u001a\u00020\u0003H\u0007J\u001e\u0010o\u001a\b\u0012\u0004\u0012\u00020\u00170l2\u0006\u0010m\u001a\u00020e2\u0006\u0010p\u001a\u00020qH\u0007J\u001e\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00170l2\u0006\u0010m\u001a\u00020e2\u0006\u0010n\u001a\u00020\u0003H\u0007J\u0014\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00170l2\u0006\u0010t\u001a\u00020uJ\u001a\u0010v\u001a\u0004\u0018\u00010\u00172\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u0003H\u0007J\u0018\u0010w\u001a\u00020\u00032\u0006\u0010x\u001a\u00020\u00172\u0006\u0010y\u001a\u00020\u0017H\u0007J\u001a\u0010z\u001a\u0004\u0018\u00010\u00172\u0006\u0010x\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\u0003H\u0007J\u0018\u0010|\u001a\u00020c2\u0006\u0010x\u001a\u00020\u00172\u0006\u0010y\u001a\u00020\u0017H\u0007J\u0010\u0010}\u001a\u00020e2\u0006\u0010~\u001a\u00020eH\u0007J*\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u0017022\u0006\u0010~\u001a\u00020e2\u0007\u0010\u0080\u0001\u001a\u00020\u00032\t\b\u0002\u0010\u0081\u0001\u001a\u00020\nH\u0007J\u001f\u0010\u0082\u0001\u001a\u0012\u0012\u0004\u0012\u00020!0Yj\b\u0012\u0004\u0012\u00020!`Z2\u0006\u0010\u0007\u001a\u00020\bJ\u0007\u0010\u0083\u0001\u001a\u00020\nJ\u0007\u0010\u0084\u0001\u001a\u00020\nJ\u001f\u0010\u0085\u0001\u001a\u00030\u0086\u00012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\t\b\u0002\u0010\u0087\u0001\u001a\u00020\nJ\b\u0010\u0088\u0001\u001a\u00030\u0086\u0001J\u0011\u0010\u0089\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u008a\u0001\u001a\u00020\bJ8\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u0006\u0010~\u001a\u00020e2\u0007\u0010\u008d\u0001\u001a\u00020!2\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u000b\b\u0002\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0003\u0010\u0091\u0001J9\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u0006\u0010~\u001a\u00020e2\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u000b\b\u0002\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0003\u0010\u0094\u0001J\u0012\u0010\u0095\u0001\u001a\u00030\u0086\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001J\u001c\u0010\u0098\u0001\u001a\u00030\u0086\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001J\b\u0010\u009b\u0001\u001a\u00030\u0086\u0001J$\u0010\u009c\u0001\u001a\u00020\n2\u0007\u0010\u009d\u0001\u001a\u00020!2\u0006\u0010x\u001a\u00020\u00172\n\b\u0002\u0010\u009e\u0001\u001a\u00030\u009f\u0001J\u0018\u0010\u00a0\u0001\u001a\u00020\n2\u0007\u0010\u009d\u0001\u001a\u00020!2\u0006\u0010x\u001a\u00020\u0017J\u0011\u0010\u00a1\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u009d\u0001\u001a\u00020!J\u0010\u0010\u00a1\u0001\u001a\u00030\u0086\u00012\u0006\u0010~\u001a\u00020eJ\b\u0010\u00a2\u0001\u001a\u00030\u0086\u0001J\u0012\u0010\u00a3\u0001\u001a\u00030\u0086\u00012\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u0016j\b\u0012\u0004\u0012\u00020\u001e`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R,\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!02\u0012\u0004\u0012\u00020301X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107RR\u00108\u001a:\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0017`\u00180\u0016j\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0017`\u0018`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010\u001cR\u001a\u0010;\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010\u0005R\u001a\u0010?\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010=\"\u0004\bA\u0010\u0005R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010=\"\u0004\bC\u0010\u0005R\u001b\u0010D\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bE\u0010=R\u001b\u0010H\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010G\u001a\u0004\bI\u0010=R!\u0010K\u001a\b\u0012\u0004\u0012\u00020!0L8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010G\u001a\u0004\bM\u0010NR!\u0010P\u001a\b\u0012\u0004\u0012\u00020!0L8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bR\u0010G\u001a\u0004\bQ\u0010NR\u0017\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00170T8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010VRM\u0010W\u001a>\u0012\u0004\u0012\u00020!\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00170Yj\b\u0012\u0004\u0012\u00020\u0017`Z0Xj\u001e\u0012\u0004\u0012\u00020!\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00170Yj\b\u0012\u0004\u0012\u00020\u0017`Z`[\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010]R-\u0010^\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030Xj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`[\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010]\u00a8\u0006\u00ab\u0001"}, d2={"Lcom/unciv/logic/map/TileMap;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "initialCapacity", "", "<init>", "(I)V", "radius", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "worldWrap", "", "(ILcom/unciv/models/ruleset/Ruleset;Z)V", "width", "height", "(IILcom/unciv/models/ruleset/Ruleset;Z)V", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getMapParameters", "()Lcom/unciv/logic/map/MapParameters;", "setMapParameters", "(Lcom/unciv/logic/map/MapParameters;)V", "tileList", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/ArrayList;", "getTileList", "()Ljava/util/ArrayList;", "setTileList", "(Ljava/util/ArrayList;)V", "startingLocations", "Lcom/unciv/logic/map/TileMap$StartingLocation;", "getStartingLocations", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "tileUniqueMapCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/unciv/logic/map/TileMap$TerrainListData;", "getTileUniqueMapCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "setTileUniqueMapCache", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "tileMatrix", "getTileMatrix", "setTileMatrix", "leftX", "getLeftX", "()I", "setLeftX", "bottomY", "getBottomY", "setBottomY", "getWidth", "setWidth", "maxLatitude", "getMaxLatitude", "maxLatitude$delegate", "Lkotlin/Lazy;", "maxLongitude", "getMaxLongitude", "maxLongitude$delegate", "naturalWonders", "", "getNaturalWonders", "()Ljava/util/Set;", "naturalWonders$delegate", "resources", "getResources", "resources$delegate", "values", "", "getValues", "()Ljava/util/Collection;", "startingLocationsByNation", "Ljava/util/HashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "getStartingLocationsByNation", "()Ljava/util/HashMap;", "continentSizes", "getContinentSizes", "clone", "contains", "vector", "Lcom/badlogic/gdx/math/Vector2;", "hexCoord", "Lcom/unciv/logic/map/HexCoord;", "x", "y", "get", "getOrNull", "hasGameInfo", "getTilesInDistance", "Lkotlin/sequences/Sequence;", "origin", "distance", "getTilesInDistanceRange", "range", "Lkotlin/ranges/IntRange;", "getTilesAtDistance", "getTilesInRectangle", "rectangle", "Lcom/badlogic/gdx/math/Rectangle;", "getIfTileExistsOrNull", "getNeighborTileClockPosition", "tile", "otherTile", "getClockPositionNeighborTile", "clockPosition", "getNeighborTilePositionAsWorldCoords", "getUnwrappedPosition", "position", "getViewableTiles", "sightDistance", "forAttack", "getRulesetIncompatibility", "isWaterMap", "usingArchipelagoRegions", "setTransients", "", "setUnitCivTransients", "setNeutralTransients", "removeMissingTerrainModReferences", "ruleSet", "placeUnitNearTile", "Lcom/unciv/logic/map/mapunit/MapUnit;", "unitName", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "unitId", "(Lcom/unciv/logic/map/HexCoord;Ljava/lang/String;Lcom/unciv/logic/civilization/Civilization;Ljava/lang/Integer;)Lcom/unciv/logic/map/mapunit/MapUnit;", "baseUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "(Lcom/unciv/logic/map/HexCoord;Lcom/unciv/models/ruleset/unit/BaseUnit;Lcom/unciv/logic/civilization/Civilization;Ljava/lang/Integer;)Lcom/unciv/logic/map/mapunit/MapUnit;", "stripPlayer", "player", "Lcom/unciv/models/metadata/Player;", "switchPlayersNation", "newNation", "Lcom/unciv/models/ruleset/nation/Nation;", "setStartingLocationsTransients", "addStartingLocation", "nationName", "usage", "Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "removeStartingLocation", "removeStartingLocations", "clearStartingLocations", "assignContinents", "mode", "Lcom/unciv/logic/map/TileMap$AssignContinentsMode;", "StartingLocation", "TerrainListData", "ViewableTile", "AssignContinentsMode", "Preview", "core"})
@SourceDebugExtension(value={"SMAP\nTileMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileMap.kt\ncom/unciv/logic/map/TileMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,811:1\n1#2:812\n774#3:813\n865#3,2:814\n774#3:816\n865#3,2:817\n1563#3:819\n1634#3,3:820\n774#3:823\n865#3,2:824\n1563#3:826\n1634#3,3:827\n1563#3:830\n1634#3,3:831\n1068#3:838\n295#3,2:839\n1869#3,2:841\n1869#3,2:843\n1869#3,2:845\n774#3:847\n865#3,2:848\n2746#3,3:850\n1869#3,2:853\n774#3:855\n865#3,2:856\n1869#3,2:858\n1869#3,2:860\n774#3:862\n865#3,2:863\n205#4,4:834\n*S KotlinDebug\n*F\n+ 1 TileMap.kt\ncom/unciv/logic/map/TileMap\n*L\n432#1:813\n432#1:814,2\n445#1:816\n445#1:817,2\n445#1:819\n445#1:820,3\n447#1:823\n447#1:824,2\n447#1:826\n447#1:827,3\n456#1:830\n456#1:831,3\n612#1:838\n613#1:839,2\n617#1:841,2\n660#1:843,2\n677#1:845,2\n684#1:847\n684#1:848,2\n686#1:850,3\n760#1:853,2\n775#1:855\n775#1:856,2\n780#1:858,2\n785#1:860,2\n792#1:862\n792#1:863,2\n476#1:834,4\n*E\n"})
public final class TileMap
implements IsPartOfGameInfoSerialization {
    @NotNull
    private MapParameters mapParameters;
    @NotNull
    private ArrayList<Tile> tileList;
    @NotNull
    private final ArrayList<StartingLocation> startingLocations;
    @NotNull
    private String description;
    public transient GameInfo gameInfo;
    @Nullable
    private transient Ruleset ruleset;
    @NotNull
    private transient ConcurrentHashMap<List<String>, TerrainListData> tileUniqueMapCache;
    @NotNull
    private transient ArrayList<ArrayList<Tile>> tileMatrix;
    private transient int leftX;
    private transient int bottomY;
    private transient int width;
    @NotNull
    private final transient Lazy maxLatitude$delegate;
    @NotNull
    private final transient Lazy maxLongitude$delegate;
    @NotNull
    private final transient Lazy naturalWonders$delegate;
    @NotNull
    private final transient Lazy resources$delegate;
    @NotNull
    private final transient HashMap<String, HashSet<Tile>> startingLocationsByNation;
    @NotNull
    private final transient HashMap<Integer, Integer> continentSizes;

    public TileMap(int initialCapacity) {
        this.mapParameters = new MapParameters();
        this.tileList = new ArrayList(initialCapacity);
        this.startingLocations = new ArrayList();
        this.description = "";
        this.tileUniqueMapCache = new ConcurrentHashMap();
        this.tileMatrix = new ArrayList();
        this.maxLatitude$delegate = LazyKt.lazy(() -> TileMap.maxLatitude_delegate$lambda$0(this));
        this.maxLongitude$delegate = LazyKt.lazy(() -> TileMap.maxLongitude_delegate$lambda$0(this));
        this.naturalWonders$delegate = LazyKt.lazy(() -> TileMap.naturalWonders_delegate$lambda$0(this));
        this.resources$delegate = LazyKt.lazy(() -> TileMap.resources_delegate$lambda$0(this));
        this.startingLocationsByNation = new HashMap();
        this.continentSizes = new HashMap();
    }

    public /* synthetic */ TileMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public final MapParameters getMapParameters() {
        return this.mapParameters;
    }

    public final void setMapParameters(@NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(mapParameters, "<set-?>");
        this.mapParameters = mapParameters;
    }

    @NotNull
    public final ArrayList<Tile> getTileList() {
        return this.tileList;
    }

    public final void setTileList(@NotNull ArrayList<Tile> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.tileList = arrayList;
    }

    @NotNull
    public final ArrayList<StartingLocation> getStartingLocations() {
        return this.startingLocations;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.description = string;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo != null) {
            return gameInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
        return null;
    }

    public final void setGameInfo(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "<set-?>");
        this.gameInfo = gameInfo;
    }

    @Nullable
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    public final void setRuleset(@Nullable Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    @NotNull
    public final ConcurrentHashMap<List<String>, TerrainListData> getTileUniqueMapCache() {
        return this.tileUniqueMapCache;
    }

    public final void setTileUniqueMapCache(@NotNull ConcurrentHashMap<List<String>, TerrainListData> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.tileUniqueMapCache = concurrentHashMap;
    }

    @NotNull
    public final ArrayList<ArrayList<Tile>> getTileMatrix() {
        return this.tileMatrix;
    }

    public final void setTileMatrix(@NotNull ArrayList<ArrayList<Tile>> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.tileMatrix = arrayList;
    }

    public final int getLeftX() {
        return this.leftX;
    }

    public final void setLeftX(int n) {
        this.leftX = n;
    }

    public final int getBottomY() {
        return this.bottomY;
    }

    public final void setBottomY(int n) {
        this.bottomY = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getMaxLatitude() {
        Lazy lazy = this.maxLatitude$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getMaxLongitude() {
        Lazy lazy = this.maxLongitude$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final Set<String> getNaturalWonders() {
        Lazy lazy = this.naturalWonders$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Set<String> getResources() {
        Lazy lazy = this.resources$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Collection<Tile> getValues() {
        return this.tileList;
    }

    @NotNull
    public final HashMap<String, HashSet<Tile>> getStartingLocationsByNation() {
        return this.startingLocationsByNation;
    }

    @NotNull
    public final HashMap<Integer, Integer> getContinentSizes() {
        return this.continentSizes;
    }

    /*
     * WARNING - void declaration
     */
    public TileMap(int radius, @NotNull Ruleset ruleset, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this(HexMath.INSTANCE.getNumberOfTilesInHexagon(radius));
        this.startingLocations.clear();
        String firstAvailableLandTerrain = MapLandmassGenerator.Companion.getInitializationTerrain$core(ruleset, TerrainType.Land);
        for (HexCoord vector : HexMath.INSTANCE.getHexCoordsInDistance(HexCoord.Companion.getZero(), radius, worldWrap)) {
            void $this$_init__u24lambda_u240;
            Tile tile;
            Tile tile2 = tile = new Tile();
            ArrayList<Tile> arrayList = this.tileList;
            boolean bl = false;
            $this$_init__u24lambda_u240.setPosition(vector.asSerializable());
            $this$_init__u24lambda_u240.setBaseTerrain(firstAvailableLandTerrain);
            arrayList.add(tile);
        }
        TileMap.setTransients$default(this, ruleset, false, 2, null);
    }

    public /* synthetic */ TileMap(int n, Ruleset ruleset, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(n, ruleset, bl);
    }

    /*
     * WARNING - void declaration
     */
    public TileMap(int width, int height, @NotNull Ruleset ruleset, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this(width * height);
        this.startingLocations.clear();
        String firstAvailableLandTerrain = MapLandmassGenerator.Companion.getInitializationTerrain$core(ruleset, TerrainType.Land);
        int wrapAdjustedWidth = worldWrap && width % 2 != 0 ? width - 1 : width;
        int column = -wrapAdjustedWidth / 2;
        int n = (wrapAdjustedWidth - 1) / 2;
        if (column <= n) {
            while (true) {
                int n2;
                int row;
                if ((row = -height / 2) <= (n2 = (height - 1) / 2)) {
                    while (true) {
                        void $this$_init__u24lambda_u241;
                        Tile tile;
                        Tile tile2 = tile = new Tile();
                        ArrayList<Tile> arrayList = this.tileList;
                        boolean bl = false;
                        $this$_init__u24lambda_u241.setPosition(HexMath.INSTANCE.getTileCoordsFromColumnRow(column, row).asSerializable());
                        $this$_init__u24lambda_u241.setBaseTerrain(firstAvailableLandTerrain);
                        arrayList.add(tile);
                        if (row == n2) break;
                        ++row;
                    }
                }
                if (column == n) break;
                ++column;
            }
        }
        TileMap.setTransients$default(this, ruleset, false, 2, null);
    }

    public /* synthetic */ TileMap(int n, int n2, Ruleset ruleset, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(n, n2, ruleset, bl);
    }

    @NotNull
    public final TileMap clone() {
        TileMap toReturn = new TileMap(this.tileList.size());
        CollectionsKt.addAll((Collection)toReturn.tileList, SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::clone$lambda$0));
        toReturn.mapParameters = this.mapParameters;
        toReturn.ruleset = this.ruleset;
        toReturn.startingLocations.clear();
        toReturn.startingLocations.ensureCapacity(this.startingLocations.size());
        toReturn.startingLocations.addAll((Collection<StartingLocation>)this.startingLocations);
        toReturn.description = this.description;
        toReturn.tileUniqueMapCache = this.tileUniqueMapCache;
        return toReturn;
    }

    @Readonly
    public final boolean contains(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.contains((int)vector.x, (int)vector.y);
    }

    @Readonly
    public final boolean contains(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return this.contains(hexCoord.getX(), hexCoord.getY());
    }

    @Readonly
    public final boolean contains(int x, int y) {
        return this.getOrNull(x, y) != null;
    }

    @Readonly
    @NotNull
    public final Tile get(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.get((int)vector.x, (int)vector.y);
    }

    @Readonly
    @NotNull
    public final Tile get(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return this.get(hexCoord.getX(), hexCoord.getY());
    }

    @Readonly
    @NotNull
    public final Tile get(int x, int y) {
        Tile tile = this.tileMatrix.get(x - this.leftX).get(y - this.bottomY);
        Intrinsics.checkNotNull(tile);
        return tile;
    }

    @Readonly
    private final Tile getOrNull(int x, int y) {
        ArrayList arrayList = (ArrayList)CollectionsKt.getOrNull((List)this.tileMatrix, x - this.leftX);
        return arrayList != null ? (Tile)CollectionsKt.getOrNull(arrayList, y - this.bottomY) : null;
    }

    public final boolean hasGameInfo() {
        return this.gameInfo != null;
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getTilesInDistance(@NotNull HexCoord origin2, int distance) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        return this.getTilesInDistanceRange(origin2, new IntRange(0, distance));
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getTilesInDistanceRange(@NotNull HexCoord origin2, @NotNull IntRange range) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Intrinsics.checkNotNullParameter(range, "range");
        return SequencesKt.flatMap(CollectionsKt.asSequence(range), arg_0 -> TileMap.getTilesInDistanceRange$lambda$0(this, origin2, arg_0));
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getTilesAtDistance(@NotNull HexCoord origin2, int distance) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        return distance <= 0 ? SequencesKt.sequenceOf(this.get(origin2)) : SequencesKt.filterNotNull(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(origin2, distance, this, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HexCoord $origin;
            final /* synthetic */ int $distance;
            final /* synthetic */ TileMap this$0;
            {
                this.$origin = $origin;
                this.$distance = $distance;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        centerX = this.$origin.getX();
                        centerY = this.$origin.getY();
                        currentX = centerX - this.$distance;
                        currentY = centerY - this.$distance;
                        i = 0;
lbl11:
                        // 2 sources

                        while (i < this.$distance) {
                            this.L$0 = $this$sequence;
                            this.I$0 = centerX;
                            this.I$1 = centerY;
                            this.I$2 = currentX;
                            this.I$3 = currentY;
                            this.I$4 = i;
                            this.label = 1;
                            v0 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(currentX, currentY), this);
                            if (v0 == var8_3) {
                                return var8_3;
                            }
                            ** GOTO lbl32
                        }
                        break;
                    }
                    case 1: {
                        i = this.I$4;
                        currentY = this.I$3;
                        currentX = this.I$2;
                        centerY = this.I$1;
                        centerX = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.I$0 = centerX;
                        this.I$1 = centerY;
                        this.I$2 = currentX;
                        this.I$3 = currentY;
                        this.I$4 = i;
                        this.label = 2;
                        v1 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(2 * centerX - currentX, 2 * centerY - currentY), this);
                        if (v1 == var8_3) {
                            return var8_3;
                        }
                        ** GOTO lbl51
                    }
                    case 2: {
                        i = this.I$4;
                        currentY = this.I$3;
                        currentX = this.I$2;
                        centerY = this.I$1;
                        centerX = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl51:
                        // 2 sources

                        ++currentX;
                        ++i;
                        ** GOTO lbl11
                    }
                }
                i = 0;
lbl55:
                // 2 sources

                while (i < this.$distance) {
                    this.L$0 = $this$sequence;
                    this.I$0 = centerX;
                    this.I$1 = centerY;
                    this.I$2 = currentX;
                    this.I$3 = currentY;
                    this.I$4 = i;
                    this.label = 3;
                    v2 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(currentX, currentY), this);
                    if (v2 == var8_3) {
                        return var8_3;
                    }
                    ** GOTO lbl76
                }
                {
                    break;
                    case 3: {
                        i = this.I$4;
                        currentY = this.I$3;
                        currentX = this.I$2;
                        centerY = this.I$1;
                        centerX = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl76:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.I$0 = centerX;
                        this.I$1 = centerY;
                        this.I$2 = currentX;
                        this.I$3 = currentY;
                        this.I$4 = i;
                        this.label = 4;
                        v3 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(2 * centerX - currentX, 2 * centerY - currentY), this);
                        if (v3 == var8_3) {
                            return var8_3;
                        }
                        ** GOTO lbl95
                    }
                    case 4: {
                        i = this.I$4;
                        currentY = this.I$3;
                        currentX = this.I$2;
                        centerY = this.I$1;
                        centerX = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl95:
                        // 2 sources

                        ++currentX;
                        ++currentY;
                        ++i;
                        ** GOTO lbl55
                    }
                }
                i = 0;
lbl100:
                // 2 sources

                while (i < this.$distance) {
                    this.L$0 = $this$sequence;
                    this.I$0 = centerX;
                    this.I$1 = centerY;
                    this.I$2 = currentX;
                    this.I$3 = currentY;
                    this.I$4 = i;
                    this.label = 5;
                    v4 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(currentX, currentY), this);
                    if (v4 == var8_3) {
                        return var8_3;
                    }
                    ** GOTO lbl121
                }
                {
                    break;
                    case 5: {
                        i = this.I$4;
                        currentY = this.I$3;
                        currentX = this.I$2;
                        centerY = this.I$1;
                        centerX = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl121:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.I$0 = centerX;
                        this.I$1 = centerY;
                        this.I$2 = currentX;
                        this.I$3 = currentY;
                        this.I$4 = i;
                        this.label = 6;
                        v5 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(2 * centerX - currentX, 2 * centerY - currentY), this);
                        if (v5 == var8_3) {
                            return var8_3;
                        }
                        ** GOTO lbl140
                    }
                    case 6: {
                        i = this.I$4;
                        currentY = this.I$3;
                        currentX = this.I$2;
                        centerY = this.I$1;
                        centerX = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl140:
                        // 2 sources

                        ++currentY;
                        ++i;
                        ** GOTO lbl100
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Tile> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final Sequence<Tile> getTilesInRectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        return SequencesKt.filterNotNull(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(rectangle, this, null){
            Object L$1;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int I$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Rectangle $rectangle;
            final /* synthetic */ TileMap this$0;
            {
                this.$rectangle = $rectangle;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var2_2 = (SequenceScope)this.L$0;
                    var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            x = (int)this.$rectangle.x;
                            y = (int)this.$rectangle.y;
                            worldColumnNumber = x;
                            var6_7 = x + (int)this.$rectangle.width;
lbl10:
                            // 2 sources

                            while (worldColumnNumber < var6_7) {
                                worldRowNumber = y;
                                var8_9 = y + (int)this.$rectangle.height;
lbl13:
                                // 2 sources

                                while (worldRowNumber < var8_9) {
                                    hexCoords = HexMath.INSTANCE.getTileCoordsFromColumnRow(worldColumnNumber, worldRowNumber);
                                    this.L$0 = $this$sequence;
                                    this.L$1 = SpillingKt.nullOutSpilledVariable(hexCoords);
                                    this.I$0 = x;
                                    this.I$1 = y;
                                    this.I$2 = worldColumnNumber;
                                    this.I$3 = var6_7;
                                    this.I$4 = worldRowNumber;
                                    this.I$5 = var8_9;
                                    this.label = 1;
                                    v0 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(hexCoords.getX(), hexCoords.getY()), this);
                                    if (v0 == var10_3) {
                                        return var10_3;
                                    }
                                    ** GOTO lbl40
                                }
                                break block0;
                            }
                            break block7;
                        }
                        case 1: {
                            var8_9 = this.I$5;
                            worldRowNumber = this.I$4;
                            var6_7 = this.I$3;
                            worldColumnNumber = this.I$2;
                            y = this.I$1;
                            x = this.I$0;
                            hexCoords = (HexCoord)this.L$1;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl40:
                            // 2 sources

                            ++worldRowNumber;
                            ** GOTO lbl13
                        }
                    }
                    ++worldColumnNumber;
                    ** GOTO lbl10
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Tile> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Readonly
    @Nullable
    public final Tile getIfTileExistsOrNull(int x, int y) {
        Tile leftSideTile;
        Tile rightSideTile;
        Tile tile;
        Tile tile2 = tile = this.getOrNull(x, y);
        if (tile2 != null) {
            return tile2;
        }
        if (!this.mapParameters.getWorldWrap()) {
            return null;
        }
        int radius = this.mapParameters.getMapSize().getRadius();
        if (Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular")) {
            radius = this.mapParameters.getMapSize().getWidth() / 2;
        }
        Tile tile3 = rightSideTile = this.getOrNull(x + radius, y - radius);
        if (tile3 != null) {
            return tile3;
        }
        Tile tile4 = leftSideTile = this.getOrNull(x - radius, y + radius);
        if (tile4 != null) {
            return tile4;
        }
        return null;
    }

    @Readonly
    public final int getNeighborTileClockPosition(@NotNull Tile tile, @NotNull Tile otherTile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(otherTile, "otherTile");
        int radius = Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular") ? this.mapParameters.getMapSize().getWidth() / 2 : this.mapParameters.getMapSize().getRadius();
        int x1 = tile.getPosition().getX();
        int y1 = tile.getPosition().getY();
        int x2 = otherTile.getPosition().getX();
        int y2 = otherTile.getPosition().getY();
        int xDifference = x1 - x2;
        int yDifference = y1 - y2;
        int xWrapDifferenceBottom = radius < 3 ? 0 : x1 - (x2 - radius);
        int yWrapDifferenceBottom = radius < 3 ? 0 : y1 - (y2 - radius);
        int xWrapDifferenceTop = radius < 3 ? 0 : x1 - (x2 + radius);
        int yWrapDifferenceTop = radius < 3 ? 0 : y1 - (y2 + radius);
        return xDifference == 1 && yDifference == 1 ? 6 : (xDifference == -1 && yDifference == -1 ? 12 : (xDifference == 1 || xWrapDifferenceBottom == 1 ? 4 : (yDifference == 1 || yWrapDifferenceBottom == 1 ? 8 : (xDifference == -1 || xWrapDifferenceTop == -1 ? 10 : (yDifference == -1 || yWrapDifferenceTop == -1 ? 2 : -1)))));
    }

    @Readonly
    @Nullable
    public final Tile getClockPositionNeighborTile(@NotNull Tile tile, int clockPosition) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        HexCoord difference = HexMath.INSTANCE.getClockPositionToHexcoord(clockPosition);
        if (Intrinsics.areEqual(difference, HexCoord.Companion.getZero())) {
            return null;
        }
        HexCoord possibleNeighborPosition = tile.getPosition().plus(difference);
        return this.getIfTileExistsOrNull(possibleNeighborPosition.getX(), possibleNeighborPosition.getY());
    }

    @Readonly
    @NotNull
    public final Vector2 getNeighborTilePositionAsWorldCoords(@NotNull Tile tile, @NotNull Tile otherTile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(otherTile, "otherTile");
        return HexMath.INSTANCE.getClockPositionToWorldVector(this.getNeighborTileClockPosition(tile, otherTile));
    }

    @Readonly
    @NotNull
    public final HexCoord getUnwrappedPosition(@NotNull HexCoord position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (!this.contains(position)) {
            return position;
        }
        int radius = Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular") ? this.mapParameters.getMapSize().getWidth() / 2 : this.mapParameters.getMapSize().getRadius();
        HexCoord vectorUnwrappedLeft = HexCoord.Companion.of(position.getX() + radius, position.getY() - radius);
        HexCoord vectorUnwrappedRight = HexCoord.Companion.of(position.getX() - radius, position.getY() + radius);
        return TileMap.getUnwrappedPosition$squareSum(vectorUnwrappedRight) < TileMap.getUnwrappedPosition$squareSum(vectorUnwrappedLeft) ? vectorUnwrappedRight : vectorUnwrappedLeft;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Tile> getViewableTiles(@NotNull HexCoord position, int sightDistance, boolean forAttack) {
        void $this$map$iv;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$map;
        ViewableTile it;
        void $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable<ViewableTile> tilesToAddInDistanceI;
        Intrinsics.checkNotNullParameter(position, "position");
        int aUnitHeight = this.get(position).getUnitHeight();
        ViewableTile[] viewableTileArray = new ViewableTile[]{new ViewableTile(this.get(position), aUnitHeight, true, false)};
        List<ViewableTile> viewableTiles = CollectionsKt.mutableListOf(viewableTileArray);
        int i = 1;
        int n = sightDistance + 1;
        if (i <= n) {
            while (true) {
                tilesToAddInDistanceI = new ArrayList();
                Iterator<Tile> iterator2 = this.getTilesAtDistance(position, i).iterator();
                while (iterator2.hasNext()) {
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv;
                    Tile cTile = iterator2.next();
                    int cTileHeight = cTile.getTileHeight();
                    if (i == sightDistance + 1 && (cTileHeight <= aUnitHeight || forAttack)) continue;
                    Iterable iterable = viewableTiles;
                    boolean $i$f$filter22 = false;
                    void var15_32 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        ViewableTile it2 = (ViewableTile)element$iv$iv;
                        boolean bl = false;
                        if (!(it2.getTile().aerialDistanceTo(cTile) == 1)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv2)).iterator();
                    if (!$i$f$filter22.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ViewableTile it3 = (ViewableTile)$i$f$filter22.next();
                    boolean bl = false;
                    int n2 = it3.getMaxHeightSeenToTile();
                    while ($i$f$filter22.hasNext()) {
                        ViewableTile it4 = (ViewableTile)$i$f$filter22.next();
                        $i$a$-minOf-TileMap$getViewableTiles$bMinimumHighestSeenTerrainSoFar$2 = false;
                        int n3 = it4.getMaxHeightSeenToTile();
                        if (n2 <= n3) continue;
                        n2 = n3;
                    }
                    int bMinimumHighestSeenTerrainSoFar = n2;
                    ((ArrayList)tilesToAddInDistanceI).add(new ViewableTile(cTile, Math.max(cTileHeight, bMinimumHighestSeenTerrainSoFar), aUnitHeight >= bMinimumHighestSeenTerrainSoFar || cTileHeight > bMinimumHighestSeenTerrainSoFar, aUnitHeight >= bMinimumHighestSeenTerrainSoFar || cTile.getUnitHeight() > bMinimumHighestSeenTerrainSoFar));
                }
                viewableTiles.addAll((Collection)tilesToAddInDistanceI);
                if (i == n) break;
                ++i;
            }
        }
        if (forAttack) {
            void $this$map$iv2;
            Iterable $this$filter$iv = viewableTiles;
            $i$f$filter = false;
            tilesToAddInDistanceI = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ViewableTile)element$iv$iv;
                boolean bl = false;
                if (!it.isAttackable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ViewableTile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTile());
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$filter$iv = viewableTiles;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ViewableTile)element$iv$iv;
            boolean bl = false;
            if (!it.isVisible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ViewableTile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTile());
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getViewableTiles$default(TileMap tileMap, HexCoord hexCoord, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return tileMap.getViewableTiles(hexCoord, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashSet<String> getRulesetIncompatibility(@NotNull Ruleset ruleset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        HashSet<String> rulesetIncompatibilities = new HashSet<String>();
        Iterable $this$map$iv = this.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tile tile = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRulesetIncompatibility(ruleset));
        }
        for (HashSet set : (List)destination$iv$iv) {
            rulesetIncompatibilities.addAll(set);
        }
        try {
            TileMap.setTransients$default(this, ruleset, false, 2, null);
        }
        catch (Exception exception2) {
            return rulesetIncompatibilities;
        }
        this.setStartingLocationsTransients();
        Iterator<StartingLocation> iterator2 = this.startingLocations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            String nationName = ((StartingLocation)object).component2();
            if (((Map)ruleset.getNations()).containsKey(nationName)) continue;
            rulesetIncompatibilities.add("Nation [" + nationName + "] does not exist in ruleset!");
        }
        rulesetIncompatibilities.remove("");
        return rulesetIncompatibilities;
    }

    public final boolean isWaterMap() {
        int n;
        this.assignContinents(AssignContinentsMode.Ensure);
        Map $this$count$iv = this.continentSizes;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() > 20)) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        int bigIslands = n;
        int players = this.getGameInfo().getGameParameters().getPlayers().size();
        return bigIslands >= players;
    }

    public final boolean usingArchipelagoRegions() {
        Collection<Integer> collection = this.continentSizes.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        float totalLand = CollectionsKt.sumOfInt((Iterable<Integer>)collection);
        Collection<Integer> collection2 = this.continentSizes.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterator iterator2 = ((Iterable)collection2).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Integer it = (Integer)iterator2.next();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        int n = it;
        while (iterator2.hasNext()) {
            Integer it2 = (Integer)iterator2.next();
            $i$a$-maxOf-TileMap$usingArchipelagoRegions$largestContinent$1 = false;
            Intrinsics.checkNotNull(it2);
            int n2 = it2;
            if (n >= n2) continue;
            n = n2;
        }
        float largestContinent = n;
        return largestContinent / totalLand < 0.25f;
    }

    public final void setTransients(@Nullable Ruleset ruleset, boolean setUnitCivTransients) {
        int x;
        int rightX;
        int topY2;
        if (ruleset != null) {
            this.ruleset = ruleset;
        }
        if (!(this.ruleset != null)) {
            boolean $i$a$-check-TileMap$setTransients$32 = false;
            String $i$a$-check-TileMap$setTransients$32 = "TileMap.setTransients called without ruleset";
            throw new IllegalStateException($i$a$-check-TileMap$setTransients$32.toString());
        }
        if (!(!((Collection)this.tileList).isEmpty())) {
            boolean $i$a$-check-TileMap$setTransients$42 = false;
            String $i$a$-check-TileMap$setTransients$42 = "No tiles were found in the save?!";
            throw new IllegalStateException($i$a$-check-TileMap$setTransients$42.toString());
        }
        if (this.tileMatrix.isEmpty()) {
            topY2 = ((Number)SequencesKt.maxOrThrow(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::setTransients$lambda$2))).intValue();
            this.bottomY = ((Number)SequencesKt.minOrThrow(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::setTransients$lambda$3))).intValue();
            rightX = ((Number)SequencesKt.maxOrThrow(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::setTransients$lambda$4))).intValue();
            this.leftX = ((Number)SequencesKt.minOrThrow(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::setTransients$lambda$5))).intValue();
            this.tileMatrix.ensureCapacity(rightX - this.leftX + 1);
            x = this.leftX;
            if (x <= rightX) {
                while (true) {
                    ArrayList<Object> row = new ArrayList<Object>(topY2 - this.bottomY + 1);
                    int y = this.bottomY;
                    if (y <= topY2) {
                        while (true) {
                            row.add(null);
                            if (y == topY2) break;
                            ++y;
                        }
                    }
                    this.tileMatrix.add(row);
                    if (x != rightX) {
                        ++x;
                        continue;
                    }
                    break;
                }
            }
        } else {
            topY2 = -2 * this.leftX;
            rightX = 3 - 2 * this.leftX;
            x = this.tileMatrix.size();
            if (!(topY2 <= x ? x <= rightX : false)) {
                boolean $i$a$-check-TileMap$setTransients$62 = false;
                String $i$a$-check-TileMap$setTransients$62 = "TileMap.setTransients called on existing tileMatrix of different size";
                throw new IllegalStateException($i$a$-check-TileMap$setTransients$62.toString());
            }
        }
        for (Tile tileInfo : this.getValues()) {
            this.tileMatrix.get(tileInfo.getPosition().getX() - this.leftX).set(tileInfo.getPosition().getY() - this.bottomY, tileInfo);
        }
        Iterator<Tile> topY2 = ((Iterable)this.getValues()).iterator();
        int tileInfo = 0;
        while (topY2.hasNext()) {
            int index = tileInfo++;
            Tile tileInfo2 = topY2.next();
            tileInfo2.setTileMap(this);
            tileInfo2.setZeroBasedIndex(index);
            Ruleset ruleset2 = this.ruleset;
            Intrinsics.checkNotNull(ruleset2);
            tileInfo2.setRuleset(ruleset2);
            tileInfo2.setTerrainTransients();
            tileInfo2.setUnitTransients(setUnitCivTransients);
        }
        int minColumn = ((Number)SequencesKt.minOrThrow(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::setTransients$lambda$7))).intValue();
        int maxColumn = ((Number)SequencesKt.maxOrThrow(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), TileMap::setTransients$lambda$8))).intValue();
        this.width = maxColumn - minColumn + 1;
    }

    public static /* synthetic */ void setTransients$default(TileMap tileMap, Ruleset ruleset, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            ruleset = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        tileMap.setTransients(ruleset, bl);
    }

    public final void setNeutralTransients() {
        for (Tile tileInfo : this.getValues()) {
            tileInfo.setOwnerTransients();
        }
    }

    public final void removeMissingTerrainModReferences(@NotNull Ruleset ruleSet) {
        Intrinsics.checkNotNullParameter(ruleSet, "ruleSet");
        for (Tile tile : this.getValues()) {
            tile.removeMissingTerrainModReferences(ruleSet);
        }
        for (StartingLocation startingLocation : CollectionsKt.toList((Iterable)this.startingLocations)) {
            if (((Map)ruleSet.getNations()).containsKey(startingLocation.getNation())) continue;
            this.startingLocations.remove(startingLocation);
        }
    }

    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull HexCoord position, @NotNull String unitName, @NotNull Civilization civInfo, @Nullable Integer unitId) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(unitName, "unitName");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        BaseUnit baseUnit = this.getGameInfo().getRuleset().getUnits().get(unitName);
        Intrinsics.checkNotNull(baseUnit);
        BaseUnit unit = baseUnit;
        return this.placeUnitNearTile(position, unit, civInfo, unitId);
    }

    public static /* synthetic */ MapUnit placeUnitNearTile$default(TileMap tileMap, HexCoord hexCoord, String string, Civilization civilization, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return tileMap.placeUnitNearTile(hexCoord, string, civilization, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull HexCoord position, @NotNull BaseUnit baseUnit, @NotNull Civilization civInfo, @Nullable Integer unitId) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        MapUnit unit = baseUnit.newMapUnit(civInfo, unitId);
        unit.assignOwner(civInfo, false);
        unit.setOriginalOwner(civInfo.getCivID());
        Tile unitToPlaceTile = null;
        Tile currentTile = this.get(position);
        unit.setCurrentTile(currentTile);
        unit.getCache().setState(new GameContext(unit));
        if (UnitMovement.canMoveTo$default(unit.getMovement(), currentTile, false, false, false, 14, null)) {
            unitToPlaceTile = currentTile;
        }
        if (unitToPlaceTile == null) {
            int tryCount = 0;
            Set potentialCandidates = TileMap.placeUnitNearTile$getPassableNeighbours(unit, currentTile);
            while (unitToPlaceTile == null && tryCount++ < 10) {
                Object v0;
                block9: {
                    void $this$firstOrNull$iv;
                    Iterable $this$sortedByDescending$iv;
                    Iterable iterable = potentialCandidates;
                    boolean $i$f$sortedByDescending = false;
                    $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(unit){
                        final /* synthetic */ MapUnit $unit$inlined;
                        {
                            this.$unit$inlined = mapUnit;
                        }

                        public final int compare(T a, T b) {
                            Tile it = (Tile)b;
                            boolean bl = false;
                            boolean bl2 = this.$unit$inlined.getBaseUnit().isLandUnit() && !this.$unit$inlined.getCache().getCanMoveOnWater() ? it.isLand() : true;
                            it = (Tile)a;
                            Comparable comparable = Boolean.valueOf(bl2);
                            bl = false;
                            return ComparisonsKt.compareValues(comparable, this.$unit$inlined.getBaseUnit().isLandUnit() && !this.$unit$inlined.getCache().getCanMoveOnWater() ? it.isLand() : true);
                        }
                    });
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Tile it = (Tile)element$iv;
                        boolean bl = false;
                        if (!UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null)) continue;
                        v0 = element$iv;
                        break block9;
                    }
                    v0 = null;
                }
                if ((unitToPlaceTile = (Tile)v0) != null) continue;
                Set newPotentialCandidates = new LinkedHashSet();
                Iterable $this$forEach$iv = potentialCandidates;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    newPotentialCandidates.addAll((Collection)TileMap.placeUnitNearTile$getPassableNeighbours(unit, it));
                }
                potentialCandidates = newPotentialCandidates;
            }
        }
        if (unitToPlaceTile == null) {
            civInfo.getUnits().removeUnit(unit);
            return null;
        }
        unit.putInTile(unitToPlaceTile);
        unit.setCurrentMovement(MapUnit.getMaxMovement$default(unit, false, 1, null));
        unit.addMovementMemory();
        Iterator<String> iterator2 = unit.getBaseUnit().getPromotions().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String promotion;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            unit.getPromotions().addPromotion(promotion, true);
        }
        iterator3 = Civilization.getMatchingUniques$default(civInfo, UniqueType.UnitsGainPromotion, null, 2, null).iterator();
        while (iterator3.hasNext()) {
            Unique unique = (Unique)((Object)iterator3.next());
            if (!MapUnit.matchesFilter$default(unit, unique.getParams().get(0), false, 2, null)) continue;
            unit.getPromotions().addPromotion(unique.getParams().get(1), true);
        }
        civInfo.updateStatsForNextTurn();
        if (!((Map)unit.getResourceRequirementsPerTurn()).isEmpty()) {
            civInfo.getCache().updateCivResources();
        }
        return unit;
    }

    public static /* synthetic */ MapUnit placeUnitNearTile$default(TileMap tileMap, HexCoord hexCoord, BaseUnit baseUnit, Civilization civilization, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return tileMap.placeUnitNearTile(hexCoord, baseUnit, civilization, n);
    }

    public final void stripPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Iterable $this$forEach$iv = this.tileList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tile it = (Tile)element$iv;
            boolean bl = false;
            Iterator<MapUnit> iterator2 = it.getUnits().iterator();
            while (iterator2.hasNext()) {
                MapUnit unit = iterator2.next();
                if (!Intrinsics.areEqual(unit.getOwner(), player.getChosenCiv())) continue;
                unit.removeFromTile();
            }
        }
        CollectionsKt.removeAll((List)this.startingLocations, arg_0 -> TileMap.stripPlayer$lambda$1(player, arg_0));
        this.startingLocationsByNation.remove(player.getChosenCiv());
    }

    /*
     * WARNING - void declaration
     */
    public final void switchPlayersNation(@NotNull Player player, @NotNull Nation newNation) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(newNation, "newNation");
        Civilization newCiv = new Civilization(newNation);
        Iterable $this$forEach$iv = this.tileList;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Tile it = (Tile)element$iv2;
            boolean bl = false;
            Iterator<MapUnit> iterator2 = it.getUnits().iterator();
            while (iterator2.hasNext()) {
                MapUnit unit = iterator2.next();
                if (!Intrinsics.areEqual(unit.getOwner(), player.getChosenCiv())) continue;
                unit.setOwner(newCiv.getCivID());
                unit.setCiv(newCiv);
                unit.setTransients(newCiv.getGameInfo().getRuleset());
            }
        }
        Iterable $this$filter$iv = this.startingLocations;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (MapUnit element$iv$iv : $this$filterTo$iv$iv) {
            StartingLocation it = (StartingLocation)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getNation(), player.getChosenCiv()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (StartingLocation element : (List)destination$iv$iv) {
            boolean bl;
            block7: {
                this.startingLocations.remove(element);
                Iterable $this$none$iv = this.startingLocations;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv3 : $this$none$iv) {
                        StartingLocation it = (StartingLocation)element$iv3;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual(it.getNation(), newCiv.getCivID()) && Intrinsics.areEqual(it.getPosition(), element.getPosition()))) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.startingLocations.add(new StartingLocation(element.getPosition(), newCiv.getCivID(), null, 4, null));
        }
        this.setStartingLocationsTransients();
    }

    public final void setStartingLocationsTransients() {
        this.startingLocationsByNation.clear();
        Iterator<StartingLocation> iterator2 = this.startingLocations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<StartingLocation> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            StartingLocation startingLocation;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            HexCoord position = startingLocation.component1();
            String nationName = startingLocation.component2();
            CollectionExtensionsKt.addToMapOfSets(this.startingLocationsByNation, nationName, this.get(position));
        }
    }

    public final boolean addStartingLocation(@NotNull String nationName, @NotNull Tile tile, @NotNull StartingLocation.Usage usage) {
        Intrinsics.checkNotNullParameter(nationName, "nationName");
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter((Object)usage, "usage");
        if (CollectionExtensionsKt.contains(this.startingLocationsByNation, nationName, tile)) {
            return false;
        }
        this.startingLocations.add(new StartingLocation(tile.getPosition(), nationName, usage));
        return CollectionExtensionsKt.addToMapOfSets(this.startingLocationsByNation, nationName, tile);
    }

    public static /* synthetic */ boolean addStartingLocation$default(TileMap tileMap, String string, Tile tile, StartingLocation.Usage usage, int n, Object object) {
        if ((n & 4) != 0) {
            usage = StartingLocation.Usage.Player;
        }
        return tileMap.addStartingLocation(string, tile, usage);
    }

    public final boolean removeStartingLocation(@NotNull String nationName, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(nationName, "nationName");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!CollectionExtensionsKt.contains(this.startingLocationsByNation, nationName, tile)) {
            return false;
        }
        this.startingLocations.remove(new StartingLocation(tile.getPosition(), nationName, null, 4, null));
        HashSet<Tile> hashSet = this.startingLocationsByNation.get(nationName);
        Intrinsics.checkNotNull(hashSet);
        return hashSet.remove(tile);
    }

    public final void removeStartingLocations(@NotNull String nationName) {
        Intrinsics.checkNotNullParameter(nationName, "nationName");
        if (this.startingLocationsByNation.get(nationName) == null) {
            return;
        }
        HashSet<Tile> hashSet = this.startingLocationsByNation.get(nationName);
        Intrinsics.checkNotNull(hashSet);
        Iterator<Tile> iterator2 = hashSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Tile> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Tile tile;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            this.startingLocations.remove(new StartingLocation(tile.getPosition(), nationName, null, 4, null));
        }
        HashSet<Tile> hashSet2 = this.startingLocationsByNation.get(nationName);
        Intrinsics.checkNotNull(hashSet2);
        hashSet2.clear();
    }

    public final void removeStartingLocations(@NotNull HexCoord position) {
        Intrinsics.checkNotNullParameter(position, "position");
        CollectionsKt.removeAll((List)this.startingLocations, arg_0 -> TileMap.removeStartingLocations$lambda$0(position, arg_0));
        this.setStartingLocationsTransients();
    }

    public final void clearStartingLocations() {
        this.startingLocations.clear();
        this.startingLocationsByNation.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void assignContinents(@NotNull AssignContinentsMode mode) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        if (mode == AssignContinentsMode.Clear) {
            Iterable $this$forEach$iv = this.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Tile it = (Tile)element$iv2;
                boolean bl = false;
                it.clearContinent();
            }
            this.continentSizes.clear();
            return;
        }
        if (mode == AssignContinentsMode.Ensure) {
            if (!((Map)this.continentSizes).isEmpty()) {
                return;
            }
            for (Tile tile : this.getValues()) {
                int continent = tile.getContinent();
                if (continent == -1) continue;
                element$iv2 = this.continentSizes;
                Integer it = continent;
                Integer n = this.continentSizes.get(continent);
                Integer bl = 1 + (n != null ? n : 0);
                element$iv2.put(it, bl);
            }
            if (!((Map)this.continentSizes).isEmpty()) {
                return;
            }
        }
        Iterable $this$filter$iv = this.getValues();
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!(it.isLand() && !it.isImpassible())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List landTiles = (List)destination$iv$iv;
        int currentContinent = 0;
        this.continentSizes.clear();
        if (mode == AssignContinentsMode.Reassign) {
            Iterable $this$forEach$iv = this.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                Tile it = (Tile)element$iv3;
                boolean bl = false;
                it.clearContinent();
            }
        }
        while (CollectionsKt.any(landTiles)) {
            void $this$filterTo$iv$iv2;
            Object element$iv42;
            BFS bfs = new BFS((Tile)CollectionsKt.random(landTiles, Random.Default), TileMap::assignContinents$lambda$3);
            bfs.stepToEnd();
            Iterable $this$forEach$iv = bfs.getReachedTiles();
            int $i$f$forEach = 0;
            for (Object element$iv42 : $this$forEach$iv) {
                Tile it = (Tile)element$iv42;
                boolean bl = false;
                it.setContinent(currentContinent);
            }
            Set<Tile> continent = bfs.getReachedTiles();
            ((Map)this.continentSizes).put(currentContinent, continent.size());
            $i$f$forEach = currentContinent;
            currentContinent = $i$f$forEach + 1;
            Iterable $this$filter$iv2 = landTiles;
            boolean $i$f$filter2 = false;
            element$iv42 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!(!continent.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            landTiles = (List)destination$iv$iv2;
        }
    }

    private static final int maxLatitude_delegate$lambda$0(TileMap this$0) {
        int n;
        if (this$0.getValues().isEmpty()) {
            n = 0;
        } else {
            Iterator iterator2 = ((Iterable)this$0.getValues()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Tile it = (Tile)iterator2.next();
            boolean bl = false;
            int n2 = Math.abs(it.getLatitude());
            while (iterator2.hasNext()) {
                Tile it2 = (Tile)iterator2.next();
                $i$a$-maxOf-TileMap$maxLatitude$2$1 = false;
                int n3 = Math.abs(it2.getLatitude());
                if (n2 >= n3) continue;
                n2 = n3;
            }
            n = n2;
        }
        return n;
    }

    private static final int maxLongitude_delegate$lambda$0(TileMap this$0) {
        int n;
        if (this$0.getValues().isEmpty()) {
            n = 0;
        } else {
            Iterator iterator2 = ((Iterable)this$0.getValues()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Tile it = (Tile)iterator2.next();
            boolean bl = false;
            int n2 = Math.abs(it.getLongitude());
            while (iterator2.hasNext()) {
                Tile it2 = (Tile)iterator2.next();
                $i$a$-maxOf-TileMap$maxLongitude$2$1 = false;
                int n3 = Math.abs(it2.getLongitude());
                if (n2 >= n3) continue;
                n2 = n3;
            }
            n = n2;
        }
        return n;
    }

    private static final Set naturalWonders_delegate$lambda$0(TileMap this$0) {
        return SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this$0.tileList), TileMap::naturalWonders_delegate$lambda$0$0), TileMap::naturalWonders_delegate$lambda$0$1));
    }

    private static final boolean naturalWonders_delegate$lambda$0$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isNaturalWonder();
    }

    private static final String naturalWonders_delegate$lambda$0$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.getNaturalWonder();
        Intrinsics.checkNotNull(string);
        return string;
    }

    private static final Set resources_delegate$lambda$0(TileMap this$0) {
        return SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this$0.tileList), TileMap::resources_delegate$lambda$0$0), TileMap::resources_delegate$lambda$0$1));
    }

    private static final boolean resources_delegate$lambda$0$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResource() != null;
    }

    private static final String resources_delegate$lambda$0$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.getResource();
        Intrinsics.checkNotNull(string);
        return string;
    }

    private static final Tile clone$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Tile.clone$default(it, false, 1, null);
    }

    private static final Sequence getTilesInDistanceRange$lambda$0(TileMap this$0, HexCoord $origin, int it) {
        return this$0.getTilesAtDistance($origin, it);
    }

    private static final int getUnwrappedPosition$squareSum(HexCoord hexCoord) {
        int x = hexCoord.getX();
        int y = hexCoord.getY();
        return x * x + y * y;
    }

    private static final int setTransients$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition().getY();
    }

    private static final int setTransients$lambda$3(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition().getY();
    }

    private static final int setTransients$lambda$4(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition().getX();
    }

    private static final int setTransients$lambda$5(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition().getX();
    }

    private static final int setTransients$lambda$7(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return HexMath.INSTANCE.getColumn(it.getPosition());
    }

    private static final int setTransients$lambda$8(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return HexMath.INSTANCE.getColumn(it.getPosition());
    }

    private static final Set<Tile> placeUnitNearTile$getPassableNeighbours(MapUnit unit, Tile tile) {
        return SequencesKt.toSet(SequencesKt.filter(tile.getNeighbors(), arg_0 -> TileMap.placeUnitNearTile$getPassableNeighbours$lambda$0(unit, arg_0)));
    }

    private static final boolean placeUnitNearTile$getPassableNeighbours$lambda$0(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UnitMovement.canPassThrough$default($unit.getMovement(), it, false, 2, null);
    }

    private static final boolean stripPlayer$lambda$1(Player $player, StartingLocation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getNation(), $player.getChosenCiv());
    }

    private static final boolean removeStartingLocations$lambda$0(HexCoord $position, StartingLocation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getPosition(), $position);
    }

    private static final boolean assignContinents$lambda$3(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLand() && !it.isImpassible();
    }

    public TileMap() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/TileMap$AssignContinentsMode;", "", "<init>", "(Ljava/lang/String;I)V", "Assign", "Reassign", "Ensure", "Clear", "core"})
    public static final class AssignContinentsMode
    extends Enum<AssignContinentsMode> {
        public static final /* enum */ AssignContinentsMode Assign = new AssignContinentsMode();
        public static final /* enum */ AssignContinentsMode Reassign = new AssignContinentsMode();
        public static final /* enum */ AssignContinentsMode Ensure = new AssignContinentsMode();
        public static final /* enum */ AssignContinentsMode Clear = new AssignContinentsMode();
        private static final /* synthetic */ AssignContinentsMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AssignContinentsMode[] values() {
            return (AssignContinentsMode[])$VALUES.clone();
        }

        public static AssignContinentsMode valueOf(String value) {
            return Enum.valueOf(AssignContinentsMode.class, value);
        }

        @NotNull
        public static EnumEntries<AssignContinentsMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = assignContinentsModeArray = new AssignContinentsMode[]{AssignContinentsMode.Assign, AssignContinentsMode.Reassign, AssignContinentsMode.Ensure, AssignContinentsMode.Clear};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/map/TileMap$Preview;", "", "<init>", "()V", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getMapParameters", "()Lcom/unciv/logic/map/MapParameters;", "startingLocations", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/TileMap$StartingLocation;", "Lkotlin/collections/ArrayList;", "getDeclaredNations", "Lkotlin/sequences/Sequence;", "", "getNationsForHumanPlayer", "core"})
    public static final class Preview {
        @NotNull
        private final MapParameters mapParameters = new MapParameters();
        @NotNull
        private final ArrayList<StartingLocation> startingLocations = new ArrayList();

        @NotNull
        public final MapParameters getMapParameters() {
            return this.mapParameters;
        }

        @NotNull
        public final Sequence<String> getDeclaredNations() {
            return SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.startingLocations), Preview::getDeclaredNations$lambda$0), Preview::getDeclaredNations$lambda$1));
        }

        @NotNull
        public final Sequence<String> getNationsForHumanPlayer() {
            return SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.startingLocations), Preview::getNationsForHumanPlayer$lambda$0), Preview::getNationsForHumanPlayer$lambda$1));
        }

        private static final boolean getDeclaredNations$lambda$0(StartingLocation it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getUsage() != StartingLocation.Usage.Normal;
        }

        private static final String getDeclaredNations$lambda$1(StartingLocation it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getNation();
        }

        private static final boolean getNationsForHumanPlayer$lambda$0(StartingLocation it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getUsage() == StartingLocation.Usage.Human;
        }

        private static final String getNationsForHumanPlayer$lambda$1(StartingLocation it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getNation();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001bB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/unciv/logic/map/TileMap$StartingLocation;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "position", "Lcom/unciv/logic/map/HexCoord;", "nation", "", "usage", "Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "<init>", "(Lcom/unciv/logic/map/HexCoord;Ljava/lang/String;Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;)V", "getPosition", "()Lcom/unciv/logic/map/HexCoord;", "getNation", "()Ljava/lang/String;", "getUsage", "()Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Usage", "core"})
    public static final class StartingLocation
    implements IsPartOfGameInfoSerialization {
        @NotNull
        private final HexCoord position;
        @NotNull
        private final String nation;
        @NotNull
        private final Usage usage;

        public StartingLocation(@NotNull HexCoord position, @NotNull String nation, @NotNull Usage usage) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(nation, "nation");
            Intrinsics.checkNotNullParameter((Object)usage, "usage");
            this.position = position;
            this.nation = nation;
            this.usage = usage;
        }

        public /* synthetic */ StartingLocation(HexCoord hexCoord, String string, Usage usage, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                hexCoord = HexCoord.Companion.getZero();
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                usage = Usage.Companion.getDefault();
            }
            this(hexCoord, string, usage);
        }

        @NotNull
        public final HexCoord getPosition() {
            return this.position;
        }

        @NotNull
        public final String getNation() {
            return this.nation;
        }

        @NotNull
        public final Usage getUsage() {
            return this.usage;
        }

        @NotNull
        public final HexCoord component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.nation;
        }

        @NotNull
        public final Usage component3() {
            return this.usage;
        }

        @NotNull
        public final StartingLocation copy(@NotNull HexCoord position, @NotNull String nation, @NotNull Usage usage) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(nation, "nation");
            Intrinsics.checkNotNullParameter((Object)usage, "usage");
            return new StartingLocation(position, nation, usage);
        }

        public static /* synthetic */ StartingLocation copy$default(StartingLocation startingLocation, HexCoord hexCoord, String string, Usage usage, int n, Object object) {
            if ((n & 1) != 0) {
                hexCoord = startingLocation.position;
            }
            if ((n & 2) != 0) {
                string = startingLocation.nation;
            }
            if ((n & 4) != 0) {
                usage = startingLocation.usage;
            }
            return startingLocation.copy(hexCoord, string, usage);
        }

        @NotNull
        public String toString() {
            return "StartingLocation(position=" + this.position + ", nation=" + this.nation + ", usage=" + (Object)((Object)this.usage) + ')';
        }

        public int hashCode() {
            int result2 = this.position.hashCode();
            result2 = result2 * 31 + this.nation.hashCode();
            result2 = result2 * 31 + this.usage.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StartingLocation)) {
                return false;
            }
            StartingLocation startingLocation = (StartingLocation)other;
            if (!Intrinsics.areEqual(this.position, startingLocation.position)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nation, startingLocation.nation)) {
                return false;
            }
            return this.usage == startingLocation.usage;
        }

        public StartingLocation() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "", "label", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "Normal", "Player", "Human", "Companion", "core"})
        public static final class Usage
        extends Enum<Usage> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String label;
            public static final /* enum */ Usage Normal;
            public static final /* enum */ Usage Player;
            public static final /* enum */ Usage Human;
            private static final /* synthetic */ Usage[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Usage(String label) {
                this.label = label;
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            public static Usage[] values() {
                return (Usage[])$VALUES.clone();
            }

            public static Usage valueOf(String value) {
                return Enum.valueOf(Usage.class, value);
            }

            @NotNull
            public static EnumEntries<Usage> getEntries() {
                return $ENTRIES;
            }

            static {
                Normal = new Usage("None");
                Player = new Usage("Player");
                Human = new Usage("Human");
                $VALUES = usageArray = new Usage[]{Usage.Normal, Usage.Player, Usage.Human};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/TileMap$StartingLocation$Usage$Companion;", "", "<init>", "()V", "default", "Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "getDefault", "()Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "core"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Usage getDefault() {
                    return Player;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/map/TileMap$TerrainListData;", "", "uniques", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "terrainNameSet", "", "", "<init>", "(Lcom/unciv/models/ruleset/unique/UniqueMap;Ljava/util/Set;)V", "getUniques", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "getTerrainNameSet", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "core"})
    public static final class TerrainListData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UniqueMap uniques;
        @NotNull
        private final Set<String> terrainNameSet;
        @NotNull
        private static final TerrainListData EMPTY = new TerrainListData(UniqueMap.Companion.getEMPTY(), SetsKt.emptySet());

        public TerrainListData(@NotNull UniqueMap uniques, @NotNull Set<String> terrainNameSet) {
            Intrinsics.checkNotNullParameter(uniques, "uniques");
            Intrinsics.checkNotNullParameter(terrainNameSet, "terrainNameSet");
            this.uniques = uniques;
            this.terrainNameSet = terrainNameSet;
        }

        @NotNull
        public final UniqueMap getUniques() {
            return this.uniques;
        }

        @NotNull
        public final Set<String> getTerrainNameSet() {
            return this.terrainNameSet;
        }

        @NotNull
        public final UniqueMap component1() {
            return this.uniques;
        }

        @NotNull
        public final Set<String> component2() {
            return this.terrainNameSet;
        }

        @NotNull
        public final TerrainListData copy(@NotNull UniqueMap uniques, @NotNull Set<String> terrainNameSet) {
            Intrinsics.checkNotNullParameter(uniques, "uniques");
            Intrinsics.checkNotNullParameter(terrainNameSet, "terrainNameSet");
            return new TerrainListData(uniques, terrainNameSet);
        }

        public static /* synthetic */ TerrainListData copy$default(TerrainListData terrainListData, UniqueMap uniqueMap2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                uniqueMap2 = terrainListData.uniques;
            }
            if ((n & 2) != 0) {
                set = terrainListData.terrainNameSet;
            }
            return terrainListData.copy(uniqueMap2, set);
        }

        @NotNull
        public String toString() {
            return "TerrainListData(uniques=" + this.uniques + ", terrainNameSet=" + this.terrainNameSet + ')';
        }

        public int hashCode() {
            int result2 = this.uniques.hashCode();
            result2 = result2 * 31 + ((Object)this.terrainNameSet).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerrainListData)) {
                return false;
            }
            TerrainListData terrainListData = (TerrainListData)other;
            if (!Intrinsics.areEqual(this.uniques, terrainListData.uniques)) {
                return false;
            }
            return Intrinsics.areEqual(this.terrainNameSet, terrainListData.terrainNameSet);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/TileMap$TerrainListData$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/unciv/logic/map/TileMap$TerrainListData;", "getEMPTY", "()Lcom/unciv/logic/map/TileMap$TerrainListData;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TerrainListData getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/map/TileMap$ViewableTile;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "maxHeightSeenToTile", "", "isVisible", "", "isAttackable", "<init>", "(Lcom/unciv/logic/map/tile/Tile;IZZ)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getMaxHeightSeenToTile", "()I", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "core"})
    public static final class ViewableTile {
        @NotNull
        private final Tile tile;
        private final int maxHeightSeenToTile;
        private final boolean isVisible;
        private final boolean isAttackable;

        public ViewableTile(@NotNull Tile tile, int maxHeightSeenToTile, boolean isVisible, boolean isAttackable) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            this.tile = tile;
            this.maxHeightSeenToTile = maxHeightSeenToTile;
            this.isVisible = isVisible;
            this.isAttackable = isAttackable;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }

        public final int getMaxHeightSeenToTile() {
            return this.maxHeightSeenToTile;
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        public final boolean isAttackable() {
            return this.isAttackable;
        }

        @NotNull
        public final Tile component1() {
            return this.tile;
        }

        public final int component2() {
            return this.maxHeightSeenToTile;
        }

        public final boolean component3() {
            return this.isVisible;
        }

        public final boolean component4() {
            return this.isAttackable;
        }

        @NotNull
        public final ViewableTile copy(@NotNull Tile tile, int maxHeightSeenToTile, boolean isVisible, boolean isAttackable) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            return new ViewableTile(tile, maxHeightSeenToTile, isVisible, isAttackable);
        }

        public static /* synthetic */ ViewableTile copy$default(ViewableTile viewableTile, Tile tile, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                tile = viewableTile.tile;
            }
            if ((n2 & 2) != 0) {
                n = viewableTile.maxHeightSeenToTile;
            }
            if ((n2 & 4) != 0) {
                bl = viewableTile.isVisible;
            }
            if ((n2 & 8) != 0) {
                bl2 = viewableTile.isAttackable;
            }
            return viewableTile.copy(tile, n, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ViewableTile(tile=" + this.tile + ", maxHeightSeenToTile=" + this.maxHeightSeenToTile + ", isVisible=" + this.isVisible + ", isAttackable=" + this.isAttackable + ')';
        }

        public int hashCode() {
            int result2 = this.tile.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.maxHeightSeenToTile);
            result2 = result2 * 31 + Boolean.hashCode(this.isVisible);
            result2 = result2 * 31 + Boolean.hashCode(this.isAttackable);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewableTile)) {
                return false;
            }
            ViewableTile viewableTile = (ViewableTile)other;
            if (!Intrinsics.areEqual(this.tile, viewableTile.tile)) {
                return false;
            }
            if (this.maxHeightSeenToTile != viewableTile.maxHeightSeenToTile) {
                return false;
            }
            if (this.isVisible != viewableTile.isVisible) {
                return false;
            }
            return this.isAttackable == viewableTile.isAttackable;
        }
    }
}

