/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.CharArray;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0006\u0010\u0017\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/components/widgets/WrappableLabel;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "text", "", "expectedWidth", "", "fontColor", "Lcom/badlogic/gdx/graphics/Color;", "fontSize", "", "hideIcons", "", "<init>", "(Ljava/lang/String;FLcom/badlogic/gdx/graphics/Color;IZ)V", "_measuredWidth", "optimizedWidth", "setWrap", "", "wrap", "getMeasuredWidth", "getMinWidth", "getPrefWidth", "getMaxWidth", "optimizePrefWidth", "core"})
public final class WrappableLabel
extends Label {
    private final float expectedWidth;
    private final int fontSize;
    private float _measuredWidth;
    private float optimizedWidth;

    public WrappableLabel(@NotNull String text2, float expectedWidth, @NotNull Color fontColor, int fontSize, boolean hideIcons) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(fontColor, "fontColor");
        super((CharSequence)TranslationsKt.tr(text2, hideIcons, hideIcons), BaseScreen.Companion.getSkin());
        this.expectedWidth = expectedWidth;
        this.fontSize = fontSize;
        this.optimizedWidth = Float.MAX_VALUE;
        if (!Intrinsics.areEqual(fontColor, Color.WHITE) || this.fontSize != 18) {
            Label.LabelStyle style = new Label.LabelStyle(this.getStyle());
            style.fontColor = fontColor;
            if (this.fontSize != 18) {
                style.font = Fonts.INSTANCE.getFont();
                this.setFontScale((float)this.fontSize / 100.0f);
            }
            this.setStyle(style);
        }
    }

    public /* synthetic */ WrappableLabel(String string, float f, Color color, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        if ((n2 & 8) != 0) {
            n = 18;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(string, f, color, n, bl);
    }

    @Override
    public void setWrap(boolean wrap) {
        this._measuredWidth = super.getPrefWidth();
        super.setWrap(wrap);
    }

    private final float getMeasuredWidth() {
        return this.getWrap() ? this._measuredWidth : super.getPrefWidth();
    }

    @Override
    public float getMinWidth() {
        return 48.0f;
    }

    @Override
    public float getPrefWidth() {
        return Math.min(this.getMeasuredWidth(), Math.min(this.expectedWidth, this.optimizedWidth));
    }

    @Override
    public float getMaxWidth() {
        return this.getMeasuredWidth();
    }

    public final float optimizePrefWidth() {
        if (!this.getWrap()) {
            return this._measuredWidth;
        }
        float labelRows = (float)Math.floor(this._measuredWidth / this.expectedWidth) + 1.0f;
        float optimizedWidth = this._measuredWidth / labelRows;
        float lineWidth = 0.0f;
        CharArray charArray = this.getText();
        Intrinsics.checkNotNullExpressionValue(charArray, "getText(...)");
        CharSequence charSequence = charArray;
        Regex regex = new Regex("\\b");
        int n = 0;
        for (String word : regex.split(charSequence, n)) {
            float wordWidth;
            if (((CharSequence)word).length() == 0 || !((lineWidth += (wordWidth = new WrappableLabel(word, Float.MAX_VALUE, null, this.fontSize, false, 20, null).getPrefWidth())) > optimizedWidth)) continue;
            if (!StringsKt.isBlank(word)) {
                optimizedWidth = lineWidth;
            }
            lineWidth = 0.0f;
        }
        this.optimizedWidth = RangesKt.coerceAtMost(optimizedWidth, this.expectedWidth);
        return optimizedWidth;
    }
}

