#include <string>
#include <map>
#include <array>
#include "PathologyEnums.h"

namespace pathology {

  std::map<std::string, LUT> DefaultColorLookupTables = 
  {
    { std::string("Background"), { {0, 1}, { { 0, 0, 0, 255 }, { 255, 255, 255, 255 } }, true } },
    { std::string("Normal"), { {0, 1}, { { 0, 0, 0, 255 }, { 255, 255, 255, 255 } }, false } },
    { std::string("Label"), { {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29}, { { 0, 0, 0, 0 }, { 0, 224, 249, 255 }, { 0, 249, 50, 255 }, { 174, 249, 0, 255 }, { 249, 100, 0, 255 }, { 249, 0, 125, 255 }, { 149, 0, 249, 255 }, { 0, 0, 206, 255 }, { 0, 185, 206, 255 }, { 0, 206, 41, 255 }, { 143, 206, 0, 255 }, { 206, 82, 0, 255 }, { 206, 0, 103, 255 }, { 124, 0, 206, 255 }, { 0, 0, 162, 255 }, { 0, 145, 162, 255 }, { 0, 162, 32, 255 }, { 114, 162, 0, 255 }, { 162, 65, 0, 255 }, { 162, 0, 81, 255 }, { 97, 0, 162, 255 }, { 0, 0, 119, 255 }, { 0, 107, 119, 255 }, { 0, 119, 23, 255 }, { 83, 119, 0, 255 }, { 119, 47, 0, 255 }, { 119, 0, 59, 255 }, { 71, 0, 119, 255 }, { 100, 100, 249, 255 }, { 100, 234, 249, 255 } }, false } },
    { std::string("Traffic Light (0 - 255)"), { {0.0, 10., 127, 255.},  { { 0, 0, 0, 0 },  { 0, 255, 0, 255 },  { 255, 255, 0, 255 },  { 255, 0, 0, 255 } }, false } },
    { std::string("Traffic Light (0 - 1)"), { {0.0, 10 / 255., 127 / 255., 1.},  { { 0, 0, 0, 0 },  { 0, 255, 0, 255 },  { 255, 255, 0, 255 },  { 255, 0, 0, 255 } }, false } }
  };

}