/* avizo_service.c generated by valac 0.56.17, the Vala compiler
 * generated from avizo_service.vala, do not modify */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gtk-layer-shell/gtk-layer-shell.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_AVIZO_WINDOW (avizo_window_get_type ())
#define AVIZO_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVIZO_WINDOW, AvizoWindow))
#define AVIZO_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVIZO_WINDOW, AvizoWindowClass))
#define IS_AVIZO_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVIZO_WINDOW))
#define IS_AVIZO_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVIZO_WINDOW))
#define AVIZO_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVIZO_WINDOW, AvizoWindowClass))

typedef struct _AvizoWindow AvizoWindow;
typedef struct _AvizoWindowClass AvizoWindowClass;
typedef struct _AvizoWindowPrivate AvizoWindowPrivate;
enum  {
	AVIZO_WINDOW_0_PROPERTY,
	AVIZO_WINDOW_IMAGE_PATH_PROPERTY,
	AVIZO_WINDOW_IMAGE_RESOURCE_PROPERTY,
	AVIZO_WINDOW_IMAGE_OPACITY_PROPERTY,
	AVIZO_WINDOW_PROGRESS_PROPERTY,
	AVIZO_WINDOW_MONITOR_PROPERTY,
	AVIZO_WINDOW_WIDTH_PROPERTY,
	AVIZO_WINDOW_HEIGHT_PROPERTY,
	AVIZO_WINDOW_PADDING_PROPERTY,
	AVIZO_WINDOW_BORDER_RADIUS_PROPERTY,
	AVIZO_WINDOW_BORDER_WIDTH_PROPERTY,
	AVIZO_WINDOW_BLOCK_HEIGHT_PROPERTY,
	AVIZO_WINDOW_BLOCK_SPACING_PROPERTY,
	AVIZO_WINDOW_BLOCK_COUNT_PROPERTY,
	AVIZO_WINDOW_FADE_IN_PROPERTY,
	AVIZO_WINDOW_FADE_OUT_PROPERTY,
	AVIZO_WINDOW_BACKGROUND_PROPERTY,
	AVIZO_WINDOW_BORDER_COLOR_PROPERTY,
	AVIZO_WINDOW_BAR_FG_COLOR_PROPERTY,
	AVIZO_WINDOW_BAR_BG_COLOR_PROPERTY,
	AVIZO_WINDOW_NUM_PROPERTIES
};
static GParamSpec* avizo_window_properties[AVIZO_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_AVIZO_SERVICE (avizo_service_get_type ())
#define AVIZO_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVIZO_SERVICE, AvizoService))
#define AVIZO_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVIZO_SERVICE, AvizoServiceClass))
#define IS_AVIZO_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVIZO_SERVICE))
#define IS_AVIZO_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVIZO_SERVICE))
#define AVIZO_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVIZO_SERVICE, AvizoServiceClass))

typedef struct _AvizoService AvizoService;
typedef struct _AvizoServiceClass AvizoServiceClass;
typedef struct _AvizoServicePrivate AvizoServicePrivate;
enum  {
	AVIZO_SERVICE_0_PROPERTY,
	AVIZO_SERVICE_IMAGE_PATH_PROPERTY,
	AVIZO_SERVICE_IMAGE_RESOURCE_PROPERTY,
	AVIZO_SERVICE_IMAGE_OPACITY_PROPERTY,
	AVIZO_SERVICE_PROGRESS_PROPERTY,
	AVIZO_SERVICE_WIDTH_PROPERTY,
	AVIZO_SERVICE_HEIGHT_PROPERTY,
	AVIZO_SERVICE_PADDING_PROPERTY,
	AVIZO_SERVICE_Y_OFFSET_PROPERTY,
	AVIZO_SERVICE_BORDER_RADIUS_PROPERTY,
	AVIZO_SERVICE_BORDER_WIDTH_PROPERTY,
	AVIZO_SERVICE_BLOCK_HEIGHT_PROPERTY,
	AVIZO_SERVICE_BLOCK_SPACING_PROPERTY,
	AVIZO_SERVICE_BLOCK_COUNT_PROPERTY,
	AVIZO_SERVICE_FADE_IN_PROPERTY,
	AVIZO_SERVICE_FADE_OUT_PROPERTY,
	AVIZO_SERVICE_BACKGROUND_PROPERTY,
	AVIZO_SERVICE_BORDER_COLOR_PROPERTY,
	AVIZO_SERVICE_BAR_FG_COLOR_PROPERTY,
	AVIZO_SERVICE_BAR_BG_COLOR_PROPERTY,
	AVIZO_SERVICE_MONITOR_PROPERTY,
	AVIZO_SERVICE_NUM_PROPERTIES
};
static GParamSpec* avizo_service_properties[AVIZO_SERVICE_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _AvizoWindow {
	GtkWindow parent_instance;
	AvizoWindowPrivate * priv;
};

struct _AvizoWindowClass {
	GtkWindowClass parent_class;
};

struct _AvizoWindowPrivate {
	gdouble _progress;
	gint _monitor;
	gint _width;
	gint _height;
	gint _padding;
	gint _border_radius;
	gint _border_width;
	gint _block_height;
	gint _block_spacing;
	gint _block_count;
	gdouble _fade_in;
	gdouble _fade_out;
	GdkRGBA _background;
	GdkRGBA _border_color;
	GdkRGBA _bar_fg_color;
	GdkRGBA _bar_bg_color;
	gdouble opacity;
	gboolean is_fade_in;
	gint64 prev_frame_time;
	guint prev_callback_id;
	GtkImage* image;
};

struct _AvizoService {
	GObject parent_instance;
	AvizoServicePrivate * priv;
};

struct _AvizoServiceClass {
	GObjectClass parent_class;
};

struct _AvizoServicePrivate {
	gchar* _image_path;
	gchar* _image_resource;
	gdouble _image_opacity;
	gdouble _progress;
	gint _width;
	gint _height;
	gint _padding;
	gdouble _y_offset;
	gint _border_radius;
	gint _border_width;
	gint _block_height;
	gint _block_spacing;
	gint _block_count;
	gdouble _fade_in;
	gdouble _fade_out;
	GdkRGBA _background;
	GdkRGBA _border_color;
	GdkRGBA _bar_fg_color;
	GdkRGBA _bar_bg_color;
	gint _monitor;
	GArray* _windows;
	gint _open_timeouts;
};

struct _Block1Data {
	int _ref_count_;
	AvizoService* self;
	gint monitors;
};

static gint AvizoWindow_private_offset;
static gpointer avizo_window_parent_class = NULL;
static gint AvizoService_private_offset;
static gpointer avizo_service_parent_class = NULL;
static gchar** avizo_service_props;
static gint avizo_service_props_length1;
static gchar** avizo_service_props = NULL;
static gint avizo_service_props_length1 = 0;
static gint _avizo_service_props_size_ = 0;

GType gdk_wayland_display_get_type (void);
VALA_EXTERN GType avizo_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AvizoWindow, g_object_unref)
VALA_EXTERN AvizoWindow* avizo_window_new (void);
VALA_EXTERN AvizoWindow* avizo_window_construct (GType object_type);
static gboolean avizo_window_on_draw (AvizoWindow* self,
                               GtkWidget* widget,
                               cairo_t* ctx);
static gboolean _avizo_window_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                cairo_t* cr,
                                                gpointer self);
VALA_EXTERN void avizo_window_show_animated (AvizoWindow* self);
static gboolean avizo_window_animation_tick (AvizoWindow* self,
                                      GtkWidget* widget,
                                      GdkFrameClock* frame_clock);
static gboolean _avizo_window_animation_tick_gtk_tick_callback (GtkWidget* widget,
                                                         GdkFrameClock* frame_clock,
                                                         gpointer self);
VALA_EXTERN void avizo_window_hide_animated (AvizoWindow* self);
VALA_EXTERN gdouble avizo_window_get_fade_in (AvizoWindow* self);
VALA_EXTERN gdouble avizo_window_get_fade_out (AvizoWindow* self);
VALA_EXTERN gint avizo_window_get_padding (AvizoWindow* self);
VALA_EXTERN gint avizo_window_get_border_width (AvizoWindow* self);
VALA_EXTERN gint avizo_window_get_block_count (AvizoWindow* self);
VALA_EXTERN gint avizo_window_get_block_spacing (AvizoWindow* self);
VALA_EXTERN gint avizo_window_get_block_height (AvizoWindow* self);
static void avizo_window_draw_rect (AvizoWindow* self,
                             cairo_t* ctx,
                             gdouble x,
                             gdouble y,
                             gdouble w,
                             gdouble h);
VALA_EXTERN void avizo_window_get_border_color (AvizoWindow* self,
                                    GdkRGBA * result);
static void avizo_window_draw_round_rect (AvizoWindow* self,
                                   cairo_t* ctx,
                                   gdouble x,
                                   gdouble y,
                                   gdouble w,
                                   gdouble h,
                                   gdouble r);
VALA_EXTERN gint avizo_window_get_border_radius (AvizoWindow* self);
VALA_EXTERN void avizo_window_get_background (AvizoWindow* self,
                                  GdkRGBA * result);
VALA_EXTERN void avizo_window_get_bar_bg_color (AvizoWindow* self,
                                    GdkRGBA * result);
VALA_EXTERN void avizo_window_get_bar_fg_color (AvizoWindow* self,
                                    GdkRGBA * result);
VALA_EXTERN gdouble avizo_window_get_progress (AvizoWindow* self);
VALA_EXTERN void avizo_window_set_image_path (AvizoWindow* self,
                                  const gchar* value);
VALA_EXTERN void avizo_window_set_image_resource (AvizoWindow* self,
                                      const gchar* value);
VALA_EXTERN gdouble avizo_window_get_image_opacity (AvizoWindow* self);
VALA_EXTERN void avizo_window_set_image_opacity (AvizoWindow* self,
                                     gdouble value);
VALA_EXTERN void avizo_window_set_progress (AvizoWindow* self,
                                gdouble value);
VALA_EXTERN gint avizo_window_get_monitor (AvizoWindow* self);
VALA_EXTERN void avizo_window_set_monitor (AvizoWindow* self,
                               gint value);
VALA_EXTERN gint avizo_window_get_width (AvizoWindow* self);
VALA_EXTERN void avizo_window_set_width (AvizoWindow* self,
                             gint value);
VALA_EXTERN gint avizo_window_get_height (AvizoWindow* self);
VALA_EXTERN void avizo_window_set_height (AvizoWindow* self,
                              gint value);
VALA_EXTERN void avizo_window_set_padding (AvizoWindow* self,
                               gint value);
VALA_EXTERN void avizo_window_set_border_radius (AvizoWindow* self,
                                     gint value);
VALA_EXTERN void avizo_window_set_border_width (AvizoWindow* self,
                                    gint value);
VALA_EXTERN void avizo_window_set_block_height (AvizoWindow* self,
                                    gint value);
VALA_EXTERN void avizo_window_set_block_spacing (AvizoWindow* self,
                                     gint value);
VALA_EXTERN void avizo_window_set_block_count (AvizoWindow* self,
                                   gint value);
VALA_EXTERN void avizo_window_set_fade_in (AvizoWindow* self,
                               gdouble value);
VALA_EXTERN void avizo_window_set_fade_out (AvizoWindow* self,
                                gdouble value);
VALA_EXTERN void avizo_window_set_background (AvizoWindow* self,
                                  GdkRGBA * value);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
VALA_EXTERN void avizo_window_set_border_color (AvizoWindow* self,
                                    GdkRGBA * value);
VALA_EXTERN void avizo_window_set_bar_fg_color (AvizoWindow* self,
                                    GdkRGBA * value);
VALA_EXTERN void avizo_window_set_bar_bg_color (AvizoWindow* self,
                                    GdkRGBA * value);
static void avizo_window_finalize (GObject * obj);
static GType avizo_window_get_type_once (void);
static void _vala_avizo_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_avizo_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN GType avizo_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AvizoService, g_object_unref)
VALA_EXTERN guint avizo_service_register_object (void* object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error);
VALA_EXTERN void rgba (gint red,
           gint green,
           gint blue,
           gdouble alpha,
           GdkRGBA* result);
static void _g_object_unref0_ (gpointer var);
static void _vala_AvizoWindow_free_function_content_of (gpointer data);
VALA_EXTERN void avizo_service_show (AvizoService* self,
                         gdouble seconds,
                         GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN gint avizo_service_get_monitor (AvizoService* self);
static AvizoWindow* avizo_service_create_window (AvizoService* self,
                                          GdkDisplay* display);
static void avizo_service_show_window (AvizoService* self,
                                AvizoWindow* window,
                                GdkMonitor* monitor);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
VALA_EXTERN gboolean is_wayland (GdkDisplay* display);
VALA_EXTERN gint avizo_service_get_height (AvizoService* self);
VALA_EXTERN gdouble avizo_service_get_y_offset (AvizoService* self);
VALA_EXTERN AvizoService* avizo_service_new (void);
VALA_EXTERN AvizoService* avizo_service_construct (GType object_type);
VALA_EXTERN const gchar* avizo_service_get_image_path (AvizoService* self);
VALA_EXTERN void avizo_service_set_image_path (AvizoService* self,
                                   const gchar* value);
VALA_EXTERN const gchar* avizo_service_get_image_resource (AvizoService* self);
VALA_EXTERN void avizo_service_set_image_resource (AvizoService* self,
                                       const gchar* value);
VALA_EXTERN gdouble avizo_service_get_image_opacity (AvizoService* self);
VALA_EXTERN void avizo_service_set_image_opacity (AvizoService* self,
                                      gdouble value);
VALA_EXTERN gdouble avizo_service_get_progress (AvizoService* self);
VALA_EXTERN void avizo_service_set_progress (AvizoService* self,
                                 gdouble value);
VALA_EXTERN gint avizo_service_get_width (AvizoService* self);
VALA_EXTERN void avizo_service_set_width (AvizoService* self,
                              gint value);
VALA_EXTERN void avizo_service_set_height (AvizoService* self,
                               gint value);
VALA_EXTERN gint avizo_service_get_padding (AvizoService* self);
VALA_EXTERN void avizo_service_set_padding (AvizoService* self,
                                gint value);
VALA_EXTERN void avizo_service_set_y_offset (AvizoService* self,
                                 gdouble value);
VALA_EXTERN gint avizo_service_get_border_radius (AvizoService* self);
VALA_EXTERN void avizo_service_set_border_radius (AvizoService* self,
                                      gint value);
VALA_EXTERN gint avizo_service_get_border_width (AvizoService* self);
VALA_EXTERN void avizo_service_set_border_width (AvizoService* self,
                                     gint value);
VALA_EXTERN gint avizo_service_get_block_height (AvizoService* self);
VALA_EXTERN void avizo_service_set_block_height (AvizoService* self,
                                     gint value);
VALA_EXTERN gint avizo_service_get_block_spacing (AvizoService* self);
VALA_EXTERN void avizo_service_set_block_spacing (AvizoService* self,
                                      gint value);
VALA_EXTERN gint avizo_service_get_block_count (AvizoService* self);
VALA_EXTERN void avizo_service_set_block_count (AvizoService* self,
                                    gint value);
VALA_EXTERN gdouble avizo_service_get_fade_in (AvizoService* self);
VALA_EXTERN void avizo_service_set_fade_in (AvizoService* self,
                                gdouble value);
VALA_EXTERN gdouble avizo_service_get_fade_out (AvizoService* self);
VALA_EXTERN void avizo_service_set_fade_out (AvizoService* self,
                                 gdouble value);
VALA_EXTERN void avizo_service_get_background (AvizoService* self,
                                   GdkRGBA * result);
VALA_EXTERN void avizo_service_set_background (AvizoService* self,
                                   GdkRGBA * value);
VALA_EXTERN void avizo_service_get_border_color (AvizoService* self,
                                     GdkRGBA * result);
VALA_EXTERN void avizo_service_set_border_color (AvizoService* self,
                                     GdkRGBA * value);
VALA_EXTERN void avizo_service_get_bar_fg_color (AvizoService* self,
                                     GdkRGBA * result);
VALA_EXTERN void avizo_service_set_bar_fg_color (AvizoService* self,
                                     GdkRGBA * value);
VALA_EXTERN void avizo_service_get_bar_bg_color (AvizoService* self,
                                     GdkRGBA * result);
VALA_EXTERN void avizo_service_set_bar_bg_color (AvizoService* self,
                                     GdkRGBA * value);
VALA_EXTERN void avizo_service_set_monitor (AvizoService* self,
                                gint value);
static void avizo_service_finalize (GObject * obj);
static GType avizo_service_get_type_once (void);
static void _vala_avizo_service_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_avizo_service_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _dbus_avizo_service_show (AvizoService* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation);
static void avizo_service_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data);
static GVariant* avizo_service_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data);
static GVariant* _dbus_avizo_service_get_image_path (AvizoService* self);
static GVariant* _dbus_avizo_service_get_image_resource (AvizoService* self);
static GVariant* _dbus_avizo_service_get_image_opacity (AvizoService* self);
static GVariant* _dbus_avizo_service_get_progress (AvizoService* self);
static GVariant* _dbus_avizo_service_get_width (AvizoService* self);
static GVariant* _dbus_avizo_service_get_height (AvizoService* self);
static GVariant* _dbus_avizo_service_get_padding (AvizoService* self);
static GVariant* _dbus_avizo_service_get_y_offset (AvizoService* self);
static GVariant* _dbus_avizo_service_get_border_radius (AvizoService* self);
static GVariant* _dbus_avizo_service_get_border_width (AvizoService* self);
static GVariant* _dbus_avizo_service_get_block_height (AvizoService* self);
static GVariant* _dbus_avizo_service_get_block_spacing (AvizoService* self);
static GVariant* _dbus_avizo_service_get_block_count (AvizoService* self);
static GVariant* _dbus_avizo_service_get_fade_in (AvizoService* self);
static GVariant* _dbus_avizo_service_get_fade_out (AvizoService* self);
static GVariant* _dbus_avizo_service_get_background (AvizoService* self);
static GVariant* _dbus_avizo_service_get_border_color (AvizoService* self);
static GVariant* _dbus_avizo_service_get_bar_fg_color (AvizoService* self);
static GVariant* _dbus_avizo_service_get_bar_bg_color (AvizoService* self);
static GVariant* _dbus_avizo_service_get_monitor (AvizoService* self);
static gboolean avizo_service_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data);
static void _dbus_avizo_service_set_image_path (AvizoService* self,
                                         GVariant* _value);
static void _dbus_avizo_service_set_image_resource (AvizoService* self,
                                             GVariant* _value);
static void _dbus_avizo_service_set_image_opacity (AvizoService* self,
                                            GVariant* _value);
static void _dbus_avizo_service_set_progress (AvizoService* self,
                                       GVariant* _value);
static void _dbus_avizo_service_set_width (AvizoService* self,
                                    GVariant* _value);
static void _dbus_avizo_service_set_height (AvizoService* self,
                                     GVariant* _value);
static void _dbus_avizo_service_set_padding (AvizoService* self,
                                      GVariant* _value);
static void _dbus_avizo_service_set_y_offset (AvizoService* self,
                                       GVariant* _value);
static void _dbus_avizo_service_set_border_radius (AvizoService* self,
                                            GVariant* _value);
static void _dbus_avizo_service_set_border_width (AvizoService* self,
                                           GVariant* _value);
static void _dbus_avizo_service_set_block_height (AvizoService* self,
                                           GVariant* _value);
static void _dbus_avizo_service_set_block_spacing (AvizoService* self,
                                            GVariant* _value);
static void _dbus_avizo_service_set_block_count (AvizoService* self,
                                          GVariant* _value);
static void _dbus_avizo_service_set_fade_in (AvizoService* self,
                                      GVariant* _value);
static void _dbus_avizo_service_set_fade_out (AvizoService* self,
                                       GVariant* _value);
static void _dbus_avizo_service_set_background (AvizoService* self,
                                         GVariant* _value);
static void _dbus_avizo_service_set_border_color (AvizoService* self,
                                           GVariant* _value);
static void _dbus_avizo_service_set_bar_fg_color (AvizoService* self,
                                           GVariant* _value);
static void _dbus_avizo_service_set_bar_bg_color (AvizoService* self,
                                           GVariant* _value);
static void _dbus_avizo_service_set_monitor (AvizoService* self,
                                      GVariant* _value);
static void _avizo_service_unregister_object (gpointer user_data);
VALA_EXTERN void on_bus_aquired (GDBusConnection* conn);
static void _vala_main (gchar** args,
                 gint args_length1);
static void _on_bus_aquired_gbus_acquired_callback (GDBusConnection* connection,
                                             const gchar* name,
                                             gpointer self);
static void __lambda5_ (void);
static void ___lambda5__gbus_name_acquired_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
static void __lambda6_ (void);
static void ___lambda6__gbus_name_lost_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self);

static const GDBusArgInfo _avizo_service_dbus_arg_info_show_seconds = {-1, "seconds", "d", NULL};
static const GDBusArgInfo * const _avizo_service_dbus_arg_info_show_in[] = {&_avizo_service_dbus_arg_info_show_seconds, NULL};
static const GDBusArgInfo * const _avizo_service_dbus_arg_info_show_out[] = {NULL};
static const GDBusMethodInfo _avizo_service_dbus_method_info_show = {-1, "Show", (GDBusArgInfo **) (&_avizo_service_dbus_arg_info_show_in), (GDBusArgInfo **) (&_avizo_service_dbus_arg_info_show_out), NULL};
static const GDBusMethodInfo * const _avizo_service_dbus_method_info[] = {&_avizo_service_dbus_method_info_show, NULL};
static const GDBusSignalInfo * const _avizo_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_image_path = {-1, "ImagePath", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_image_resource = {-1, "ImageResource", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_image_opacity = {-1, "ImageOpacity", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_progress = {-1, "Progress", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_width = {-1, "Width", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_height = {-1, "Height", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_padding = {-1, "Padding", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_y_offset = {-1, "YOffset", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_border_radius = {-1, "BorderRadius", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_border_width = {-1, "BorderWidth", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_block_height = {-1, "BlockHeight", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_block_spacing = {-1, "BlockSpacing", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_block_count = {-1, "BlockCount", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_fade_in = {-1, "FadeIn", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_fade_out = {-1, "FadeOut", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_background = {-1, "Background", "(dddd)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_border_color = {-1, "BorderColor", "(dddd)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_bar_fg_color = {-1, "BarFgColor", "(dddd)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_bar_bg_color = {-1, "BarBgColor", "(dddd)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _avizo_service_dbus_property_info_monitor = {-1, "Monitor", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _avizo_service_dbus_property_info[] = {&_avizo_service_dbus_property_info_image_path, &_avizo_service_dbus_property_info_image_resource, &_avizo_service_dbus_property_info_image_opacity, &_avizo_service_dbus_property_info_progress, &_avizo_service_dbus_property_info_width, &_avizo_service_dbus_property_info_height, &_avizo_service_dbus_property_info_padding, &_avizo_service_dbus_property_info_y_offset, &_avizo_service_dbus_property_info_border_radius, &_avizo_service_dbus_property_info_border_width, &_avizo_service_dbus_property_info_block_height, &_avizo_service_dbus_property_info_block_spacing, &_avizo_service_dbus_property_info_block_count, &_avizo_service_dbus_property_info_fade_in, &_avizo_service_dbus_property_info_fade_out, &_avizo_service_dbus_property_info_background, &_avizo_service_dbus_property_info_border_color, &_avizo_service_dbus_property_info_bar_fg_color, &_avizo_service_dbus_property_info_bar_bg_color, &_avizo_service_dbus_property_info_monitor, NULL};
static const GDBusInterfaceInfo _avizo_service_dbus_interface_info = {-1, "org.danb.avizo.service", (GDBusMethodInfo **) (&_avizo_service_dbus_method_info), (GDBusSignalInfo **) (&_avizo_service_dbus_signal_info), (GDBusPropertyInfo **) (&_avizo_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _avizo_service_dbus_interface_vtable = {avizo_service_dbus_interface_method_call, avizo_service_dbus_interface_get_property, avizo_service_dbus_interface_set_property};

static inline gpointer
avizo_window_get_instance_private (AvizoWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AvizoWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_avizo_window_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                       cairo_t* cr,
                                       gpointer self)
{
	gboolean result;
	result = avizo_window_on_draw ((AvizoWindow*) self, _sender, cr);
	return result;
}

AvizoWindow*
avizo_window_construct (GType object_type)
{
	AvizoWindow * self = NULL;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GdkVisual* _tmp6_;
	self = (AvizoWindow*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = screen;
	_tmp3_ = gdk_screen_get_rgba_visual (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	visual = _tmp4_;
	_tmp6_ = visual;
	if (_tmp6_ != NULL) {
		GdkScreen* _tmp7_;
		_tmp7_ = screen;
		_tmp5_ = gdk_screen_is_composited (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GdkVisual* _tmp8_;
		_tmp8_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp8_);
	}
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _avizo_window_on_draw_gtk_widget_draw, self, 0);
	_g_object_unref0 (visual);
	_g_object_unref0 (screen);
	return self;
}

AvizoWindow*
avizo_window_new (void)
{
	return avizo_window_construct (TYPE_AVIZO_WINDOW);
}

static gboolean
_avizo_window_animation_tick_gtk_tick_callback (GtkWidget* widget,
                                                GdkFrameClock* frame_clock,
                                                gpointer self)
{
	gboolean result;
	result = avizo_window_animation_tick ((AvizoWindow*) self, widget, frame_clock);
	return result;
}

void
avizo_window_show_animated (AvizoWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->prev_callback_id);
	self->priv->is_fade_in = TRUE;
	self->priv->prev_callback_id = gtk_widget_add_tick_callback ((GtkWidget*) self, _avizo_window_animation_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
	gtk_widget_show ((GtkWidget*) self);
}

void
avizo_window_hide_animated (AvizoWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->prev_callback_id);
	self->priv->is_fade_in = FALSE;
	self->priv->prev_callback_id = gtk_widget_add_tick_callback ((GtkWidget*) self, _avizo_window_animation_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
}

static gboolean
avizo_window_animation_tick (AvizoWindow* self,
                             GtkWidget* widget,
                             GdkFrameClock* frame_clock)
{
	gint64 animation_us_elapsed = 0LL;
	gdouble animation_sec_elapsed = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	gdk_frame_clock_begin_updating (frame_clock);
	if (self->priv->prev_frame_time == ((gint64) 0)) {
		animation_us_elapsed = (gint64) 0;
	} else {
		animation_us_elapsed = gdk_frame_clock_get_frame_time (frame_clock) - self->priv->prev_frame_time;
	}
	self->priv->prev_frame_time = gdk_frame_clock_get_frame_time (frame_clock);
	animation_sec_elapsed = ((gdouble) animation_us_elapsed) / 1000000;
	if (self->priv->is_fade_in) {
		gdouble _tmp0_;
		if (self->priv->opacity >= ((gdouble) 1)) {
			self->priv->prev_frame_time = (gint64) 0;
			gdk_frame_clock_end_updating (frame_clock);
			result = FALSE;
			return result;
		}
		_tmp0_ = self->priv->_fade_in;
		self->priv->opacity = self->priv->opacity + (animation_sec_elapsed / _tmp0_);
		if (self->priv->opacity > ((gdouble) 1)) {
			self->priv->opacity = (gdouble) 1;
		}
		g_print ("Fade in: %f\n", self->priv->opacity);
		gtk_widget_set_opacity (widget, self->priv->opacity);
	} else {
		gdouble _tmp1_;
		if (self->priv->opacity <= ((gdouble) 0)) {
			gtk_widget_hide ((GtkWidget*) self);
			self->priv->prev_frame_time = (gint64) 0;
			gdk_frame_clock_end_updating (frame_clock);
			result = FALSE;
			return result;
		}
		_tmp1_ = self->priv->_fade_out;
		self->priv->opacity = self->priv->opacity - (animation_sec_elapsed / _tmp1_);
		if (self->priv->opacity < ((gdouble) 0)) {
			self->priv->opacity = (gdouble) 0;
		}
		g_print ("Fade out: %f\n", self->priv->opacity);
		gtk_widget_set_opacity (widget, self->priv->opacity);
	}
	gdk_frame_clock_end_updating (frame_clock);
	result = TRUE;
	return result;
}

static gboolean
avizo_window_on_draw (AvizoWindow* self,
                      GtkWidget* widget,
                      cairo_t* ctx)
{
	gdouble block_width = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble blocks_x = 0.0;
	gint _tmp5_;
	gint _tmp6_;
	gdouble blocks_y = 0.0;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GdkRGBA _tmp10_;
	gint _tmp11_;
	GdkRGBA _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GdkRGBA _tmp19_;
	GdkRGBA _tmp25_;
	gint _tmp26_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->_padding;
	_tmp1_ = self->priv->_border_width;
	_tmp2_ = self->priv->_block_count;
	_tmp3_ = self->priv->_block_spacing;
	_tmp4_ = self->priv->_block_count;
	block_width = (((self->priv->_width - (2 * _tmp0_)) - (2 * _tmp1_)) - ((gdouble) ((_tmp2_ - 1) * _tmp3_))) / _tmp4_;
	_tmp5_ = self->priv->_padding;
	_tmp6_ = self->priv->_border_width;
	blocks_x = (gdouble) (_tmp5_ + _tmp6_);
	_tmp7_ = self->priv->_padding;
	_tmp8_ = self->priv->_border_width;
	_tmp9_ = self->priv->_block_height;
	blocks_y = (gdouble) (((self->priv->_height - _tmp7_) - _tmp8_) - _tmp9_);
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	cairo_paint (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	avizo_window_draw_rect (self, ctx, (gdouble) 0, (gdouble) 0, (gdouble) self->priv->_width, (gdouble) self->priv->_height);
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	_tmp10_ = self->priv->_border_color;
	gdk_cairo_set_source_rgba (ctx, &_tmp10_);
	_tmp11_ = self->priv->_border_radius;
	avizo_window_draw_round_rect (self, ctx, (gdouble) 0, (gdouble) 0, (gdouble) self->priv->_width, (gdouble) self->priv->_height, (gdouble) _tmp11_);
	_tmp12_ = self->priv->_background;
	gdk_cairo_set_source_rgba (ctx, &_tmp12_);
	_tmp13_ = self->priv->_border_width;
	_tmp14_ = self->priv->_border_width;
	_tmp15_ = self->priv->_border_width;
	_tmp16_ = self->priv->_border_width;
	_tmp17_ = self->priv->_border_radius;
	_tmp18_ = self->priv->_border_width;
	avizo_window_draw_round_rect (self, ctx, (gdouble) _tmp13_, (gdouble) _tmp14_, (gdouble) (self->priv->_width - (2 * _tmp15_)), (gdouble) (self->priv->_height - (2 * _tmp16_)), (gdouble) (_tmp17_ - _tmp18_));
	_tmp19_ = self->priv->_bar_bg_color;
	gdk_cairo_set_source_rgba (ctx, &_tmp19_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = self->priv->_block_count;
				if (!(i < _tmp22_)) {
					break;
				}
				_tmp23_ = self->priv->_block_spacing;
				_tmp24_ = self->priv->_block_height;
				avizo_window_draw_rect (self, ctx, blocks_x + ((block_width + _tmp23_) * i), blocks_y, block_width, (gdouble) _tmp24_);
			}
		}
	}
	_tmp25_ = self->priv->_bar_fg_color;
	gdk_cairo_set_source_rgba (ctx, &_tmp25_);
	_tmp26_ = self->priv->_block_spacing;
	if (_tmp26_ > 0) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp27_ = FALSE;
				_tmp27_ = TRUE;
				while (TRUE) {
					gint _tmp29_;
					gdouble _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					if (!_tmp27_) {
						gint _tmp28_;
						_tmp28_ = i;
						i = _tmp28_ + 1;
					}
					_tmp27_ = FALSE;
					_tmp29_ = self->priv->_block_count;
					_tmp30_ = self->priv->_progress;
					if (!(i < ((gint) (_tmp29_ * _tmp30_)))) {
						break;
					}
					_tmp31_ = self->priv->_block_spacing;
					_tmp32_ = self->priv->_block_height;
					avizo_window_draw_rect (self, ctx, blocks_x + ((block_width + _tmp31_) * i), blocks_y, block_width, (gdouble) _tmp32_);
				}
			}
		}
	} else {
		gdouble width = 0.0;
		gint _tmp33_;
		gdouble _tmp34_;
		gint height = 0;
		gint _tmp35_;
		_tmp33_ = self->priv->_block_count;
		_tmp34_ = self->priv->_progress;
		width = (block_width * _tmp33_) * _tmp34_;
		_tmp35_ = self->priv->_block_height;
		height = _tmp35_;
		avizo_window_draw_rect (self, ctx, blocks_x, blocks_y, width, (gdouble) height);
	}
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	result = FALSE;
	return result;
}

static void
avizo_window_draw_rect (AvizoWindow* self,
                        cairo_t* ctx,
                        gdouble x,
                        gdouble y,
                        gdouble w,
                        gdouble h)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	cairo_line_to (ctx, x, y);
	cairo_line_to (ctx, x + w, y);
	cairo_line_to (ctx, x + w, y + h);
	cairo_line_to (ctx, x, y + h);
	cairo_close_path (ctx);
	cairo_fill (ctx);
}

static void
avizo_window_draw_round_rect (AvizoWindow* self,
                              cairo_t* ctx,
                              gdouble x,
                              gdouble y,
                              gdouble w,
                              gdouble h,
                              gdouble r)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	cairo_move_to (ctx, x + r, y);
	cairo_line_to (ctx, (x + w) - r, y);
	cairo_arc (ctx, (x + w) - r, y + r, r, (-G_PI) / 2, (gdouble) 0);
	cairo_line_to (ctx, x + w, (y + h) - r);
	cairo_arc (ctx, (x + w) - r, (y + h) - r, r, (gdouble) 0, G_PI / 2);
	cairo_line_to (ctx, x + r, y + h);
	cairo_arc (ctx, x + r, (y + h) - r, r, G_PI / 2, G_PI);
	cairo_line_to (ctx, x, y + r);
	cairo_arc (ctx, x + r, y + r, r, G_PI, (3 * G_PI) / 2);
	cairo_close_path (ctx);
	cairo_fill (ctx);
}

void
avizo_window_set_image_path (AvizoWindow* self,
                             const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, "") != 0) {
		GtkImage* _tmp0_;
		_tmp0_ = self->priv->image;
		gtk_image_set_from_file (_tmp0_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_IMAGE_PATH_PROPERTY]);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
avizo_window_set_image_resource (AvizoWindow* self,
                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, "") != 0) {
		GtkImage* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->image;
		_tmp1_ = string_to_string (value);
		_tmp2_ = g_strconcat ("/org/danb/avizo/data/images/", _tmp1_, ".png", NULL);
		_tmp3_ = _tmp2_;
		gtk_image_set_from_resource (_tmp0_, _tmp3_);
		_g_free0 (_tmp3_);
	}
	g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_IMAGE_RESOURCE_PROPERTY]);
}

gdouble
avizo_window_get_image_opacity (AvizoWindow* self)
{
	gdouble result;
	GtkImage* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->image;
	_tmp1_ = gtk_widget_get_opacity ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
avizo_window_set_image_opacity (AvizoWindow* self,
                                gdouble value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image;
	gtk_widget_set_opacity ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_IMAGE_OPACITY_PROPERTY]);
}

gdouble
avizo_window_get_progress (AvizoWindow* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

void
avizo_window_set_progress (AvizoWindow* self,
                           gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_PROGRESS_PROPERTY]);
	}
}

gint
avizo_window_get_monitor (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor;
	return result;
}

void
avizo_window_set_monitor (AvizoWindow* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_monitor (self);
	if (old_value != value) {
		self->priv->_monitor = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_MONITOR_PROPERTY]);
	}
}

gint
avizo_window_get_width (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

void
avizo_window_set_width (AvizoWindow* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->_width, self->priv->_height);
	g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_WIDTH_PROPERTY]);
}

gint
avizo_window_get_height (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
	return result;
}

void
avizo_window_set_height (AvizoWindow* self,
                         gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_height = value;
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->_width, self->priv->_height);
	g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_HEIGHT_PROPERTY]);
}

gint
avizo_window_get_padding (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding;
	return result;
}

void
avizo_window_set_padding (AvizoWindow* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_padding (self);
	if (old_value != value) {
		self->priv->_padding = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_PADDING_PROPERTY]);
	}
}

gint
avizo_window_get_border_radius (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_radius;
	return result;
}

void
avizo_window_set_border_radius (AvizoWindow* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_border_radius (self);
	if (old_value != value) {
		self->priv->_border_radius = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BORDER_RADIUS_PROPERTY]);
	}
}

gint
avizo_window_get_border_width (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_width;
	return result;
}

void
avizo_window_set_border_width (AvizoWindow* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_border_width (self);
	if (old_value != value) {
		self->priv->_border_width = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BORDER_WIDTH_PROPERTY]);
	}
}

gint
avizo_window_get_block_height (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_height;
	return result;
}

void
avizo_window_set_block_height (AvizoWindow* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_block_height (self);
	if (old_value != value) {
		self->priv->_block_height = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BLOCK_HEIGHT_PROPERTY]);
	}
}

gint
avizo_window_get_block_spacing (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_spacing;
	return result;
}

void
avizo_window_set_block_spacing (AvizoWindow* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_block_spacing (self);
	if (old_value != value) {
		self->priv->_block_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BLOCK_SPACING_PROPERTY]);
	}
}

gint
avizo_window_get_block_count (AvizoWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_count;
	return result;
}

void
avizo_window_set_block_count (AvizoWindow* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_block_count (self);
	if (old_value != value) {
		self->priv->_block_count = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BLOCK_COUNT_PROPERTY]);
	}
}

gdouble
avizo_window_get_fade_in (AvizoWindow* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_in;
	return result;
}

void
avizo_window_set_fade_in (AvizoWindow* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_fade_in (self);
	if (old_value != value) {
		self->priv->_fade_in = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_FADE_IN_PROPERTY]);
	}
}

gdouble
avizo_window_get_fade_out (AvizoWindow* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_out;
	return result;
}

void
avizo_window_set_fade_out (AvizoWindow* self,
                           gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_window_get_fade_out (self);
	if (old_value != value) {
		self->priv->_fade_out = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_FADE_OUT_PROPERTY]);
	}
}

void
avizo_window_get_background (AvizoWindow* self,
                             GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
avizo_window_set_background (AvizoWindow* self,
                             GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_window_get_background (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_background = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BACKGROUND_PROPERTY]);
	}
}

void
avizo_window_get_border_color (AvizoWindow* self,
                               GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_border_color;
	*result = _tmp0_;
	return;
}

void
avizo_window_set_border_color (AvizoWindow* self,
                               GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_window_get_border_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_border_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BORDER_COLOR_PROPERTY]);
	}
}

void
avizo_window_get_bar_fg_color (AvizoWindow* self,
                               GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_bar_fg_color;
	*result = _tmp0_;
	return;
}

void
avizo_window_set_bar_fg_color (AvizoWindow* self,
                               GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_window_get_bar_fg_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_bar_fg_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BAR_FG_COLOR_PROPERTY]);
	}
}

void
avizo_window_get_bar_bg_color (AvizoWindow* self,
                               GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_bar_bg_color;
	*result = _tmp0_;
	return;
}

void
avizo_window_set_bar_bg_color (AvizoWindow* self,
                               GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_window_get_bar_bg_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_bar_bg_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_window_properties[AVIZO_WINDOW_BAR_BG_COLOR_PROPERTY]);
	}
}

static void
avizo_window_class_init (AvizoWindowClass * klass,
                         gpointer klass_data)
{
	avizo_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AvizoWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_avizo_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avizo_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = avizo_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_IMAGE_PATH_PROPERTY, avizo_window_properties[AVIZO_WINDOW_IMAGE_PATH_PROPERTY] = g_param_spec_string ("image-path", "image-path", "image-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_IMAGE_RESOURCE_PROPERTY, avizo_window_properties[AVIZO_WINDOW_IMAGE_RESOURCE_PROPERTY] = g_param_spec_string ("image-resource", "image-resource", "image-resource", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_IMAGE_OPACITY_PROPERTY, avizo_window_properties[AVIZO_WINDOW_IMAGE_OPACITY_PROPERTY] = g_param_spec_double ("image-opacity", "image-opacity", "image-opacity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_PROGRESS_PROPERTY, avizo_window_properties[AVIZO_WINDOW_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_MONITOR_PROPERTY, avizo_window_properties[AVIZO_WINDOW_MONITOR_PROPERTY] = g_param_spec_int ("monitor", "monitor", "monitor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_WIDTH_PROPERTY, avizo_window_properties[AVIZO_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_HEIGHT_PROPERTY, avizo_window_properties[AVIZO_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_PADDING_PROPERTY, avizo_window_properties[AVIZO_WINDOW_PADDING_PROPERTY] = g_param_spec_int ("padding", "padding", "padding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BORDER_RADIUS_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BORDER_RADIUS_PROPERTY] = g_param_spec_int ("border-radius", "border-radius", "border-radius", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BORDER_WIDTH_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BORDER_WIDTH_PROPERTY] = g_param_spec_int ("border-width", "border-width", "border-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BLOCK_HEIGHT_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BLOCK_HEIGHT_PROPERTY] = g_param_spec_int ("block-height", "block-height", "block-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BLOCK_SPACING_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BLOCK_SPACING_PROPERTY] = g_param_spec_int ("block-spacing", "block-spacing", "block-spacing", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BLOCK_COUNT_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BLOCK_COUNT_PROPERTY] = g_param_spec_int ("block-count", "block-count", "block-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_FADE_IN_PROPERTY, avizo_window_properties[AVIZO_WINDOW_FADE_IN_PROPERTY] = g_param_spec_double ("fade-in", "fade-in", "fade-in", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_FADE_OUT_PROPERTY, avizo_window_properties[AVIZO_WINDOW_FADE_OUT_PROPERTY] = g_param_spec_double ("fade-out", "fade-out", "fade-out", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BACKGROUND_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BACKGROUND_PROPERTY] = g_param_spec_boxed ("background", "background", "background", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BORDER_COLOR_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BORDER_COLOR_PROPERTY] = g_param_spec_boxed ("border-color", "border-color", "border-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BAR_FG_COLOR_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BAR_FG_COLOR_PROPERTY] = g_param_spec_boxed ("bar-fg-color", "bar-fg-color", "bar-fg-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_WINDOW_BAR_BG_COLOR_PROPERTY, avizo_window_properties[AVIZO_WINDOW_BAR_BG_COLOR_PROPERTY] = g_param_spec_boxed ("bar-bg-color", "bar-bg-color", "bar-bg-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/danb/avizo/ui/avizo.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image", FALSE, AvizoWindow_private_offset + G_STRUCT_OFFSET (AvizoWindowPrivate, image));
}

static void
avizo_window_instance_init (AvizoWindow * self,
                            gpointer klass)
{
	self->priv = avizo_window_get_instance_private (self);
	self->priv->_width = 248;
	self->priv->_height = 232;
	memset (&self->priv->_background, 0, sizeof (GdkRGBA));
	memset (&self->priv->_border_color, 0, sizeof (GdkRGBA));
	memset (&self->priv->_bar_fg_color, 0, sizeof (GdkRGBA));
	memset (&self->priv->_bar_bg_color, 0, sizeof (GdkRGBA));
	self->priv->opacity = (gdouble) 0;
	self->priv->is_fade_in = TRUE;
	self->priv->prev_frame_time = (gint64) 0;
	self->priv->prev_callback_id = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
avizo_window_finalize (GObject * obj)
{
	AvizoWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVIZO_WINDOW, AvizoWindow);
	G_OBJECT_CLASS (avizo_window_parent_class)->finalize (obj);
}

static GType
avizo_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AvizoWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avizo_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvizoWindow), 0, (GInstanceInitFunc) avizo_window_instance_init, NULL };
	GType avizo_window_type_id;
	avizo_window_type_id = g_type_register_static (gtk_window_get_type (), "AvizoWindow", &g_define_type_info, 0);
	AvizoWindow_private_offset = g_type_add_instance_private (avizo_window_type_id, sizeof (AvizoWindowPrivate));
	return avizo_window_type_id;
}

GType
avizo_window_get_type (void)
{
	static volatile gsize avizo_window_type_id__once = 0;
	if (g_once_init_enter (&avizo_window_type_id__once)) {
		GType avizo_window_type_id;
		avizo_window_type_id = avizo_window_get_type_once ();
		g_once_init_leave (&avizo_window_type_id__once, avizo_window_type_id);
	}
	return avizo_window_type_id__once;
}

static void
_vala_avizo_window_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	AvizoWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVIZO_WINDOW, AvizoWindow);
	switch (property_id) {
		case AVIZO_WINDOW_IMAGE_OPACITY_PROPERTY:
		g_value_set_double (value, avizo_window_get_image_opacity (self));
		break;
		case AVIZO_WINDOW_PROGRESS_PROPERTY:
		g_value_set_double (value, avizo_window_get_progress (self));
		break;
		case AVIZO_WINDOW_MONITOR_PROPERTY:
		g_value_set_int (value, avizo_window_get_monitor (self));
		break;
		case AVIZO_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, avizo_window_get_width (self));
		break;
		case AVIZO_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, avizo_window_get_height (self));
		break;
		case AVIZO_WINDOW_PADDING_PROPERTY:
		g_value_set_int (value, avizo_window_get_padding (self));
		break;
		case AVIZO_WINDOW_BORDER_RADIUS_PROPERTY:
		g_value_set_int (value, avizo_window_get_border_radius (self));
		break;
		case AVIZO_WINDOW_BORDER_WIDTH_PROPERTY:
		g_value_set_int (value, avizo_window_get_border_width (self));
		break;
		case AVIZO_WINDOW_BLOCK_HEIGHT_PROPERTY:
		g_value_set_int (value, avizo_window_get_block_height (self));
		break;
		case AVIZO_WINDOW_BLOCK_SPACING_PROPERTY:
		g_value_set_int (value, avizo_window_get_block_spacing (self));
		break;
		case AVIZO_WINDOW_BLOCK_COUNT_PROPERTY:
		g_value_set_int (value, avizo_window_get_block_count (self));
		break;
		case AVIZO_WINDOW_FADE_IN_PROPERTY:
		g_value_set_double (value, avizo_window_get_fade_in (self));
		break;
		case AVIZO_WINDOW_FADE_OUT_PROPERTY:
		g_value_set_double (value, avizo_window_get_fade_out (self));
		break;
		case AVIZO_WINDOW_BACKGROUND_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_window_get_background (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_WINDOW_BORDER_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_window_get_border_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_WINDOW_BAR_FG_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_window_get_bar_fg_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_WINDOW_BAR_BG_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_window_get_bar_bg_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_avizo_window_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	AvizoWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVIZO_WINDOW, AvizoWindow);
	switch (property_id) {
		case AVIZO_WINDOW_IMAGE_PATH_PROPERTY:
		avizo_window_set_image_path (self, g_value_get_string (value));
		break;
		case AVIZO_WINDOW_IMAGE_RESOURCE_PROPERTY:
		avizo_window_set_image_resource (self, g_value_get_string (value));
		break;
		case AVIZO_WINDOW_IMAGE_OPACITY_PROPERTY:
		avizo_window_set_image_opacity (self, g_value_get_double (value));
		break;
		case AVIZO_WINDOW_PROGRESS_PROPERTY:
		avizo_window_set_progress (self, g_value_get_double (value));
		break;
		case AVIZO_WINDOW_MONITOR_PROPERTY:
		avizo_window_set_monitor (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_WIDTH_PROPERTY:
		avizo_window_set_width (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_HEIGHT_PROPERTY:
		avizo_window_set_height (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_PADDING_PROPERTY:
		avizo_window_set_padding (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_BORDER_RADIUS_PROPERTY:
		avizo_window_set_border_radius (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_BORDER_WIDTH_PROPERTY:
		avizo_window_set_border_width (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_BLOCK_HEIGHT_PROPERTY:
		avizo_window_set_block_height (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_BLOCK_SPACING_PROPERTY:
		avizo_window_set_block_spacing (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_BLOCK_COUNT_PROPERTY:
		avizo_window_set_block_count (self, g_value_get_int (value));
		break;
		case AVIZO_WINDOW_FADE_IN_PROPERTY:
		avizo_window_set_fade_in (self, g_value_get_double (value));
		break;
		case AVIZO_WINDOW_FADE_OUT_PROPERTY:
		avizo_window_set_fade_out (self, g_value_get_double (value));
		break;
		case AVIZO_WINDOW_BACKGROUND_PROPERTY:
		avizo_window_set_background (self, g_value_get_boxed (value));
		break;
		case AVIZO_WINDOW_BORDER_COLOR_PROPERTY:
		avizo_window_set_border_color (self, g_value_get_boxed (value));
		break;
		case AVIZO_WINDOW_BAR_FG_COLOR_PROPERTY:
		avizo_window_set_bar_fg_color (self, g_value_get_boxed (value));
		break;
		case AVIZO_WINDOW_BAR_BG_COLOR_PROPERTY:
		avizo_window_set_bar_bg_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
avizo_service_get_instance_private (AvizoService* self)
{
	return G_STRUCT_MEMBER_P (self, AvizoService_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_AvizoWindow_free_function_content_of (gpointer data)
{
	AvizoWindow* self;
	self = *((AvizoWindow**) data);
	_g_object_unref0_ (self);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AvizoService* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda4_ (Block1Data* _data1_)
{
	AvizoService* self;
	gint _tmp0_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = self->priv->_open_timeouts;
	self->priv->_open_timeouts = _tmp0_ - 1;
	if (self->priv->_open_timeouts == 0) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					AvizoWindow* window = NULL;
					GArray* _tmp3_;
					AvizoWindow* _tmp4_;
					AvizoWindow* _tmp5_;
					AvizoWindow* _tmp6_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < _data1_->monitors)) {
						break;
					}
					_tmp3_ = self->priv->_windows;
					_tmp4_ = g_array_index (_tmp3_, AvizoWindow*, (guint) i);
					_tmp5_ = _g_object_ref0 (_tmp4_);
					window = _tmp5_;
					_tmp6_ = window;
					if (_tmp6_ != NULL) {
						AvizoWindow* _tmp7_;
						_tmp7_ = window;
						avizo_window_hide_animated (_tmp7_);
					}
					_g_object_unref0 (window);
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

void
avizo_service_show (AvizoService* self,
                    gdouble seconds,
                    GError** error)
{
	Block1Data* _data1_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GArray* _tmp3_;
	gint _tmp5_;
	gint _tmp29_;
	gdouble _tmp30_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_data1_->monitors = gdk_display_get_n_monitors (_tmp2_);
	_tmp3_ = self->priv->_windows;
	if (_tmp3_->len < ((guint) _data1_->monitors)) {
		GArray* _tmp4_;
		_tmp4_ = self->priv->_windows;
		g_array_set_size (_tmp4_, (guint) _data1_->monitors);
	}
	_tmp5_ = self->priv->_monitor;
	if (_tmp5_ >= _data1_->monitors) {
		FILE* _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = stderr;
		_tmp7_ = self->priv->_monitor;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Monitor: ", _tmp9_, " does not exist\n", NULL);
		_tmp11_ = _tmp10_;
		fprintf (_tmp6_, "%s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_object_unref0 (display);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < _data1_->monitors)) {
					break;
				}
				_tmp15_ = self->priv->_monitor;
				if (_tmp15_ == -1) {
					_tmp14_ = TRUE;
				} else {
					gint _tmp16_;
					_tmp16_ = self->priv->_monitor;
					_tmp14_ = _tmp16_ == i;
				}
				if (_tmp14_) {
					AvizoWindow* window = NULL;
					GArray* _tmp17_;
					AvizoWindow* _tmp18_;
					AvizoWindow* _tmp19_;
					AvizoWindow* _tmp20_;
					AvizoWindow* _tmp26_;
					GdkDisplay* _tmp27_;
					GdkMonitor* _tmp28_;
					_tmp17_ = self->priv->_windows;
					_tmp18_ = g_array_index (_tmp17_, AvizoWindow*, (guint) i);
					_tmp19_ = _g_object_ref0 (_tmp18_);
					window = _tmp19_;
					_tmp20_ = window;
					if (_tmp20_ == NULL) {
						GdkDisplay* _tmp21_;
						AvizoWindow* _tmp22_;
						GArray* _tmp23_;
						AvizoWindow* _tmp24_;
						AvizoWindow* _tmp25_;
						_tmp21_ = display;
						_tmp22_ = avizo_service_create_window (self, _tmp21_);
						_g_object_unref0 (window);
						window = _tmp22_;
						_tmp23_ = self->priv->_windows;
						_tmp24_ = window;
						_tmp25_ = _g_object_ref0 (_tmp24_);
						g_array_insert_val (_tmp23_, (guint) i, _tmp25_);
					}
					_tmp26_ = window;
					_tmp27_ = display;
					_tmp28_ = gdk_display_get_monitor (_tmp27_, i);
					avizo_service_show_window (self, _tmp26_, _tmp28_);
					_g_object_unref0 (window);
				}
			}
		}
	}
	_tmp29_ = self->priv->_open_timeouts;
	self->priv->_open_timeouts = _tmp29_ + 1;
	_tmp30_ = seconds;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (_tmp30_ * 1000)), ___lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_g_object_unref0 (display);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static AvizoWindow*
avizo_service_create_window (AvizoService* self,
                             GdkDisplay* display)
{
	AvizoWindow* window = NULL;
	AvizoWindow* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	AvizoWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	_tmp0_ = avizo_window_new ();
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	_tmp1_ = avizo_service_props;
	_tmp1__length1 = avizo_service_props_length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp1_;
		prop_name_collection_length1 = _tmp1__length1;
		for (prop_name_it = 0; prop_name_it < prop_name_collection_length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp2_;
			gchar* prop_name = NULL;
			_tmp2_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp2_;
			{
				const gchar* _tmp3_;
				AvizoWindow* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = prop_name;
				_tmp4_ = window;
				_tmp5_ = prop_name;
				g_object_bind_property_with_closures ((GObject*) self, _tmp3_, (GObject*) _tmp4_, _tmp5_, G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				_g_free0 (prop_name);
			}
		}
	}
	if (is_wayland (display)) {
		AvizoWindow* _tmp6_;
		AvizoWindow* _tmp7_;
		AvizoWindow* _tmp8_;
		AvizoWindow* _tmp9_;
		AvizoWindow* _tmp10_;
		AvizoWindow* _tmp11_;
		_tmp6_ = window;
		gtk_layer_init_for_window ((GtkWindow*) _tmp6_);
		_tmp7_ = window;
		gtk_layer_set_layer ((GtkWindow*) _tmp7_, GTK_LAYER_SHELL_LAYER_OVERLAY);
		_tmp8_ = window;
		gtk_layer_set_anchor ((GtkWindow*) _tmp8_, GTK_LAYER_SHELL_EDGE_TOP, TRUE);
		_tmp9_ = window;
		gtk_layer_set_namespace ((GtkWindow*) _tmp9_, "avizo");
		_tmp10_ = window;
		gtk_layer_set_exclusive_zone ((GtkWindow*) _tmp10_, -1);
		_tmp11_ = window;
		gtk_layer_set_keyboard_mode ((GtkWindow*) _tmp11_, GTK_LAYER_SHELL_KEYBOARD_MODE_NONE);
	}
	result = window;
	return result;
}

static void
avizo_service_show_window (AvizoService* self,
                           AvizoWindow* window,
                           GdkMonitor* monitor)
{
	gint margin = 0;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	GdkDisplay* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (monitor != NULL);
	gdk_monitor_get_workarea (monitor, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_height;
	_tmp3_ = self->priv->_y_offset;
	margin = (gint) lround ((_tmp1_.height - _tmp2_) * _tmp3_);
	_tmp4_ = gdk_monitor_get_display (monitor);
	if (is_wayland (_tmp4_)) {
		gtk_layer_set_monitor ((GtkWindow*) window, monitor);
		gtk_layer_set_margin ((GtkWindow*) window, GTK_LAYER_SHELL_EDGE_TOP, margin);
	} else {
		gint x = 0;
		gint _y = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gtk_window_set_position ((GtkWindow*) window, GTK_WIN_POS_CENTER);
		gtk_window_get_position ((GtkWindow*) window, &_tmp5_, &_tmp6_);
		x = _tmp5_;
		_y = _tmp6_;
		gtk_window_move ((GtkWindow*) window, x, margin);
		gtk_window_set_type_hint ((GtkWindow*) window, GDK_WINDOW_TYPE_HINT_NOTIFICATION);
		gtk_window_set_accept_focus ((GtkWindow*) window, FALSE);
	}
	avizo_window_show_animated (window);
	gtk_widget_queue_draw ((GtkWidget*) window);
}

AvizoService*
avizo_service_construct (GType object_type)
{
	AvizoService * self = NULL;
	self = (AvizoService*) g_object_new (object_type, NULL);
	return self;
}

AvizoService*
avizo_service_new (void)
{
	return avizo_service_construct (TYPE_AVIZO_SERVICE);
}

const gchar*
avizo_service_get_image_path (AvizoService* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_path;
	result = _tmp0_;
	return result;
}

void
avizo_service_set_image_path (AvizoService* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_image_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_image_path);
		self->priv->_image_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_IMAGE_PATH_PROPERTY]);
	}
}

const gchar*
avizo_service_get_image_resource (AvizoService* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_resource;
	result = _tmp0_;
	return result;
}

void
avizo_service_set_image_resource (AvizoService* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_image_resource (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_image_resource);
		self->priv->_image_resource = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_IMAGE_RESOURCE_PROPERTY]);
	}
}

gdouble
avizo_service_get_image_opacity (AvizoService* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_image_opacity;
	return result;
}

void
avizo_service_set_image_opacity (AvizoService* self,
                                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_image_opacity (self);
	if (old_value != value) {
		self->priv->_image_opacity = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_IMAGE_OPACITY_PROPERTY]);
	}
}

gdouble
avizo_service_get_progress (AvizoService* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

void
avizo_service_set_progress (AvizoService* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_PROGRESS_PROPERTY]);
	}
}

gint
avizo_service_get_width (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

void
avizo_service_set_width (AvizoService* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_WIDTH_PROPERTY]);
	}
}

gint
avizo_service_get_height (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
	return result;
}

void
avizo_service_set_height (AvizoService* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_height (self);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_HEIGHT_PROPERTY]);
	}
}

gint
avizo_service_get_padding (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding;
	return result;
}

void
avizo_service_set_padding (AvizoService* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_padding (self);
	if (old_value != value) {
		self->priv->_padding = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_PADDING_PROPERTY]);
	}
}

gdouble
avizo_service_get_y_offset (AvizoService* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_y_offset;
	return result;
}

void
avizo_service_set_y_offset (AvizoService* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_y_offset (self);
	if (old_value != value) {
		self->priv->_y_offset = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_Y_OFFSET_PROPERTY]);
	}
}

gint
avizo_service_get_border_radius (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_radius;
	return result;
}

void
avizo_service_set_border_radius (AvizoService* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_border_radius (self);
	if (old_value != value) {
		self->priv->_border_radius = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BORDER_RADIUS_PROPERTY]);
	}
}

gint
avizo_service_get_border_width (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_width;
	return result;
}

void
avizo_service_set_border_width (AvizoService* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_border_width (self);
	if (old_value != value) {
		self->priv->_border_width = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BORDER_WIDTH_PROPERTY]);
	}
}

gint
avizo_service_get_block_height (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_height;
	return result;
}

void
avizo_service_set_block_height (AvizoService* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_block_height (self);
	if (old_value != value) {
		self->priv->_block_height = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BLOCK_HEIGHT_PROPERTY]);
	}
}

gint
avizo_service_get_block_spacing (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_spacing;
	return result;
}

void
avizo_service_set_block_spacing (AvizoService* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_block_spacing (self);
	if (old_value != value) {
		self->priv->_block_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BLOCK_SPACING_PROPERTY]);
	}
}

gint
avizo_service_get_block_count (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_count;
	return result;
}

void
avizo_service_set_block_count (AvizoService* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_block_count (self);
	if (old_value != value) {
		self->priv->_block_count = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BLOCK_COUNT_PROPERTY]);
	}
}

gdouble
avizo_service_get_fade_in (AvizoService* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_in;
	return result;
}

void
avizo_service_set_fade_in (AvizoService* self,
                           gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_fade_in (self);
	if (old_value != value) {
		self->priv->_fade_in = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_FADE_IN_PROPERTY]);
	}
}

gdouble
avizo_service_get_fade_out (AvizoService* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fade_out;
	return result;
}

void
avizo_service_set_fade_out (AvizoService* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_fade_out (self);
	if (old_value != value) {
		self->priv->_fade_out = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_FADE_OUT_PROPERTY]);
	}
}

void
avizo_service_get_background (AvizoService* self,
                              GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background;
	*result = _tmp0_;
	return;
}

void
avizo_service_set_background (AvizoService* self,
                              GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_service_get_background (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_background = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BACKGROUND_PROPERTY]);
	}
}

void
avizo_service_get_border_color (AvizoService* self,
                                GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_border_color;
	*result = _tmp0_;
	return;
}

void
avizo_service_set_border_color (AvizoService* self,
                                GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_service_get_border_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_border_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BORDER_COLOR_PROPERTY]);
	}
}

void
avizo_service_get_bar_fg_color (AvizoService* self,
                                GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_bar_fg_color;
	*result = _tmp0_;
	return;
}

void
avizo_service_set_bar_fg_color (AvizoService* self,
                                GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_service_get_bar_fg_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_bar_fg_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BAR_FG_COLOR_PROPERTY]);
	}
}

void
avizo_service_get_bar_bg_color (AvizoService* self,
                                GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_bar_bg_color;
	*result = _tmp0_;
	return;
}

void
avizo_service_set_bar_bg_color (AvizoService* self,
                                GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	avizo_service_get_bar_bg_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_bar_bg_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_BAR_BG_COLOR_PROPERTY]);
	}
}

gint
avizo_service_get_monitor (AvizoService* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor;
	return result;
}

void
avizo_service_set_monitor (AvizoService* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = avizo_service_get_monitor (self);
	if (old_value != value) {
		self->priv->_monitor = value;
		g_object_notify_by_pspec ((GObject *) self, avizo_service_properties[AVIZO_SERVICE_MONITOR_PROPERTY]);
	}
}

static void
avizo_service_class_init (AvizoServiceClass * klass,
                          gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	avizo_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AvizoService_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_avizo_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avizo_service_set_property;
	G_OBJECT_CLASS (klass)->finalize = avizo_service_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_IMAGE_PATH_PROPERTY, avizo_service_properties[AVIZO_SERVICE_IMAGE_PATH_PROPERTY] = g_param_spec_string ("image-path", "image-path", "image-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_IMAGE_RESOURCE_PROPERTY, avizo_service_properties[AVIZO_SERVICE_IMAGE_RESOURCE_PROPERTY] = g_param_spec_string ("image-resource", "image-resource", "image-resource", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_IMAGE_OPACITY_PROPERTY, avizo_service_properties[AVIZO_SERVICE_IMAGE_OPACITY_PROPERTY] = g_param_spec_double ("image-opacity", "image-opacity", "image-opacity", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_PROGRESS_PROPERTY, avizo_service_properties[AVIZO_SERVICE_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_WIDTH_PROPERTY, avizo_service_properties[AVIZO_SERVICE_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 248, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_HEIGHT_PROPERTY, avizo_service_properties[AVIZO_SERVICE_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 232, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_PADDING_PROPERTY, avizo_service_properties[AVIZO_SERVICE_PADDING_PROPERTY] = g_param_spec_int ("padding", "padding", "padding", G_MININT, G_MAXINT, 24, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_Y_OFFSET_PROPERTY, avizo_service_properties[AVIZO_SERVICE_Y_OFFSET_PROPERTY] = g_param_spec_double ("y-offset", "y-offset", "y-offset", -G_MAXDOUBLE, G_MAXDOUBLE, 0.75, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BORDER_RADIUS_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BORDER_RADIUS_PROPERTY] = g_param_spec_int ("border-radius", "border-radius", "border-radius", G_MININT, G_MAXINT, 16, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BORDER_WIDTH_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BORDER_WIDTH_PROPERTY] = g_param_spec_int ("border-width", "border-width", "border-width", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BLOCK_HEIGHT_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BLOCK_HEIGHT_PROPERTY] = g_param_spec_int ("block-height", "block-height", "block-height", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BLOCK_SPACING_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BLOCK_SPACING_PROPERTY] = g_param_spec_int ("block-spacing", "block-spacing", "block-spacing", G_MININT, G_MAXINT, 2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BLOCK_COUNT_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BLOCK_COUNT_PROPERTY] = g_param_spec_int ("block-count", "block-count", "block-count", G_MININT, G_MAXINT, 20, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_FADE_IN_PROPERTY, avizo_service_properties[AVIZO_SERVICE_FADE_IN_PROPERTY] = g_param_spec_double ("fade-in", "fade-in", "fade-in", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_FADE_OUT_PROPERTY, avizo_service_properties[AVIZO_SERVICE_FADE_OUT_PROPERTY] = g_param_spec_double ("fade-out", "fade-out", "fade-out", -G_MAXDOUBLE, G_MAXDOUBLE, 0.5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BACKGROUND_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BACKGROUND_PROPERTY] = g_param_spec_boxed ("background", "background", "background", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BORDER_COLOR_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BORDER_COLOR_PROPERTY] = g_param_spec_boxed ("border-color", "border-color", "border-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BAR_FG_COLOR_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BAR_FG_COLOR_PROPERTY] = g_param_spec_boxed ("bar-fg-color", "bar-fg-color", "bar-fg-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_BAR_BG_COLOR_PROPERTY, avizo_service_properties[AVIZO_SERVICE_BAR_BG_COLOR_PROPERTY] = g_param_spec_boxed ("bar-bg-color", "bar-bg-color", "bar-bg-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVIZO_SERVICE_MONITOR_PROPERTY, avizo_service_properties[AVIZO_SERVICE_MONITOR_PROPERTY] = g_param_spec_int ("monitor", "monitor", "monitor", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_strdup ("image_path");
	_tmp1_ = g_strdup ("image_resource");
	_tmp2_ = g_strdup ("image_opacity");
	_tmp3_ = g_strdup ("progress");
	_tmp4_ = g_strdup ("width");
	_tmp5_ = g_strdup ("height");
	_tmp6_ = g_strdup ("padding");
	_tmp7_ = g_strdup ("monitor");
	_tmp8_ = g_strdup ("border_radius");
	_tmp9_ = g_strdup ("border_width");
	_tmp10_ = g_strdup ("block_height");
	_tmp11_ = g_strdup ("block_spacing");
	_tmp12_ = g_strdup ("block_count");
	_tmp13_ = g_strdup ("fade_in");
	_tmp14_ = g_strdup ("fade_out");
	_tmp15_ = g_strdup ("background");
	_tmp16_ = g_strdup ("border_color");
	_tmp17_ = g_strdup ("bar_fg_color");
	_tmp18_ = g_strdup ("bar_bg_color");
	_tmp19_ = g_new0 (gchar*, 19 + 1);
	_tmp19_[0] = _tmp0_;
	_tmp19_[1] = _tmp1_;
	_tmp19_[2] = _tmp2_;
	_tmp19_[3] = _tmp3_;
	_tmp19_[4] = _tmp4_;
	_tmp19_[5] = _tmp5_;
	_tmp19_[6] = _tmp6_;
	_tmp19_[7] = _tmp7_;
	_tmp19_[8] = _tmp8_;
	_tmp19_[9] = _tmp9_;
	_tmp19_[10] = _tmp10_;
	_tmp19_[11] = _tmp11_;
	_tmp19_[12] = _tmp12_;
	_tmp19_[13] = _tmp13_;
	_tmp19_[14] = _tmp14_;
	_tmp19_[15] = _tmp15_;
	_tmp19_[16] = _tmp16_;
	_tmp19_[17] = _tmp17_;
	_tmp19_[18] = _tmp18_;
	avizo_service_props = _tmp19_;
	avizo_service_props_length1 = 19;
	_avizo_service_props_size_ = avizo_service_props_length1;
}

static void
avizo_service_instance_init (AvizoService * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	GArray* _tmp6_;
	self->priv = avizo_service_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_image_path = _tmp0_;
	_tmp1_ = g_strdup ("volume_muted");
	self->priv->_image_resource = _tmp1_;
	self->priv->_image_opacity = 1.0;
	self->priv->_progress = 0.0;
	self->priv->_width = 248;
	self->priv->_height = 232;
	self->priv->_padding = 24;
	self->priv->_y_offset = 0.75;
	self->priv->_border_radius = 16;
	self->priv->_border_width = 1;
	self->priv->_block_height = 10;
	self->priv->_block_spacing = 2;
	self->priv->_block_count = 20;
	self->priv->_fade_in = 0.2;
	self->priv->_fade_out = 0.5;
	rgba (160, 160, 160, 0.8, &_tmp2_);
	self->priv->_background = _tmp2_;
	rgba (90, 90, 90, 0.8, &_tmp3_);
	self->priv->_border_color = _tmp3_;
	rgba (0, 0, 0, 0.8, &_tmp4_);
	self->priv->_bar_fg_color = _tmp4_;
	rgba (106, 106, 106, 0.8, &_tmp5_);
	self->priv->_bar_bg_color = _tmp5_;
	self->priv->_monitor = -1;
	_tmp6_ = g_array_new (TRUE, TRUE, sizeof (AvizoWindow*));
	g_array_set_clear_func (_tmp6_, (GDestroyNotify) _vala_AvizoWindow_free_function_content_of);
	self->priv->_windows = _tmp6_;
	self->priv->_open_timeouts = 0;
}

static void
avizo_service_finalize (GObject * obj)
{
	AvizoService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVIZO_SERVICE, AvizoService);
	_g_free0 (self->priv->_image_path);
	_g_free0 (self->priv->_image_resource);
	_g_array_unref0 (self->priv->_windows);
	G_OBJECT_CLASS (avizo_service_parent_class)->finalize (obj);
}

static GType
avizo_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AvizoServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avizo_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvizoService), 0, (GInstanceInitFunc) avizo_service_instance_init, NULL };
	GType avizo_service_type_id;
	avizo_service_type_id = g_type_register_static (G_TYPE_OBJECT, "AvizoService", &g_define_type_info, 0);
	g_type_set_qdata (avizo_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) avizo_service_register_object);
	AvizoService_private_offset = g_type_add_instance_private (avizo_service_type_id, sizeof (AvizoServicePrivate));
	return avizo_service_type_id;
}

GType
avizo_service_get_type (void)
{
	static volatile gsize avizo_service_type_id__once = 0;
	if (g_once_init_enter (&avizo_service_type_id__once)) {
		GType avizo_service_type_id;
		avizo_service_type_id = avizo_service_get_type_once ();
		g_once_init_leave (&avizo_service_type_id__once, avizo_service_type_id);
	}
	return avizo_service_type_id__once;
}

static void
_vala_avizo_service_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	AvizoService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVIZO_SERVICE, AvizoService);
	switch (property_id) {
		case AVIZO_SERVICE_IMAGE_PATH_PROPERTY:
		g_value_set_string (value, avizo_service_get_image_path (self));
		break;
		case AVIZO_SERVICE_IMAGE_RESOURCE_PROPERTY:
		g_value_set_string (value, avizo_service_get_image_resource (self));
		break;
		case AVIZO_SERVICE_IMAGE_OPACITY_PROPERTY:
		g_value_set_double (value, avizo_service_get_image_opacity (self));
		break;
		case AVIZO_SERVICE_PROGRESS_PROPERTY:
		g_value_set_double (value, avizo_service_get_progress (self));
		break;
		case AVIZO_SERVICE_WIDTH_PROPERTY:
		g_value_set_int (value, avizo_service_get_width (self));
		break;
		case AVIZO_SERVICE_HEIGHT_PROPERTY:
		g_value_set_int (value, avizo_service_get_height (self));
		break;
		case AVIZO_SERVICE_PADDING_PROPERTY:
		g_value_set_int (value, avizo_service_get_padding (self));
		break;
		case AVIZO_SERVICE_Y_OFFSET_PROPERTY:
		g_value_set_double (value, avizo_service_get_y_offset (self));
		break;
		case AVIZO_SERVICE_BORDER_RADIUS_PROPERTY:
		g_value_set_int (value, avizo_service_get_border_radius (self));
		break;
		case AVIZO_SERVICE_BORDER_WIDTH_PROPERTY:
		g_value_set_int (value, avizo_service_get_border_width (self));
		break;
		case AVIZO_SERVICE_BLOCK_HEIGHT_PROPERTY:
		g_value_set_int (value, avizo_service_get_block_height (self));
		break;
		case AVIZO_SERVICE_BLOCK_SPACING_PROPERTY:
		g_value_set_int (value, avizo_service_get_block_spacing (self));
		break;
		case AVIZO_SERVICE_BLOCK_COUNT_PROPERTY:
		g_value_set_int (value, avizo_service_get_block_count (self));
		break;
		case AVIZO_SERVICE_FADE_IN_PROPERTY:
		g_value_set_double (value, avizo_service_get_fade_in (self));
		break;
		case AVIZO_SERVICE_FADE_OUT_PROPERTY:
		g_value_set_double (value, avizo_service_get_fade_out (self));
		break;
		case AVIZO_SERVICE_BACKGROUND_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_service_get_background (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_SERVICE_BORDER_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_service_get_border_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_SERVICE_BAR_FG_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_service_get_bar_fg_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_SERVICE_BAR_BG_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			avizo_service_get_bar_bg_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case AVIZO_SERVICE_MONITOR_PROPERTY:
		g_value_set_int (value, avizo_service_get_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_avizo_service_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	AvizoService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVIZO_SERVICE, AvizoService);
	switch (property_id) {
		case AVIZO_SERVICE_IMAGE_PATH_PROPERTY:
		avizo_service_set_image_path (self, g_value_get_string (value));
		break;
		case AVIZO_SERVICE_IMAGE_RESOURCE_PROPERTY:
		avizo_service_set_image_resource (self, g_value_get_string (value));
		break;
		case AVIZO_SERVICE_IMAGE_OPACITY_PROPERTY:
		avizo_service_set_image_opacity (self, g_value_get_double (value));
		break;
		case AVIZO_SERVICE_PROGRESS_PROPERTY:
		avizo_service_set_progress (self, g_value_get_double (value));
		break;
		case AVIZO_SERVICE_WIDTH_PROPERTY:
		avizo_service_set_width (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_HEIGHT_PROPERTY:
		avizo_service_set_height (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_PADDING_PROPERTY:
		avizo_service_set_padding (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_Y_OFFSET_PROPERTY:
		avizo_service_set_y_offset (self, g_value_get_double (value));
		break;
		case AVIZO_SERVICE_BORDER_RADIUS_PROPERTY:
		avizo_service_set_border_radius (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_BORDER_WIDTH_PROPERTY:
		avizo_service_set_border_width (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_BLOCK_HEIGHT_PROPERTY:
		avizo_service_set_block_height (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_BLOCK_SPACING_PROPERTY:
		avizo_service_set_block_spacing (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_BLOCK_COUNT_PROPERTY:
		avizo_service_set_block_count (self, g_value_get_int (value));
		break;
		case AVIZO_SERVICE_FADE_IN_PROPERTY:
		avizo_service_set_fade_in (self, g_value_get_double (value));
		break;
		case AVIZO_SERVICE_FADE_OUT_PROPERTY:
		avizo_service_set_fade_out (self, g_value_get_double (value));
		break;
		case AVIZO_SERVICE_BACKGROUND_PROPERTY:
		avizo_service_set_background (self, g_value_get_boxed (value));
		break;
		case AVIZO_SERVICE_BORDER_COLOR_PROPERTY:
		avizo_service_set_border_color (self, g_value_get_boxed (value));
		break;
		case AVIZO_SERVICE_BAR_FG_COLOR_PROPERTY:
		avizo_service_set_bar_fg_color (self, g_value_get_boxed (value));
		break;
		case AVIZO_SERVICE_BAR_BG_COLOR_PROPERTY:
		avizo_service_set_bar_bg_color (self, g_value_get_boxed (value));
		break;
		case AVIZO_SERVICE_MONITOR_PROPERTY:
		avizo_service_set_monitor (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_avizo_service_show (AvizoService* self,
                          GVariant* _parameters_,
                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gdouble seconds = 0.0;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	seconds = g_variant_get_double (_tmp0_);
	g_variant_unref (_tmp0_);
	avizo_service_show (self, seconds, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
avizo_service_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_avizo_service_show (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_avizo_service_get_image_path (AvizoService* self)
{
	const gchar* result;
	GVariant* _reply;
	result = avizo_service_get_image_path (self);
	_reply = g_variant_new_string (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_image_resource (AvizoService* self)
{
	const gchar* result;
	GVariant* _reply;
	result = avizo_service_get_image_resource (self);
	_reply = g_variant_new_string (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_image_opacity (AvizoService* self)
{
	gdouble result;
	GVariant* _reply;
	result = avizo_service_get_image_opacity (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_progress (AvizoService* self)
{
	gdouble result;
	GVariant* _reply;
	result = avizo_service_get_progress (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_width (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_width (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_height (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_height (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_padding (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_padding (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_y_offset (AvizoService* self)
{
	gdouble result;
	GVariant* _reply;
	result = avizo_service_get_y_offset (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_border_radius (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_border_radius (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_border_width (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_border_width (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_block_height (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_block_height (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_block_spacing (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_block_spacing (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_block_count (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_block_count (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_fade_in (AvizoService* self)
{
	gdouble result;
	GVariant* _reply;
	result = avizo_service_get_fade_in (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_fade_out (AvizoService* self)
{
	gdouble result;
	GVariant* _reply;
	result = avizo_service_get_fade_out (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_background (AvizoService* self)
{
	GdkRGBA result = {0};
	GVariant* _reply;
	GVariantBuilder _tmp1_;
	avizo_service_get_background (self, &result);
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp1_, g_variant_new_double (result.red));
	g_variant_builder_add_value (&_tmp1_, g_variant_new_double (result.green));
	g_variant_builder_add_value (&_tmp1_, g_variant_new_double (result.blue));
	g_variant_builder_add_value (&_tmp1_, g_variant_new_double (result.alpha));
	_reply = g_variant_builder_end (&_tmp1_);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_border_color (AvizoService* self)
{
	GdkRGBA result = {0};
	GVariant* _reply;
	GVariantBuilder _tmp2_;
	avizo_service_get_border_color (self, &result);
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp2_, g_variant_new_double (result.red));
	g_variant_builder_add_value (&_tmp2_, g_variant_new_double (result.green));
	g_variant_builder_add_value (&_tmp2_, g_variant_new_double (result.blue));
	g_variant_builder_add_value (&_tmp2_, g_variant_new_double (result.alpha));
	_reply = g_variant_builder_end (&_tmp2_);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_bar_fg_color (AvizoService* self)
{
	GdkRGBA result = {0};
	GVariant* _reply;
	GVariantBuilder _tmp3_;
	avizo_service_get_bar_fg_color (self, &result);
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp3_, g_variant_new_double (result.red));
	g_variant_builder_add_value (&_tmp3_, g_variant_new_double (result.green));
	g_variant_builder_add_value (&_tmp3_, g_variant_new_double (result.blue));
	g_variant_builder_add_value (&_tmp3_, g_variant_new_double (result.alpha));
	_reply = g_variant_builder_end (&_tmp3_);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_bar_bg_color (AvizoService* self)
{
	GdkRGBA result = {0};
	GVariant* _reply;
	GVariantBuilder _tmp4_;
	avizo_service_get_bar_bg_color (self, &result);
	g_variant_builder_init (&_tmp4_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp4_, g_variant_new_double (result.red));
	g_variant_builder_add_value (&_tmp4_, g_variant_new_double (result.green));
	g_variant_builder_add_value (&_tmp4_, g_variant_new_double (result.blue));
	g_variant_builder_add_value (&_tmp4_, g_variant_new_double (result.alpha));
	_reply = g_variant_builder_end (&_tmp4_);
	return _reply;
}

static GVariant*
_dbus_avizo_service_get_monitor (AvizoService* self)
{
	gint result;
	GVariant* _reply;
	result = avizo_service_get_monitor (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
avizo_service_dbus_interface_get_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "ImagePath") == 0) {
		return _dbus_avizo_service_get_image_path (object);
	} else if (strcmp (property_name, "ImageResource") == 0) {
		return _dbus_avizo_service_get_image_resource (object);
	} else if (strcmp (property_name, "ImageOpacity") == 0) {
		return _dbus_avizo_service_get_image_opacity (object);
	} else if (strcmp (property_name, "Progress") == 0) {
		return _dbus_avizo_service_get_progress (object);
	} else if (strcmp (property_name, "Width") == 0) {
		return _dbus_avizo_service_get_width (object);
	} else if (strcmp (property_name, "Height") == 0) {
		return _dbus_avizo_service_get_height (object);
	} else if (strcmp (property_name, "Padding") == 0) {
		return _dbus_avizo_service_get_padding (object);
	} else if (strcmp (property_name, "YOffset") == 0) {
		return _dbus_avizo_service_get_y_offset (object);
	} else if (strcmp (property_name, "BorderRadius") == 0) {
		return _dbus_avizo_service_get_border_radius (object);
	} else if (strcmp (property_name, "BorderWidth") == 0) {
		return _dbus_avizo_service_get_border_width (object);
	} else if (strcmp (property_name, "BlockHeight") == 0) {
		return _dbus_avizo_service_get_block_height (object);
	} else if (strcmp (property_name, "BlockSpacing") == 0) {
		return _dbus_avizo_service_get_block_spacing (object);
	} else if (strcmp (property_name, "BlockCount") == 0) {
		return _dbus_avizo_service_get_block_count (object);
	} else if (strcmp (property_name, "FadeIn") == 0) {
		return _dbus_avizo_service_get_fade_in (object);
	} else if (strcmp (property_name, "FadeOut") == 0) {
		return _dbus_avizo_service_get_fade_out (object);
	} else if (strcmp (property_name, "Background") == 0) {
		return _dbus_avizo_service_get_background (object);
	} else if (strcmp (property_name, "BorderColor") == 0) {
		return _dbus_avizo_service_get_border_color (object);
	} else if (strcmp (property_name, "BarFgColor") == 0) {
		return _dbus_avizo_service_get_bar_fg_color (object);
	} else if (strcmp (property_name, "BarBgColor") == 0) {
		return _dbus_avizo_service_get_bar_bg_color (object);
	} else if (strcmp (property_name, "Monitor") == 0) {
		return _dbus_avizo_service_get_monitor (object);
	}
	return NULL;
}

static void
_dbus_avizo_service_set_image_path (AvizoService* self,
                                    GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	avizo_service_set_image_path (self, value);
	_g_free0 (value);
}

static void
_dbus_avizo_service_set_image_resource (AvizoService* self,
                                        GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	avizo_service_set_image_resource (self, value);
	_g_free0 (value);
}

static void
_dbus_avizo_service_set_image_opacity (AvizoService* self,
                                       GVariant* _value)
{
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	avizo_service_set_image_opacity (self, value);
}

static void
_dbus_avizo_service_set_progress (AvizoService* self,
                                  GVariant* _value)
{
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	avizo_service_set_progress (self, value);
}

static void
_dbus_avizo_service_set_width (AvizoService* self,
                               GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_width (self, value);
}

static void
_dbus_avizo_service_set_height (AvizoService* self,
                                GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_height (self, value);
}

static void
_dbus_avizo_service_set_padding (AvizoService* self,
                                 GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_padding (self, value);
}

static void
_dbus_avizo_service_set_y_offset (AvizoService* self,
                                  GVariant* _value)
{
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	avizo_service_set_y_offset (self, value);
}

static void
_dbus_avizo_service_set_border_radius (AvizoService* self,
                                       GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_border_radius (self, value);
}

static void
_dbus_avizo_service_set_border_width (AvizoService* self,
                                      GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_border_width (self, value);
}

static void
_dbus_avizo_service_set_block_height (AvizoService* self,
                                      GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_block_height (self, value);
}

static void
_dbus_avizo_service_set_block_spacing (AvizoService* self,
                                       GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_block_spacing (self, value);
}

static void
_dbus_avizo_service_set_block_count (AvizoService* self,
                                     GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_block_count (self, value);
}

static void
_dbus_avizo_service_set_fade_in (AvizoService* self,
                                 GVariant* _value)
{
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	avizo_service_set_fade_in (self, value);
}

static void
_dbus_avizo_service_set_fade_out (AvizoService* self,
                                  GVariant* _value)
{
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	avizo_service_set_fade_out (self, value);
}

static void
_dbus_avizo_service_set_background (AvizoService* self,
                                    GVariant* _value)
{
	GdkRGBA value = {0};
	GdkRGBA _tmp5_;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	g_variant_iter_init (&_tmp6_, _value);
	_tmp7_ = g_variant_iter_next_value (&_tmp6_);
	_tmp5_.red = g_variant_get_double (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_tmp6_);
	_tmp5_.green = g_variant_get_double (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_tmp6_);
	_tmp5_.blue = g_variant_get_double (_tmp9_);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_tmp6_);
	_tmp5_.alpha = g_variant_get_double (_tmp10_);
	g_variant_unref (_tmp10_);
	value = _tmp5_;
	avizo_service_set_background (self, &value);
}

static void
_dbus_avizo_service_set_border_color (AvizoService* self,
                                      GVariant* _value)
{
	GdkRGBA value = {0};
	GdkRGBA _tmp11_;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	g_variant_iter_init (&_tmp12_, _value);
	_tmp13_ = g_variant_iter_next_value (&_tmp12_);
	_tmp11_.red = g_variant_get_double (_tmp13_);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_tmp12_);
	_tmp11_.green = g_variant_get_double (_tmp14_);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_tmp12_);
	_tmp11_.blue = g_variant_get_double (_tmp15_);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_tmp12_);
	_tmp11_.alpha = g_variant_get_double (_tmp16_);
	g_variant_unref (_tmp16_);
	value = _tmp11_;
	avizo_service_set_border_color (self, &value);
}

static void
_dbus_avizo_service_set_bar_fg_color (AvizoService* self,
                                      GVariant* _value)
{
	GdkRGBA value = {0};
	GdkRGBA _tmp17_;
	GVariantIter _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	g_variant_iter_init (&_tmp18_, _value);
	_tmp19_ = g_variant_iter_next_value (&_tmp18_);
	_tmp17_.red = g_variant_get_double (_tmp19_);
	g_variant_unref (_tmp19_);
	_tmp20_ = g_variant_iter_next_value (&_tmp18_);
	_tmp17_.green = g_variant_get_double (_tmp20_);
	g_variant_unref (_tmp20_);
	_tmp21_ = g_variant_iter_next_value (&_tmp18_);
	_tmp17_.blue = g_variant_get_double (_tmp21_);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_tmp18_);
	_tmp17_.alpha = g_variant_get_double (_tmp22_);
	g_variant_unref (_tmp22_);
	value = _tmp17_;
	avizo_service_set_bar_fg_color (self, &value);
}

static void
_dbus_avizo_service_set_bar_bg_color (AvizoService* self,
                                      GVariant* _value)
{
	GdkRGBA value = {0};
	GdkRGBA _tmp23_;
	GVariantIter _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	g_variant_iter_init (&_tmp24_, _value);
	_tmp25_ = g_variant_iter_next_value (&_tmp24_);
	_tmp23_.red = g_variant_get_double (_tmp25_);
	g_variant_unref (_tmp25_);
	_tmp26_ = g_variant_iter_next_value (&_tmp24_);
	_tmp23_.green = g_variant_get_double (_tmp26_);
	g_variant_unref (_tmp26_);
	_tmp27_ = g_variant_iter_next_value (&_tmp24_);
	_tmp23_.blue = g_variant_get_double (_tmp27_);
	g_variant_unref (_tmp27_);
	_tmp28_ = g_variant_iter_next_value (&_tmp24_);
	_tmp23_.alpha = g_variant_get_double (_tmp28_);
	g_variant_unref (_tmp28_);
	value = _tmp23_;
	avizo_service_set_bar_bg_color (self, &value);
}

static void
_dbus_avizo_service_set_monitor (AvizoService* self,
                                 GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	avizo_service_set_monitor (self, value);
}

static gboolean
avizo_service_dbus_interface_set_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GVariant* value,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "ImagePath") == 0) {
		_dbus_avizo_service_set_image_path (object, value);
		return TRUE;
	} else if (strcmp (property_name, "ImageResource") == 0) {
		_dbus_avizo_service_set_image_resource (object, value);
		return TRUE;
	} else if (strcmp (property_name, "ImageOpacity") == 0) {
		_dbus_avizo_service_set_image_opacity (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Progress") == 0) {
		_dbus_avizo_service_set_progress (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Width") == 0) {
		_dbus_avizo_service_set_width (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Height") == 0) {
		_dbus_avizo_service_set_height (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Padding") == 0) {
		_dbus_avizo_service_set_padding (object, value);
		return TRUE;
	} else if (strcmp (property_name, "YOffset") == 0) {
		_dbus_avizo_service_set_y_offset (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BorderRadius") == 0) {
		_dbus_avizo_service_set_border_radius (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BorderWidth") == 0) {
		_dbus_avizo_service_set_border_width (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BlockHeight") == 0) {
		_dbus_avizo_service_set_block_height (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BlockSpacing") == 0) {
		_dbus_avizo_service_set_block_spacing (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BlockCount") == 0) {
		_dbus_avizo_service_set_block_count (object, value);
		return TRUE;
	} else if (strcmp (property_name, "FadeIn") == 0) {
		_dbus_avizo_service_set_fade_in (object, value);
		return TRUE;
	} else if (strcmp (property_name, "FadeOut") == 0) {
		_dbus_avizo_service_set_fade_out (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Background") == 0) {
		_dbus_avizo_service_set_background (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BorderColor") == 0) {
		_dbus_avizo_service_set_border_color (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BarFgColor") == 0) {
		_dbus_avizo_service_set_bar_fg_color (object, value);
		return TRUE;
	} else if (strcmp (property_name, "BarBgColor") == 0) {
		_dbus_avizo_service_set_bar_bg_color (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Monitor") == 0) {
		_dbus_avizo_service_set_monitor (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
avizo_service_register_object (gpointer object,
                               GDBusConnection* connection,
                               const gchar* path,
                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_avizo_service_dbus_interface_info), &_avizo_service_dbus_interface_vtable, data, _avizo_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_avizo_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gboolean
is_wayland (GdkDisplay* display)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (display != NULL) {
		_tmp0_ = g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) display), gdk_wayland_display_get_type ());
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
rgba (gint red,
      gint green,
      gint blue,
      gdouble alpha,
      GdkRGBA* result)
{
	GdkRGBA o = {0};
	memset (&o, 0, sizeof (GdkRGBA));
	o.red = red / 255.0;
	o.green = green / 255.0;
	o.blue = blue / 255.0;
	o.alpha = alpha;
	*result = o;
	return;
}

void
on_bus_aquired (GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (conn != NULL);
	{
		AvizoService* _tmp0_;
		AvizoService* _tmp1_;
		_tmp0_ = avizo_service_new ();
		_tmp1_ = _tmp0_;
		avizo_service_register_object (_tmp1_, conn, "/org/danb/avizo/service", &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		FILE* _tmp2_;
		g_clear_error (&_inner_error0_);
		_tmp2_ = stderr;
		fprintf (_tmp2_, "Could not register service\n");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_on_bus_aquired_gbus_acquired_callback (GDBusConnection* connection,
                                        const gchar* name,
                                        gpointer self)
{
	on_bus_aquired (connection);
}

static void
__lambda5_ (void)
{
}

static void
___lambda5__gbus_name_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	__lambda5_ ();
}

static void
__lambda6_ (void)
{
	FILE* _tmp0_;
	_tmp0_ = stderr;
	fprintf (_tmp0_, "Could not acquire name\n");
}

static void
___lambda6__gbus_name_lost_callback (GDBusConnection* connection,
                                     const gchar* name,
                                     gpointer self)
{
	__lambda6_ ();
}

static void
_vala_main (gchar** args,
            gint args_length1)
{
	AvizoService* _tmp0_;
	AvizoService* _tmp1_;
	gtk_init ((gint*) (&args_length1), &args);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.danb.avizo.service", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) _on_bus_aquired_gbus_acquired_callback, NULL, (GClosureNotify) NULL), (GClosure*) ((___lambda5__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda5__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda6__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda6__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	_tmp0_ = avizo_service_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	gtk_main ();
}

int
main (int argc,
      char ** argv)
{
	_vala_main (argv, argc);
	return 0;
}

