function __ciel_find_ciel_workdir
    set cur (readlink -f $PWD)
    while test "$cur" != "/"
        if test -d "$cur/.ciel"
            echo "$cur"
            break
        end
        set cur (dirname $cur)
    end
end

function __ciel_list_instances
    set workdir (__ciel_find_ciel_workdir)
    if ! test -d "$workdir/".ciel/container/instances
        return
    end
    find "$workdir/".ciel/container/instances -maxdepth 1 -mindepth 1 -type d -printf '%f\tInstance\n'
end

function __ciel_list_packages
    set workdir (__ciel_find_ciel_workdir)
    if ! test -d "$workdir/"TREE
        return
    end
    find "$workdir/TREE/groups/" -maxdepth 1 -mindepth 1 -type f -printf 'groups/%f\n'
    if string match -q -- "*/*" "$current"
        return
    end
    find "$workdir/TREE" -maxdepth 2 -mindepth 2 -type d -not -path "TREE/.git" -printf '%f\n'
end

function __ciel_list_plugins
    set ciel_path (readlink -f (command -v ciel))
    set ciel_plugin_dir (dirname $ciel_path)"/../lib/ciel/ciel-plugin"
    find "$ciel_plugin_dir" -maxdepth 1 -mindepth 1 -type f -printf '%f\t-Ciel plugin-\n' | cut -d'-' -f2-
end

complete -c ciel -n "__fish_use_subcommand" -s C -d 'Set the CIEL! working directory' -r
complete -c ciel -n "__fish_use_subcommand" -s b -l batch -d 'Batch mode, no input required'
complete -c ciel -n "__fish_use_subcommand" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_use_subcommand" -s V -l version -d 'Print version information'
complete -c ciel -n "__fish_use_subcommand" -f -a "version" -d 'Display the version of CIEL!'
complete -c ciel -n "__fish_use_subcommand" -f -a "init" -d 'Initialize the work directory'
complete -c ciel -n "__fish_use_subcommand" -f -a "update-os" -d 'Update the OS in the container'
complete -c ciel -n "__fish_use_subcommand" -f -a "load-tree" -d 'Clone package tree from the link provided or AOSC OS ABBS main repository'
complete -c ciel -n "__fish_use_subcommand" -f -a "update-tree" -d 'Update the existing ABBS tree (fetch only) and optionally switch to a different branch'
complete -c ciel -n "__fish_use_subcommand" -f -a "new" -d 'Create a new CIEL workspace'
complete -c ciel -n "__fish_use_subcommand" -f -a "list" -d 'List all the instances under the specified working directory'
complete -c ciel -n "__fish_use_subcommand" -f -a "add" -d 'Add a new instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "del" -d 'Remove an instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "shell" -d 'Start an interactive shell'
complete -c ciel -n "__fish_use_subcommand" -f -a "run" -d 'Lower-level version of \'shell\', without login environment, without sourcing ~/.bash_profile'
complete -c ciel -n "__fish_use_subcommand" -f -a "config" -d 'Configure system and toolchain for building interactively'
complete -c ciel -n "__fish_use_subcommand" -f -a "commit" -d 'Commit changes onto the shared underlying OS'
complete -c ciel -n "__fish_use_subcommand" -f -a "doctor" -d 'Diagnose problems (hopefully)'
complete -c ciel -n "__fish_use_subcommand" -f -a "build" -d 'Build the packages using the specified instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "rollback" -d 'Rollback all or specified instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "down" -d 'Shutdown and unmount all or one instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "stop" -d 'Shuts down an instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "mount" -d 'Mount all or specified instance'
complete -c ciel -n "__fish_use_subcommand" -f -a "farewell" -d 'Remove everything related to CIEL!'
complete -c ciel -n "__fish_use_subcommand" -f -a "repo" -d 'Local repository operations'
complete -c ciel -n "__fish_use_subcommand" -f -a "clean" -d 'Clean all the output directories and source cache directories'
complete -c ciel -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ciel -n "__fish_seen_subcommand_from version" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from init" -l upgrade -d 'Upgrade Ciel workspace from an older version'
complete -c ciel -n "__fish_seen_subcommand_from init" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from load-os" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from update-os" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from load-tree" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from update-tree" -s r -l rebase -d 'Rebase the specified branch from the updated upstream' -r
complete -c ciel -n "__fish_seen_subcommand_from update-tree" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from new" -l from-tarball -d 'Create a new workspace from the specified tarball' -r
complete -c ciel -n "__fish_seen_subcommand_from new" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from list" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from add" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from del" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from shell" -s i -d 'Instance to be used' -r
complete -c ciel -n "__fish_seen_subcommand_from shell" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from run" -s i -d 'Instance to run command in' -r
complete -c ciel -n "__fish_seen_subcommand_from run" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from config" -s g -d 'Configure base system instead of an instance'
complete -c ciel -n "__fish_seen_subcommand_from config" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from commit" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from doctor" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from build" -s c -l resume -d 'Continue from a Ciel checkpoint' -r
complete -c ciel -n "__fish_seen_subcommand_from build" -l with-topics -d 'Try to add topics before building, delimited by space' -r
complete -c ciel -n "__fish_seen_subcommand_from build" -l stage-select -d 'Select the starting point for a build' -r
complete -c ciel -n "__fish_seen_subcommand_from build" -s g -d 'Fetch source packages only'
complete -c ciel -n "__fish_seen_subcommand_from build" -s x -l offline -d 'Disable network in the container during the build'
complete -c ciel -n "__fish_seen_subcommand_from build" -s 2 -l stage2 -d 'Use stage 2 mode instead of the regular build mode'
complete -c ciel -n "__fish_seen_subcommand_from build" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from rollback" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from down" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from stop" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from mount" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from farewell" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "refresh" -d 'Refresh the repository'
complete -c ciel -n "__fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "init" -d 'Initialize the repository'
complete -c ciel -n "__fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "deinit" -d 'Uninitialize the repository'
complete -c ciel -n "__fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from refresh" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from init" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from deinit" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "refresh" -d 'Refresh the repository'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "init" -d 'Initialize the repository'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "deinit" -d 'Uninitialize the repository'
complete -c ciel -n "__fish_seen_subcommand_from repo; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ciel -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Print help information'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Display the version of CIEL!'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "init" -d 'Initialize the work directory'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "load-os" -d 'Unpack OS tarball or fetch the latest BuildKit from the repository'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "update-os" -d 'Update the OS in the container'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "load-tree" -d 'Clone package tree from the link provided or AOSC OS ABBS main repository'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "update-tree" -d 'Update the existing ABBS tree (fetch only) and optionally switch to a different branch'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "new" -d 'Create a new CIEL workspace'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all the instances under the specified working directory'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a new instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "del" -d 'Remove an instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "shell" -d 'Start an interactive shell'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "run" -d 'Lower-level version of \'shell\', without login environment, without sourcing ~/.bash_profile'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "config" -d 'Configure system and toolchain for building interactively'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "commit" -d 'Commit changes onto the shared underlying OS'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "doctor" -d 'Diagnose problems (hopefully)'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "build" -d 'Build the packages using the specified instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "rollback" -d 'Rollback all or specified instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "down" -d 'Shutdown and unmount all or one instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "stop" -d 'Shuts down an instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "mount" -d 'Mount all or specified instance'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "farewell" -d 'Remove everything related to CIEL!'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "repo" -d 'Local repository operations'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "clean" -d 'Clean all the output directories and source cache directories'
complete -c ciel -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from load-os; and not __fish_seen_subcommand_from update-os; and not __fish_seen_subcommand_from load-tree; and not __fish_seen_subcommand_from update-tree; and not __fish_seen_subcommand_from new; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from del; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from doctor; and not __fish_seen_subcommand_from build; and not __fish_seen_subcommand_from rollback; and not __fish_seen_subcommand_from down; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from mount; and not __fish_seen_subcommand_from farewell; and not __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ciel -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit" -f -a "refresh" -d 'Refresh the repository'
complete -c ciel -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit" -f -a "init" -d 'Initialize the repository'
complete -c ciel -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from repo; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from deinit" -f -a "deinit" -d 'Uninitialize the repository'
# Enhanced completions
complete -xc ciel -n "__fish_seen_subcommand_from build" -a "(__ciel_list_packages)"
complete -xc ciel -n "__fish_seen_subcommand_from build" -s i -d 'Instance to build in' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from run" -s i -d 'Instance to run command in' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from config" -s i -d 'Instance to be configured' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from commit" -s i -d 'Instance to be committed' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from build" -s i -d 'Instance to build in' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from rollback" -s i -d 'Instance to be rolled back' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from down" -s i -d 'Instance to be un-mounted' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from stop" -s i -d 'Instance to be stopped' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from mount" -s i -d 'Instance to be mounted' -a "(__ciel_list_instances)"
complete -xc ciel -n "__fish_seen_subcommand_from load-os" -a "(__fish_complete_suffix tar.xz squashfs)"
complete -c ciel -n "__fish_use_subcommand" -f -a "(__ciel_list_plugins)"
