type token =
  | TUnknown of (
# 537 "parsing_c/parser_c.mly"
        Ast_c.info
# 6 "parsing_c/parser_c.ml"
)
  | TCommentSpace of (
# 540 "parsing_c/parser_c.mly"
        Ast_c.info
# 11 "parsing_c/parser_c.ml"
)
  | TCommentNewline of (
# 540 "parsing_c/parser_c.mly"
        Ast_c.info
# 16 "parsing_c/parser_c.ml"
)
  | TComment of (
# 540 "parsing_c/parser_c.mly"
        Ast_c.info
# 21 "parsing_c/parser_c.ml"
)
  | TInt of (
# 546 "parsing_c/parser_c.mly"
        (string * (Ast_c.sign * Ast_c.base)) * Ast_c.info
# 26 "parsing_c/parser_c.ml"
)
  | TFloat of (
# 547 "parsing_c/parser_c.mly"
        (string * Ast_c.floatType) * Ast_c.info
# 31 "parsing_c/parser_c.ml"
)
  | TChar of (
# 548 "parsing_c/parser_c.mly"
        (string * Ast_c.isWchar) * Ast_c.info
# 36 "parsing_c/parser_c.ml"
)
  | TString of (
# 549 "parsing_c/parser_c.mly"
        (string * Ast_c.isWchar) * Ast_c.info
# 41 "parsing_c/parser_c.ml"
)
  | TQuote of (
# 550 "parsing_c/parser_c.mly"
        (string * Ast_c.isWchar) * Ast_c.info
# 46 "parsing_c/parser_c.ml"
)
  | TPct of (
# 551 "parsing_c/parser_c.mly"
        Ast_c.info
# 51 "parsing_c/parser_c.ml"
)
  | TFormat of (
# 552 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 56 "parsing_c/parser_c.ml"
)
  | TSubString of (
# 552 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 61 "parsing_c/parser_c.ml"
)
  | TDecimal of (
# 553 "parsing_c/parser_c.mly"
        (string * string (*n*) * string (*p*)) * Ast_c.info
# 66 "parsing_c/parser_c.ml"
)
  | TIdent of (
# 555 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 71 "parsing_c/parser_c.ml"
)
  | TKRParam of (
# 556 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 76 "parsing_c/parser_c.ml"
)
  | Tconstructorname of (
# 557 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 81 "parsing_c/parser_c.ml"
)
  | TypedefIdent of (
# 559 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 86 "parsing_c/parser_c.ml"
)
  | TOPar of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 91 "parsing_c/parser_c.ml"
)
  | TCPar of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 96 "parsing_c/parser_c.ml"
)
  | TOBrace of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 101 "parsing_c/parser_c.ml"
)
  | TCBrace of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 106 "parsing_c/parser_c.ml"
)
  | TOCro of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 111 "parsing_c/parser_c.ml"
)
  | TCCro of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 116 "parsing_c/parser_c.ml"
)
  | TOCroCro of (
# 568 "parsing_c/parser_c.mly"
        Ast_c.info
# 121 "parsing_c/parser_c.ml"
)
  | TDot of (
# 569 "parsing_c/parser_c.mly"
        Ast_c.info
# 126 "parsing_c/parser_c.ml"
)
  | TColonColon of (
# 569 "parsing_c/parser_c.mly"
        Ast_c.info
# 131 "parsing_c/parser_c.ml"
)
  | TComma of (
# 569 "parsing_c/parser_c.mly"
        Ast_c.info
# 136 "parsing_c/parser_c.ml"
)
  | TNoComma of (
# 569 "parsing_c/parser_c.mly"
        Ast_c.info
# 141 "parsing_c/parser_c.ml"
)
  | TPtrOp of (
# 569 "parsing_c/parser_c.mly"
        Ast_c.info
# 146 "parsing_c/parser_c.ml"
)
  | TQualType of (
# 570 "parsing_c/parser_c.mly"
        Ast_c.info
# 151 "parsing_c/parser_c.ml"
)
  | TQualExp of (
# 570 "parsing_c/parser_c.mly"
        Ast_c.info
# 156 "parsing_c/parser_c.ml"
)
  | TQualId of (
# 570 "parsing_c/parser_c.mly"
        Ast_c.info
# 161 "parsing_c/parser_c.ml"
)
  | TInc of (
# 571 "parsing_c/parser_c.mly"
        Ast_c.info
# 166 "parsing_c/parser_c.ml"
)
  | TDec of (
# 571 "parsing_c/parser_c.mly"
        Ast_c.info
# 171 "parsing_c/parser_c.ml"
)
  | TAssign of (
# 572 "parsing_c/parser_c.mly"
        Ast_c.assignOp
# 176 "parsing_c/parser_c.ml"
)
  | TEq of (
# 573 "parsing_c/parser_c.mly"
        Ast_c.info
# 181 "parsing_c/parser_c.ml"
)
  | TWhy of (
# 574 "parsing_c/parser_c.mly"
        Ast_c.info
# 186 "parsing_c/parser_c.ml"
)
  | TTilde of (
# 574 "parsing_c/parser_c.mly"
        Ast_c.info
# 191 "parsing_c/parser_c.ml"
)
  | TBang of (
# 575 "parsing_c/parser_c.mly"
        Ast_c.info
# 196 "parsing_c/parser_c.ml"
)
  | TEllipsis of (
# 576 "parsing_c/parser_c.mly"
        Ast_c.info
# 201 "parsing_c/parser_c.ml"
)
  | TDotDot of (
# 577 "parsing_c/parser_c.mly"
        Ast_c.info
# 206 "parsing_c/parser_c.ml"
)
  | TPtVirg of (
# 579 "parsing_c/parser_c.mly"
        Ast_c.info
# 211 "parsing_c/parser_c.ml"
)
  | TOrLog of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 216 "parsing_c/parser_c.ml"
)
  | TAndLog of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 221 "parsing_c/parser_c.ml"
)
  | TOr of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 226 "parsing_c/parser_c.ml"
)
  | TXor of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 231 "parsing_c/parser_c.ml"
)
  | TAnd of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 236 "parsing_c/parser_c.ml"
)
  | TEqEq of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 241 "parsing_c/parser_c.ml"
)
  | TNotEq of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 246 "parsing_c/parser_c.ml"
)
  | TInf of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 251 "parsing_c/parser_c.ml"
)
  | TSup of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 256 "parsing_c/parser_c.ml"
)
  | TInf3 of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 261 "parsing_c/parser_c.ml"
)
  | TSup3 of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 266 "parsing_c/parser_c.ml"
)
  | TInfEq of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 271 "parsing_c/parser_c.ml"
)
  | TSupEq of (
# 581 "parsing_c/parser_c.mly"
        Ast_c.info
# 276 "parsing_c/parser_c.ml"
)
  | TShl of (
# 582 "parsing_c/parser_c.mly"
        Ast_c.info
# 281 "parsing_c/parser_c.ml"
)
  | TShr of (
# 582 "parsing_c/parser_c.mly"
        Ast_c.info
# 286 "parsing_c/parser_c.ml"
)
  | TPlus of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 291 "parsing_c/parser_c.ml"
)
  | TMinus of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 296 "parsing_c/parser_c.ml"
)
  | TMul of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 301 "parsing_c/parser_c.ml"
)
  | TDiv of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 306 "parsing_c/parser_c.ml"
)
  | TMod of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 311 "parsing_c/parser_c.ml"
)
  | TMax of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 316 "parsing_c/parser_c.ml"
)
  | TMin of (
# 583 "parsing_c/parser_c.mly"
        Ast_c.info
# 321 "parsing_c/parser_c.ml"
)
  | Tchar of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 326 "parsing_c/parser_c.ml"
)
  | Tshort of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 331 "parsing_c/parser_c.ml"
)
  | Tint of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 336 "parsing_c/parser_c.ml"
)
  | Tdouble of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 341 "parsing_c/parser_c.ml"
)
  | Tfloat of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 346 "parsing_c/parser_c.ml"
)
  | Tcomplex of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 351 "parsing_c/parser_c.ml"
)
  | Tlong of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 356 "parsing_c/parser_c.ml"
)
  | Tunsigned of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 361 "parsing_c/parser_c.ml"
)
  | Tsigned of (
# 586 "parsing_c/parser_c.mly"
        Ast_c.info
# 366 "parsing_c/parser_c.ml"
)
  | Tvoid of (
# 587 "parsing_c/parser_c.mly"
        Ast_c.info
# 371 "parsing_c/parser_c.ml"
)
  | Tsize_t of (
# 587 "parsing_c/parser_c.mly"
        Ast_c.info
# 376 "parsing_c/parser_c.ml"
)
  | Tssize_t of (
# 587 "parsing_c/parser_c.mly"
        Ast_c.info
# 381 "parsing_c/parser_c.ml"
)
  | Tptrdiff_t of (
# 587 "parsing_c/parser_c.mly"
        Ast_c.info
# 386 "parsing_c/parser_c.ml"
)
  | TautoType of (
# 587 "parsing_c/parser_c.mly"
        Ast_c.info
# 391 "parsing_c/parser_c.ml"
)
  | Tauto of (
# 588 "parsing_c/parser_c.mly"
        Ast_c.info
# 396 "parsing_c/parser_c.ml"
)
  | Tregister of (
# 588 "parsing_c/parser_c.mly"
        Ast_c.info
# 401 "parsing_c/parser_c.ml"
)
  | Textern of (
# 588 "parsing_c/parser_c.mly"
        Ast_c.info
# 406 "parsing_c/parser_c.ml"
)
  | Tstatic of (
# 588 "parsing_c/parser_c.mly"
        Ast_c.info
# 411 "parsing_c/parser_c.ml"
)
  | Talignas of (
# 588 "parsing_c/parser_c.mly"
        Ast_c.info
# 416 "parsing_c/parser_c.ml"
)
  | Ttypedef of (
# 589 "parsing_c/parser_c.mly"
        Ast_c.info
# 421 "parsing_c/parser_c.ml"
)
  | Tconst of (
# 590 "parsing_c/parser_c.mly"
        Ast_c.info
# 426 "parsing_c/parser_c.ml"
)
  | Tvolatile of (
# 590 "parsing_c/parser_c.mly"
        Ast_c.info
# 431 "parsing_c/parser_c.ml"
)
  | Tstruct of (
# 591 "parsing_c/parser_c.mly"
        Ast_c.info
# 436 "parsing_c/parser_c.ml"
)
  | Tunion of (
# 591 "parsing_c/parser_c.mly"
        Ast_c.info
# 441 "parsing_c/parser_c.ml"
)
  | Tenum of (
# 591 "parsing_c/parser_c.mly"
        Ast_c.info
# 446 "parsing_c/parser_c.ml"
)
  | Tdecimal of (
# 591 "parsing_c/parser_c.mly"
        Ast_c.info
# 451 "parsing_c/parser_c.ml"
)
  | Texec of (
# 591 "parsing_c/parser_c.mly"
        Ast_c.info
# 456 "parsing_c/parser_c.ml"
)
  | Ttemplate of (
# 591 "parsing_c/parser_c.mly"
        Ast_c.info
# 461 "parsing_c/parser_c.ml"
)
  | Tbreak of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 466 "parsing_c/parser_c.ml"
)
  | Telse of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 471 "parsing_c/parser_c.ml"
)
  | Tswitch of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 476 "parsing_c/parser_c.ml"
)
  | Tcase of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 481 "parsing_c/parser_c.ml"
)
  | Tcontinue of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 486 "parsing_c/parser_c.ml"
)
  | Tfor of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 491 "parsing_c/parser_c.ml"
)
  | Tdo of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 496 "parsing_c/parser_c.ml"
)
  | Ttry of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 501 "parsing_c/parser_c.ml"
)
  | Tif of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 506 "parsing_c/parser_c.ml"
)
  | Twhile of (
# 592 "parsing_c/parser_c.mly"
        Ast_c.info
# 511 "parsing_c/parser_c.ml"
)
  | Tcatch of (
# 593 "parsing_c/parser_c.mly"
        Ast_c.info
# 516 "parsing_c/parser_c.ml"
)
  | Treturn of (
# 593 "parsing_c/parser_c.mly"
        Ast_c.info
# 521 "parsing_c/parser_c.ml"
)
  | Tgoto of (
# 594 "parsing_c/parser_c.mly"
        Ast_c.info
# 526 "parsing_c/parser_c.ml"
)
  | Tdefault of (
# 594 "parsing_c/parser_c.mly"
        Ast_c.info
# 531 "parsing_c/parser_c.ml"
)
  | Tsizeof of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 536 "parsing_c/parser_c.ml"
)
  | Tnew of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 541 "parsing_c/parser_c.ml"
)
  | Tdelete of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 546 "parsing_c/parser_c.ml"
)
  | Tusing of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 551 "parsing_c/parser_c.ml"
)
  | Tdefined of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 556 "parsing_c/parser_c.ml"
)
  | TOParCplusplusInit of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 561 "parsing_c/parser_c.ml"
)
  | Tnamespace of (
# 595 "parsing_c/parser_c.mly"
        Ast_c.info
# 566 "parsing_c/parser_c.ml"
)
  | Tcpp_struct of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 571 "parsing_c/parser_c.ml"
)
  | Tcpp_union of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 576 "parsing_c/parser_c.ml"
)
  | Tclass of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 581 "parsing_c/parser_c.ml"
)
  | Tprivate of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 586 "parsing_c/parser_c.ml"
)
  | Tpublic of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 591 "parsing_c/parser_c.ml"
)
  | Tprotected of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 596 "parsing_c/parser_c.ml"
)
  | Toperator of (
# 596 "parsing_c/parser_c.mly"
        Ast_c.info
# 601 "parsing_c/parser_c.ml"
)
  | TTemplateStart of (
# 597 "parsing_c/parser_c.mly"
        Ast_c.info
# 606 "parsing_c/parser_c.ml"
)
  | TTemplateEnd of (
# 597 "parsing_c/parser_c.mly"
        Ast_c.info
# 611 "parsing_c/parser_c.ml"
)
  | TTemplateEndSup of (
# 597 "parsing_c/parser_c.mly"
        Ast_c.info
# 616 "parsing_c/parser_c.ml"
)
  | TTemplateEndTemplateEnd of (
# 597 "parsing_c/parser_c.mly"
        Ast_c.info
# 621 "parsing_c/parser_c.ml"
)
  | TTemplateEndTemplateEndTemplateEnd of (
# 598 "parsing_c/parser_c.mly"
        Ast_c.info
# 626 "parsing_c/parser_c.ml"
)
  | Tfinal of (
# 598 "parsing_c/parser_c.mly"
        Ast_c.info
# 631 "parsing_c/parser_c.ml"
)
  | Tvirtual of (
# 598 "parsing_c/parser_c.mly"
        Ast_c.info
# 636 "parsing_c/parser_c.ml"
)
  | Ttypename of (
# 598 "parsing_c/parser_c.mly"
        Ast_c.info
# 641 "parsing_c/parser_c.ml"
)
  | Trestrict of (
# 602 "parsing_c/parser_c.mly"
        Ast_c.info
# 646 "parsing_c/parser_c.ml"
)
  | Tasm of (
# 607 "parsing_c/parser_c.mly"
        Ast_c.info
# 651 "parsing_c/parser_c.ml"
)
  | Tattribute of (
# 608 "parsing_c/parser_c.mly"
        Ast_c.info
# 656 "parsing_c/parser_c.ml"
)
  | TattributeNoarg of (
# 609 "parsing_c/parser_c.mly"
        Ast_c.info
# 661 "parsing_c/parser_c.ml"
)
  | Tinline of (
# 610 "parsing_c/parser_c.mly"
        Ast_c.info
# 666 "parsing_c/parser_c.ml"
)
  | Ttypeof of (
# 611 "parsing_c/parser_c.mly"
        Ast_c.info
# 671 "parsing_c/parser_c.ml"
)
  | TDefine of (
# 623 "parsing_c/parser_c.mly"
        Ast_c.info
# 676 "parsing_c/parser_c.ml"
)
  | TCppEscapedNewline of (
# 626 "parsing_c/parser_c.mly"
        Ast_c.info
# 681 "parsing_c/parser_c.ml"
)
  | TCppConcatOp of (
# 628 "parsing_c/parser_c.mly"
        Ast_c.info
# 686 "parsing_c/parser_c.ml"
)
  | TOParDefine of (
# 631 "parsing_c/parser_c.mly"
        Ast_c.info
# 691 "parsing_c/parser_c.ml"
)
  | TOBraceDefineInit of (
# 632 "parsing_c/parser_c.mly"
        Ast_c.info
# 696 "parsing_c/parser_c.ml"
)
  | TIdentDefine of (
# 634 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 701 "parsing_c/parser_c.ml"
)
  | TDefEOL of (
# 635 "parsing_c/parser_c.mly"
        Ast_c.info
# 706 "parsing_c/parser_c.ml"
)
  | TInclude of (
# 644 "parsing_c/parser_c.mly"
        (string * string * bool ref * Ast_c.info)
# 711 "parsing_c/parser_c.ml"
)
  | TIncludeStart of (
# 647 "parsing_c/parser_c.mly"
        (Ast_c.info * bool ref)
# 716 "parsing_c/parser_c.ml"
)
  | TIncludeFilename of (
# 648 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 721 "parsing_c/parser_c.ml"
)
  | TIfdef of (
# 657 "parsing_c/parser_c.mly"
        (Ast_c.ifdef_guard * (int * int) option ref * Ast_c.info)
# 726 "parsing_c/parser_c.ml"
)
  | TIfdefelif of (
# 657 "parsing_c/parser_c.mly"
        (Ast_c.ifdef_guard * (int * int) option ref * Ast_c.info)
# 731 "parsing_c/parser_c.ml"
)
  | TIfdefelse of (
# 659 "parsing_c/parser_c.mly"
        ((int * int) option ref * Ast_c.info)
# 736 "parsing_c/parser_c.ml"
)
  | TEndif of (
# 659 "parsing_c/parser_c.mly"
        ((int * int) option ref * Ast_c.info)
# 741 "parsing_c/parser_c.ml"
)
  | TIfdefBool of (
# 661 "parsing_c/parser_c.mly"
        (bool * (int * int) option ref * Ast_c.info)
# 746 "parsing_c/parser_c.ml"
)
  | TIfdefMisc of (
# 661 "parsing_c/parser_c.mly"
        (bool * (int * int) option ref * Ast_c.info)
# 751 "parsing_c/parser_c.ml"
)
  | TIfdefVersion of (
# 661 "parsing_c/parser_c.mly"
        (bool * (int * int) option ref * Ast_c.info)
# 756 "parsing_c/parser_c.ml"
)
  | TUifdef of (
# 674 "parsing_c/parser_c.mly"
        Ast_c.info
# 761 "parsing_c/parser_c.ml"
)
  | TUelseif of (
# 674 "parsing_c/parser_c.mly"
        Ast_c.info
# 766 "parsing_c/parser_c.ml"
)
  | TUendif of (
# 674 "parsing_c/parser_c.mly"
        Ast_c.info
# 771 "parsing_c/parser_c.ml"
)
  | TUndef of (
# 680 "parsing_c/parser_c.mly"
        Ast_c.info
# 776 "parsing_c/parser_c.ml"
)
  | TPrePragma of (
# 681 "parsing_c/parser_c.mly"
        Ast_c.info*Ast_c.info*string*Ast_c.info*Ast_c.info*(string*Ast_c.info)list
# 781 "parsing_c/parser_c.ml"
)
  | TPragma of (
# 682 "parsing_c/parser_c.mly"
        Ast_c.info
# 786 "parsing_c/parser_c.ml"
)
  | TPragmaString of (
# 683 "parsing_c/parser_c.mly"
        string * Ast_c.info
# 791 "parsing_c/parser_c.ml"
)
  | TCppDirectiveOther of (
# 685 "parsing_c/parser_c.mly"
        Ast_c.info
# 796 "parsing_c/parser_c.ml"
)
  | TMacroAttr of (
# 693 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 801 "parsing_c/parser_c.ml"
)
  | TMacroAttrArgs of (
# 693 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 806 "parsing_c/parser_c.ml"
)
  | TMacroStmt of (
# 694 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 811 "parsing_c/parser_c.ml"
)
  | TMacroIdStmt of (
# 694 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 816 "parsing_c/parser_c.ml"
)
  | TMacroIdentBuilder of (
# 695 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 821 "parsing_c/parser_c.ml"
)
  | TMacroString of (
# 697 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 826 "parsing_c/parser_c.ml"
)
  | TMacroDecl of (
# 698 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 831 "parsing_c/parser_c.ml"
)
  | TMacroDeclConst of (
# 699 "parsing_c/parser_c.mly"
        Ast_c.info
# 836 "parsing_c/parser_c.ml"
)
  | TMacroIterator of (
# 701 "parsing_c/parser_c.mly"
        (string * Ast_c.info)
# 841 "parsing_c/parser_c.ml"
)
  | TCommentSkipTagStart of (
# 713 "parsing_c/parser_c.mly"
        Ast_c.info
# 846 "parsing_c/parser_c.ml"
)
  | TCommentSkipTagEnd of (
# 713 "parsing_c/parser_c.mly"
        Ast_c.info
# 851 "parsing_c/parser_c.ml"
)
  | TCParEOL of (
# 717 "parsing_c/parser_c.mly"
        Ast_c.info
# 856 "parsing_c/parser_c.ml"
)
  | TAction of (
# 719 "parsing_c/parser_c.mly"
        Ast_c.info
# 861 "parsing_c/parser_c.ml"
)
  | TCommentMisc of (
# 723 "parsing_c/parser_c.mly"
        Ast_c.info
# 866 "parsing_c/parser_c.ml"
)
  | TCommentCpp of (
# 724 "parsing_c/parser_c.mly"
        (Token_c.cppcommentkind * Ast_c.info)
# 871 "parsing_c/parser_c.ml"
)
  | EOF of (
# 728 "parsing_c/parser_c.mly"
        Ast_c.info
# 876 "parsing_c/parser_c.ml"
)
  | TTODO of (
# 729 "parsing_c/parser_c.mly"
        Ast_c.info
# 881 "parsing_c/parser_c.ml"
)

open Parsing
let _ = parse_error;;
# 2 "parsing_c/parser_c.mly"
(* Yoann Padioleau
 *
 * Copyright (C) 2002, 2006, 2007, 2008, 2009 Yoann Padioleau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License (GPL)
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * file license.txt for more details.
 *)

(**
 * This grammar has been inspired by:
 * http://www.lysator.liu.se/c/ANSI-C-grammar-y.html
 *)

open Common

open Ast_c

module LP = Lexer_parser
open Lexer_parser (* for the fields *)

open Semantic_c (* Semantic exn *)
module T = Token_c

(*****************************************************************************)
(* Wrappers *)
(*****************************************************************************)
let string_and_loc s = function
    ii::_ ->
      Printf.sprintf "PARSING: %s:%d: %s"
	(file_of_info ii) (line_of_info ii) s
  | [] -> Printf.sprintf "PARSING: %s" s

let warning ii s v =
  if !Flag_parsing_c.verbose_parsing
  then Common.warning (string_and_loc s ii) v
  else v

let computed_warning ii s v = (*do not construct string unless it will be shown*)
  if !Flag_parsing_c.verbose_parsing
  then Common.warning (string_and_loc (s()) ii) v
  else v

let pr2, pr2_once = Common.mk_pr2_wrappers Flag_parsing_c.verbose_parsing

(*****************************************************************************)
(* Parse helpers functions *)
(*****************************************************************************)

(*-------------------------------------------------------------------------- *)
(* Type related *)
(*-------------------------------------------------------------------------- *)

type shortLong      = Short  | Long | LongLong

type decl = {
  storageD: storagebis wrap;
  alignD: align wrap;
  typeD: ((sign option) * (shortLong option) * (typeCbis option)) wrap;
  qualifD: typeQualifierbis wrap;
  inlineD: bool             wrap;
  (* note: have a full_info: parse_info list; to remember ordering
   * between storage, qualifier, type ? well this info is already in
   * the Ast_c.info, just have to sort them to get good order *)
}

let nullDecl = {
  storageD = NoSto, [];
  alignD = NoAlign, [];
  typeD = (None, None, None), [];
  qualifD = nullQualif;
  inlineD = false, [];
}
let fake_pi = Common.fake_parse_info

let addStorageD  = function
  | ((x,ii), ({storageD = (NoSto,[])} as v)) -> { v with storageD = (x, [ii]) }
  | ((x,ii), ({storageD = (y, ii2)} as v)) ->
      if x = y then warning [ii] "duplicate storage classes" v
      else warning [ii] "multiple storage classes, keeping the second" v
      
let addAlignD  = function
  |  ((x,ii), ({alignD = (NoAlign,[])} as v)) -> {v with alignD = (x, ii) }
  |  ((x,ii), ({alignD = (y, ii2)} as v)) ->
      if x = y then warning ii "duplicate align classes" v
      else warning ii "multiple align classes, keeping the second" v

let addInlineD  = function
  | ((true,ii), ({inlineD = (false,[])} as v)) -> { v with inlineD=(true,[ii])}
  | ((true,ii), ({inlineD = (true, ii2)} as v)) -> warning [ii] "duplicate inline" v
  | _ -> raise (Impossible 86)


let addTypeD     = function
  | ((Left3 Signed,ii)   ,({typeD = ((Some Signed,  b,c),ii2)} as v)) ->
      warning ii "duplicate 'signed'"   v
  | ((Left3 UnSigned,ii) ,({typeD = ((Some UnSigned,b,c),ii2)} as v)) ->
      warning ii "duplicate 'unsigned'" v
  | ((Left3 _,ii),        ({typeD = ((Some _,b,c),ii2)} as _v)) ->
      raise (Semantic ("both signed and unsigned specified", fake_pi))
  | ((Left3 x,ii),        ({typeD = ((None,b,c),ii2)} as v))   ->
      {v with typeD = (Some x,b,c),ii @ ii2}

  | ((Middle3 Short,ii),  ({typeD = ((a,Some Short,c),ii2)} as v)) ->
      warning ii "duplicate 'short'" v


  (* gccext: long long allowed *)
  | ((Middle3 Long,ii),   ({typeD = ((a,Some Long ,c),ii2)} as v)) ->
      { v with typeD = (a, Some LongLong, c),ii @ ii2 }
  | ((Middle3 Long,ii),   ({typeD = ((a,Some LongLong ,c),ii2)} as v)) ->
      warning ii "triplicate 'long'" v


  | ((Middle3 _,ii),      ({typeD = ((a,Some _,c),ii2)} as _v)) ->
      raise (Semantic ("both long and short specified", fake_pi))
  | ((Middle3 x,ii),      ({typeD = ((a,None,c),ii2)} as v))  ->
      {v with typeD = (a, Some x,c),ii @ ii2}

  | ((Right3 (BaseType (FloatType CUnknownComplex)),ii),
     ({typeD = ((a,b,Some (BaseType (FloatType CFloat))),ii2)} as v)) ->
       {v with typeD = (a,b, Some (BaseType (FloatType CFloatComplex))),ii @ ii2}

  | ((Right3 (BaseType (FloatType CUnknownComplex)),ii),
     ({typeD = ((a,b,Some (BaseType (FloatType CDouble))),ii2)} as v)) ->
       {v with typeD = (a,b, Some (BaseType (FloatType CDoubleComplex))),ii @ ii2}

  | ((Right3 (BaseType (FloatType CFloat)),ii),
     ({typeD = ((a,b,Some (BaseType (FloatType CUnknownComplex))),ii2)} as v)) ->
       {v with typeD = (a,b, Some (BaseType (FloatType CFloatComplex))),ii @ ii2}

  | ((Right3 (BaseType (FloatType CDouble)),ii),
     ({typeD = ((a,b,Some (BaseType (FloatType CUnknownComplex))),ii2)} as v)) ->
       {v with typeD = (a,b, Some (BaseType (FloatType CDoubleComplex))),ii @ ii2}

  | ((Right3 t,ii),       ({typeD = ((a,b,Some x),ii2)} as v)) ->
      let mktype t ii = (nQ,[],(t,ii)) in
      let oldtype = Pretty_print_c.string_of_fullType (mktype x ii2) in
      let newtype = Pretty_print_c.string_of_fullType (mktype t ii) in
      let oldattr =
	String.length oldtype > 2 && String.get oldtype 0 = '_' &&
	String.get oldtype 1 = '_' in
      let newattr =
	String.length oldtype > 2 && String.get oldtype 0 = '_' &&
	String.get oldtype 1 = '_' in
      (if oldattr && not newattr
      then Data.add_special_name oldtype Data.Attr
      else if newattr && not oldattr
      then Data.add_special_name newtype Data.Attr);
      computed_warning ii
	(fun _ ->
	  Printf.sprintf "two or more data types: dropping %s, keeping typeD %s\n"
	    newtype oldtype)
	v
  | ((Right3 t,ii),       ({typeD = ((a,b,None),ii2)} as v))   ->
      {v with typeD = (a,b, Some t),ii @ ii2}


let addQualif = function
  | (({const=true},ii),   ({const=true},ii2 as x)) ->   warning [ii] "duplicate 'const'" x
  | (({volatile=true},ii),({volatile=true},ii2 as x))-> warning [ii] "duplicate 'volatile'" x
  | (({restrict=true},ii),({restrict=true},ii2 as x))-> warning [ii] "duplicate 'restrict'" x
  | (({const=true},ii),   (v,ii2)) -> {v with const=true},ii::ii2
  | (({volatile=true},ii),(v,ii2)) -> {v with volatile=true},ii2@[ii]
  | (({restrict=true},ii),(v,ii2)) -> {v with restrict=true},ii2@[ii]
  | ((_,ii),_) ->
      internal_error
	(Printf.sprintf "there is no const, volatile or restrict keyword: %s:%d"
	   (file_of_info ii) (line_of_info ii))

let addQualifD (qu, ({qualifD = v} as x)) =
  { x with qualifD = (addQualif (qu, v)) }


(*-------------------------------------------------------------------------- *)
(* Declaration/Function related *)
(*-------------------------------------------------------------------------- *)


(* stdC: type section, basic integer types (and ritchie)
 * To understand the code, just look at the result (right part of the PM)
 * and go back.
 *)
let (fixDeclSpecForDecl: (attribute list * decl) -> (fullType * (storage wrap)))  = function
 (attrs,
  {storageD = (st,iist);
  alignD = (al,iial);
  qualifD = (qu,iiq);
  typeD = (ty,iit);
  inlineD = (inline,iinl);
  }) ->
   let ty',iit' =
   (match ty with
 | (None,None,None)       ->
     (* generate fake_info, otherwise type_annotater can crash in
      * offset.
      *)
     warning (iist@iiq@iit@iinl) "type defaults to 'int'"
       (defaultInt, [fakeAfterInfo()])
 | (None, None, Some t)   -> (t, iit)

 | (Some sign,   None, (None| Some (BaseType (IntType (Si (_,CInt))))))  ->
     BaseType(IntType (Si (sign, CInt))), iit
 | ((None|Some Signed),Some x,(None|Some(BaseType(IntType (Si (_,CInt)))))) ->
     BaseType(IntType (Si (Signed, [Short,CShort; Long, CLong; LongLong, CLongLong] +> List.assoc x))), iit
 | (Some UnSigned, Some x, (None| Some (BaseType (IntType (Si (_,CInt))))))->
     BaseType(IntType (Si (UnSigned, [Short,CShort; Long, CLong; LongLong, CLongLong] +> List.assoc x))), iit
 | (Some sign,   None, (Some (BaseType (IntType CChar))))   ->
     BaseType(IntType (Si (sign, CChar2))), iit
 | (None, Some Long,(Some(BaseType(FloatType CDouble))))    ->
     BaseType (FloatType (CLongDouble)), iit
 | (None, Some Long,(Some(BaseType(FloatType CDoubleComplex))))    ->
     BaseType (FloatType (CLongDoubleComplex)), iit

 | (Some _,_, Some _) ->
     (*mine*)
     raise (Semantic ("signed, unsigned valid only for char and int", fake_pi))
 | (_,Some _,(Some(BaseType(FloatType (CFloat))))) ->
     raise (Semantic ("long or short specified with floating type", fake_pi))
 | (_,Some Short,(Some(BaseType(FloatType CDouble)))) ->
     raise (Semantic ("the only valid combination is long double", fake_pi))
 | (_,Some Short,(Some(BaseType(FloatType CDoubleComplex)))) ->
     raise (Semantic ("the only valid combination is long double complex", fake_pi))

 | (_, Some _, Some _) ->
     (* mine *)
     raise (Semantic ("long, short valid only for int or float", fake_pi))

     (* if do short uint i, then gcc say parse error, strange ? it is
      * not a parse error, it is just that we don't allow with typedef
      * either short/long or signed/unsigned. In fact, with
      * parse_typedef_fix2 (with et() and dt()) now I say too parse
      * error so this code is executed only when do short struct
      * {....} and never with a typedef cos now we parse short uint i
      * as short ident ident => parse error (cos after first short i
      * pass in dt() mode) *)

   )
   in
   ((qu, iiq), attrs, (ty', iit')),
   ((st, inline, al),iist @ iinl @ iial)


let fixDeclSpecForParam = function ((attrs,{storageD = (st,iist)}) as r) ->
  let (qu_ty,_st) = fixDeclSpecForDecl r in
  match st with
  | (Sto Register) -> (qu_ty, true), iist
  | NoSto -> (qu_ty, false), iist
  | _ ->
      raise
        (Semantic ("storage class specified for parameter of function",
                  fake_pi))

let fixDeclSpecForArg = function ((attrs,{storageD = (st,iist)}) as r) ->
  let (qu_ty,_st) = fixDeclSpecForDecl r in
  (qu_ty, st = Sto Register), iist

let fixDeclSpecForMacro = function ((attrs,{storageD = (st,iist)}) as r) ->
  let (qu_ty,_st) = fixDeclSpecForDecl r in
  match st with
  | NoSto -> qu_ty
  | _ ->
      raise
        (Semantic ("storage class specified for macro type decl",
                  fake_pi))

let fixDeclSpecForMacroDecl = function (attrs,d) ->
  if d.typeD = nullDecl.typeD && d.qualifD = nullDecl.qualifD
     && d.inlineD = nullDecl.inlineD
  then (attrs,d.storageD)
  else raise (Semantic ("too much info on MacroDecl", fake_pi))

let fixDeclSpecForFuncDef x =
  let (returnType,storage) = fixDeclSpecForDecl x in
  (match fst3 (unwrap storage) with
  | StoTypedef ->
      raise (Semantic ("function definition declared 'typedef'", fake_pi))
  | _ -> (returnType, storage)
  )

(* parameter: (this is the context where we give parameter only when
 * in func DEFINITION not in funct DECLARATION) We must have a name.
 * This function ensure that we give only parameterTypeDecl with well
 * formed Classic constructor todo?: do we accept other declaration
 * in ? so I must add them to the compound of the deffunc. I don't
 * have to handle typedef pb here cos C forbid to do VF f { ... }
 * with VF a typedef of func cos here we don't see the name of the
 * argument (in the typedef)
 *)
let (fixOldCDecl: fullType -> fullType) = fun ty ->
  match Ast_c.unwrap_typeC ty with
  | FunctionType (fullt, (params, (b, iib))) ->

      (* stdC: If the prototype declaration declares a parameter for a
       * function that you are defining (it is part of a function
       * definition), then you must write a name within the declarator.
       * Otherwise, you can omit the name. *)
      (match params with
      | [{p_namei = None; p_type = ty2},_] ->
          (match Ast_c.unwrap_typeC ty2 with
          | BaseType Void ->
              ty
          | _ ->
              pr2_once ("SEMANTIC:parameter name omitted, but I continue");
              ty
          )

      | params ->
          (params +> List.iter (fun (param,_) ->
            match param with
            | {p_namei = None} ->
              (* if majuscule, then certainly macro-parameter *)
                pr2_once ("SEMANTIC:parameter name omitted, but I continue");
	    | _ -> ()
          ));
          ty
      )

        (* todo? can we declare prototype in the decl or structdef,
           ... => length <> but good kan meme *)
  | _ ->
      (* gcc say parse error but don't see why *)
      raise (Semantic ("seems this is not a function", fake_pi))

let create_decls decl_spec init_decl_list ender local =
  let (returnType,storage) = fixDeclSpecForDecl decl_spec in
  let iistart = Ast_c.fakeBeforeInfo() in
  DeclList (
  (init_decl_list +> List.map (fun ((attrs, ((name,f),endattrs), ini), iivirg) ->
    let s = str_of_name name in
    if fst3 (unwrap storage) = StoTypedef
    then LP.add_typedef s;
    {v_namei = Some (name, ini);
      v_type = f returnType;
      v_storage = unwrap storage;
      v_local = local;
      v_attr = attrs; (* extra attrs as compared to the common type *)
      v_endattr = endattrs;
      v_type_bis = ref None},
    iivirg)), (ender::iistart::snd storage))
  

(* For fake info added at the end of a conditional or iteration, to have the
correct position information *)
let postfakeInfo pii  =
  let (max,min) =  Lib_parsing_c.max_min_ii_by_pos pii in
  let max_pi = Ast_c.get_info (fun x -> x) max in
  let vp = ({str="";charpos=max_pi.Common.charpos;line=max_pi.Common.line;
	      column=max_pi.Common.column;file=max_pi.Common.file},
	    String.length max_pi.Common.str) in
  { pinfo = FakeTok ("",vp,Ast_c.After);
    cocci_tag = ref Ast_c.emptyAnnot;
    annots_tag = Token_annot.empty;
    comments_tag = ref Ast_c.emptyComments;
    danger = ref Ast_c.NoDanger;
  }

let fixFunc (typ, compound, old_style_opt) =
  let (cp,iicp) = compound in

  let ((name, ty, (st,iist), iidotdot, constr_inh), endattrs) = typ in

  let (qu, attrs, tybis) = ty in

  match Ast_c.unwrap_typeC ty with
  | FunctionType (fullt, (params,abool)) ->
      let iifunc = Ast_c.get_ii_typeC_take_care tybis in

      let iistart = Ast_c.fakeBeforeInfo() in
      let iiend   = postfakeInfo iicp in
      assert (qu = nullQualif);
      assert (attrs = []);

      (match params with
      | [{p_namei= None; p_type = ty2}, _] ->
          (match Ast_c.unwrap_typeC ty2 with
          | BaseType Void ->  ()
          | _ ->
                (* failwith "internal error: fixOldCDecl not good" *)
              ()
          )
      | params ->
          params +> List.iter (function
          | ({p_namei = Some s}, _) -> ()
	  | _ -> ()
                (* failwith "internal error: fixOldCDecl not good" *)
          )
      );
      (* bugfix: cf tests_c/function_pointer4.c.
       * Apparemment en C on peut syntaxiquement ecrire ca:
       *
       *   void a(int)(int x);
       * mais apres gcc gueule au niveau semantique avec:
       *   xxx.c:1: error: 'a' declared as function returning a function
       * Je ne faisais pas cette verif. Sur du code comme
       *   void METH(foo)(int x) { ...} , le parser croit (a tort) que foo
       * est un typedef, et donc c'est parsé comme l'exemple precedent,
       * ce qui ensuite confuse l'unparser qui n'est pas habitué
       * a avoir dans le returnType un FunctionType et qui donc
       * pr_elem les ii dans le mauvais sens ce qui genere au final
       * une exception. Hence this fix to at least detect the error
       * at parsing time (not unparsing time).
       *)
      (match Ast_c.unwrap_typeC fullt with
      | FunctionType _ ->
          let s = Ast_c.str_of_name name in
          let iis = Ast_c.info_of_name name in
          pr2 (spf "WEIRD: %s declared as function returning a function." s);
          pr2 (spf "This is probably because of a macro. Extend standard.h");
          raise (Semantic (spf "error: %s " s, Ast_c.parse_info_of_info iis))
      | _ -> ()
      );

      (* it must be nullQualif,cos parser construct only this*)
      {f_name = name;
       f_type = (fullt, (params, abool));
       f_storage = st;
       f_constr_inherited = constr_inh;
       f_body =
	if !Flag_parsing_c.parsing_header_for_types
	then []
	else cp;
       f_endattr = endattrs;
       f_old_c_style = old_style_opt;
      },
      (iifunc @ iicp @ [iistart;iiend] @ iidotdot @ iist)
  | _ ->
      raise
        (Semantic
            ("you are trying to do a function definition but you don't give " ^
             "any parameter", fake_pi))


(*-------------------------------------------------------------------------- *)
(* parse_typedef_fix2 *)
(*-------------------------------------------------------------------------- *)

let dt s () =
  if !Flag_parsing_c.debug_etdt then pr2 ("<" ^ s);
  LP.disable_typedef ()

let et s () =
  if !Flag_parsing_c.debug_etdt then pr2 (">" ^ s);
  LP.enable_typedef ()

let fixSimpleTypeForCPPType x =
  let (returnType, _) =
    fixDeclSpecForDecl
      (dt "spec_qualif" ();
       ([],(addTypeD((dt "type" (); x),nullDecl)))) in
  returnType

let fix_add_params_ident x =
  let (s, ty, st, _dotdot, _constr_inh) = x in
  match Ast_c.unwrap_typeC ty with
  | FunctionType (fullt, (params, bool)) ->

      (match params with
      | [{p_namei=None; p_type=ty2}, _] ->
          (match Ast_c.unwrap_typeC ty2 with
          | BaseType Void -> ()
          | _ ->
              (* failwith "internal error: fixOldCDecl not good" *)
              ()
          )
      | params ->
          params +> List.iter (function
          | ({p_namei= Some name}, _) ->
              LP.add_ident (Ast_c.str_of_name s)
	  | _ ->
              ()
                (* failwith "internal error: fixOldCDecl not good" *)
          )
      )
  | _ -> ()

(*-------------------------------------------------------------------------- *)
(* shortcuts *)
(*-------------------------------------------------------------------------- *)

let mk_e e ii = Ast_c.mk_e e ii

let mk_string_wrap (s,info) = (s, [info])
let mk_info_string info = (Ast_c.str_of_info info, [info])

(*-------------------------------------------------------------------------- *)
(* support for functions with no return type *)
(*-------------------------------------------------------------------------- *)

let args_are_params l =
  match l with
    [Right (ArgAction(ActMisc [x])), ii] when Ast_c.is_fake x -> true
  | _ -> List.for_all (function Right (ArgType x), ii -> true | _ -> false) l
let args_to_params l pb =
  let pi =
    match pb with Some pb -> Ast_c.parse_info_of_info pb | None -> fake_pi in
  match l with
    [(Right (ArgAction(ActMisc [x])), ii)] when Ast_c.is_fake x -> []
  | l ->
      List.map
	(function
	    Right (ArgType x), ii -> x, ii
	  | x ->
	      raise
		(Semantic
		   ("function with no return type must have types in param list",
		    pi)))
	l

(*let check_cpp tok =
  if !Flag.c_plus_plus = Flag.Off
  then
    let i = Ast_c.parse_info_of_info tok in
    raise (Semantic("C++ code detected, try using the --c++ option", i))*)

# 1407 "parsing_c/parser_c.ml"
let yytransl_const = [|
    0|]

let yytransl_block = [|
  257 (* TUnknown *);
  258 (* TCommentSpace *);
  259 (* TCommentNewline *);
  260 (* TComment *);
  261 (* TInt *);
  262 (* TFloat *);
  263 (* TChar *);
  264 (* TString *);
  265 (* TQuote *);
  266 (* TPct *);
  267 (* TFormat *);
  268 (* TSubString *);
  269 (* TDecimal *);
  270 (* TIdent *);
  271 (* TKRParam *);
  272 (* Tconstructorname *);
  273 (* TypedefIdent *);
  274 (* TOPar *);
  275 (* TCPar *);
  276 (* TOBrace *);
  277 (* TCBrace *);
  278 (* TOCro *);
  279 (* TCCro *);
  280 (* TOCroCro *);
  281 (* TDot *);
  282 (* TColonColon *);
  283 (* TComma *);
  284 (* TNoComma *);
  285 (* TPtrOp *);
  286 (* TQualType *);
  287 (* TQualExp *);
  288 (* TQualId *);
  289 (* TInc *);
  290 (* TDec *);
  291 (* TAssign *);
  292 (* TEq *);
  293 (* TWhy *);
  294 (* TTilde *);
  295 (* TBang *);
  296 (* TEllipsis *);
  297 (* TDotDot *);
  298 (* TPtVirg *);
  299 (* TOrLog *);
  300 (* TAndLog *);
  301 (* TOr *);
  302 (* TXor *);
  303 (* TAnd *);
  304 (* TEqEq *);
  305 (* TNotEq *);
  306 (* TInf *);
  307 (* TSup *);
  308 (* TInf3 *);
  309 (* TSup3 *);
  310 (* TInfEq *);
  311 (* TSupEq *);
  312 (* TShl *);
  313 (* TShr *);
  314 (* TPlus *);
  315 (* TMinus *);
  316 (* TMul *);
  317 (* TDiv *);
  318 (* TMod *);
  319 (* TMax *);
  320 (* TMin *);
  321 (* Tchar *);
  322 (* Tshort *);
  323 (* Tint *);
  324 (* Tdouble *);
  325 (* Tfloat *);
  326 (* Tcomplex *);
  327 (* Tlong *);
  328 (* Tunsigned *);
  329 (* Tsigned *);
  330 (* Tvoid *);
  331 (* Tsize_t *);
  332 (* Tssize_t *);
  333 (* Tptrdiff_t *);
  334 (* TautoType *);
  335 (* Tauto *);
  336 (* Tregister *);
  337 (* Textern *);
  338 (* Tstatic *);
  339 (* Talignas *);
  340 (* Ttypedef *);
  341 (* Tconst *);
  342 (* Tvolatile *);
  343 (* Tstruct *);
  344 (* Tunion *);
  345 (* Tenum *);
  346 (* Tdecimal *);
  347 (* Texec *);
  348 (* Ttemplate *);
  349 (* Tbreak *);
  350 (* Telse *);
  351 (* Tswitch *);
  352 (* Tcase *);
  353 (* Tcontinue *);
  354 (* Tfor *);
  355 (* Tdo *);
  356 (* Ttry *);
  357 (* Tif *);
  358 (* Twhile *);
  359 (* Tcatch *);
  360 (* Treturn *);
  361 (* Tgoto *);
  362 (* Tdefault *);
  363 (* Tsizeof *);
  364 (* Tnew *);
  365 (* Tdelete *);
  366 (* Tusing *);
  367 (* Tdefined *);
  368 (* TOParCplusplusInit *);
  369 (* Tnamespace *);
  370 (* Tcpp_struct *);
  371 (* Tcpp_union *);
  372 (* Tclass *);
  373 (* Tprivate *);
  374 (* Tpublic *);
  375 (* Tprotected *);
  376 (* Toperator *);
  377 (* TTemplateStart *);
  378 (* TTemplateEnd *);
  379 (* TTemplateEndSup *);
  380 (* TTemplateEndTemplateEnd *);
  381 (* TTemplateEndTemplateEndTemplateEnd *);
  382 (* Tfinal *);
  383 (* Tvirtual *);
  384 (* Ttypename *);
  385 (* Trestrict *);
  386 (* Tasm *);
  387 (* Tattribute *);
  388 (* TattributeNoarg *);
  389 (* Tinline *);
  390 (* Ttypeof *);
  391 (* TDefine *);
  392 (* TCppEscapedNewline *);
  393 (* TCppConcatOp *);
  394 (* TOParDefine *);
  395 (* TOBraceDefineInit *);
  396 (* TIdentDefine *);
  397 (* TDefEOL *);
  398 (* TInclude *);
  399 (* TIncludeStart *);
  400 (* TIncludeFilename *);
  401 (* TIfdef *);
  402 (* TIfdefelif *);
  403 (* TIfdefelse *);
  404 (* TEndif *);
  405 (* TIfdefBool *);
  406 (* TIfdefMisc *);
  407 (* TIfdefVersion *);
  408 (* TUifdef *);
  409 (* TUelseif *);
  410 (* TUendif *);
  411 (* TUndef *);
  412 (* TPrePragma *);
  413 (* TPragma *);
  414 (* TPragmaString *);
  415 (* TCppDirectiveOther *);
  416 (* TMacroAttr *);
  417 (* TMacroAttrArgs *);
  418 (* TMacroStmt *);
  419 (* TMacroIdStmt *);
  420 (* TMacroIdentBuilder *);
  421 (* TMacroString *);
  422 (* TMacroDecl *);
  423 (* TMacroDeclConst *);
  424 (* TMacroIterator *);
  425 (* TCommentSkipTagStart *);
  426 (* TCommentSkipTagEnd *);
  427 (* TCParEOL *);
  428 (* TAction *);
  429 (* TCommentMisc *);
  430 (* TCommentCpp *);
    0 (* EOF *);
  431 (* TTODO *);
    0|]

let yylhs = "\255\255\
\001\000\008\000\008\000\008\000\008\000\010\000\010\000\011\000\
\012\000\012\000\014\000\014\000\014\000\013\000\013\000\013\000\
\013\000\015\000\015\000\017\000\017\000\017\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\018\000\018\000\
\018\000\018\000\018\000\018\000\018\000\018\000\004\000\004\000\
\019\000\019\000\019\000\020\000\020\000\020\000\020\000\026\000\
\025\000\025\000\025\000\024\000\024\000\030\000\030\000\022\000\
\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\
\022\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\
\022\000\022\000\022\000\022\000\032\000\032\000\032\000\032\000\
\032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
\032\000\032\000\032\000\032\000\032\000\032\000\032\000\032\000\
\031\000\031\000\021\000\021\000\021\000\021\000\021\000\021\000\
\021\000\021\000\021\000\021\000\036\000\036\000\036\000\036\000\
\036\000\036\000\036\000\035\000\035\000\035\000\035\000\035\000\
\035\000\035\000\035\000\035\000\035\000\041\000\041\000\041\000\
\041\000\041\000\041\000\041\000\041\000\041\000\041\000\037\000\
\037\000\042\000\042\000\046\000\046\000\047\000\048\000\048\000\
\048\000\051\000\051\000\052\000\052\000\052\000\050\000\053\000\
\056\000\033\000\034\000\003\000\057\000\057\000\057\000\057\000\
\057\000\057\000\057\000\057\000\057\000\057\000\057\000\058\000\
\058\000\058\000\058\000\065\000\065\000\067\000\067\000\067\000\
\045\000\069\000\069\000\071\000\071\000\071\000\072\000\072\000\
\072\000\072\000\072\000\059\000\059\000\075\000\077\000\077\000\
\060\000\060\000\060\000\060\000\060\000\060\000\007\000\007\000\
\007\000\007\000\007\000\007\000\007\000\007\000\061\000\061\000\
\061\000\061\000\061\000\061\000\043\000\043\000\043\000\062\000\
\062\000\083\000\085\000\085\000\085\000\085\000\085\000\064\000\
\064\000\064\000\064\000\087\000\087\000\087\000\087\000\088\000\
\088\000\086\000\089\000\089\000\089\000\089\000\089\000\089\000\
\089\000\089\000\089\000\089\000\089\000\089\000\089\000\089\000\
\089\000\089\000\089\000\089\000\089\000\089\000\089\000\089\000\
\089\000\089\000\089\000\089\000\089\000\089\000\089\000\089\000\
\089\000\089\000\089\000\089\000\089\000\089\000\089\000\089\000\
\029\000\029\000\029\000\029\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\038\000\038\000\038\000\038\000\
\090\000\090\000\092\000\092\000\095\000\095\000\096\000\096\000\
\096\000\097\000\097\000\099\000\099\000\099\000\098\000\098\000\
\098\000\104\000\104\000\107\000\107\000\105\000\105\000\109\000\
\109\000\109\000\106\000\106\000\106\000\106\000\106\000\108\000\
\111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
\111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
\111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
\112\000\113\000\117\000\117\000\117\000\118\000\118\000\118\000\
\118\000\118\000\118\000\118\000\115\000\115\000\115\000\120\000\
\120\000\120\000\120\000\049\000\049\000\049\000\049\000\123\000\
\123\000\123\000\123\000\123\000\123\000\123\000\123\000\123\000\
\076\000\126\000\121\000\121\000\122\000\128\000\128\000\128\000\
\128\000\128\000\128\000\129\000\110\000\110\000\110\000\005\000\
\005\000\130\000\131\000\131\000\131\000\131\000\131\000\131\000\
\134\000\134\000\134\000\134\000\134\000\134\000\134\000\134\000\
\134\000\134\000\134\000\134\000\136\000\137\000\137\000\137\000\
\137\000\135\000\135\000\066\000\079\000\138\000\138\000\138\000\
\138\000\145\000\145\000\145\000\145\000\145\000\145\000\145\000\
\145\000\133\000\147\000\148\000\139\000\139\000\080\000\080\000\
\080\000\080\000\149\000\149\000\081\000\081\000\124\000\124\000\
\150\000\150\000\150\000\040\000\040\000\141\000\151\000\151\000\
\151\000\151\000\154\000\154\000\154\000\152\000\152\000\152\000\
\155\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
\164\000\164\000\164\000\164\000\165\000\165\000\165\000\165\000\
\165\000\165\000\166\000\166\000\166\000\166\000\166\000\166\000\
\168\000\168\000\168\000\168\000\168\000\168\000\168\000\168\000\
\168\000\169\000\169\000\169\000\169\000\171\000\171\000\173\000\
\173\000\174\000\174\000\170\000\170\000\172\000\172\000\157\000\
\157\000\167\000\167\000\167\000\178\000\178\000\178\000\178\000\
\093\000\162\000\156\000\179\000\180\000\176\000\177\000\163\000\
\163\000\160\000\160\000\094\000\091\000\091\000\189\000\189\000\
\183\000\183\000\184\000\184\000\188\000\188\000\190\000\190\000\
\191\000\073\000\193\000\193\000\192\000\192\000\194\000\195\000\
\195\000\197\000\197\000\199\000\199\000\196\000\006\000\006\000\
\006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
\006\000\006\000\202\000\202\000\200\000\200\000\200\000\200\000\
\200\000\200\000\200\000\200\000\200\000\200\000\200\000\200\000\
\200\000\200\000\204\000\204\000\204\000\204\000\204\000\204\000\
\078\000\078\000\206\000\206\000\205\000\207\000\209\000\208\000\
\074\000\074\000\074\000\074\000\074\000\074\000\074\000\210\000\
\210\000\210\000\210\000\009\000\009\000\009\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\211\000\
\211\000\211\000\211\000\212\000\158\000\158\000\068\000\070\000\
\185\000\187\000\143\000\144\000\140\000\142\000\159\000\161\000\
\201\000\114\000\116\000\100\000\101\000\102\000\103\000\044\000\
\044\000\082\000\082\000\084\000\084\000\198\000\198\000\028\000\
\028\000\039\000\039\000\027\000\027\000\063\000\063\000\181\000\
\181\000\182\000\182\000\175\000\175\000\175\000\186\000\186\000\
\186\000\186\000\132\000\132\000\132\000\119\000\119\000\125\000\
\125\000\054\000\054\000\055\000\055\000\016\000\016\000\016\000\
\153\000\153\000\213\000\213\000\146\000\127\000\127\000\203\000\
\203\000\023\000\023\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000"

let yylen = "\002\000\
\002\000\000\000\002\000\006\000\005\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\003\000\002\000\004\000\
\002\000\001\000\003\000\001\000\002\000\003\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\003\000\
\001\000\003\000\003\000\001\000\005\000\003\000\004\000\003\000\
\003\000\003\000\000\000\003\000\001\000\001\000\001\000\001\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\001\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\001\000\004\000\001\000\002\000\002\000\002\000\002\000\004\000\
\002\000\004\000\002\000\004\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\002\000\004\000\004\000\004\000\
\003\000\003\000\002\000\002\000\006\000\001\000\001\000\001\000\
\003\000\001\000\001\000\003\000\001\000\002\000\003\000\001\000\
\001\000\000\000\002\000\002\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\002\000\005\000\006\000\004\000\001\000\004\000\003\000\
\004\000\006\000\003\000\001\000\001\000\002\000\003\000\002\000\
\003\000\000\000\001\000\001\000\001\000\002\000\001\000\001\000\
\001\000\001\000\001\000\001\000\002\000\005\000\001\000\002\000\
\005\000\007\000\005\000\009\000\011\000\003\000\005\000\007\000\
\006\000\007\000\006\000\007\000\008\000\005\000\002\000\001\000\
\001\000\001\000\002\000\003\000\003\000\001\000\001\000\002\000\
\001\000\002\000\001\000\004\000\007\000\001\000\000\000\000\000\
\004\000\003\000\002\000\000\000\003\000\003\000\004\000\000\000\
\003\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\006\000\004\000\001\000\
\004\000\004\000\001\000\002\000\001\000\003\000\002\000\004\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\004\000\004\000\004\000\003\000\
\006\000\002\000\001\000\002\000\001\000\002\000\003\000\001\000\
\001\000\001\000\001\000\001\000\003\000\003\000\004\000\004\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\003\000\003\000\002\000\002\000\
\001\000\001\000\001\000\001\000\002\000\003\000\002\000\003\000\
\003\000\004\000\003\000\004\000\000\000\001\000\003\000\001\000\
\002\000\002\000\001\000\001\000\002\000\002\000\001\000\002\000\
\004\000\002\000\004\000\002\000\004\000\003\000\005\000\005\000\
\001\000\001\000\002\000\002\000\001\000\001\000\001\000\001\000\
\002\000\002\000\002\000\001\000\000\000\002\000\002\000\001\000\
\002\000\001\000\002\000\003\000\006\000\008\000\007\000\009\000\
\001\000\001\000\001\000\001\000\001\000\001\000\002\000\002\000\
\002\000\002\000\002\000\002\000\004\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\003\000\004\000\
\004\000\001\000\002\000\003\000\004\000\004\000\005\000\004\000\
\005\000\001\000\001\000\001\000\002\000\002\000\002\000\002\000\
\002\000\002\000\004\000\005\000\001\000\003\000\001\000\003\000\
\001\000\003\000\003\000\000\000\002\000\001\000\001\000\003\000\
\003\000\003\000\002\000\003\000\005\000\001\000\001\000\000\000\
\008\000\006\000\005\000\006\000\004\000\004\000\002\000\002\000\
\001\000\001\000\002\000\002\000\001\000\001\000\001\000\002\000\
\002\000\002\000\001\000\001\000\006\000\006\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\002\000\002\000\
\002\000\008\000\008\000\008\000\008\000\002\000\000\000\001\000\
\003\000\004\000\004\000\001\000\000\000\001\000\000\000\001\000\
\000\000\003\000\002\000\004\000\002\000\003\000\002\000\003\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\000\000\001\000\000\000\006\000\003\000\002\000\002\000\001\000\
\001\000\001\000\002\000\000\000\001\000\001\000\001\000\003\000\
\001\000\001\000\001\000\002\000\002\000\003\000\001\000\002\000\
\001\000\004\000\006\000\004\000\004\000\002\000\002\000\004\000\
\007\000\003\000\004\000\001\000\006\000\005\000\006\000\005\000\
\003\000\004\000\001\000\002\000\001\000\001\000\001\000\001\000\
\002\000\002\000\001\000\004\000\006\000\004\000\005\000\004\000\
\006\000\000\000\001\000\001\000\001\000\002\000\002\000\001\000\
\003\000\001\000\003\000\003\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\006\000\
\005\000\004\000\002\000\005\000\001\000\001\000\005\000\004\000\
\001\000\001\000\001\000\001\000\005\000\001\000\001\000\001\000\
\002\000\002\000\002\000\001\000\001\000\003\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\002\000\002\000\001\000\002\000\001\000\
\002\000\001\000\002\000\001\000\003\000\001\000\003\000\000\000\
\001\000\001\000\003\000\001\000\003\000\001\000\003\000\001\000\
\002\000\001\000\002\000\001\000\004\000\003\000\001\000\004\000\
\003\000\000\000\001\000\004\000\003\000\001\000\003\000\001\000\
\003\000\001\000\002\000\000\000\002\000\000\000\001\000\003\000\
\001\000\002\000\001\000\002\000\001\000\001\000\000\000\001\000\
\000\000\001\000\000\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000"

let yydefred = "\000\000\
\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\244\002\000\000\008\000\000\000\083\001\190\002\000\000\166\002\
\066\001\074\001\067\001\069\001\068\001\070\001\075\001\077\001\
\076\001\065\001\071\001\072\001\073\001\080\001\216\001\217\001\
\215\001\214\001\000\000\219\001\095\001\096\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\097\001\000\000\000\000\000\000\000\000\000\000\000\000\141\002\
\143\002\142\002\144\002\149\002\150\002\151\002\000\000\000\000\
\108\002\100\001\000\000\000\000\167\002\245\002\162\002\161\002\
\000\000\089\001\158\002\157\002\164\002\000\000\093\001\000\000\
\094\001\091\001\092\001\000\000\000\000\000\000\098\001\099\001\
\000\000\220\001\221\001\000\000\000\000\218\001\065\002\000\000\
\000\000\066\002\067\002\000\000\082\002\090\002\000\000\095\002\
\097\002\145\002\146\002\148\002\147\002\163\002\174\000\175\000\
\178\000\000\000\000\000\179\000\000\000\012\000\000\000\175\002\
\000\000\000\000\000\000\000\000\161\000\162\000\236\000\163\000\
\157\000\159\000\160\000\158\000\000\000\001\001\000\000\000\000\
\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\214\000\000\000\000\000\000\000\246\002\000\000\209\000\
\184\000\000\000\000\000\087\000\089\000\000\000\000\000\104\000\
\000\000\000\000\000\000\164\000\185\000\000\000\206\000\204\000\
\205\000\207\000\208\000\000\000\000\000\000\000\000\000\010\000\
\248\002\000\000\000\000\000\000\188\001\000\000\249\002\250\002\
\000\000\001\000\003\000\186\002\000\000\006\000\007\000\000\000\
\085\001\000\000\000\000\235\002\019\002\000\000\020\002\085\002\
\086\002\078\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\002\000\024\002\025\002\026\002\000\000\000\000\
\000\000\210\001\000\000\000\000\103\002\000\000\000\000\000\000\
\000\000\000\000\155\002\000\000\195\001\114\001\113\001\112\001\
\000\000\000\000\115\001\000\000\000\000\000\000\000\000\000\000\
\109\001\189\001\116\001\000\000\235\001\000\000\219\002\096\002\
\212\001\208\001\211\001\164\001\000\000\000\000\191\000\000\000\
\000\000\202\002\192\000\193\000\199\000\000\000\207\001\209\001\
\183\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\091\002\093\002\000\000\000\000\189\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\020\000\000\000\148\000\000\000\
\149\000\000\000\000\000\201\000\145\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\013\000\255\000\
\000\000\151\000\000\000\000\000\103\000\000\000\000\000\102\000\
\101\000\000\000\153\000\000\000\155\000\000\000\000\000\015\000\
\000\000\000\000\000\000\000\000\000\000\237\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\171\000\172\000\000\000\150\000\006\001\
\000\000\007\001\192\002\000\000\210\000\000\000\000\000\000\000\
\232\000\234\000\000\000\231\000\229\000\000\000\227\000\000\000\
\233\000\235\000\185\001\186\001\187\001\000\000\000\000\000\000\
\000\000\194\001\000\000\193\001\000\000\002\000\160\001\222\002\
\000\000\000\000\000\000\177\001\087\001\000\000\000\000\000\000\
\196\000\197\000\000\000\198\000\200\000\236\002\077\002\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\090\001\178\001\
\000\000\224\002\000\000\000\000\000\000\113\002\002\000\000\000\
\000\000\000\000\188\002\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\233\002\000\000\106\002\000\000\000\000\
\000\000\206\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\122\001\123\001\143\001\144\001\140\001\138\001\139\001\
\136\001\137\001\132\001\133\001\134\001\135\001\130\001\131\001\
\126\001\129\001\128\001\127\001\125\001\124\001\121\001\000\000\
\234\001\000\000\000\000\000\000\000\000\000\000\000\000\108\001\
\145\001\000\000\000\000\000\000\242\001\000\000\000\000\196\001\
\179\002\181\002\000\000\000\000\000\000\227\002\000\000\104\001\
\000\000\000\000\000\000\000\000\000\000\181\001\165\001\166\001\
\000\000\000\000\000\000\172\002\000\000\173\002\168\002\056\002\
\000\000\035\002\000\000\000\000\000\000\052\002\037\002\034\002\
\033\002\038\002\000\000\069\002\036\002\000\000\210\002\000\000\
\000\000\028\002\000\000\031\002\000\000\000\000\032\002\000\000\
\000\000\068\002\027\002\208\002\000\000\083\002\177\002\000\000\
\092\002\094\002\190\000\188\000\000\000\187\000\023\000\032\000\
\069\000\056\000\044\000\051\000\034\000\057\000\082\000\070\000\
\084\000\072\000\073\000\064\000\029\000\028\000\066\000\048\000\
\074\000\024\000\078\000\035\000\085\000\075\000\081\000\046\000\
\039\000\047\000\077\000\030\000\045\000\076\000\031\000\036\000\
\052\000\042\000\043\000\054\000\086\000\068\000\053\000\040\000\
\071\000\060\000\041\000\083\000\059\000\037\000\038\000\033\000\
\062\000\065\000\063\000\061\000\049\000\050\000\079\000\067\000\
\025\000\026\000\027\000\055\000\080\000\058\000\000\000\018\000\
\180\000\183\000\021\000\000\000\000\000\061\001\062\001\064\001\
\063\001\000\000\058\001\053\001\054\001\051\001\052\001\057\001\
\034\001\035\001\037\001\036\001\055\001\056\001\000\000\045\001\
\044\001\049\001\050\001\048\001\038\001\039\001\043\001\042\001\
\041\001\040\001\047\001\046\001\027\001\028\001\029\001\030\001\
\031\001\033\001\032\001\060\001\059\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\239\000\
\000\000\000\000\000\000\000\000\221\000\219\000\220\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\204\002\000\000\
\000\000\094\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\133\002\136\002\000\000\231\002\
\000\000\088\000\216\000\090\000\091\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\105\000\106\000\
\109\000\108\000\107\000\203\000\000\000\000\000\000\000\169\000\
\170\000\000\000\000\000\193\002\000\000\000\000\000\000\176\002\
\225\000\230\000\000\000\151\001\000\000\000\000\000\000\000\000\
\000\000\002\000\000\000\161\001\162\001\187\002\000\000\000\000\
\086\001\000\000\229\002\213\001\079\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\114\002\000\000\160\002\000\000\000\000\194\002\
\000\000\000\000\103\001\082\001\081\001\000\000\003\002\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\255\001\000\000\
\000\000\000\000\249\001\000\000\122\002\121\002\000\000\234\002\
\104\002\116\002\107\002\101\001\102\001\000\000\000\000\000\000\
\154\002\117\001\000\000\142\001\141\001\000\000\245\001\223\001\
\000\000\000\000\000\000\146\001\000\000\118\001\000\000\190\001\
\191\001\111\001\000\000\000\000\000\000\236\001\000\000\221\002\
\000\000\254\001\000\000\000\000\000\000\191\002\203\002\000\000\
\179\001\180\001\171\002\169\002\170\002\000\000\000\000\000\000\
\000\000\041\002\039\002\040\002\184\002\013\002\000\000\000\000\
\211\002\000\000\000\000\000\000\070\002\000\000\059\002\000\000\
\000\000\000\000\212\002\014\002\209\002\089\002\000\000\215\002\
\000\000\000\000\022\000\000\000\000\000\000\000\000\000\215\000\
\019\001\000\000\000\000\217\000\000\000\000\000\000\000\000\000\
\000\000\240\000\000\000\000\000\000\000\096\000\100\000\000\000\
\000\000\000\000\000\000\095\000\154\000\156\000\000\000\000\000\
\000\000\213\000\134\002\135\002\016\000\000\000\000\000\000\000\
\000\000\146\000\167\000\166\000\168\000\005\001\000\000\150\001\
\152\001\155\001\153\001\000\000\000\000\000\000\005\000\000\000\
\159\001\223\002\088\001\000\000\000\000\000\000\000\000\000\000\
\000\000\225\002\156\002\000\000\110\002\000\000\112\002\159\002\
\000\000\000\000\014\001\000\000\196\002\195\002\165\002\189\002\
\004\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\253\001\000\000\000\000\000\000\207\002\
\153\002\000\000\000\000\000\000\000\000\000\000\119\001\120\001\
\000\000\241\001\000\000\000\000\000\000\000\000\220\002\182\002\
\224\001\180\002\225\001\000\000\174\002\000\000\000\000\000\000\
\000\000\000\000\011\002\000\000\000\000\071\002\000\000\061\002\
\000\000\063\002\000\000\000\000\058\002\000\000\007\002\000\000\
\000\000\019\000\000\000\018\001\000\000\000\000\000\000\000\000\
\243\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\138\002\000\000\000\000\247\000\000\000\195\000\205\002\
\097\000\098\000\211\000\000\000\000\000\232\002\254\000\093\000\
\000\000\154\001\156\001\004\000\000\000\000\000\000\000\198\002\
\078\001\000\000\000\000\171\001\169\001\125\000\000\000\173\001\
\000\000\109\002\111\002\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\002\002\240\002\124\002\000\002\250\001\
\251\001\001\002\000\000\128\002\197\001\000\000\152\002\000\000\
\246\001\243\001\000\000\228\001\000\000\000\000\000\000\000\000\
\000\000\105\001\012\002\000\000\010\002\000\000\000\000\000\000\
\000\000\060\002\062\002\064\002\214\002\000\000\217\002\000\000\
\178\002\076\002\088\002\025\001\000\000\000\000\000\000\017\001\
\218\000\249\000\000\000\251\000\000\000\000\000\000\000\000\000\
\000\000\000\000\212\000\000\000\173\000\000\000\000\000\000\000\
\175\001\176\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\026\001\000\000\
\000\000\197\002\005\002\000\000\000\000\105\002\000\000\000\000\
\199\001\000\000\244\001\230\001\232\001\229\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\213\002\216\002\000\000\
\021\001\022\001\250\000\252\000\000\000\248\000\238\000\242\000\
\137\002\000\000\000\000\000\000\000\000\000\000\199\002\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\126\000\127\000\130\000\
\129\000\128\000\248\001\012\001\000\000\000\000\129\002\198\001\
\000\000\231\001\233\001\009\002\000\000\000\000\000\000\030\002\
\029\002\023\001\253\000\000\000\000\000\000\000\000\000\100\002\
\101\002\000\000\200\001\054\002\000\000\000\000\000\000\048\002\
\000\000\139\002\140\002\000\000\244\000\000\000\043\002\045\002\
\000\000\000\000\000\000\042\002\044\002\000\000\013\001\000\000\
\000\000\049\002\245\000\050\002\051\002"

let yydgoto = "\008\000\
\009\000\070\000\026\004\159\000\185\000\122\001\160\000\010\000\
\195\000\046\003\037\002\161\000\184\000\163\000\119\002\207\002\
\038\001\120\002\164\000\165\000\166\000\167\000\215\002\062\001\
\194\002\063\001\186\002\008\001\074\000\065\001\168\000\055\004\
\169\000\237\002\170\000\171\000\172\000\202\000\009\001\090\003\
\173\000\030\001\174\000\177\001\175\000\031\001\052\002\010\001\
\011\001\012\001\191\002\202\001\156\001\013\001\157\001\254\003\
\176\000\177\000\178\000\179\000\180\000\178\001\203\001\166\002\
\182\002\075\000\125\001\181\000\126\001\249\002\127\001\128\001\
\076\000\130\001\176\002\144\001\177\002\027\004\014\001\244\000\
\072\003\031\003\032\003\204\003\205\003\152\004\016\004\134\003\
\167\002\079\000\080\000\081\000\082\000\083\000\084\000\085\000\
\086\000\087\000\088\000\225\000\035\003\089\000\000\002\245\000\
\246\000\247\000\084\003\249\000\250\000\246\001\251\000\242\001\
\078\003\137\001\146\001\007\003\006\002\139\001\147\001\148\001\
\007\002\008\002\168\001\056\004\169\001\170\001\236\001\189\000\
\190\000\140\001\090\000\252\000\234\001\091\000\092\000\093\000\
\094\000\253\000\254\000\251\001\091\003\241\003\049\003\243\003\
\086\003\087\003\255\000\088\003\245\001\050\003\051\003\220\003\
\052\003\196\001\095\000\096\000\017\002\013\002\020\001\027\002\
\110\003\097\000\041\002\098\000\099\000\042\002\043\002\028\002\
\029\002\030\002\223\004\237\004\239\004\240\004\122\003\118\003\
\255\003\123\003\044\002\031\002\045\002\032\002\100\000\024\001\
\048\002\127\003\106\004\211\000\101\000\128\003\129\003\102\000\
\027\001\103\000\104\000\000\001\105\000\047\004\048\004\197\001\
\044\003\200\001\070\004\208\002\106\000\185\004\107\000\108\000\
\109\000\110\000\014\002\015\002\238\001"

let yysindex = "\039\005\
\000\000\138\016\051\025\001\029\035\038\025\004\030\255\000\000\
\000\000\028\017\000\000\128\255\000\000\000\000\181\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\220\255\000\000\000\000\000\000\193\001\193\001\
\103\255\017\000\043\255\009\001\054\001\193\001\193\001\193\001\
\000\000\047\000\084\000\002\038\097\000\236\255\038\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\038\000\194\000\
\000\000\000\000\195\000\219\000\000\000\000\000\000\000\000\000\
\109\255\000\000\000\000\000\000\000\000\004\006\000\000\000\000\
\000\000\000\000\000\000\002\038\002\038\002\038\000\000\000\000\
\166\017\000\000\000\000\002\038\002\038\000\000\000\000\164\001\
\101\002\000\000\000\000\217\000\000\000\000\000\030\002\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\228\001\000\000\141\000\000\000\224\026\000\000\
\181\001\251\001\025\030\025\030\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\024\001\000\000\226\000\001\029\
\000\000\068\001\051\025\085\001\116\001\135\001\001\029\195\001\
\153\001\025\030\168\016\060\029\124\001\085\255\148\001\075\001\
\197\001\000\000\200\001\000\000\011\002\000\000\146\255\000\000\
\000\000\000\000\219\001\000\000\000\000\230\000\005\018\000\000\
\035\038\059\004\025\030\000\000\000\000\074\255\000\000\000\000\
\000\000\000\000\000\000\005\002\094\023\141\000\038\002\000\000\
\000\000\035\038\035\038\035\038\000\000\082\002\000\000\000\000\
\168\002\000\000\000\000\000\000\158\037\000\000\000\000\062\001\
\000\000\139\255\071\018\000\000\000\000\193\001\000\000\000\000\
\000\000\000\000\062\001\001\029\074\031\053\255\114\002\208\000\
\160\002\218\002\000\000\000\000\000\000\000\000\074\255\233\002\
\232\018\000\000\044\026\042\020\000\000\127\002\122\002\232\018\
\071\018\071\018\000\000\067\028\000\000\000\000\000\000\000\000\
\208\036\010\003\000\000\036\003\169\255\239\000\108\255\169\255\
\000\000\000\000\000\000\200\000\000\000\152\255\000\000\000\000\
\000\000\000\000\000\000\000\000\201\000\162\002\000\000\053\003\
\057\003\000\000\000\000\000\000\000\000\105\001\000\000\000\000\
\000\000\182\001\223\002\140\032\066\003\144\031\043\008\078\003\
\000\000\000\000\030\002\069\003\000\000\096\003\228\001\089\036\
\013\000\088\003\139\255\062\001\000\000\085\003\000\000\035\038\
\000\000\020\040\001\029\000\000\000\000\016\001\162\025\026\003\
\030\003\001\029\001\029\038\002\141\000\001\029\000\000\000\000\
\002\024\000\000\035\038\232\018\000\000\057\002\216\024\000\000\
\000\000\117\003\000\000\208\000\000\000\074\255\130\003\000\000\
\135\003\071\018\015\001\232\018\001\029\000\000\002\024\001\029\
\001\029\001\029\025\030\025\030\025\030\025\030\025\030\025\030\
\025\030\025\030\025\030\025\030\025\030\025\030\025\030\025\030\
\025\030\025\030\025\030\025\030\025\030\025\030\123\003\232\018\
\232\018\201\000\201\000\000\000\000\000\232\018\000\000\000\000\
\228\001\000\000\000\000\074\255\000\000\000\000\001\029\121\003\
\000\000\000\000\122\003\000\000\000\000\145\003\000\000\094\023\
\000\000\000\000\000\000\000\000\000\000\082\002\034\027\121\001\
\158\037\000\000\175\001\000\000\156\003\000\000\000\000\000\000\
\105\001\160\003\153\003\000\000\000\000\062\001\232\018\009\003\
\000\000\000\000\166\003\000\000\000\000\000\000\000\000\006\001\
\013\007\103\255\065\003\062\001\062\001\067\028\000\000\000\000\
\098\255\000\000\058\017\170\035\165\003\000\000\000\000\244\033\
\072\255\189\003\000\000\190\003\192\003\194\003\001\029\062\001\
\051\025\093\255\015\001\181\026\000\000\146\255\000\000\094\023\
\000\000\014\005\226\001\000\000\071\003\000\000\122\002\073\003\
\042\255\000\000\117\001\079\255\198\003\239\000\196\003\201\003\
\203\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\071\018\
\000\000\116\027\138\000\000\000\000\000\193\001\108\255\000\000\
\000\000\182\027\158\037\000\000\000\000\088\005\102\007\000\000\
\000\000\000\000\181\026\181\026\180\003\000\000\209\003\000\000\
\071\018\105\001\193\001\215\001\193\001\000\000\000\000\000\000\
\201\000\201\000\201\000\000\000\148\000\000\000\000\000\000\000\
\088\000\000\000\199\003\202\003\204\003\000\000\000\000\000\000\
\000\000\000\000\212\003\000\000\000\000\148\255\000\000\140\032\
\144\031\000\000\219\003\000\000\224\003\206\003\000\000\127\008\
\212\003\000\000\000\000\000\000\144\031\000\000\000\000\201\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\097\003\000\000\
\000\000\000\000\000\000\062\001\123\003\000\000\000\000\000\000\
\000\000\227\003\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\208\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\207\003\020\040\163\001\
\001\029\002\024\225\027\225\027\004\006\242\003\243\003\000\000\
\030\003\212\001\248\001\038\002\000\000\000\000\000\000\004\006\
\123\003\245\003\247\003\246\003\000\000\000\000\000\000\232\018\
\232\018\000\000\043\008\057\002\025\030\250\003\251\003\074\255\
\001\029\254\001\232\003\253\003\000\000\000\000\255\001\000\000\
\008\004\000\000\000\000\000\000\000\000\038\002\244\003\110\013\
\230\019\052\027\113\011\115\016\170\005\170\005\064\005\064\005\
\064\005\064\005\004\005\004\005\218\003\218\003\000\000\000\000\
\000\000\000\000\000\000\000\000\141\029\011\004\096\255\000\000\
\000\000\238\003\029\004\000\000\074\001\002\024\002\024\000\000\
\000\000\000\000\047\004\000\000\045\004\175\001\160\003\035\028\
\158\037\000\000\090\034\000\000\000\000\000\000\030\004\210\036\
\000\000\208\003\000\000\000\000\000\000\001\029\067\028\062\001\
\074\031\040\004\042\004\043\004\074\031\140\035\245\035\038\004\
\245\035\041\004\000\000\192\034\000\000\020\001\044\004\000\000\
\054\004\068\004\000\000\000\000\000\000\135\255\000\000\252\003\
\074\255\071\004\070\004\086\004\141\000\065\004\000\000\091\004\
\181\026\089\002\000\000\161\002\000\000\000\000\181\026\000\000\
\000\000\000\000\000\000\000\000\000\000\193\001\071\018\165\001\
\000\000\000\000\196\003\000\000\000\000\075\002\000\000\000\000\
\181\026\074\255\095\004\000\000\097\004\000\000\160\003\000\000\
\000\000\000\000\036\003\169\255\152\255\000\000\067\028\000\000\
\102\007\000\000\104\004\105\004\232\018\000\000\000\000\215\001\
\000\000\000\000\000\000\000\000\000\000\182\001\140\032\182\001\
\140\032\000\000\000\000\000\000\000\000\000\000\024\001\107\004\
\000\000\212\003\071\018\071\018\000\000\001\029\000\000\147\001\
\147\001\205\000\000\000\000\000\000\000\000\000\062\003\000\000\
\094\004\089\036\000\000\114\004\122\004\020\040\187\002\000\000\
\000\000\051\025\102\004\000\000\117\028\176\028\128\000\001\029\
\158\037\000\000\166\024\166\024\114\004\000\000\000\000\137\019\
\119\004\123\004\247\003\000\000\000\000\000\000\117\004\127\004\
\124\002\000\000\000\000\000\000\000\000\015\001\166\024\001\029\
\181\026\000\000\000\000\000\000\000\000\000\000\002\024\000\000\
\000\000\000\000\000\000\124\004\160\003\038\035\000\000\199\001\
\000\000\000\000\000\000\130\004\129\004\176\255\027\039\027\039\
\200\029\000\000\000\000\125\004\000\000\135\004\000\000\000\000\
\161\004\024\001\000\000\156\004\000\000\000\000\000\000\000\000\
\000\000\001\029\167\004\169\004\074\255\206\020\181\026\159\004\
\105\004\181\026\181\026\000\000\181\026\092\003\053\002\000\000\
\000\000\147\004\193\001\105\004\172\004\074\255\000\000\000\000\
\116\027\000\000\181\026\181\026\036\003\152\255\000\000\000\000\
\000\000\000\000\000\000\053\003\000\000\212\003\148\000\212\003\
\174\004\158\037\000\000\179\002\199\002\000\000\151\004\000\000\
\001\029\000\000\001\029\145\014\000\000\248\005\000\000\175\004\
\001\029\000\000\227\003\000\000\232\018\181\004\183\004\020\040\
\000\000\002\024\166\024\210\002\166\024\216\002\116\027\229\002\
\179\004\000\000\131\004\166\024\000\000\055\004\000\000\000\000\
\000\000\000\000\000\000\184\004\051\025\000\000\000\000\000\000\
\207\004\000\000\000\000\000\000\211\004\213\004\206\004\000\000\
\000\000\200\029\074\031\000\000\000\000\000\000\212\013\000\000\
\181\026\000\000\000\000\001\029\215\004\020\001\219\004\001\029\
\117\004\225\004\093\004\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\181\026\000\000\000\000\116\027\000\000\227\002\
\000\000\000\000\226\004\000\000\104\004\105\004\116\027\181\026\
\181\026\000\000\000\000\140\032\000\000\158\037\234\004\193\001\
\193\001\000\000\000\000\000\000\000\000\145\014\000\000\248\005\
\000\000\000\000\000\000\000\000\019\002\187\002\187\002\000\000\
\000\000\000\000\166\024\000\000\166\024\236\004\217\004\085\001\
\166\024\245\002\000\000\166\004\000\000\232\018\232\018\199\001\
\000\000\000\000\025\030\025\030\025\030\025\030\025\030\025\030\
\025\030\025\030\025\030\025\030\025\030\025\030\025\030\025\030\
\025\030\025\030\025\030\025\030\025\030\105\004\000\000\242\004\
\254\004\000\000\000\000\234\002\184\004\000\000\089\002\222\004\
\000\000\116\027\000\000\000\000\000\000\000\000\104\004\105\004\
\212\003\247\004\229\004\230\004\235\004\000\000\000\000\187\002\
\000\000\000\000\000\000\000\000\166\024\000\000\000\000\000\000\
\000\000\166\024\166\024\241\002\001\005\003\005\000\000\165\018\
\058\025\215\012\196\008\084\009\140\015\140\015\127\006\127\006\
\127\006\038\005\038\005\109\004\109\004\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\005\005\217\004\000\000\000\000\
\238\004\000\000\000\000\000\000\157\004\201\000\157\004\000\000\
\000\000\000\000\000\000\137\004\245\002\051\025\051\025\000\000\
\000\000\001\029\000\000\000\000\125\255\121\002\013\005\000\000\
\151\000\000\000\000\000\132\004\000\000\022\005\000\000\000\000\
\232\018\232\018\201\000\000\000\000\000\051\025\000\000\024\005\
\026\005\000\000\000\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\222\002\074\003\
\102\000\000\000\000\000\000\000\000\000\108\002\113\002\200\002\
\000\000\000\000\000\000\073\030\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\122\005\
\000\000\000\000\000\000\121\030\164\030\204\030\000\000\000\000\
\025\005\000\000\000\000\247\030\034\031\000\000\000\000\000\000\
\000\000\000\000\000\000\030\005\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\242\009\044\005\000\000\234\038\000\000\113\038\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\012\005\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\131\010\000\000\000\000\000\000\000\000\
\000\000\025\039\000\000\000\000\000\000\144\012\181\014\000\000\
\000\000\042\012\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\034\005\146\007\057\006\000\000\
\000\000\079\000\192\000\028\001\000\000\052\000\000\000\000\000\
\000\000\000\000\000\000\000\000\040\005\000\000\000\000\000\000\
\000\000\134\004\041\005\000\000\000\000\242\025\000\000\000\000\
\000\000\000\000\187\000\000\000\000\000\027\005\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\052\005\000\000\000\000\191\004\000\000\000\000\000\000\078\255\
\235\002\082\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\050\001\044\002\000\000\235\003\023\006\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\039\002\000\000\000\000\
\182\000\000\000\000\000\000\000\000\000\060\003\000\000\000\000\
\000\000\000\000\240\006\253\000\015\008\056\005\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\044\005\000\000\
\000\000\000\000\196\011\000\000\000\000\177\008\000\000\000\000\
\000\000\036\005\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\037\005\063\011\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\191\014\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\235\002\238\002\052\005\000\000\000\000\000\000\000\000\
\000\000\042\005\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\052\005\
\000\000\000\000\000\000\000\000\000\000\031\005\000\000\000\000\
\044\005\000\000\000\000\243\011\000\000\038\032\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\056\255\
\000\000\000\000\000\000\000\000\000\000\056\037\000\000\066\000\
\040\005\000\000\139\000\000\000\000\000\000\000\000\000\000\000\
\016\003\000\000\061\005\000\000\000\000\000\000\220\004\124\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\068\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\238\002\069\005\114\021\208\004\022\022\000\000\
\186\022\209\004\000\000\000\000\000\000\000\000\228\004\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\072\005\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\235\002\
\000\000\000\000\000\000\011\003\248\003\216\004\095\006\000\000\
\000\000\000\000\040\005\115\014\000\000\110\004\000\000\000\000\
\000\000\000\000\073\005\069\005\000\000\000\000\000\000\000\000\
\124\003\056\037\064\001\103\003\064\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\137\001\
\056\005\000\000\000\000\000\000\000\000\142\033\000\000\000\000\
\000\000\000\000\000\000\000\000\093\005\000\000\000\000\083\001\
\000\000\000\000\000\000\000\000\016\011\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\066\009\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\150\039\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\036\005\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\077\015\000\000\000\000\074\005\000\000\000\000\000\000\000\000\
\000\000\000\000\034\033\000\000\082\040\018\003\000\000\052\005\
\109\005\000\000\000\000\191\014\000\000\000\000\000\000\000\000\
\000\000\000\000\027\003\042\003\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\092\005\000\000\153\014\
\192\009\011\013\125\014\013\009\033\006\085\014\156\013\196\013\
\002\014\042\014\054\013\094\013\075\010\191\012\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\064\255\071\255\000\000\
\000\000\000\000\000\000\000\000\000\000\148\002\000\000\000\000\
\040\005\000\000\000\000\000\000\000\000\000\000\215\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\194\255\022\000\068\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\087\000\118\005\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\119\005\000\000\087\036\000\000\000\000\000\000\
\069\005\149\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\023\003\082\255\108\005\
\000\000\000\000\136\005\000\000\000\000\000\000\000\000\000\000\
\069\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\071\001\046\002\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\025\005\000\000\000\000\137\005\
\000\000\000\000\000\000\000\000\000\000\000\000\253\000\000\000\
\253\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\235\002\235\002\000\000\000\000\000\000\113\001\
\113\001\000\000\000\000\000\000\000\000\000\000\141\005\000\000\
\028\003\000\000\000\000\000\000\000\000\036\005\213\039\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\050\001\000\000\
\000\000\000\000\000\000\000\000\089\012\000\000\000\000\130\005\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\069\005\000\000\000\000\000\000\000\000\000\000\095\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\072\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\227\000\000\000\000\000\193\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\191\004\000\000\017\005\
\000\000\114\255\138\255\000\000\000\000\029\005\000\000\000\000\
\000\000\000\000\023\003\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\073\005\069\005\145\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\040\005\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\144\005\000\000\000\000\
\000\000\000\000\150\039\000\000\000\000\000\000\000\000\036\005\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\241\015\000\000\000\000\047\003\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\216\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\094\000\000\000\
\069\005\000\000\000\000\000\000\000\000\087\000\000\000\000\000\
\035\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\045\005\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\073\005\
\069\005\000\000\000\000\253\000\000\000\040\005\000\000\108\005\
\108\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\213\039\213\039\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\052\005\052\005\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\075\005\000\000\029\005\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\080\255\000\000\000\000\000\000\000\000\213\039\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\
\177\000\107\000\178\002\128\003\062\005\154\006\045\006\104\011\
\151\011\125\009\221\010\024\010\181\010\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\077\005\000\000\000\000\
\000\000\000\000\000\000\000\000\203\000\000\000\203\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\092\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\052\005\109\005\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\000\000\255\255\018\000\183\255\004\000\160\006\099\255\
\005\000\251\000\023\000\242\001\253\255\126\255\000\000\237\004\
\000\000\041\003\171\255\072\002\104\003\031\019\000\000\116\005\
\241\003\000\000\000\000\077\255\039\001\140\254\172\000\104\028\
\008\001\255\253\000\000\187\005\000\000\062\006\211\254\106\254\
\225\254\173\255\100\255\011\006\156\255\000\000\000\000\000\000\
\137\255\235\254\061\003\069\255\000\000\005\255\131\254\154\255\
\000\000\000\000\016\255\000\000\000\000\209\254\076\255\160\253\
\205\254\049\001\000\000\000\000\000\000\000\000\230\254\040\255\
\101\255\007\000\037\004\062\253\000\000\180\252\033\000\096\254\
\082\252\000\000\184\003\000\000\173\002\245\001\239\252\228\002\
\000\000\063\255\073\255\000\000\000\000\000\000\008\000\107\002\
\011\001\000\000\000\000\000\000\000\000\000\000\253\002\044\255\
\229\255\084\255\186\255\075\255\000\000\000\000\000\000\000\000\
\168\003\009\000\156\254\076\253\144\255\164\254\000\000\000\000\
\158\254\098\005\195\002\197\002\233\003\231\003\009\255\000\000\
\172\003\000\000\000\000\000\000\003\253\193\003\000\000\000\000\
\000\000\000\000\113\254\240\252\037\254\009\252\033\255\169\253\
\000\000\121\004\000\000\169\003\009\006\182\002\044\253\186\252\
\045\255\093\254\000\000\000\000\000\000\157\003\164\255\241\252\
\251\253\000\000\227\004\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\041\002\000\000\015\002\000\000\037\001\
\178\255\072\252\223\004\239\004\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\105\005\000\000\087\252\000\000\000\000\
\054\254\000\000\000\000\000\000\000\000\000\000\141\002\056\003\
\000\000\076\005\000\000\110\003\029\000\048\002\229\251\051\002\
\242\251\000\000\179\003\106\002\002\000"

let yytablesize = 10642
let yytable = "\162\000\
\244\001\158\000\026\001\007\001\022\001\071\000\072\000\248\000\
\077\000\191\000\254\001\192\001\186\000\056\001\188\002\155\001\
\195\001\115\001\034\001\166\001\197\000\183\000\199\002\205\001\
\073\000\129\001\011\003\211\002\189\002\167\001\252\001\056\003\
\092\003\046\001\078\000\124\003\255\002\048\003\190\002\049\001\
\206\000\206\000\078\000\254\002\089\003\180\001\004\003\206\000\
\206\000\206\000\123\001\192\001\201\001\204\001\024\003\026\003\
\008\004\003\002\084\004\239\002\060\003\176\001\171\002\207\001\
\240\001\147\001\115\001\020\003\235\003\186\003\137\003\029\004\
\193\001\239\001\178\003\101\004\228\000\138\001\182\001\112\001\
\113\001\112\001\113\001\154\001\224\000\233\003\083\003\246\003\
\171\001\248\003\039\004\222\000\103\004\164\004\186\004\103\001\
\200\002\064\003\222\003\047\002\228\002\250\002\070\001\085\003\
\118\004\063\003\025\001\187\004\228\002\160\001\041\003\046\002\
\030\003\154\001\154\001\223\000\198\000\153\001\172\003\199\000\
\025\002\047\002\001\002\132\003\021\003\196\000\234\000\138\000\
\139\000\241\001\253\001\142\000\006\002\046\002\006\002\162\000\
\033\001\048\001\148\001\007\001\055\001\182\001\079\003\012\002\
\120\000\196\000\007\001\153\001\153\001\202\002\235\000\076\004\
\209\002\181\001\232\003\042\001\007\002\209\003\007\002\160\004\
\052\001\011\000\136\001\213\000\150\001\053\003\247\004\254\002\
\166\004\115\001\071\001\249\001\077\001\174\004\210\003\218\004\
\186\000\162\000\042\003\121\001\238\002\229\000\050\002\149\003\
\033\002\111\003\242\002\078\001\003\002\032\001\175\004\183\001\
\014\000\186\000\186\000\186\000\228\000\157\000\114\004\005\002\
\116\004\186\004\021\003\054\002\224\000\047\002\025\004\122\004\
\206\001\003\002\154\001\222\000\061\003\078\000\187\004\244\002\
\208\000\046\002\209\000\022\003\170\001\088\004\125\002\015\003\
\162\000\078\004\189\001\010\003\129\001\145\001\007\001\240\002\
\241\002\167\001\186\000\223\000\114\001\203\000\114\001\087\004\
\003\003\185\002\004\002\217\004\153\001\190\001\007\001\210\002\
\200\002\065\003\212\002\213\002\228\002\123\001\006\002\243\001\
\043\004\055\001\068\004\151\001\194\001\072\004\073\004\250\001\
\074\004\201\000\073\003\097\003\143\003\098\003\055\001\188\000\
\245\002\028\003\007\001\007\001\244\002\251\002\007\002\023\002\
\007\001\036\002\026\002\184\001\039\002\243\002\049\002\121\002\
\253\002\067\003\212\000\210\000\129\001\012\004\179\004\077\001\
\180\004\051\004\235\001\051\000\184\004\205\001\144\000\186\000\
\168\001\204\000\204\000\070\003\078\000\162\000\040\002\181\002\
\204\000\204\000\204\000\170\001\168\002\123\001\144\000\067\001\
\223\000\007\001\186\000\178\002\179\002\095\003\192\001\180\002\
\066\000\067\000\005\002\162\000\169\004\181\002\240\001\173\002\
\038\003\054\003\162\004\120\003\147\001\207\001\111\001\239\001\
\215\004\184\002\019\001\021\001\177\004\178\004\172\001\005\002\
\182\001\182\001\174\001\214\002\182\001\224\000\055\001\055\001\
\227\004\015\001\136\001\017\001\251\003\228\004\229\004\184\002\
\154\001\015\001\227\000\201\000\037\001\004\002\140\003\228\000\
\247\001\080\002\182\001\248\000\162\000\182\001\121\001\015\001\
\104\003\071\004\040\001\040\001\025\002\141\000\012\002\012\002\
\012\002\154\001\182\001\077\003\081\004\144\000\080\002\168\001\
\056\003\251\002\153\001\001\003\071\003\141\000\141\000\141\000\
\160\003\059\001\217\003\074\003\181\003\148\001\226\004\148\001\
\078\000\148\001\196\003\233\001\198\003\148\001\004\002\017\001\
\023\004\145\001\120\000\153\001\189\003\126\003\102\003\112\004\
\103\003\230\000\228\003\188\000\105\003\162\000\237\003\040\003\
\083\003\064\001\141\003\142\003\162\000\172\001\121\001\148\001\
\252\004\174\001\149\001\211\002\188\000\188\000\188\000\238\003\
\201\002\085\003\201\002\143\000\201\002\159\001\079\002\231\000\
\078\000\183\001\183\001\010\001\232\000\183\001\053\001\247\001\
\158\001\118\000\082\003\143\000\143\000\182\000\055\002\075\003\
\078\000\121\003\247\001\079\002\141\000\124\001\096\003\004\004\
\122\000\010\001\201\002\183\001\233\000\188\000\183\001\122\000\
\091\004\248\001\093\004\043\001\055\002\011\001\005\004\243\001\
\206\000\212\003\025\001\183\001\182\000\011\001\165\004\204\000\
\236\000\023\001\204\000\254\002\148\001\055\001\055\001\055\001\
\080\001\081\001\053\002\011\001\153\003\154\003\122\000\085\004\
\086\004\075\002\041\004\145\001\191\001\032\001\214\000\148\001\
\013\003\215\000\229\003\201\003\203\002\217\000\123\002\204\002\
\014\003\011\000\053\002\023\002\036\002\011\000\026\002\039\002\
\122\000\202\003\143\000\115\001\055\001\184\001\184\001\201\002\
\036\002\184\001\188\000\039\002\112\003\148\001\205\002\169\002\
\170\002\102\004\003\002\104\004\038\002\046\002\211\004\243\000\
\078\000\040\002\139\003\218\000\024\002\188\000\223\003\184\001\
\226\003\219\000\184\001\198\000\222\001\040\002\199\000\166\001\
\219\004\151\000\239\002\166\001\239\002\047\001\239\002\184\001\
\151\000\167\001\239\002\222\001\234\003\167\001\206\002\172\002\
\201\002\226\001\187\002\239\002\182\003\064\001\241\000\218\002\
\120\000\183\002\007\001\007\001\155\000\218\002\218\002\187\000\
\226\001\169\002\175\003\155\000\239\002\236\003\182\000\151\000\
\189\002\216\000\002\002\140\003\167\004\168\004\135\001\183\002\
\000\004\002\004\031\004\224\003\061\001\050\001\069\001\062\003\
\122\000\182\000\134\001\239\002\115\001\068\001\135\001\063\003\
\009\003\151\000\155\000\149\001\238\000\095\004\053\002\239\000\
\051\001\180\003\239\002\122\000\210\000\074\002\018\003\019\003\
\011\003\072\001\150\004\220\004\240\000\066\004\162\000\188\003\
\181\002\244\003\014\000\227\001\155\000\115\001\053\002\073\001\
\124\001\198\000\039\003\067\003\199\000\138\003\083\004\017\001\
\120\000\239\002\227\001\117\003\014\000\077\001\252\003\253\003\
\196\000\057\001\198\000\053\001\000\003\199\000\118\000\154\001\
\005\002\173\001\184\002\025\002\018\001\025\002\200\000\044\001\
\053\001\064\001\064\001\118\000\045\004\122\000\074\001\046\004\
\014\000\075\001\161\003\225\003\095\003\243\000\113\004\109\004\
\241\000\057\004\122\000\012\002\182\000\012\002\147\003\243\000\
\002\002\153\001\239\002\080\004\135\001\028\001\077\001\029\001\
\124\001\151\000\162\000\162\000\181\002\181\002\122\000\183\001\
\158\001\170\004\184\001\154\001\154\001\192\001\054\001\243\000\
\081\003\204\000\195\001\079\001\151\000\055\003\001\003\007\001\
\198\000\073\003\148\003\199\000\155\000\204\000\089\004\204\000\
\162\003\165\003\077\001\187\000\036\001\051\000\184\002\184\002\
\063\003\166\003\195\003\044\001\076\001\153\001\153\001\155\000\
\154\001\145\001\254\001\078\000\187\000\187\000\187\000\051\000\
\145\001\176\004\009\002\010\002\011\002\001\002\117\001\120\003\
\061\001\120\000\066\000\067\000\203\003\198\002\078\000\073\003\
\115\001\226\002\193\001\226\002\078\000\226\002\151\000\239\002\
\077\001\226\002\153\001\051\000\066\000\067\000\239\002\038\002\
\239\002\115\001\192\002\151\000\193\002\187\000\241\000\239\002\
\024\002\239\002\057\004\038\002\239\002\239\002\239\002\239\002\
\233\001\155\000\206\000\226\002\049\002\227\003\077\004\151\000\
\066\000\067\000\055\001\134\001\055\001\063\003\155\000\135\001\
\172\004\173\004\023\002\063\004\023\002\026\002\073\003\026\002\
\157\003\166\001\198\000\218\003\219\003\199\000\131\003\073\003\
\017\001\021\002\155\000\167\001\021\002\238\000\022\002\021\002\
\239\000\022\002\243\000\126\003\022\002\249\003\162\000\078\000\
\017\004\078\000\249\004\044\000\250\004\240\000\037\004\162\000\
\162\000\120\003\187\000\071\003\021\002\172\001\077\001\243\000\
\170\003\022\002\092\004\239\002\061\001\061\001\020\004\022\004\
\226\002\024\004\107\004\162\000\054\000\187\000\149\001\008\002\
\149\001\008\002\149\001\162\000\055\000\181\002\149\001\028\004\
\028\004\145\001\099\004\243\000\100\004\141\001\183\001\007\001\
\063\000\184\001\064\000\142\001\065\000\121\003\044\001\243\000\
\025\002\071\003\073\003\028\004\221\003\096\004\052\004\053\004\
\149\001\174\001\189\004\190\004\142\000\063\003\044\001\184\002\
\013\004\226\002\162\000\014\004\189\001\023\002\078\000\015\004\
\023\002\097\004\183\002\023\002\142\000\142\000\142\000\142\000\
\061\004\063\003\039\001\041\001\115\004\126\003\151\004\190\001\
\243\000\155\003\117\004\017\002\077\001\175\001\017\002\045\001\
\023\002\017\002\077\001\243\000\226\000\243\000\194\001\119\004\
\071\003\058\001\179\001\045\001\214\004\228\002\044\001\077\001\
\230\002\071\003\055\001\047\003\077\001\228\002\233\001\025\001\
\230\002\025\001\159\001\198\001\161\004\149\001\162\000\162\000\
\181\002\162\000\045\001\183\004\001\001\002\001\003\001\199\001\
\162\000\243\000\145\001\232\001\015\001\016\001\237\001\121\003\
\149\001\162\000\163\001\124\004\195\000\239\001\183\002\183\002\
\007\001\007\001\163\001\142\000\193\000\131\002\239\001\028\004\
\087\002\028\004\184\002\239\001\239\001\131\002\087\002\087\002\
\028\004\044\001\239\002\045\001\132\002\064\001\149\001\064\001\
\239\002\226\002\047\003\047\003\132\002\000\005\001\005\233\001\
\204\000\228\002\204\000\255\001\071\003\006\001\167\001\051\002\
\167\001\156\004\167\001\001\002\203\003\017\001\167\001\018\002\
\006\004\007\004\018\002\238\004\016\002\018\002\204\000\023\002\
\080\003\047\002\026\002\204\000\055\001\131\001\132\001\133\001\
\053\002\049\002\122\002\049\002\054\004\110\001\124\002\162\000\
\167\001\162\000\099\003\100\003\101\003\162\000\075\004\007\004\
\238\004\147\001\237\001\147\001\078\000\147\001\145\001\174\002\
\135\003\147\001\204\000\204\000\175\002\084\001\057\000\058\000\
\248\004\230\004\231\004\197\002\253\004\236\002\228\002\028\004\
\228\002\028\004\228\002\200\002\151\004\028\004\228\002\024\002\
\201\002\024\002\140\000\147\001\001\004\003\004\243\000\205\000\
\207\000\246\002\247\002\007\001\007\001\248\002\220\000\221\000\
\222\000\243\000\140\000\140\000\140\000\140\000\140\000\002\003\
\228\002\162\000\006\003\008\003\152\001\167\001\162\000\162\000\
\012\003\017\003\045\001\045\001\045\001\045\001\045\001\045\001\
\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\
\045\001\045\001\045\001\045\001\045\001\045\001\027\003\033\003\
\034\003\028\004\036\003\057\003\037\003\059\003\028\004\028\004\
\066\003\241\001\055\001\068\003\093\003\054\004\045\001\183\002\
\147\001\069\003\162\000\162\000\244\004\245\004\167\001\094\003\
\109\003\130\003\098\002\099\002\115\003\204\000\045\001\106\003\
\044\001\116\003\107\003\147\001\108\003\228\002\117\003\055\001\
\136\003\140\000\162\000\133\003\003\005\107\001\107\001\107\001\
\243\000\107\001\107\001\144\003\145\003\107\001\191\001\150\003\
\061\001\151\003\061\001\238\001\158\003\159\003\107\001\163\003\
\152\003\147\001\240\001\107\001\107\001\098\001\099\001\100\001\
\101\001\102\001\167\003\240\001\168\003\171\003\045\001\107\001\
\240\001\240\001\173\003\045\001\164\003\174\003\228\002\001\000\
\002\000\003\000\004\000\005\000\006\000\007\000\054\004\054\004\
\054\004\054\004\054\004\054\004\054\004\054\004\054\004\054\004\
\054\004\054\004\054\004\054\004\054\004\054\004\054\004\054\004\
\054\004\176\003\183\002\177\003\098\002\099\002\184\003\044\001\
\243\000\187\003\243\000\191\003\104\001\192\003\193\003\197\003\
\105\001\243\000\199\003\106\001\030\003\044\001\208\003\107\001\
\213\003\045\001\107\001\108\001\109\001\098\002\099\002\207\003\
\166\003\211\003\045\001\045\001\107\001\098\002\099\002\238\001\
\214\003\215\003\204\000\204\000\107\001\107\001\110\001\216\003\
\230\003\098\002\099\002\098\002\099\002\098\002\099\002\076\003\
\047\003\090\001\240\003\110\001\250\003\242\003\047\003\110\001\
\110\001\009\004\110\001\110\001\110\001\169\003\044\000\011\004\
\110\001\033\004\107\001\107\001\024\002\110\001\018\004\034\004\
\047\003\036\004\042\004\084\001\049\004\107\001\084\001\084\001\
\084\001\084\001\084\001\084\001\084\001\084\001\035\004\054\000\
\084\001\084\001\110\001\084\001\050\004\084\001\058\004\055\000\
\145\004\146\004\147\004\148\004\149\004\084\001\084\001\084\001\
\059\004\084\001\060\004\063\000\084\001\064\000\062\004\065\000\
\064\004\069\004\084\001\065\004\079\004\044\001\082\004\094\004\
\098\004\084\001\110\004\105\004\111\004\120\004\084\001\084\001\
\084\001\084\001\084\001\084\001\084\001\084\001\084\001\084\001\
\084\001\084\001\084\001\084\001\084\001\084\001\084\001\084\001\
\084\001\084\001\084\001\084\001\084\001\084\001\084\001\084\001\
\121\004\123\004\030\004\125\004\126\004\110\001\127\004\110\001\
\128\004\158\004\238\002\238\002\238\002\153\004\238\002\040\004\
\047\003\155\004\238\002\157\004\163\004\243\000\110\001\084\001\
\084\001\084\001\110\001\238\002\171\004\084\001\181\004\084\001\
\238\002\238\002\182\004\188\004\212\004\213\004\084\001\216\004\
\084\001\221\004\084\001\084\001\238\002\222\004\084\001\224\004\
\045\001\110\001\084\001\232\004\225\004\233\004\234\004\235\004\
\110\001\044\001\236\004\182\000\059\000\254\004\047\003\002\002\
\118\000\047\003\047\003\135\001\047\003\084\001\084\001\251\004\
\255\004\084\001\004\005\084\001\045\001\122\000\005\005\200\002\
\084\001\084\002\047\003\047\003\186\000\002\001\226\000\237\000\
\247\002\238\000\157\001\228\002\239\000\096\001\097\001\098\001\
\099\001\100\001\101\001\102\001\009\000\238\002\200\002\238\002\
\044\001\240\000\044\001\130\002\073\002\016\001\003\001\158\001\
\044\001\238\002\243\002\200\002\045\001\200\002\009\001\243\000\
\138\000\252\001\107\001\252\001\117\002\120\002\238\002\143\004\
\144\004\145\004\146\004\147\004\148\004\149\004\238\002\045\001\
\138\000\138\000\138\000\138\000\138\000\138\000\138\000\014\000\
\115\002\072\002\238\002\004\001\238\002\045\001\238\002\094\001\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\102\001\
\047\003\200\002\238\002\238\000\242\002\241\000\239\000\090\001\
\008\001\185\002\090\001\090\001\090\001\081\002\090\001\090\001\
\090\001\090\001\047\003\240\000\090\001\239\002\151\000\090\001\
\045\001\090\001\106\001\147\001\228\002\241\002\045\001\047\003\
\047\003\008\002\081\002\090\001\006\002\090\001\192\000\043\003\
\090\001\008\002\010\004\231\001\037\000\038\000\090\001\126\002\
\045\001\155\000\196\002\242\000\156\003\090\001\035\001\138\000\
\116\001\006\002\090\001\090\001\090\001\090\001\090\001\090\001\
\090\001\090\001\090\001\090\001\090\001\090\001\090\001\090\001\
\090\001\090\001\090\001\090\001\090\001\090\001\090\001\090\001\
\090\001\090\001\090\001\090\001\032\004\146\003\206\003\127\002\
\049\000\125\002\051\000\090\001\091\001\045\001\246\004\092\001\
\093\001\094\001\095\001\096\001\097\001\098\001\099\001\100\001\
\101\001\102\001\154\004\090\001\090\001\090\001\108\004\016\002\
\090\004\090\001\005\003\090\001\231\003\130\004\129\004\066\000\
\067\000\190\003\090\001\194\003\090\001\237\001\090\001\090\001\
\159\004\239\003\090\001\114\003\247\003\053\001\090\001\241\004\
\118\000\002\005\016\003\125\003\191\004\067\004\113\003\045\001\
\045\001\182\000\058\003\038\004\243\004\236\000\242\004\122\000\
\245\003\090\001\090\001\000\000\000\000\090\001\000\000\090\001\
\000\000\000\000\000\000\122\000\090\001\000\000\000\000\000\000\
\045\001\000\000\239\002\000\000\000\000\237\000\000\000\238\000\
\000\000\239\002\239\000\118\000\000\000\118\000\000\000\118\000\
\000\000\045\001\239\002\118\000\118\000\000\000\045\001\240\000\
\239\002\045\001\045\001\000\000\045\001\118\000\000\000\135\000\
\118\000\118\000\118\000\118\000\118\000\118\000\118\000\118\000\
\118\000\118\000\045\001\045\001\000\000\118\000\000\000\135\000\
\135\000\135\000\135\000\135\000\135\000\135\000\135\000\000\000\
\000\000\000\000\135\000\135\000\000\000\044\000\000\000\000\000\
\045\001\000\000\045\001\000\000\000\000\000\000\000\000\000\000\
\045\001\106\001\106\001\106\001\000\000\106\001\106\001\000\000\
\000\000\106\001\000\000\241\000\000\000\000\000\054\000\000\000\
\151\000\000\000\106\001\000\000\239\002\000\000\055\000\106\001\
\106\001\000\000\000\000\000\000\151\000\000\000\000\000\000\000\
\000\000\009\000\063\000\106\001\064\000\000\000\065\000\000\000\
\000\000\045\001\118\000\155\000\000\000\239\002\000\000\000\000\
\045\001\000\000\000\000\000\000\000\000\239\002\135\000\155\000\
\000\000\242\000\000\000\000\000\000\000\118\000\000\000\000\000\
\000\000\239\002\045\001\239\002\139\000\239\002\141\004\142\004\
\143\004\144\004\145\004\146\004\147\004\148\004\149\004\045\001\
\045\001\000\000\000\000\000\000\139\000\139\000\139\000\139\000\
\139\000\139\000\139\000\118\000\000\000\000\000\106\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\106\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\106\001\106\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\045\001\045\001\045\001\045\001\045\001\045\001\
\045\001\045\001\045\001\045\001\045\001\045\001\045\001\045\001\
\045\001\045\001\045\001\045\001\045\001\016\002\106\001\106\001\
\016\002\016\002\016\002\057\002\016\002\016\002\016\002\016\002\
\000\000\106\001\016\002\000\000\000\000\016\002\015\002\016\002\
\000\000\000\000\000\000\139\000\000\000\000\000\000\000\000\000\
\057\002\016\002\000\000\016\002\000\000\013\000\016\002\000\000\
\000\000\000\000\000\000\000\000\016\002\000\000\000\000\000\000\
\000\000\000\000\015\000\016\002\000\000\000\000\000\000\000\000\
\016\002\016\002\016\002\016\002\016\002\016\002\016\002\016\002\
\016\002\016\002\016\002\016\002\016\002\016\002\016\002\016\002\
\016\002\016\002\016\002\016\002\016\002\016\002\016\002\016\002\
\016\002\016\002\000\000\000\000\000\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\025\000\026\000\027\000\
\028\000\029\000\030\000\000\000\000\000\000\000\000\000\000\000\
\000\000\016\002\016\002\016\002\000\000\162\001\042\000\016\002\
\000\000\016\002\000\000\000\000\000\000\000\000\000\000\000\000\
\016\002\000\000\016\002\182\000\016\002\016\002\000\000\236\000\
\016\002\000\000\000\000\000\000\016\002\014\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\122\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\002\
\016\002\238\000\053\000\016\002\239\000\016\002\009\000\009\000\
\009\000\009\000\016\002\000\000\000\000\000\000\000\000\009\000\
\000\000\240\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\000\000\009\000\009\000\009\000\000\000\
\017\000\000\000\009\000\009\000\009\000\009\000\009\000\000\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\000\000\044\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\241\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\051\000\000\000\000\000\000\000\054\000\000\000\151\000\009\000\
\000\000\000\000\000\000\000\000\055\000\000\000\009\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\063\000\009\000\064\000\000\000\065\000\066\000\067\000\000\000\
\000\000\155\000\000\000\009\000\120\000\000\000\000\000\000\000\
\000\000\000\000\000\000\009\000\009\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\015\002\000\000\009\000\015\002\
\015\002\015\002\000\000\015\002\015\002\015\002\015\002\000\000\
\000\000\015\002\000\000\000\000\015\002\000\000\015\002\000\000\
\000\000\009\000\009\000\000\000\000\000\000\000\000\000\000\000\
\015\002\000\000\015\002\013\000\009\000\015\002\000\000\000\000\
\000\000\014\000\000\000\015\002\000\000\000\000\000\000\000\000\
\015\000\000\000\015\002\000\000\000\000\000\000\000\000\015\002\
\015\002\015\002\015\002\015\002\015\002\015\002\015\002\015\002\
\015\002\015\002\015\002\015\002\015\002\015\002\015\002\015\002\
\015\002\015\002\015\002\015\002\015\002\015\002\015\002\015\002\
\015\002\000\000\000\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\025\000\026\000\027\000\028\000\029\000\
\030\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\015\002\015\002\015\002\000\000\042\000\000\000\015\002\000\000\
\015\002\000\000\000\000\000\000\182\000\000\000\000\000\015\002\
\236\000\015\002\000\000\015\002\015\002\000\000\000\000\015\002\
\000\000\000\000\000\000\015\002\000\000\000\000\122\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\119\003\000\000\238\000\000\000\000\000\239\000\015\002\015\002\
\053\000\000\000\015\002\000\000\015\002\017\000\017\000\017\000\
\017\000\015\002\240\000\000\000\000\000\000\000\017\000\123\000\
\000\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\000\000\017\000\017\000\017\000\000\000\000\000\
\000\000\017\000\017\000\017\000\017\000\017\000\000\000\017\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\176\000\135\004\136\004\137\004\138\004\241\000\000\000\
\000\000\139\004\140\004\141\004\142\004\143\004\144\004\145\004\
\146\004\147\004\148\004\149\004\000\000\000\000\000\000\151\000\
\000\000\000\000\000\000\000\000\000\000\000\000\017\000\000\000\
\000\000\000\000\000\000\000\000\000\000\017\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\120\000\
\017\000\120\000\155\000\120\000\000\000\000\000\000\000\120\000\
\120\000\000\000\017\000\000\000\000\000\000\000\000\000\000\000\
\000\000\120\000\017\000\017\000\120\000\120\000\120\000\120\000\
\120\000\120\000\120\000\120\000\000\000\017\000\000\000\000\000\
\000\000\120\000\000\000\000\000\000\000\000\000\014\000\014\000\
\014\000\014\000\110\000\000\000\000\000\000\000\000\000\014\000\
\017\000\017\000\014\000\014\000\014\000\014\000\014\000\014\000\
\014\000\014\000\014\000\017\000\014\000\014\000\014\000\000\000\
\000\000\000\000\014\000\014\000\014\000\014\000\014\000\000\000\
\014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
\014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
\014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
\014\000\014\000\181\000\136\004\137\004\138\004\120\000\000\000\
\000\000\139\004\140\004\141\004\142\004\143\004\144\004\145\004\
\146\004\147\004\148\004\149\004\000\000\000\000\000\000\133\000\
\000\000\120\000\000\000\000\000\000\000\000\000\000\000\014\000\
\000\000\000\000\000\000\000\000\000\000\000\000\014\000\133\000\
\133\000\133\000\133\000\133\000\133\000\133\000\133\000\000\000\
\000\000\014\000\133\000\133\000\133\000\133\000\000\000\120\000\
\000\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\014\000\014\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\014\000\000\000\
\000\000\000\000\123\000\000\000\123\000\000\000\123\000\000\000\
\000\000\000\000\123\000\123\000\000\000\000\000\000\000\000\000\
\000\000\014\000\014\000\000\000\123\000\000\000\000\000\123\000\
\123\000\123\000\123\000\123\000\014\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\123\000\000\000\133\000\000\000\
\000\000\006\001\006\001\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\176\000\176\000\000\000\176\000\176\000\
\176\000\000\000\176\000\000\000\176\000\176\000\176\000\177\000\
\000\000\000\000\176\000\176\000\176\000\176\000\176\000\000\000\
\000\000\176\000\176\000\176\000\176\000\176\000\176\000\176\000\
\176\000\176\000\176\000\176\000\176\000\176\000\176\000\176\000\
\176\000\176\000\176\000\176\000\176\000\176\000\176\000\176\000\
\176\000\176\000\131\000\000\000\000\000\000\000\000\000\000\000\
\000\000\123\000\000\000\000\000\000\000\000\000\011\000\000\000\
\000\000\000\000\131\000\131\000\131\000\131\000\131\000\131\000\
\131\000\131\000\000\000\000\000\123\000\131\000\131\000\131\000\
\131\000\131\000\131\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\110\000\000\000\110\000\
\000\000\110\000\000\000\000\000\000\000\110\000\110\000\000\000\
\000\000\000\000\123\000\176\000\000\000\000\000\000\000\110\000\
\000\000\000\000\110\000\110\000\110\000\110\000\110\000\110\000\
\110\000\110\000\110\000\110\000\110\000\110\000\176\000\110\000\
\110\000\110\000\110\000\110\000\110\000\110\000\000\000\000\000\
\000\000\000\000\007\001\007\001\000\000\000\000\000\000\000\000\
\000\000\131\000\000\000\000\000\181\000\181\000\006\001\181\000\
\181\000\181\000\000\000\181\000\176\000\181\000\181\000\181\000\
\000\000\000\000\000\000\181\000\181\000\181\000\181\000\181\000\
\000\000\000\000\181\000\181\000\181\000\181\000\181\000\181\000\
\181\000\181\000\181\000\181\000\181\000\181\000\181\000\181\000\
\181\000\181\000\181\000\181\000\181\000\181\000\181\000\181\000\
\181\000\181\000\181\000\165\000\110\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\132\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\110\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\132\000\
\132\000\132\000\132\000\132\000\132\000\132\000\132\000\000\000\
\000\000\000\000\132\000\132\000\132\000\132\000\132\000\132\000\
\000\000\000\000\182\000\000\000\000\000\110\000\000\000\134\000\
\000\000\000\000\000\000\000\000\181\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\134\000\
\134\000\134\000\134\000\134\000\134\000\134\000\134\000\181\000\
\000\000\000\000\134\000\134\000\134\000\134\000\000\000\005\001\
\005\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\177\000\177\000\000\000\177\000\177\000\177\000\007\001\
\177\000\147\000\177\000\177\000\177\000\181\000\132\000\000\000\
\177\000\177\000\177\000\177\000\177\000\000\000\000\000\177\000\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\011\000\011\000\011\000\011\000\011\000\011\000\134\000\011\000\
\152\000\011\000\011\000\011\000\000\000\000\000\000\000\011\000\
\011\000\011\000\011\000\011\000\000\000\000\000\011\000\011\000\
\011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
\011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
\011\000\011\000\011\000\011\000\011\000\011\000\011\000\000\000\
\000\000\000\000\136\000\000\000\000\000\000\000\000\000\000\000\
\000\000\177\000\000\000\000\000\000\000\000\000\000\000\145\000\
\000\000\000\000\136\000\136\000\136\000\136\000\136\000\136\000\
\136\000\136\000\000\000\000\000\177\000\136\000\136\000\087\001\
\088\001\089\001\090\001\091\001\000\000\000\000\092\001\093\001\
\094\001\095\001\096\001\097\001\098\001\099\001\100\001\101\001\
\102\001\137\000\000\000\000\000\005\001\000\000\000\000\000\000\
\011\000\000\000\177\000\000\000\000\000\000\000\111\000\000\000\
\000\000\137\000\137\000\137\000\137\000\137\000\137\000\137\000\
\137\000\000\000\000\000\011\000\137\000\137\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\165\000\165\000\000\000\
\165\000\165\000\165\000\000\000\165\000\000\000\165\000\165\000\
\165\000\136\000\000\000\000\000\165\000\165\000\165\000\165\000\
\165\000\011\000\000\000\165\000\165\000\165\000\165\000\165\000\
\165\000\165\000\165\000\165\000\165\000\165\000\165\000\165\000\
\165\000\165\000\165\000\165\000\165\000\165\000\165\000\165\000\
\165\000\165\000\165\000\165\000\182\000\182\000\000\000\182\000\
\182\000\182\000\121\000\182\000\000\000\182\000\182\000\182\000\
\137\000\000\000\000\000\182\000\182\000\182\000\182\000\182\000\
\000\000\000\000\182\000\182\000\182\000\182\000\182\000\182\000\
\182\000\182\000\182\000\182\000\182\000\182\000\182\000\182\000\
\182\000\182\000\182\000\182\000\182\000\182\000\182\000\182\000\
\182\000\182\000\182\000\000\000\000\000\112\000\000\000\000\000\
\000\000\000\000\000\000\000\000\147\000\165\000\147\000\000\000\
\147\000\000\000\000\000\000\000\147\000\147\000\000\000\000\000\
\000\000\000\000\000\000\000\000\147\000\147\000\147\000\000\000\
\165\000\147\000\147\000\147\000\147\000\147\000\147\000\147\000\
\147\000\147\000\147\000\147\000\147\000\113\000\147\000\147\000\
\147\000\147\000\147\000\147\000\147\000\147\000\147\000\147\000\
\147\000\147\000\000\000\152\000\182\000\152\000\165\000\152\000\
\000\000\000\000\000\000\152\000\152\000\000\000\000\000\000\000\
\000\000\000\000\000\000\152\000\152\000\152\000\000\000\182\000\
\152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
\152\000\152\000\152\000\152\000\000\000\152\000\152\000\152\000\
\152\000\152\000\152\000\152\000\152\000\152\000\152\000\152\000\
\152\000\000\000\000\000\114\000\000\000\182\000\000\000\000\000\
\000\000\000\000\145\000\147\000\145\000\000\000\145\000\000\000\
\000\000\000\000\145\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\145\000\000\000\147\000\000\000\
\145\000\145\000\145\000\145\000\145\000\145\000\145\000\145\000\
\145\000\145\000\145\000\115\000\145\000\145\000\145\000\145\000\
\145\000\145\000\145\000\145\000\145\000\145\000\145\000\145\000\
\000\000\111\000\152\000\111\000\147\000\111\000\000\000\000\000\
\000\000\111\000\111\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\111\000\000\000\152\000\111\000\111\000\
\111\000\111\000\111\000\111\000\111\000\111\000\111\000\111\000\
\111\000\111\000\000\000\111\000\111\000\111\000\111\000\111\000\
\111\000\111\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\116\000\000\000\152\000\134\004\135\004\136\004\137\004\
\138\004\145\000\000\000\000\000\139\004\140\004\141\004\142\004\
\143\004\144\004\145\004\146\004\147\004\148\004\149\004\000\000\
\000\000\000\000\000\000\000\000\145\000\121\000\000\000\121\000\
\000\000\121\000\000\000\000\000\000\000\121\000\121\000\000\000\
\000\000\117\000\000\000\000\000\000\000\000\000\000\000\121\000\
\000\000\000\000\121\000\121\000\121\000\121\000\121\000\121\000\
\111\000\000\000\145\000\000\000\000\000\000\000\000\000\121\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\112\000\000\000\112\000\111\000\112\000\000\000\000\000\000\000\
\112\000\112\000\000\000\000\000\119\000\000\000\000\000\000\000\
\000\000\000\000\112\000\000\000\000\000\112\000\112\000\112\000\
\112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
\112\000\111\000\112\000\112\000\112\000\112\000\112\000\000\000\
\113\000\000\000\113\000\000\000\113\000\000\000\000\000\000\000\
\113\000\113\000\000\000\000\000\122\000\000\000\000\000\000\000\
\000\000\000\000\113\000\000\000\121\000\113\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
\113\000\000\000\113\000\113\000\113\000\113\000\113\000\121\000\
\124\000\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\000\000\000\000\092\001\093\001\094\001\095\001\096\001\
\097\001\098\001\099\001\100\001\101\001\102\001\114\000\112\000\
\114\000\000\000\114\000\000\000\092\000\121\000\114\000\114\000\
\000\000\000\000\000\000\000\000\000\000\000\000\099\000\000\000\
\114\000\000\000\112\000\114\000\114\000\114\000\114\000\114\000\
\114\000\114\000\114\000\114\000\114\000\114\000\114\000\000\000\
\114\000\114\000\114\000\000\000\000\000\000\000\115\000\113\000\
\115\000\000\000\115\000\000\000\000\000\000\000\115\000\115\000\
\112\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\115\000\000\000\113\000\115\000\115\000\115\000\115\000\115\000\
\115\000\115\000\115\000\115\000\115\000\115\000\115\000\000\000\
\115\000\115\000\115\000\000\000\000\000\000\000\131\004\132\004\
\133\004\134\004\135\004\136\004\137\004\138\004\000\000\000\000\
\113\000\139\004\140\004\141\004\142\004\143\004\144\004\145\004\
\146\004\147\004\148\004\149\004\116\000\114\000\116\000\000\000\
\116\000\000\000\000\000\000\000\116\000\116\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\116\000\000\000\
\114\000\116\000\116\000\116\000\116\000\116\000\116\000\116\000\
\116\000\116\000\116\000\116\000\116\000\000\000\116\000\116\000\
\116\000\000\000\000\000\000\000\117\000\115\000\117\000\000\000\
\117\000\000\000\000\000\000\000\117\000\117\000\114\000\000\000\
\000\000\000\000\000\000\000\000\246\000\000\000\117\000\000\000\
\115\000\117\000\117\000\117\000\117\000\117\000\117\000\117\000\
\117\000\117\000\117\000\117\000\117\000\000\000\117\000\117\000\
\117\000\000\000\000\000\000\000\000\000\000\000\000\000\119\000\
\000\000\119\000\000\000\119\000\000\000\000\000\115\000\119\000\
\119\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\119\000\000\000\116\000\119\000\119\000\119\000\119\000\
\119\000\119\000\119\000\119\000\119\000\119\000\102\002\000\000\
\000\000\119\000\000\000\000\000\000\000\241\001\116\000\122\000\
\000\000\122\000\000\000\122\000\000\000\000\000\241\001\122\000\
\122\000\000\000\000\000\000\000\241\001\000\000\182\000\000\000\
\000\000\122\000\236\000\117\000\122\000\122\000\122\000\122\000\
\122\000\122\000\122\000\124\000\116\000\124\000\000\000\124\000\
\122\000\122\000\000\000\124\000\124\000\000\000\117\000\000\000\
\000\000\000\000\000\000\000\000\238\000\124\000\000\000\239\000\
\124\000\124\000\124\000\124\000\000\000\000\000\000\000\092\000\
\000\000\092\000\000\000\092\000\240\000\124\000\119\000\092\000\
\092\000\099\000\000\000\099\000\117\000\099\000\000\000\000\000\
\000\000\099\000\099\000\000\000\092\000\092\000\092\000\000\000\
\102\002\119\000\000\000\000\000\000\000\000\000\099\000\099\000\
\099\000\092\000\000\000\000\000\000\000\000\000\000\000\000\000\
\241\000\000\000\000\000\099\000\000\000\000\000\122\000\000\000\
\000\000\102\002\000\000\000\000\000\000\000\000\044\000\119\000\
\000\000\102\002\000\000\000\000\000\000\000\000\000\000\000\000\
\241\000\122\000\000\000\000\000\000\000\102\002\000\000\102\002\
\000\000\102\002\124\000\000\000\000\000\000\000\000\000\054\000\
\000\000\151\000\000\000\000\000\000\000\000\000\000\000\055\000\
\000\000\000\000\000\000\000\000\000\000\124\000\000\000\122\000\
\000\000\000\000\000\000\063\000\000\000\064\000\092\000\065\000\
\000\000\000\000\000\000\000\000\155\000\000\000\000\000\000\000\
\099\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\092\000\000\000\124\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\099\000\000\000\000\000\000\000\000\000\
\000\000\246\000\246\000\246\000\246\000\246\000\000\000\000\000\
\000\000\246\000\246\000\000\000\246\000\246\000\246\000\092\000\
\246\000\246\000\000\000\000\000\246\000\000\000\000\000\000\000\
\000\000\099\000\246\000\246\000\246\000\246\000\246\000\000\000\
\000\000\000\000\246\000\246\000\000\000\000\000\246\000\000\000\
\246\000\000\000\000\000\246\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\246\000\246\000\
\246\000\069\000\000\000\000\000\000\000\246\000\246\000\246\000\
\246\000\246\000\246\000\246\000\246\000\246\000\246\000\246\000\
\246\000\246\000\246\000\246\000\246\000\246\000\246\000\246\000\
\246\000\246\000\246\000\246\000\246\000\246\000\246\000\246\000\
\000\000\246\000\246\000\246\000\246\000\246\000\246\000\246\000\
\246\000\246\000\246\000\000\000\246\000\246\000\246\000\246\000\
\246\000\246\000\246\000\246\000\000\000\138\004\246\000\246\000\
\246\000\139\004\140\004\141\004\142\004\143\004\144\004\145\004\
\146\004\147\004\148\004\149\004\000\000\246\000\246\000\246\000\
\000\000\246\000\246\000\246\000\000\000\246\000\000\000\000\000\
\000\000\246\000\000\000\246\000\000\000\246\000\246\000\246\000\
\246\000\246\000\246\000\246\000\246\000\000\000\246\000\246\000\
\000\000\246\000\000\000\246\000\246\000\246\000\246\000\246\000\
\246\000\246\000\246\000\000\000\246\000\241\000\241\000\241\000\
\241\000\241\000\000\000\000\000\000\000\241\000\241\000\000\000\
\241\000\241\000\241\000\000\000\241\000\241\000\000\000\000\000\
\241\000\000\000\000\000\000\000\000\000\000\000\241\000\241\000\
\241\000\241\000\241\000\000\000\000\000\000\000\241\000\241\000\
\000\000\000\000\241\000\194\000\241\000\000\000\000\000\241\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\241\000\241\000\241\000\000\000\000\000\000\000\
\000\000\241\000\241\000\241\000\241\000\241\000\241\000\241\000\
\241\000\241\000\241\000\241\000\241\000\241\000\241\000\241\000\
\241\000\241\000\241\000\241\000\241\000\241\000\241\000\241\000\
\241\000\241\000\241\000\241\000\000\000\241\000\000\000\241\000\
\241\000\241\000\241\000\241\000\241\000\241\000\241\000\000\000\
\241\000\241\000\241\000\241\000\241\000\241\000\241\000\241\000\
\000\000\000\000\241\000\241\000\241\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\241\000\241\000\241\000\000\000\241\000\241\000\241\000\
\000\000\241\000\000\000\000\000\000\000\241\000\000\000\241\000\
\000\000\241\000\241\000\241\000\241\000\241\000\241\000\241\000\
\241\000\000\000\241\000\241\000\000\000\241\000\000\000\241\000\
\241\000\241\000\241\000\241\000\241\000\241\000\241\000\011\000\
\241\000\012\000\013\000\000\000\000\000\000\000\000\000\000\000\
\000\000\014\000\088\001\089\001\090\001\091\001\000\000\015\000\
\092\001\093\001\094\001\095\001\096\001\097\001\098\001\099\001\
\100\001\101\001\102\001\016\000\000\000\182\000\000\000\000\000\
\013\000\060\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\015\000\000\000\122\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\000\000\043\000\000\000\000\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\000\000\044\000\
\000\000\000\000\045\000\046\000\047\000\048\000\000\000\000\000\
\000\000\042\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\049\000\050\000\051\000\000\000\052\000\053\000\
\054\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\055\000\000\000\056\000\057\000\058\000\059\000\060\000\061\000\
\062\000\000\000\000\000\000\000\063\000\000\000\064\000\000\000\
\065\000\066\000\067\000\012\000\013\000\053\000\000\000\068\000\
\151\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\
\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\182\000\
\000\000\000\000\013\000\155\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\000\
\000\000\122\000\000\000\000\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\025\000\026\000\027\000\028\000\
\029\000\030\000\031\000\032\000\033\000\034\000\035\000\036\000\
\037\000\038\000\039\000\040\000\041\000\042\000\000\000\043\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\000\000\000\000\000\000\000\000\193\000\046\000\047\000\048\000\
\000\000\000\000\000\000\042\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\049\000\000\000\051\000\000\000\
\052\000\053\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\111\000\112\000\113\000\114\000\115\000\000\000\
\000\000\000\000\116\000\182\000\004\001\000\000\013\000\119\000\
\000\000\023\003\000\000\066\000\067\000\014\000\000\000\053\000\
\000\000\068\000\151\000\015\000\121\000\122\000\123\000\124\000\
\000\000\000\000\000\000\125\000\126\000\000\000\000\000\000\000\
\000\000\128\000\000\000\000\000\129\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\155\000\000\000\130\000\
\131\000\132\000\000\000\000\000\000\000\000\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\032\000\033\000\034\000\
\035\000\036\000\037\000\038\000\039\000\040\000\041\000\042\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\146\000\147\000\148\000\005\001\149\000\000\000\000\000\046\000\
\047\000\048\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\049\000\000\000\
\051\000\082\001\052\000\053\000\000\000\000\000\151\000\083\001\
\084\001\085\001\086\001\087\001\088\001\089\001\090\001\091\001\
\000\000\000\000\092\001\093\001\094\001\095\001\096\001\097\001\
\098\001\099\001\100\001\101\001\102\001\066\000\067\000\000\000\
\000\000\155\000\156\000\111\000\112\000\113\000\114\000\115\000\
\000\000\006\001\000\000\116\000\182\000\004\001\000\000\013\000\
\119\000\000\000\000\000\000\000\000\000\000\000\014\000\000\000\
\000\000\000\000\000\000\000\000\015\000\121\000\122\000\123\000\
\124\000\000\000\000\000\000\000\125\000\126\000\000\000\000\000\
\000\000\000\000\128\000\000\000\000\000\129\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\130\000\131\000\132\000\000\000\000\000\000\000\000\000\017\000\
\018\000\019\000\020\000\021\000\022\000\023\000\024\000\025\000\
\026\000\027\000\028\000\029\000\030\000\031\000\032\000\033\000\
\034\000\035\000\036\000\037\000\038\000\039\000\040\000\041\000\
\042\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\146\000\147\000\148\000\000\000\149\000\000\000\000\000\
\046\000\047\000\048\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\049\000\
\000\000\051\000\000\000\052\000\053\000\000\000\000\000\151\000\
\132\004\133\004\134\004\135\004\136\004\137\004\138\004\000\000\
\000\000\000\000\139\004\140\004\141\004\142\004\143\004\144\004\
\145\004\146\004\147\004\148\004\149\004\000\000\066\000\067\000\
\000\000\000\000\155\000\156\000\111\000\112\000\113\000\114\000\
\115\000\000\000\152\001\000\000\116\000\182\000\004\001\000\000\
\013\000\119\000\000\000\000\000\000\000\000\000\000\000\014\000\
\000\000\000\000\000\000\000\000\000\000\015\000\121\000\122\000\
\123\000\124\000\000\000\000\000\000\000\125\000\126\000\000\000\
\000\000\000\000\000\000\128\000\000\000\000\000\129\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\130\000\131\000\132\000\000\000\000\000\000\000\000\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\031\000\032\000\
\033\000\034\000\035\000\036\000\037\000\038\000\039\000\040\000\
\041\000\042\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\146\000\147\000\148\000\000\000\149\000\000\000\
\000\000\046\000\047\000\048\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\049\000\000\000\051\000\000\000\052\000\053\000\000\000\000\000\
\151\000\216\002\217\002\218\002\219\002\220\002\221\002\222\002\
\223\002\224\002\225\002\226\002\227\002\228\002\229\002\230\002\
\231\002\232\002\233\002\234\002\235\002\000\000\000\000\066\000\
\067\000\000\000\000\000\155\000\156\000\111\000\112\000\113\000\
\114\000\115\000\000\000\006\001\000\000\116\000\182\000\004\001\
\000\000\013\000\119\000\000\000\000\000\000\000\000\000\000\000\
\014\000\000\000\000\000\000\000\000\000\000\000\015\000\121\000\
\122\000\123\000\124\000\000\000\000\000\000\000\125\000\126\000\
\000\000\000\000\000\000\000\000\128\000\000\000\000\000\129\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\130\000\131\000\132\000\000\000\000\000\000\000\
\000\000\017\000\018\000\019\000\020\000\021\000\022\000\023\000\
\024\000\025\000\026\000\027\000\028\000\029\000\030\000\031\000\
\032\000\033\000\034\000\035\000\036\000\037\000\038\000\039\000\
\040\000\041\000\042\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\146\000\147\000\148\000\000\000\149\000\
\000\000\000\000\046\000\047\000\048\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\049\000\000\000\051\000\000\000\052\000\053\000\000\000\
\000\000\151\000\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\000\000\000\000\092\001\093\001\094\001\095\001\096\001\
\097\001\098\001\099\001\100\001\101\001\102\001\000\000\000\000\
\066\000\067\000\000\000\000\000\155\000\156\000\111\000\112\000\
\113\000\114\000\115\000\000\000\030\004\000\000\116\000\117\000\
\000\000\012\000\118\001\119\000\000\000\120\000\000\000\183\001\
\000\000\014\000\184\001\000\000\000\000\000\000\000\000\015\000\
\121\000\122\000\123\000\124\000\000\000\000\000\000\000\125\000\
\126\000\000\000\000\000\127\000\000\000\128\000\000\000\000\000\
\129\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\130\000\131\000\132\000\000\000\000\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\133\000\000\000\134\000\000\000\
\135\000\136\000\137\000\138\000\185\001\140\000\141\000\142\000\
\000\000\143\000\144\000\145\000\146\000\147\000\148\000\044\000\
\149\000\000\000\000\000\046\000\047\000\048\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\049\000\186\001\051\000\000\000\052\000\053\000\
\054\000\000\000\151\000\187\001\188\001\000\000\000\000\000\000\
\055\000\000\000\056\000\057\000\058\000\059\000\060\000\061\000\
\062\000\152\000\000\000\000\000\063\000\000\000\064\000\000\000\
\065\000\066\000\067\000\153\000\154\000\155\000\156\000\068\000\
\000\000\157\000\111\000\112\000\113\000\114\000\115\000\000\000\
\000\000\000\000\116\000\117\000\000\000\012\000\118\001\119\000\
\000\000\120\000\000\000\183\001\000\000\014\000\184\001\000\000\
\000\000\000\000\000\000\015\000\121\000\122\000\123\000\124\000\
\000\000\000\000\000\000\125\000\126\000\000\000\000\000\127\000\
\000\000\128\000\000\000\000\000\129\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\130\000\
\131\000\132\000\000\000\000\000\000\000\000\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\032\000\033\000\034\000\
\035\000\036\000\037\000\038\000\039\000\040\000\041\000\042\000\
\133\000\000\000\134\000\000\000\135\000\136\000\137\000\138\000\
\185\001\140\000\141\000\142\000\000\000\143\000\144\000\145\000\
\146\000\147\000\148\000\044\000\149\000\000\000\000\000\046\000\
\047\000\048\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\049\000\186\001\
\051\000\000\000\052\000\053\000\054\000\000\000\151\000\000\000\
\188\001\000\000\000\000\000\000\055\000\000\000\056\000\057\000\
\058\000\059\000\060\000\061\000\062\000\152\000\000\000\000\000\
\063\000\000\000\064\000\000\000\065\000\066\000\067\000\153\000\
\154\000\155\000\156\000\068\000\000\000\157\000\232\000\232\000\
\232\000\232\000\232\000\000\000\000\000\000\000\232\000\232\000\
\000\000\232\000\232\000\232\000\000\000\232\000\000\000\000\000\
\000\000\232\000\000\000\000\000\000\000\000\000\000\000\232\000\
\232\000\232\000\232\000\232\000\000\000\000\000\000\000\232\000\
\232\000\000\000\000\000\232\000\000\000\232\000\000\000\000\000\
\232\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\232\000\232\000\232\000\000\000\000\000\
\000\000\000\000\232\000\232\000\232\000\232\000\232\000\232\000\
\232\000\232\000\232\000\232\000\232\000\232\000\232\000\232\000\
\232\000\232\000\232\000\232\000\232\000\232\000\232\000\232\000\
\232\000\232\000\232\000\232\000\232\000\000\000\232\000\000\000\
\232\000\232\000\232\000\232\000\232\000\232\000\232\000\232\000\
\000\000\232\000\232\000\232\000\232\000\232\000\232\000\232\000\
\232\000\000\000\000\000\232\000\232\000\232\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\232\000\232\000\232\000\000\000\232\000\232\000\
\232\000\000\000\232\000\000\000\000\000\000\000\118\002\000\000\
\232\000\000\000\232\000\232\000\232\000\232\000\232\000\232\000\
\232\000\232\000\000\000\000\000\232\000\000\000\232\000\000\000\
\232\000\232\000\232\000\232\000\232\000\232\000\232\000\232\000\
\000\000\232\000\231\000\231\000\231\000\231\000\231\000\000\000\
\000\000\000\000\231\000\231\000\000\000\231\000\231\000\231\000\
\000\000\231\000\000\000\000\000\000\000\231\000\000\000\000\000\
\000\000\000\000\000\000\231\000\231\000\231\000\231\000\231\000\
\000\000\000\000\000\000\231\000\231\000\000\000\000\000\231\000\
\000\000\231\000\000\000\000\000\231\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\231\000\
\231\000\231\000\000\000\000\000\000\000\000\000\231\000\231\000\
\231\000\231\000\231\000\231\000\231\000\231\000\231\000\231\000\
\231\000\231\000\231\000\231\000\231\000\231\000\231\000\231\000\
\231\000\231\000\231\000\231\000\231\000\231\000\231\000\231\000\
\231\000\000\000\231\000\000\000\231\000\231\000\231\000\231\000\
\231\000\231\000\231\000\231\000\000\000\231\000\231\000\231\000\
\231\000\231\000\231\000\231\000\231\000\000\000\000\000\231\000\
\231\000\231\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\231\000\231\000\
\231\000\000\000\231\000\231\000\231\000\000\000\231\000\000\000\
\000\000\000\000\119\002\000\000\231\000\000\000\231\000\231\000\
\231\000\231\000\231\000\231\000\231\000\231\000\000\000\000\000\
\231\000\000\000\231\000\000\000\231\000\231\000\231\000\231\000\
\231\000\231\000\231\000\231\000\000\000\231\000\233\000\233\000\
\233\000\233\000\233\000\000\000\000\000\000\000\233\000\233\000\
\000\000\233\000\233\000\233\000\000\000\233\000\000\000\000\000\
\000\000\233\000\000\000\000\000\000\000\000\000\000\000\233\000\
\233\000\233\000\233\000\233\000\000\000\000\000\000\000\233\000\
\233\000\000\000\000\000\233\000\000\000\233\000\000\000\000\000\
\233\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\233\000\233\000\233\000\000\000\000\000\
\000\000\000\000\233\000\233\000\233\000\233\000\233\000\233\000\
\233\000\233\000\233\000\233\000\233\000\233\000\233\000\233\000\
\233\000\233\000\233\000\233\000\233\000\233\000\233\000\233\000\
\233\000\233\000\233\000\233\000\233\000\000\000\233\000\000\000\
\233\000\233\000\233\000\233\000\233\000\233\000\233\000\233\000\
\000\000\233\000\233\000\233\000\233\000\233\000\233\000\233\000\
\233\000\000\000\000\000\233\000\233\000\233\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\233\000\233\000\233\000\000\000\233\000\233\000\
\233\000\000\000\233\000\000\000\000\000\000\000\123\002\000\000\
\233\000\000\000\233\000\233\000\233\000\233\000\233\000\233\000\
\233\000\233\000\000\000\000\000\233\000\000\000\233\000\000\000\
\233\000\233\000\233\000\233\000\233\000\233\000\233\000\233\000\
\000\000\233\000\111\000\112\000\113\000\114\000\115\000\000\000\
\000\000\000\000\116\000\117\000\000\000\012\000\118\001\119\000\
\000\000\120\000\000\000\000\000\000\000\014\000\000\000\000\000\
\000\000\000\000\000\000\015\000\121\000\122\000\123\000\124\000\
\000\000\000\000\000\000\125\000\126\000\000\000\000\000\127\000\
\000\000\128\000\000\000\000\000\129\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\130\000\
\131\000\132\000\000\000\000\000\000\000\000\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\032\000\033\000\034\000\
\035\000\036\000\037\000\038\000\039\000\040\000\041\000\042\000\
\133\000\000\000\134\000\000\000\135\000\119\001\137\000\138\000\
\139\000\140\000\141\000\142\000\000\000\143\000\144\000\120\001\
\146\000\147\000\148\000\044\000\149\000\000\000\000\000\046\000\
\047\000\048\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\049\000\150\000\
\051\000\000\000\052\000\053\000\054\000\000\000\151\000\000\000\
\000\000\000\000\000\000\000\000\055\000\000\000\056\000\057\000\
\058\000\059\000\060\000\061\000\062\000\152\000\000\000\000\000\
\063\000\000\000\064\000\000\000\065\000\066\000\067\000\153\000\
\154\000\155\000\156\000\068\000\000\000\157\000\111\000\112\000\
\113\000\114\000\115\000\000\000\000\000\000\000\116\000\117\000\
\000\000\000\000\118\001\119\000\000\000\120\000\000\000\000\000\
\000\000\014\000\000\000\000\000\000\000\000\000\000\000\015\000\
\121\000\122\000\123\000\124\000\000\000\000\000\000\000\125\000\
\126\000\000\000\000\000\127\000\000\000\128\000\000\000\000\000\
\129\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\130\000\131\000\132\000\000\000\000\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\133\000\000\000\134\000\000\000\
\135\000\136\000\137\000\138\000\139\000\140\000\141\000\142\000\
\000\000\143\000\144\000\145\000\146\000\147\000\148\000\000\000\
\149\000\000\000\000\000\046\000\047\000\048\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\049\000\150\000\051\000\000\000\052\000\053\000\
\000\000\000\000\151\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\152\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\066\000\067\000\153\000\154\000\155\000\156\000\068\000\
\000\000\157\000\111\000\112\000\113\000\114\000\115\000\000\000\
\000\000\000\000\116\000\117\000\000\000\000\000\118\000\119\000\
\000\000\120\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\121\000\122\000\123\000\124\000\
\000\000\000\000\000\000\125\000\126\000\000\000\000\000\127\000\
\000\000\128\000\000\000\000\000\129\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\130\000\
\131\000\132\000\000\000\000\000\000\000\182\000\000\000\000\000\
\013\000\195\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\015\000\000\000\122\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\133\000\000\000\134\000\000\000\135\000\136\000\137\000\138\000\
\139\000\140\000\141\000\142\000\000\000\143\000\144\000\145\000\
\146\000\147\000\148\000\000\000\149\000\000\000\000\000\000\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\000\000\150\000\
\000\000\000\000\000\000\000\000\000\000\000\000\151\000\000\000\
\000\000\042\000\000\000\000\000\000\000\000\000\056\000\111\000\
\112\000\113\000\114\000\115\000\000\000\152\000\000\000\116\000\
\117\000\000\000\000\000\118\000\119\000\000\000\120\000\153\000\
\154\000\155\000\156\000\000\000\000\000\157\000\000\000\000\000\
\000\000\121\000\122\000\123\000\124\000\000\000\000\000\000\000\
\125\000\126\000\000\000\000\000\127\000\053\000\128\000\000\000\
\151\000\129\000\000\000\000\000\000\000\000\000\133\004\134\004\
\135\004\136\004\137\004\138\004\130\000\131\000\132\000\139\004\
\140\004\141\004\142\004\143\004\144\004\145\004\146\004\147\004\
\148\004\149\004\000\000\155\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\133\000\000\000\134\000\
\000\000\135\000\136\000\137\000\138\000\139\000\140\000\141\000\
\142\000\000\000\143\000\144\000\145\000\146\000\147\000\148\000\
\000\000\149\000\000\000\000\000\000\000\000\000\111\000\112\000\
\113\000\114\000\115\000\000\000\000\000\000\000\116\000\182\000\
\000\000\000\000\013\000\119\000\150\000\000\000\000\000\000\000\
\000\000\014\000\000\000\151\000\000\000\000\000\000\000\015\000\
\121\000\122\000\123\000\124\000\000\000\000\000\000\000\125\000\
\126\000\000\000\152\000\127\000\000\000\128\000\000\000\000\000\
\129\000\000\000\000\000\000\000\153\000\154\000\155\000\156\000\
\000\000\000\000\157\000\130\000\131\000\132\000\000\000\000\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\000\000\000\000\000\000\237\002\
\000\000\000\000\237\002\237\002\000\000\237\002\000\000\000\000\
\000\000\000\000\000\000\000\000\146\000\147\000\148\000\000\000\
\149\000\237\002\000\000\046\000\047\000\048\000\000\000\000\000\
\000\000\000\000\237\002\000\000\000\000\237\002\000\000\000\000\
\237\002\000\000\049\000\000\000\051\000\000\000\052\000\053\000\
\000\000\000\000\151\000\000\000\000\000\237\002\000\000\000\000\
\111\000\112\000\113\000\114\000\115\000\000\000\000\000\000\000\
\116\000\182\000\000\000\000\000\013\000\119\000\000\000\000\000\
\000\000\066\000\067\000\014\000\000\000\155\000\156\000\068\000\
\000\000\015\000\121\000\122\000\123\000\124\000\000\000\000\000\
\000\000\125\000\126\000\000\000\000\000\000\000\000\000\128\000\
\000\000\000\000\129\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\130\000\131\000\132\000\
\000\000\237\002\000\000\000\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\025\000\026\000\027\000\028\000\
\029\000\030\000\237\002\000\000\000\000\000\000\000\000\000\000\
\037\000\038\000\039\000\040\000\041\000\042\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\237\002\146\000\147\000\
\148\000\000\000\149\000\000\000\000\000\046\000\047\000\048\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\049\000\000\000\051\000\000\000\
\000\000\053\000\000\000\000\000\151\000\000\000\000\000\000\000\
\000\000\111\000\112\000\113\000\114\000\115\000\000\000\000\000\
\000\000\116\000\045\003\000\000\000\000\199\000\119\000\000\000\
\249\001\000\000\183\001\066\000\067\000\184\001\000\000\155\000\
\156\000\000\000\000\000\121\000\122\000\123\000\124\000\000\000\
\000\000\000\000\125\000\126\000\000\000\000\000\000\000\000\000\
\128\000\000\000\000\000\129\000\111\000\112\000\113\000\114\000\
\115\000\000\000\000\000\000\000\116\000\182\000\130\000\131\000\
\132\000\119\000\000\000\120\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\121\000\122\000\
\123\000\124\000\000\000\000\000\000\000\125\000\126\000\000\000\
\000\000\000\000\000\000\128\000\000\000\000\000\129\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\130\000\131\000\132\000\000\000\000\000\000\000\146\000\
\147\000\148\000\000\000\149\000\000\000\000\000\111\000\112\000\
\113\000\114\000\115\000\000\000\000\000\000\000\116\000\182\000\
\000\000\000\000\000\000\119\000\000\000\000\000\000\000\000\000\
\252\002\000\000\000\000\000\000\000\000\151\000\000\000\000\000\
\121\000\122\000\123\000\124\000\000\000\000\000\000\000\125\000\
\126\000\000\000\146\000\147\000\148\000\128\000\149\000\000\000\
\129\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\155\000\156\000\000\000\130\000\131\000\132\000\000\000\000\000\
\000\000\086\001\087\001\088\001\089\001\090\001\091\001\000\000\
\151\000\092\001\093\001\094\001\095\001\096\001\097\001\098\001\
\099\001\100\001\101\001\102\001\000\000\000\000\000\000\000\000\
\111\000\112\000\113\000\114\000\115\000\000\000\000\000\000\000\
\116\000\182\000\000\000\155\000\156\000\119\000\000\000\249\001\
\000\000\000\000\000\000\000\000\146\000\147\000\148\000\000\000\
\149\000\000\000\121\000\122\000\123\000\124\000\000\000\000\000\
\000\000\125\000\126\000\000\000\000\000\000\000\000\000\128\000\
\000\000\000\000\129\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\151\000\000\000\000\000\130\000\131\000\132\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\111\000\112\000\113\000\114\000\115\000\000\000\
\000\000\000\000\116\000\182\000\000\000\155\000\156\000\119\000\
\000\000\000\000\000\000\000\000\076\003\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\121\000\122\000\123\000\124\000\
\000\000\000\000\000\000\125\000\126\000\000\000\146\000\147\000\
\148\000\128\000\149\000\000\000\129\000\111\000\112\000\113\000\
\114\000\115\000\000\000\000\000\000\000\116\000\182\000\130\000\
\131\000\132\000\119\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\151\000\000\000\000\000\121\000\
\122\000\123\000\124\000\000\000\000\000\000\000\125\000\126\000\
\000\000\000\000\127\000\000\000\128\000\000\000\000\000\129\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\155\000\
\156\000\000\000\130\000\131\000\132\000\000\000\000\000\000\000\
\146\000\147\000\148\000\000\000\149\000\000\000\000\000\111\000\
\112\000\113\000\114\000\115\000\000\000\000\000\000\000\116\000\
\182\000\000\000\000\000\000\000\119\000\000\000\000\000\000\000\
\000\000\179\003\000\000\000\000\000\000\000\000\151\000\000\000\
\000\000\121\000\122\000\123\000\124\000\000\000\000\000\000\000\
\125\000\126\000\000\000\146\000\147\000\148\000\128\000\149\000\
\182\000\129\000\000\000\000\000\236\000\000\000\000\000\000\000\
\000\000\155\000\156\000\000\000\130\000\131\000\132\000\000\000\
\000\000\000\000\122\000\000\000\000\000\000\000\000\000\000\000\
\000\000\151\000\000\000\000\000\000\000\000\000\238\000\000\000\
\000\000\239\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\111\000\112\000\113\000\114\000\115\000\240\000\000\000\
\000\000\116\000\182\000\000\000\155\000\156\000\119\000\019\004\
\000\000\000\000\000\000\000\000\000\000\146\000\147\000\148\000\
\000\000\149\000\000\000\121\000\122\000\123\000\124\000\000\000\
\000\000\000\000\125\000\126\000\000\000\000\000\000\000\000\000\
\128\000\000\000\000\000\129\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\151\000\000\000\000\000\130\000\131\000\
\132\000\000\000\000\000\000\000\111\000\112\000\113\000\114\000\
\115\000\000\000\241\000\000\000\116\000\182\000\000\000\000\000\
\000\000\119\000\021\004\000\000\000\000\000\000\155\000\156\000\
\000\000\000\000\000\000\151\000\000\000\000\000\121\000\122\000\
\123\000\124\000\000\000\000\000\000\000\125\000\126\000\000\000\
\000\000\000\000\000\000\128\000\000\000\000\000\129\000\146\000\
\147\000\148\000\000\000\149\000\000\000\000\000\155\000\000\000\
\000\000\130\000\131\000\132\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\151\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\111\000\112\000\113\000\
\114\000\115\000\000\000\000\000\000\000\116\000\182\000\000\000\
\000\000\000\000\119\000\000\000\000\000\000\000\000\000\000\000\
\155\000\156\000\146\000\147\000\148\000\000\000\149\000\121\000\
\122\000\123\000\124\000\000\000\000\000\000\000\125\000\126\000\
\000\000\000\000\000\000\000\000\128\000\000\000\000\000\129\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\151\000\000\000\130\000\131\000\132\000\000\000\000\000\000\000\
\111\000\112\000\113\000\114\000\115\000\000\000\000\000\000\000\
\116\000\182\000\000\000\000\000\000\000\119\000\000\000\000\000\
\000\000\066\001\000\000\155\000\156\000\000\000\000\000\000\000\
\000\000\000\000\121\000\122\000\123\000\124\000\000\000\000\000\
\000\000\125\000\126\000\000\000\000\000\000\000\000\000\128\000\
\000\000\000\000\129\000\146\000\147\000\148\000\000\000\149\000\
\000\000\000\000\000\000\000\000\000\000\130\000\131\000\132\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\151\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\111\000\112\000\113\000\114\000\115\000\000\000\000\000\
\000\000\116\000\182\000\000\000\000\000\000\000\119\000\000\000\
\169\003\000\000\000\000\000\000\155\000\156\000\146\000\000\000\
\148\000\000\000\149\000\121\000\122\000\123\000\124\000\000\000\
\000\000\000\000\125\000\126\000\000\000\000\000\000\000\000\000\
\128\000\000\000\000\000\129\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\151\000\000\000\130\000\131\000\
\132\000\000\000\000\000\000\000\111\000\112\000\113\000\114\000\
\115\000\000\000\000\000\000\000\116\000\182\000\000\000\000\000\
\000\000\119\000\000\000\249\001\000\000\000\000\000\000\155\000\
\156\000\000\000\000\000\000\000\000\000\000\000\121\000\122\000\
\123\000\124\000\000\000\000\000\000\000\125\000\126\000\000\000\
\000\000\000\000\000\000\128\000\000\000\000\000\129\000\146\000\
\000\000\148\000\000\000\149\000\000\000\000\000\000\000\000\000\
\000\000\130\000\131\000\132\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\151\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\111\000\112\000\113\000\
\114\000\115\000\000\000\000\000\000\000\116\000\182\000\000\000\
\000\000\000\000\119\000\000\000\000\000\000\000\000\000\000\000\
\155\000\156\000\146\000\000\000\148\000\000\000\149\000\121\000\
\122\000\123\000\124\000\000\000\000\000\000\000\125\000\126\000\
\000\000\000\000\000\000\000\000\128\000\000\000\000\000\129\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\151\000\000\000\130\000\131\000\132\000\000\000\204\001\000\000\
\000\000\000\000\204\001\204\001\000\000\204\001\204\001\204\001\
\000\000\000\000\000\000\204\001\000\000\000\000\000\000\000\000\
\204\001\000\000\000\000\155\000\156\000\000\000\000\000\000\000\
\000\000\000\000\204\001\000\000\204\001\000\000\000\000\204\001\
\000\000\000\000\000\000\000\000\000\000\204\001\000\000\000\000\
\000\000\000\000\000\000\146\000\204\001\148\000\202\001\149\000\
\000\000\000\000\202\001\202\001\000\000\202\001\202\001\202\001\
\000\000\000\000\000\000\202\001\000\000\000\000\000\000\000\000\
\202\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\151\000\202\001\000\000\202\001\000\000\000\000\202\001\
\000\000\000\000\000\000\000\000\000\000\202\001\000\000\000\000\
\000\000\203\001\000\000\000\000\202\001\203\001\203\001\000\000\
\203\001\203\001\203\001\000\000\155\000\156\000\203\001\000\000\
\204\001\000\000\204\001\203\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\203\001\000\000\203\001\
\000\000\204\001\203\001\000\000\000\000\204\001\000\000\000\000\
\203\001\206\001\000\000\000\000\000\000\206\001\206\001\203\001\
\206\001\206\001\206\001\000\000\000\000\000\000\206\001\000\000\
\000\000\000\000\000\000\206\001\204\001\000\000\204\001\000\000\
\202\001\000\000\202\001\204\001\000\000\206\001\000\000\206\001\
\000\000\000\000\206\001\000\000\000\000\000\000\000\000\000\000\
\206\001\202\001\000\000\000\000\201\001\202\001\000\000\206\001\
\201\001\201\001\000\000\201\001\201\001\201\001\000\000\000\000\
\000\000\201\001\000\000\000\000\000\000\000\000\201\001\000\000\
\000\000\000\000\000\000\203\001\202\001\203\001\202\001\000\000\
\201\001\000\000\201\001\202\001\000\000\201\001\000\000\000\000\
\000\000\000\000\000\000\201\001\203\001\000\000\000\000\205\001\
\203\001\000\000\201\001\205\001\205\001\000\000\205\001\205\001\
\205\001\000\000\000\000\000\000\205\001\000\000\000\000\000\000\
\000\000\205\001\000\000\206\001\000\000\206\001\000\000\203\001\
\000\000\203\001\000\000\205\001\000\000\205\001\203\001\000\000\
\205\001\000\000\000\000\000\000\206\001\000\000\205\001\000\000\
\206\001\000\000\013\000\000\000\000\000\205\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\000\
\000\000\000\000\000\000\000\000\000\000\000\000\201\001\206\001\
\201\001\206\001\000\000\000\000\000\000\000\000\206\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\201\001\
\000\000\000\000\000\000\201\001\000\000\000\000\000\000\000\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\000\000\205\001\201\001\205\001\201\001\011\000\161\001\000\000\
\013\000\201\001\162\001\042\000\000\000\163\001\000\000\014\000\
\000\000\000\000\205\001\000\000\000\000\015\000\205\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\034\002\000\000\000\000\000\000\164\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\205\001\000\000\205\001\
\000\000\165\001\000\000\000\000\205\001\000\000\000\000\053\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\031\000\032\000\
\033\000\034\000\035\000\036\000\037\000\038\000\039\000\040\000\
\041\000\042\000\192\004\193\004\194\004\195\004\196\004\197\004\
\198\004\199\004\200\004\201\004\202\004\203\004\204\004\205\004\
\206\004\207\004\208\004\209\004\210\004\044\000\000\000\000\000\
\000\000\046\000\047\000\048\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\049\000\000\000\051\000\000\000\052\000\053\000\054\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\055\000\000\000\
\056\000\057\000\058\000\059\000\060\000\061\000\062\000\000\000\
\000\000\000\000\063\000\000\000\064\000\000\000\065\000\066\000\
\067\000\000\000\000\000\083\001\000\000\035\002\083\001\083\001\
\000\000\000\000\000\000\083\001\000\000\083\001\000\000\000\000\
\000\000\000\000\000\000\083\001\000\000\083\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\012\000\083\001\
\000\000\083\001\000\000\000\000\083\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\083\001\000\000\000\000\000\000\000\000\083\001\083\001\
\083\001\083\001\083\001\083\001\083\001\083\001\083\001\083\001\
\083\001\083\001\083\001\083\001\083\001\083\001\083\001\083\001\
\083\001\083\001\083\001\083\001\083\001\083\001\083\001\083\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\083\001\
\083\001\083\001\000\000\012\000\013\000\083\001\000\000\000\000\
\000\000\000\000\000\000\014\000\000\000\000\000\083\001\000\000\
\083\001\015\000\083\001\083\001\000\000\000\000\083\001\000\000\
\000\000\000\000\083\001\000\000\000\000\018\002\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\083\001\083\001\000\000\
\000\000\083\001\000\000\083\001\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\025\000\026\000\027\000\028\000\
\029\000\030\000\031\000\032\000\033\000\034\000\035\000\036\000\
\037\000\038\000\039\000\040\000\041\000\042\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\044\000\000\000\000\000\000\000\046\000\047\000\048\000\
\019\002\020\002\021\002\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\022\002\000\000\049\000\000\000\051\000\000\000\
\052\000\053\000\054\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\055\000\000\000\056\000\057\000\058\000\059\000\
\060\000\061\000\062\000\000\000\000\000\000\000\063\000\000\000\
\064\000\000\000\065\000\066\000\067\000\000\000\000\000\089\001\
\000\000\068\000\089\001\089\001\000\000\000\000\000\000\089\001\
\000\000\089\001\000\000\000\000\089\001\000\000\000\000\089\001\
\000\000\089\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\089\001\000\000\000\000\
\089\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\089\001\000\000\000\000\
\000\000\000\000\089\001\089\001\089\001\089\001\089\001\089\001\
\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\
\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\
\089\001\089\001\089\001\089\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\089\001\089\001\089\001\000\000\000\000\
\000\000\089\001\000\000\089\001\000\000\000\000\089\001\089\001\
\000\000\000\000\089\001\000\000\089\001\089\001\089\001\089\001\
\000\000\000\000\089\001\089\001\000\000\089\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\089\001\
\000\000\089\001\000\000\000\000\089\001\000\000\000\000\000\000\
\000\000\089\001\089\001\000\000\000\000\089\001\000\000\000\000\
\000\000\089\001\000\000\000\000\000\000\000\000\089\001\089\001\
\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\
\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\
\089\001\089\001\089\001\089\001\089\001\089\001\089\001\089\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\089\001\
\089\001\089\001\000\000\012\000\013\000\089\001\000\000\000\000\
\029\003\000\000\000\000\014\000\000\000\000\000\089\001\000\000\
\089\001\015\000\089\001\089\001\000\000\000\000\089\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\089\001\089\001\000\000\
\000\000\089\001\000\000\000\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\025\000\026\000\027\000\028\000\
\029\000\030\000\031\000\032\000\033\000\034\000\035\000\036\000\
\037\000\038\000\039\000\040\000\041\000\042\000\000\000\043\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\193\000\046\000\047\000\048\000\
\000\000\012\000\013\000\000\000\000\000\000\000\183\003\000\000\
\000\000\014\000\000\000\000\000\049\000\000\000\051\000\015\000\
\052\000\053\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\066\000\067\000\000\000\000\000\000\000\
\000\000\068\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\000\000\043\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\193\000\046\000\047\000\048\000\000\000\012\000\
\013\000\000\000\000\000\000\000\200\003\000\000\000\000\014\000\
\000\000\000\000\049\000\000\000\051\000\015\000\052\000\053\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\066\000\067\000\000\000\000\000\000\000\000\000\068\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\031\000\032\000\
\033\000\034\000\035\000\036\000\037\000\038\000\039\000\040\000\
\041\000\042\000\000\000\043\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\193\000\046\000\047\000\048\000\000\000\012\000\013\000\000\000\
\000\000\000\000\044\004\000\000\000\000\014\000\000\000\000\000\
\049\000\000\000\051\000\015\000\052\000\053\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066\000\
\067\000\000\000\000\000\000\000\000\000\068\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\032\000\033\000\034\000\
\035\000\036\000\037\000\038\000\039\000\040\000\041\000\042\000\
\000\000\043\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\193\000\046\000\
\047\000\048\000\000\000\012\000\013\000\000\000\000\000\000\000\
\000\000\000\000\000\000\014\000\000\000\000\000\049\000\000\000\
\051\000\015\000\052\000\053\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\182\000\
\000\000\000\000\013\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\066\000\067\000\015\000\
\000\000\122\000\000\000\068\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\025\000\026\000\027\000\028\000\
\029\000\030\000\031\000\032\000\033\000\034\000\035\000\036\000\
\037\000\038\000\039\000\040\000\041\000\042\000\000\000\043\000\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\000\000\000\000\000\000\000\000\000\000\046\000\047\000\048\000\
\000\000\000\000\182\000\042\000\000\000\013\000\000\000\000\000\
\000\000\000\000\000\000\000\000\049\000\000\000\051\000\000\000\
\052\000\053\000\015\000\000\000\122\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\025\003\000\000\066\000\067\000\000\000\000\000\053\000\
\000\000\068\000\151\000\000\000\000\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\025\000\026\000\027\000\
\028\000\029\000\030\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\155\000\042\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\055\002\000\000\
\009\000\009\000\000\000\009\000\009\000\000\000\000\000\009\000\
\000\000\009\000\009\000\009\000\000\000\000\000\000\000\009\000\
\009\000\000\000\053\000\009\000\000\000\151\000\000\000\006\000\
\000\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\000\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\000\000\
\155\000\056\002\057\002\058\002\059\002\060\002\061\002\062\002\
\063\002\064\002\065\002\066\002\067\002\068\002\069\002\070\002\
\071\002\072\002\073\002\074\002\075\002\076\002\077\002\078\002\
\079\002\080\002\081\002\082\002\083\002\084\002\085\002\086\002\
\087\002\088\002\089\002\090\002\091\002\092\002\093\002\000\000\
\094\002\095\002\096\002\097\002\098\002\099\002\100\002\000\000\
\000\000\101\002\102\002\103\002\104\002\105\002\106\002\107\002\
\108\002\000\000\000\000\000\000\000\000\000\000\109\002\110\002\
\111\002\112\002\113\002\114\002\115\002\116\002\117\002\000\000\
\143\001\208\001\013\000\009\000\000\000\209\001\000\000\000\000\
\000\000\014\000\000\000\000\000\000\000\000\000\000\000\015\000\
\210\001\211\001\212\001\213\001\000\000\125\000\126\000\000\000\
\118\002\185\003\214\001\128\000\215\001\216\001\129\000\217\001\
\218\001\219\001\220\001\000\000\000\000\221\001\222\001\223\001\
\224\001\130\000\131\000\132\000\225\001\226\001\227\001\228\001\
\000\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\229\001\230\001\000\000\000\000\000\000\
\000\000\000\000\000\000\046\000\047\000\048\000\186\002\000\000\
\186\002\000\000\186\002\000\000\000\000\000\000\000\000\186\002\
\000\000\000\000\049\000\000\000\051\000\186\002\052\000\053\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\066\000\067\000\000\000\000\000\000\000\000\000\000\000\
\186\002\186\002\186\002\186\002\186\002\186\002\186\002\186\002\
\186\002\186\002\186\002\186\002\186\002\186\002\186\002\186\002\
\186\002\186\002\186\002\186\002\186\002\186\002\186\002\186\002\
\186\002\186\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\186\002\186\002\186\002\143\001\000\000\013\000\000\000\
\000\000\000\000\000\000\000\000\000\000\014\000\000\000\000\000\
\186\002\000\000\186\002\015\000\186\002\186\002\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\186\002\
\186\002\000\000\000\000\000\000\000\000\000\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\032\000\033\000\034\000\
\035\000\036\000\037\000\038\000\039\000\040\000\041\000\042\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\046\000\
\047\000\048\000\013\000\000\000\000\000\000\000\000\000\000\000\
\000\000\014\000\000\000\000\000\000\000\000\000\049\000\015\000\
\051\000\000\000\052\000\053\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\
\000\000\000\000\014\000\000\000\000\000\066\000\067\000\000\000\
\015\000\000\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\025\000\026\000\027\000\028\000\029\000\030\000\
\031\000\032\000\033\000\034\000\035\000\036\000\037\000\038\000\
\039\000\040\000\041\000\042\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\025\000\026\000\027\000\028\000\029\000\
\030\000\000\000\000\000\046\000\047\000\048\000\000\000\037\000\
\038\000\039\000\040\000\041\000\042\000\000\000\000\000\000\000\
\000\000\202\000\049\000\000\000\051\000\000\000\052\000\053\000\
\202\000\000\000\000\000\000\000\000\000\000\000\202\000\000\000\
\000\000\000\000\000\000\000\000\046\000\047\000\048\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\066\000\067\000\049\000\000\000\051\000\000\000\000\000\
\053\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\202\000\202\000\202\000\202\000\202\000\202\000\202\000\
\202\000\202\000\202\000\202\000\202\000\202\000\202\000\000\000\
\000\000\000\000\066\000\067\000\000\000\202\000\202\000\202\000\
\202\000\202\000\202\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\202\000\202\000\202\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\202\000\000\000\202\000\000\000\000\000\202\000\000\000\
\000\000\000\000\000\000\009\000\000\000\000\000\000\000\009\000\
\000\000\000\000\009\000\000\000\009\000\000\000\009\000\000\000\
\000\000\000\000\009\000\009\000\009\000\009\000\009\000\000\000\
\202\000\202\000\011\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\000\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\010\000\013\000\000\000\000\000\010\000\000\000\
\000\000\010\000\000\000\010\000\000\000\010\000\000\000\000\000\
\015\000\010\000\010\000\010\000\010\000\010\000\000\000\000\000\
\000\000\013\000\010\000\010\000\010\000\010\000\010\000\010\000\
\010\000\010\000\010\000\010\000\010\000\000\000\010\000\010\000\
\010\000\010\000\010\000\010\000\010\000\010\000\010\000\010\000\
\010\000\000\000\000\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\025\000\026\000\027\000\028\000\029\000\
\030\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\039\000\040\000\041\000\042\000\000\000\009\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\046\000\047\000\048\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\024\001\024\001\024\001\024\001\000\000\000\000\
\053\000\000\000\000\000\024\001\000\000\010\000\024\001\024\001\
\024\001\024\001\024\001\000\000\000\000\000\000\000\000\000\000\
\024\001\000\000\000\000\000\000\000\000\000\000\024\001\024\001\
\024\001\024\001\024\001\000\000\024\001\000\000\024\001\024\001\
\024\001\024\001\024\001\024\001\024\001\024\001\024\001\024\001\
\024\001\000\000\000\000\024\001\024\001\024\001\024\001\024\001\
\024\001\024\001\024\001\024\001\024\001\024\001\000\000\000\000\
\000\000\020\001\020\001\020\001\020\001\000\000\000\000\000\000\
\000\000\000\000\020\001\000\000\000\000\020\001\020\001\020\001\
\020\001\020\001\000\000\000\000\000\000\000\000\000\000\020\001\
\000\000\000\000\000\000\024\001\000\000\020\001\020\001\020\001\
\020\001\020\001\024\001\020\001\000\000\020\001\020\001\020\001\
\020\001\020\001\020\001\020\001\020\001\020\001\020\001\020\001\
\000\000\000\000\020\001\020\001\020\001\020\001\020\001\020\001\
\020\001\020\001\020\001\020\001\020\001\000\000\000\000\000\000\
\126\002\127\002\128\002\129\002\000\000\000\000\000\000\000\000\
\000\000\130\002\000\000\000\000\131\002\132\002\133\002\134\002\
\135\002\000\000\000\000\000\000\000\000\000\000\136\002\000\000\
\000\000\000\000\020\001\000\000\137\002\138\002\139\002\140\002\
\141\002\020\001\142\002\000\000\143\002\000\000\144\002\145\002\
\146\002\147\002\148\002\149\002\150\002\151\002\152\002\000\000\
\000\000\153\002\154\002\155\002\156\002\157\002\158\002\159\002\
\160\002\161\002\162\002\163\002\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\185\000\194\000\000\000\000\000\185\000\
\000\000\000\000\185\000\000\000\185\000\000\000\185\000\000\000\
\000\000\164\002\185\000\185\000\185\000\185\000\185\000\000\000\
\165\002\000\000\000\000\000\000\185\000\185\000\185\000\185\000\
\185\000\185\000\185\000\185\000\185\000\185\000\000\000\185\000\
\185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
\185\000\185\000"

let yycheck = "\003\000\
\248\000\003\000\103\000\089\000\097\000\002\000\002\000\078\000\
\002\000\006\000\006\001\228\000\005\000\144\000\060\001\203\000\
\228\000\174\000\119\000\213\000\012\000\004\000\070\001\236\000\
\002\000\181\000\152\001\079\001\060\001\213\000\254\000\195\001\
\252\001\136\000\002\000\041\002\137\001\188\001\060\001\140\000\
\039\000\040\000\010\000\136\001\247\001\225\000\145\001\046\000\
\047\000\048\000\181\000\000\000\232\000\234\000\171\001\172\001\
\127\003\014\001\233\003\105\001\019\001\219\000\047\001\236\000\
\246\000\000\000\223\000\166\001\085\003\008\003\167\002\148\003\
\228\000\246\000\255\002\004\004\021\001\190\000\000\000\008\001\
\009\001\008\001\009\001\203\000\021\001\083\003\247\001\103\003\
\036\001\105\003\167\003\021\001\006\004\085\004\122\004\169\000\
\019\001\019\001\055\003\020\001\019\001\128\001\018\001\247\001\
\023\004\027\001\103\000\122\004\027\001\212\000\018\001\020\001\
\041\001\233\000\234\000\021\001\014\001\203\000\023\001\017\001\
\020\001\042\001\027\001\125\002\027\001\018\001\018\001\098\001\
\099\001\022\001\005\001\102\001\019\001\042\001\021\001\139\000\
\119\000\139\000\000\000\225\000\144\000\227\000\243\001\018\001\
\020\001\018\001\232\000\233\000\234\000\074\001\042\001\222\003\
\076\001\227\000\079\003\133\000\019\001\023\001\021\001\078\004\
\143\000\014\001\190\000\121\001\026\001\192\001\042\001\004\002\
\087\004\070\001\086\001\020\001\027\001\102\004\040\001\167\004\
\169\000\181\000\086\001\181\000\104\001\144\001\027\001\185\002\
\021\001\038\001\110\001\042\001\145\001\137\001\104\004\000\000\
\024\001\186\000\187\000\188\000\141\001\168\001\019\004\014\001\
\021\004\229\004\027\001\031\001\141\001\126\001\145\003\028\004\
\236\000\166\001\074\001\141\001\171\001\181\000\229\004\116\001\
\114\001\126\001\116\001\122\001\027\001\238\003\040\001\161\001\
\228\000\223\003\228\000\151\001\128\001\197\000\060\001\106\001\
\107\001\161\001\227\000\141\001\165\001\018\001\165\001\237\003\
\142\001\059\001\014\001\162\004\074\001\228\000\076\001\077\001\
\171\001\171\001\080\001\081\001\171\001\128\001\141\001\247\000\
\181\003\005\001\215\003\121\001\228\000\218\003\219\003\112\001\
\221\003\015\000\234\001\003\002\173\002\005\002\018\001\005\000\
\119\001\175\001\104\001\105\001\177\001\134\001\141\001\020\001\
\110\001\022\001\020\001\000\000\022\001\113\001\027\001\019\001\
\135\001\206\001\018\001\041\000\192\001\134\003\115\004\027\001\
\117\004\122\001\130\001\131\001\121\004\002\002\027\001\040\001\
\027\001\039\000\040\000\232\001\020\001\057\001\022\001\057\001\
\046\000\047\000\048\000\122\001\043\001\192\001\043\001\148\000\
\018\001\151\001\059\001\050\001\051\001\001\002\019\001\054\001\
\160\001\161\001\145\001\079\001\092\004\079\001\004\002\047\001\
\183\001\194\001\080\004\040\002\019\001\002\002\171\000\004\002\
\159\004\057\001\096\000\097\000\110\004\111\004\027\001\166\001\
\018\001\019\001\027\001\082\001\022\001\018\001\106\001\107\001\
\181\004\019\001\134\001\020\001\114\003\186\004\187\004\079\001\
\232\001\027\001\018\001\121\000\122\000\145\001\170\002\140\001\
\027\001\020\001\044\001\194\001\128\001\047\001\128\001\041\001\
\041\001\217\003\123\000\124\000\032\002\027\001\009\002\010\002\
\011\002\001\002\060\001\242\001\228\003\122\001\041\001\122\001\
\052\003\002\002\232\001\139\001\234\001\043\001\044\001\045\001\
\200\002\146\000\049\003\018\001\001\003\019\001\176\004\021\001\
\128\001\023\001\023\003\036\001\025\003\027\001\194\001\020\001\
\041\001\137\001\020\001\001\002\015\003\048\002\027\001\016\004\
\013\002\140\001\073\003\169\000\017\002\185\001\087\003\185\001\
\089\003\147\000\171\002\172\002\192\001\122\001\192\001\053\001\
\042\001\122\001\200\000\247\002\186\000\187\000\188\000\087\003\
\019\001\089\003\021\001\027\001\023\001\211\000\020\001\014\001\
\176\001\018\001\019\001\019\001\018\001\022\001\014\001\122\001\
\206\000\017\001\246\001\043\001\044\001\014\001\020\001\086\001\
\192\001\040\002\027\001\041\001\122\001\181\000\002\002\027\001\
\032\001\041\001\053\001\044\001\018\001\227\000\047\001\032\001\
\246\003\042\001\248\003\018\001\042\001\019\001\042\001\239\001\
\247\001\041\003\247\001\060\001\014\001\027\001\086\004\245\000\
\018\001\041\001\248\000\096\003\122\001\009\002\010\002\011\002\
\035\001\036\001\014\001\041\001\192\002\193\002\032\001\235\003\
\236\003\021\001\169\003\243\001\228\000\137\001\014\001\141\001\
\019\001\017\001\074\003\008\001\014\001\044\000\036\001\017\001\
\027\001\014\001\038\001\032\002\033\002\014\001\032\002\033\002\
\032\001\022\001\122\001\200\002\048\002\018\001\019\001\122\001\
\045\002\022\001\040\001\045\002\030\002\171\001\040\001\040\001\
\041\001\004\004\015\003\006\004\022\001\023\001\150\004\078\000\
\032\002\033\002\169\002\014\001\020\001\059\001\062\003\044\001\
\064\003\020\001\047\001\014\001\027\001\045\002\017\001\017\003\
\168\004\137\001\019\001\021\003\021\001\018\001\023\001\060\001\
\137\001\017\003\027\001\042\001\084\003\021\003\080\001\047\001\
\171\001\027\001\060\001\036\001\002\003\063\001\120\001\021\001\
\020\001\057\001\192\002\193\002\164\001\027\001\028\001\005\000\
\042\001\040\001\041\001\164\001\053\001\085\003\014\001\137\001\
\152\003\113\001\018\001\175\003\088\004\089\004\022\001\079\001\
\120\003\121\003\152\003\063\003\147\000\018\001\149\000\019\001\
\032\001\014\001\018\001\027\001\041\003\018\001\022\001\027\001\
\150\001\137\001\164\001\000\000\044\001\250\003\014\001\047\001\
\018\001\000\003\042\001\032\001\162\001\021\001\164\001\165\001\
\030\004\014\001\057\004\169\004\060\001\213\003\170\002\014\003\
\170\002\093\003\024\001\027\001\164\001\074\003\038\001\101\001\
\128\001\014\001\184\001\096\003\017\001\019\001\230\003\020\001\
\020\001\122\001\042\001\041\001\024\001\027\001\115\003\116\003\
\018\001\041\001\014\001\014\001\022\001\017\001\017\001\063\003\
\015\003\216\000\170\002\103\003\041\001\105\003\026\001\136\000\
\014\001\171\001\172\001\017\001\014\001\032\001\018\001\017\001\
\024\001\018\001\201\002\064\003\152\003\236\000\018\004\013\004\
\120\001\193\003\032\001\102\003\014\001\104\003\019\001\246\000\
\018\001\063\003\171\001\227\003\022\001\010\001\027\001\012\001\
\192\001\137\001\246\002\247\002\246\002\247\002\032\001\022\001\
\238\001\094\004\025\001\115\003\116\003\214\003\060\001\014\001\
\246\001\247\001\214\003\041\001\137\001\036\001\254\002\093\003\
\014\001\233\003\019\001\017\001\164\001\003\002\238\003\005\002\
\019\001\019\001\027\001\169\000\026\001\131\001\246\002\247\002\
\027\001\027\001\022\003\212\000\018\001\115\003\116\003\164\001\
\152\003\001\003\030\004\003\003\186\000\187\000\188\000\131\001\
\008\003\023\001\117\001\118\001\119\001\027\001\042\001\004\004\
\063\001\020\001\160\001\161\001\030\003\068\001\022\003\023\004\
\213\003\019\001\214\003\021\001\028\003\023\001\137\001\020\001\
\027\001\027\001\152\003\131\001\160\001\161\001\027\001\033\002\
\027\001\230\003\018\001\137\001\020\001\227\000\120\001\036\001\
\032\002\036\001\050\004\045\002\041\001\042\001\041\001\042\001\
\036\001\164\001\089\003\053\001\089\003\019\001\042\001\137\001\
\160\001\161\001\102\003\018\001\104\003\027\001\164\001\022\001\
\096\004\097\004\103\003\210\003\105\003\103\003\078\004\105\003\
\197\002\051\004\014\001\027\001\028\001\017\001\124\002\087\004\
\020\001\014\001\164\001\051\004\017\001\044\001\014\001\020\001\
\047\001\017\001\145\001\006\004\020\001\111\003\138\003\103\003\
\138\003\105\003\018\001\110\001\020\001\060\001\019\001\147\003\
\148\003\102\004\040\001\233\003\041\001\036\001\027\001\166\001\
\237\002\041\001\247\003\112\001\171\001\172\001\141\003\142\003\
\122\001\144\003\009\004\167\003\135\001\059\001\019\001\019\001\
\021\001\021\001\023\001\175\003\143\001\175\003\027\001\147\003\
\148\003\145\003\001\004\194\001\003\004\014\001\022\001\013\004\
\155\001\025\001\157\001\020\001\159\001\004\004\119\001\206\001\
\092\004\023\004\162\004\167\003\036\001\019\001\191\003\192\003\
\053\001\042\001\126\004\127\004\027\001\027\001\135\001\175\003\
\022\001\171\001\214\003\025\001\214\003\014\001\182\003\029\001\
\017\001\019\001\170\002\020\001\043\001\044\001\045\001\046\001\
\202\003\027\001\123\000\124\000\019\001\104\004\060\004\214\003\
\247\001\195\002\019\001\014\001\027\001\020\001\017\001\136\000\
\041\001\020\001\027\001\002\002\052\000\004\002\214\003\019\001\
\078\004\146\000\018\001\148\000\019\001\019\001\183\001\027\001\
\019\001\087\004\006\004\188\001\027\001\027\001\036\001\004\004\
\027\001\006\004\016\003\141\001\042\001\122\001\018\004\019\004\
\018\004\021\004\171\000\120\004\084\000\085\000\086\000\158\001\
\028\004\040\002\250\003\018\001\092\000\093\000\020\001\102\004\
\141\001\037\004\019\001\037\004\019\001\027\001\246\002\247\002\
\126\004\127\004\027\001\122\001\027\001\019\001\036\001\019\004\
\021\001\021\004\018\004\041\001\042\001\027\001\027\001\028\001\
\028\004\242\001\036\001\212\000\019\001\023\003\171\001\025\003\
\042\001\019\001\251\001\252\001\027\001\249\004\250\004\036\001\
\062\003\027\001\064\003\023\001\162\004\172\001\019\001\011\001\
\021\001\064\004\023\001\027\001\062\004\020\001\027\001\014\001\
\027\001\028\001\017\001\222\004\126\001\020\001\084\003\092\004\
\246\001\020\001\092\004\089\003\104\004\186\000\187\000\188\000\
\009\001\102\004\019\001\104\004\193\003\000\000\026\001\115\004\
\053\001\117\004\009\002\010\002\011\002\121\004\027\001\028\001\
\251\004\019\001\112\001\021\001\092\004\023\001\094\004\102\001\
\143\002\027\001\120\003\121\003\103\001\000\000\146\001\147\001\
\237\004\153\001\154\001\023\001\241\004\019\001\019\001\115\004\
\021\001\117\004\023\001\018\001\234\004\121\004\027\001\103\003\
\018\001\105\003\027\001\053\001\120\003\121\003\173\002\039\000\
\040\000\041\001\041\001\249\004\250\004\021\001\046\000\047\000\
\048\000\184\002\043\001\044\001\045\001\046\001\047\001\020\001\
\053\001\181\004\019\001\027\001\172\001\122\001\186\004\187\004\
\019\001\121\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\091\001\092\001\093\001\094\001\095\001\096\001\
\097\001\098\001\099\001\100\001\101\001\102\001\042\001\019\001\
\019\001\181\004\019\001\141\001\019\001\141\001\186\004\187\004\
\019\001\022\001\222\004\019\001\041\001\050\004\119\001\175\003\
\122\001\023\001\230\004\231\004\230\004\231\004\171\001\023\001\
\021\001\137\001\020\001\020\001\018\001\227\003\135\001\041\001\
\169\002\018\001\041\001\141\001\041\001\122\001\041\001\251\004\
\042\001\122\001\254\004\025\001\254\004\019\001\020\001\021\001\
\015\003\023\001\024\001\018\001\018\001\027\001\214\003\019\001\
\023\003\019\001\025\003\020\001\019\001\019\001\036\001\040\001\
\027\001\171\001\027\001\041\001\042\001\060\001\061\001\062\001\
\063\001\064\001\019\001\036\001\041\001\019\001\183\001\053\001\
\041\001\042\001\053\001\188\001\040\001\009\001\171\001\001\000\
\002\000\003\000\004\000\005\000\006\000\007\000\131\004\132\004\
\133\004\134\004\135\004\136\004\137\004\138\004\139\004\140\004\
\141\004\142\004\143\004\144\004\145\004\146\004\147\004\148\004\
\149\004\019\001\018\004\023\001\110\001\110\001\041\001\000\003\
\087\003\122\001\089\003\036\001\018\001\036\001\036\001\042\001\
\022\001\096\003\042\001\025\001\041\001\014\003\019\001\029\001\
\018\001\242\001\112\001\033\001\034\001\135\001\135\001\042\001\
\027\001\102\001\251\001\252\001\122\001\143\001\143\001\112\001\
\019\001\041\001\096\004\097\004\130\001\131\001\052\001\021\001\
\018\001\155\001\155\001\157\001\157\001\159\001\159\001\023\001\
\049\003\000\000\019\001\014\001\018\001\021\001\055\003\018\001\
\019\001\036\001\021\001\022\001\023\001\020\001\110\001\014\001\
\027\001\019\001\160\001\161\001\092\004\032\001\041\001\021\001\
\073\003\019\001\023\001\014\001\019\001\171\001\017\001\018\001\
\019\001\020\001\021\001\022\001\023\001\024\001\042\001\135\001\
\027\001\028\001\053\001\030\001\036\001\032\001\042\001\143\001\
\060\001\061\001\062\001\063\001\064\001\040\001\041\001\042\001\
\042\001\044\001\018\001\155\001\047\001\157\001\027\001\159\001\
\018\001\027\001\053\001\019\001\042\001\118\003\019\001\018\001\
\042\001\060\001\014\001\021\001\014\001\019\001\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\094\001\042\001\172\001\021\001\018\001\120\001\018\001\122\001\
\027\001\141\001\019\001\020\001\021\001\023\001\023\001\168\003\
\169\003\023\001\027\001\019\001\019\001\004\004\137\001\114\001\
\115\001\116\001\141\001\036\001\019\001\120\001\019\001\122\001\
\041\001\042\001\042\001\094\001\019\001\008\001\129\001\042\001\
\131\001\019\001\133\001\134\001\053\001\041\001\137\001\042\001\
\169\002\164\001\141\001\019\001\042\001\019\001\018\001\042\001\
\171\001\210\003\126\001\014\001\148\001\154\001\215\003\018\001\
\000\000\218\003\219\003\022\001\221\003\160\001\161\001\027\001\
\019\001\164\001\019\001\166\001\197\002\032\001\021\001\023\001\
\171\001\020\001\235\003\236\003\009\001\042\001\021\001\042\001\
\000\000\044\001\019\001\019\001\047\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\042\001\110\001\019\001\112\001\
\001\004\060\001\003\004\141\001\021\001\042\001\042\001\019\001\
\009\004\122\001\041\001\053\001\237\002\122\001\019\001\102\004\
\027\001\021\001\019\001\019\001\141\001\141\001\135\001\058\001\
\059\001\060\001\061\001\062\001\063\001\064\001\143\001\000\003\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\024\001\
\141\001\021\001\155\001\042\001\157\001\014\003\159\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\064\001\
\057\004\021\001\171\001\044\001\041\001\120\001\047\001\014\001\
\019\001\019\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\075\004\060\001\027\001\042\001\137\001\030\001\
\049\003\032\001\019\001\019\001\027\001\141\001\055\003\088\004\
\089\004\021\001\041\001\042\001\021\001\044\001\007\000\187\001\
\047\001\141\001\130\003\241\000\085\001\086\001\053\001\141\001\
\073\003\164\001\063\001\166\001\196\002\060\001\121\000\122\001\
\174\000\141\001\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\152\003\177\002\031\003\141\001\
\129\001\141\001\131\001\050\001\051\001\118\003\234\004\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\062\004\114\001\115\001\116\001\011\004\000\000\
\244\003\120\001\145\001\122\001\077\003\051\004\050\004\160\001\
\161\001\017\003\129\001\021\003\131\001\245\000\133\001\134\001\
\075\004\089\003\137\001\033\002\104\003\014\001\141\001\223\004\
\017\001\251\004\162\001\045\002\128\004\214\003\032\002\168\003\
\169\003\014\001\199\001\166\003\229\004\018\001\228\004\032\001\
\102\003\160\001\161\001\255\255\255\255\164\001\255\255\166\001\
\255\255\255\255\255\255\032\001\171\001\255\255\255\255\255\255\
\193\003\255\255\020\001\255\255\255\255\042\001\255\255\044\001\
\255\255\027\001\047\001\019\001\255\255\021\001\255\255\023\001\
\255\255\210\003\036\001\027\001\028\001\255\255\215\003\060\001\
\042\001\218\003\219\003\255\255\221\003\037\001\255\255\027\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\235\003\236\003\255\255\053\001\255\255\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\255\255\
\255\255\255\255\054\001\055\001\255\255\110\001\255\255\255\255\
\001\004\255\255\003\004\255\255\255\255\255\255\255\255\255\255\
\009\004\019\001\020\001\021\001\255\255\023\001\024\001\255\255\
\255\255\027\001\255\255\120\001\255\255\255\255\135\001\255\255\
\137\001\255\255\036\001\255\255\110\001\255\255\143\001\041\001\
\042\001\255\255\255\255\255\255\137\001\255\255\255\255\255\255\
\255\255\000\000\155\001\053\001\157\001\255\255\159\001\255\255\
\255\255\050\004\122\001\164\001\255\255\135\001\255\255\255\255\
\057\004\255\255\255\255\255\255\255\255\143\001\122\001\164\001\
\255\255\166\001\255\255\255\255\255\255\141\001\255\255\255\255\
\255\255\155\001\075\004\157\001\027\001\159\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\064\001\088\004\
\089\004\255\255\255\255\255\255\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\171\001\255\255\255\255\112\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\122\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\130\001\131\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\131\004\132\004\133\004\134\004\135\004\136\004\
\137\004\138\004\139\004\140\004\141\004\142\004\143\004\144\004\
\145\004\146\004\147\004\148\004\149\004\014\001\160\001\161\001\
\017\001\018\001\019\001\020\001\021\001\022\001\023\001\024\001\
\255\255\171\001\027\001\255\255\255\255\030\001\000\000\032\001\
\255\255\255\255\255\255\122\001\255\255\255\255\255\255\255\255\
\041\001\042\001\255\255\044\001\255\255\017\001\047\001\255\255\
\255\255\255\255\255\255\255\255\053\001\255\255\255\255\255\255\
\255\255\255\255\030\001\060\001\255\255\255\255\255\255\255\255\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\079\001\080\001\
\081\001\082\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\255\255\255\255\255\255\065\001\066\001\067\001\
\068\001\069\001\070\001\071\001\072\001\073\001\074\001\075\001\
\076\001\077\001\078\001\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\115\001\116\001\255\255\089\001\090\001\120\001\
\255\255\122\001\255\255\255\255\255\255\255\255\255\255\255\255\
\129\001\255\255\131\001\014\001\133\001\134\001\255\255\018\001\
\137\001\255\255\255\255\255\255\141\001\024\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\032\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\160\001\
\161\001\044\001\134\001\164\001\047\001\166\001\005\001\006\001\
\007\001\008\001\171\001\255\255\255\255\255\255\255\255\014\001\
\255\255\060\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\255\255\027\001\028\001\029\001\255\255\
\000\000\255\255\033\001\034\001\035\001\036\001\037\001\255\255\
\039\001\040\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\255\255\110\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\120\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\131\001\255\255\255\255\255\255\135\001\255\255\137\001\094\001\
\255\255\255\255\255\255\255\255\143\001\255\255\101\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\155\001\112\001\157\001\255\255\159\001\160\001\161\001\255\255\
\255\255\164\001\255\255\122\001\000\000\255\255\255\255\255\255\
\255\255\255\255\255\255\130\001\131\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\014\001\255\255\141\001\017\001\
\018\001\019\001\255\255\021\001\022\001\023\001\024\001\255\255\
\255\255\027\001\255\255\255\255\030\001\255\255\032\001\255\255\
\255\255\160\001\161\001\255\255\255\255\255\255\255\255\255\255\
\042\001\255\255\044\001\017\001\171\001\047\001\255\255\255\255\
\255\255\000\000\255\255\053\001\255\255\255\255\255\255\255\255\
\030\001\255\255\060\001\255\255\255\255\255\255\255\255\065\001\
\066\001\067\001\068\001\069\001\070\001\071\001\072\001\073\001\
\074\001\075\001\076\001\077\001\078\001\079\001\080\001\081\001\
\082\001\083\001\084\001\085\001\086\001\087\001\088\001\089\001\
\090\001\255\255\255\255\065\001\066\001\067\001\068\001\069\001\
\070\001\071\001\072\001\073\001\074\001\075\001\076\001\077\001\
\078\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\114\001\115\001\116\001\255\255\090\001\255\255\120\001\255\255\
\122\001\255\255\255\255\255\255\014\001\255\255\255\255\129\001\
\018\001\131\001\255\255\133\001\134\001\255\255\255\255\137\001\
\255\255\255\255\255\255\141\001\255\255\255\255\032\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\042\001\255\255\044\001\255\255\255\255\047\001\160\001\161\001\
\134\001\255\255\164\001\255\255\166\001\005\001\006\001\007\001\
\008\001\171\001\060\001\255\255\255\255\255\255\014\001\000\000\
\255\255\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\255\255\027\001\028\001\029\001\255\255\255\255\
\255\255\033\001\034\001\035\001\036\001\037\001\255\255\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\064\001\000\000\047\001\048\001\049\001\050\001\120\001\255\255\
\255\255\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\255\255\255\255\255\255\137\001\
\255\255\255\255\255\255\255\255\255\255\255\255\094\001\255\255\
\255\255\255\255\255\255\255\255\255\255\101\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\019\001\
\112\001\021\001\164\001\023\001\255\255\255\255\255\255\027\001\
\028\001\255\255\122\001\255\255\255\255\255\255\255\255\255\255\
\255\255\037\001\130\001\131\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\047\001\255\255\141\001\255\255\255\255\
\255\255\053\001\255\255\255\255\255\255\255\255\005\001\006\001\
\007\001\008\001\000\000\255\255\255\255\255\255\255\255\014\001\
\160\001\161\001\017\001\018\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\171\001\027\001\028\001\029\001\255\255\
\255\255\255\255\033\001\034\001\035\001\036\001\037\001\255\255\
\039\001\040\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\000\000\048\001\049\001\050\001\122\001\255\255\
\255\255\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\255\255\255\255\255\255\027\001\
\255\255\141\001\255\255\255\255\255\255\255\255\255\255\094\001\
\255\255\255\255\255\255\255\255\255\255\255\255\101\001\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\255\255\
\255\255\112\001\054\001\055\001\056\001\057\001\255\255\171\001\
\255\255\255\255\255\255\122\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\130\001\131\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\141\001\255\255\
\255\255\255\255\019\001\255\255\021\001\255\255\023\001\255\255\
\255\255\255\255\027\001\028\001\255\255\255\255\255\255\255\255\
\255\255\160\001\161\001\255\255\037\001\255\255\255\255\040\001\
\041\001\042\001\043\001\044\001\171\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\053\001\255\255\122\001\255\255\
\255\255\008\001\009\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\018\001\019\001\255\255\021\001\022\001\
\023\001\255\255\025\001\255\255\027\001\028\001\029\001\000\000\
\255\255\255\255\033\001\034\001\035\001\036\001\037\001\255\255\
\255\255\040\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\027\001\255\255\255\255\255\255\255\255\255\255\
\255\255\122\001\255\255\255\255\255\255\255\255\000\000\255\255\
\255\255\255\255\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\255\255\255\255\141\001\054\001\055\001\056\001\
\057\001\058\001\059\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\019\001\255\255\021\001\
\255\255\023\001\255\255\255\255\255\255\027\001\028\001\255\255\
\255\255\255\255\171\001\122\001\255\255\255\255\255\255\037\001\
\255\255\255\255\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\141\001\053\001\
\054\001\055\001\056\001\057\001\058\001\059\001\255\255\255\255\
\255\255\255\255\008\001\009\001\255\255\255\255\255\255\255\255\
\255\255\122\001\255\255\255\255\018\001\019\001\165\001\021\001\
\022\001\023\001\255\255\025\001\171\001\027\001\028\001\029\001\
\255\255\255\255\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\255\255\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\058\001\059\001\060\001\061\001\
\062\001\063\001\064\001\000\000\122\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\027\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\141\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\255\255\
\255\255\255\255\054\001\055\001\056\001\057\001\058\001\059\001\
\255\255\255\255\000\000\255\255\255\255\171\001\255\255\027\001\
\255\255\255\255\255\255\255\255\122\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\141\001\
\255\255\255\255\054\001\055\001\056\001\057\001\255\255\008\001\
\009\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\018\001\019\001\255\255\021\001\022\001\023\001\165\001\
\025\001\000\000\027\001\028\001\029\001\171\001\122\001\255\255\
\033\001\034\001\035\001\036\001\037\001\255\255\255\255\040\001\
\041\001\042\001\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\064\001\
\018\001\019\001\020\001\021\001\022\001\023\001\122\001\025\001\
\000\000\027\001\028\001\029\001\255\255\255\255\255\255\033\001\
\034\001\035\001\036\001\037\001\255\255\255\255\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\064\001\255\255\
\255\255\255\255\027\001\255\255\255\255\255\255\255\255\255\255\
\255\255\122\001\255\255\255\255\255\255\255\255\255\255\000\000\
\255\255\255\255\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\255\255\255\255\141\001\054\001\055\001\047\001\
\048\001\049\001\050\001\051\001\255\255\255\255\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\064\001\027\001\255\255\255\255\165\001\255\255\255\255\255\255\
\122\001\255\255\171\001\255\255\255\255\255\255\000\000\255\255\
\255\255\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\255\255\255\255\141\001\054\001\055\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\018\001\019\001\255\255\
\021\001\022\001\023\001\255\255\025\001\255\255\027\001\028\001\
\029\001\122\001\255\255\255\255\033\001\034\001\035\001\036\001\
\037\001\171\001\255\255\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\018\001\019\001\255\255\021\001\
\022\001\023\001\000\000\025\001\255\255\027\001\028\001\029\001\
\122\001\255\255\255\255\033\001\034\001\035\001\036\001\037\001\
\255\255\255\255\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\058\001\059\001\060\001\061\001\
\062\001\063\001\064\001\255\255\255\255\000\000\255\255\255\255\
\255\255\255\255\255\255\255\255\019\001\122\001\021\001\255\255\
\023\001\255\255\255\255\255\255\027\001\028\001\255\255\255\255\
\255\255\255\255\255\255\255\255\035\001\036\001\037\001\255\255\
\141\001\040\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\000\000\053\001\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\255\255\019\001\122\001\021\001\171\001\023\001\
\255\255\255\255\255\255\027\001\028\001\255\255\255\255\255\255\
\255\255\255\255\255\255\035\001\036\001\037\001\255\255\141\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\255\255\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\064\001\255\255\255\255\000\000\255\255\171\001\255\255\255\255\
\255\255\255\255\019\001\122\001\021\001\255\255\023\001\255\255\
\255\255\255\255\027\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\037\001\255\255\141\001\255\255\
\041\001\042\001\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\051\001\000\000\053\001\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\064\001\
\255\255\019\001\122\001\021\001\171\001\023\001\255\255\255\255\
\255\255\027\001\028\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\037\001\255\255\141\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\255\255\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\000\000\255\255\171\001\046\001\047\001\048\001\049\001\
\050\001\122\001\255\255\255\255\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\064\001\255\255\
\255\255\255\255\255\255\255\255\141\001\019\001\255\255\021\001\
\255\255\023\001\255\255\255\255\255\255\027\001\028\001\255\255\
\255\255\000\000\255\255\255\255\255\255\255\255\255\255\037\001\
\255\255\255\255\040\001\041\001\042\001\043\001\044\001\045\001\
\122\001\255\255\171\001\255\255\255\255\255\255\255\255\053\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\019\001\255\255\021\001\141\001\023\001\255\255\255\255\255\255\
\027\001\028\001\255\255\255\255\000\000\255\255\255\255\255\255\
\255\255\255\255\037\001\255\255\255\255\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\171\001\053\001\054\001\055\001\056\001\057\001\255\255\
\019\001\255\255\021\001\255\255\023\001\255\255\255\255\255\255\
\027\001\028\001\255\255\255\255\000\000\255\255\255\255\255\255\
\255\255\255\255\037\001\255\255\122\001\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\255\255\053\001\054\001\055\001\056\001\057\001\141\001\
\000\000\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\255\255\255\255\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\061\001\062\001\063\001\064\001\019\001\122\001\
\021\001\255\255\023\001\255\255\000\000\171\001\027\001\028\001\
\255\255\255\255\255\255\255\255\255\255\255\255\000\000\255\255\
\037\001\255\255\141\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\051\001\255\255\
\053\001\054\001\055\001\255\255\255\255\255\255\019\001\122\001\
\021\001\255\255\023\001\255\255\255\255\255\255\027\001\028\001\
\171\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\037\001\255\255\141\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\051\001\255\255\
\053\001\054\001\055\001\255\255\255\255\255\255\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\255\255\255\255\
\171\001\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\019\001\122\001\021\001\255\255\
\023\001\255\255\255\255\255\255\027\001\028\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\037\001\255\255\
\141\001\040\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\255\255\053\001\054\001\
\055\001\255\255\255\255\255\255\019\001\122\001\021\001\255\255\
\023\001\255\255\255\255\255\255\027\001\028\001\171\001\255\255\
\255\255\255\255\255\255\255\255\000\000\255\255\037\001\255\255\
\141\001\040\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\255\255\053\001\054\001\
\055\001\255\255\255\255\255\255\255\255\255\255\255\255\019\001\
\255\255\021\001\255\255\023\001\255\255\255\255\171\001\027\001\
\028\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\037\001\255\255\122\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\020\001\255\255\
\255\255\053\001\255\255\255\255\255\255\027\001\141\001\019\001\
\255\255\021\001\255\255\023\001\255\255\255\255\036\001\027\001\
\028\001\255\255\255\255\255\255\042\001\255\255\014\001\255\255\
\255\255\037\001\018\001\122\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\019\001\171\001\021\001\255\255\023\001\
\032\001\053\001\255\255\027\001\028\001\255\255\141\001\255\255\
\255\255\255\255\255\255\255\255\044\001\037\001\255\255\047\001\
\040\001\041\001\042\001\043\001\255\255\255\255\255\255\019\001\
\255\255\021\001\255\255\023\001\060\001\053\001\122\001\027\001\
\028\001\019\001\255\255\021\001\171\001\023\001\255\255\255\255\
\255\255\027\001\028\001\255\255\040\001\041\001\042\001\255\255\
\110\001\141\001\255\255\255\255\255\255\255\255\040\001\041\001\
\042\001\053\001\255\255\255\255\255\255\255\255\255\255\255\255\
\000\000\255\255\255\255\053\001\255\255\255\255\122\001\255\255\
\255\255\135\001\255\255\255\255\255\255\255\255\110\001\171\001\
\255\255\143\001\255\255\255\255\255\255\255\255\255\255\255\255\
\120\001\141\001\255\255\255\255\255\255\155\001\255\255\157\001\
\255\255\159\001\122\001\255\255\255\255\255\255\255\255\135\001\
\255\255\137\001\255\255\255\255\255\255\255\255\255\255\143\001\
\255\255\255\255\255\255\255\255\255\255\141\001\255\255\171\001\
\255\255\255\255\255\255\155\001\255\255\157\001\122\001\159\001\
\255\255\255\255\255\255\255\255\164\001\255\255\255\255\255\255\
\122\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\141\001\255\255\171\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\141\001\255\255\255\255\255\255\255\255\
\255\255\005\001\006\001\007\001\008\001\009\001\255\255\255\255\
\255\255\013\001\014\001\255\255\016\001\017\001\018\001\171\001\
\020\001\021\001\255\255\255\255\024\001\255\255\255\255\255\255\
\255\255\171\001\030\001\031\001\032\001\033\001\034\001\255\255\
\255\255\255\255\038\001\039\001\255\255\255\255\042\001\255\255\
\044\001\255\255\255\255\047\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\058\001\059\001\
\060\001\000\000\255\255\255\255\255\255\065\001\066\001\067\001\
\068\001\069\001\070\001\071\001\072\001\073\001\074\001\075\001\
\076\001\077\001\078\001\079\001\080\001\081\001\082\001\083\001\
\084\001\085\001\086\001\087\001\088\001\089\001\090\001\091\001\
\255\255\093\001\094\001\095\001\096\001\097\001\098\001\099\001\
\100\001\101\001\102\001\255\255\104\001\105\001\106\001\107\001\
\108\001\109\001\110\001\111\001\255\255\050\001\114\001\115\001\
\116\001\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\255\255\129\001\130\001\131\001\
\255\255\133\001\134\001\135\001\255\255\137\001\255\255\255\255\
\255\255\141\001\255\255\143\001\255\255\145\001\146\001\147\001\
\148\001\149\001\150\001\151\001\152\001\255\255\154\001\155\001\
\255\255\157\001\255\255\159\001\160\001\161\001\162\001\163\001\
\164\001\165\001\166\001\255\255\168\001\005\001\006\001\007\001\
\008\001\009\001\255\255\255\255\255\255\013\001\014\001\255\255\
\016\001\017\001\018\001\255\255\020\001\021\001\255\255\255\255\
\024\001\255\255\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\038\001\039\001\
\255\255\255\255\042\001\000\000\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\058\001\059\001\060\001\255\255\255\255\255\255\
\255\255\065\001\066\001\067\001\068\001\069\001\070\001\071\001\
\072\001\073\001\074\001\075\001\076\001\077\001\078\001\079\001\
\080\001\081\001\082\001\083\001\084\001\085\001\086\001\087\001\
\088\001\089\001\090\001\091\001\255\255\093\001\255\255\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\102\001\255\255\
\104\001\105\001\106\001\107\001\108\001\109\001\110\001\111\001\
\255\255\255\255\114\001\115\001\116\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\129\001\130\001\131\001\255\255\133\001\134\001\135\001\
\255\255\137\001\255\255\255\255\255\255\141\001\255\255\143\001\
\255\255\145\001\146\001\147\001\148\001\149\001\150\001\151\001\
\152\001\255\255\154\001\155\001\255\255\157\001\255\255\159\001\
\160\001\161\001\162\001\163\001\164\001\165\001\166\001\014\001\
\168\001\016\001\017\001\255\255\255\255\255\255\255\255\255\255\
\255\255\024\001\048\001\049\001\050\001\051\001\255\255\030\001\
\054\001\055\001\056\001\057\001\058\001\059\001\060\001\061\001\
\062\001\063\001\064\001\042\001\255\255\014\001\255\255\255\255\
\017\001\018\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\030\001\255\255\032\001\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\255\255\092\001\255\255\255\255\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\255\255\110\001\
\255\255\255\255\113\001\114\001\115\001\116\001\255\255\255\255\
\255\255\090\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\129\001\130\001\131\001\255\255\133\001\134\001\
\135\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\143\001\255\255\145\001\146\001\147\001\148\001\149\001\150\001\
\151\001\255\255\255\255\255\255\155\001\255\255\157\001\255\255\
\159\001\160\001\161\001\016\001\017\001\134\001\255\255\166\001\
\137\001\255\255\255\255\024\001\255\255\255\255\255\255\255\255\
\255\255\030\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\014\001\
\255\255\255\255\017\001\164\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\030\001\
\255\255\032\001\255\255\255\255\065\001\066\001\067\001\068\001\
\069\001\070\001\071\001\072\001\073\001\074\001\075\001\076\001\
\077\001\078\001\079\001\080\001\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\255\255\092\001\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\255\255\255\255\255\255\255\255\113\001\114\001\115\001\116\001\
\255\255\255\255\255\255\090\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\129\001\255\255\131\001\255\255\
\133\001\134\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\005\001\006\001\007\001\008\001\009\001\255\255\
\255\255\255\255\013\001\014\001\015\001\255\255\017\001\018\001\
\255\255\128\001\255\255\160\001\161\001\024\001\255\255\134\001\
\255\255\166\001\137\001\030\001\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\038\001\039\001\255\255\255\255\255\255\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\164\001\255\255\058\001\
\059\001\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\107\001\108\001\109\001\110\001\111\001\255\255\255\255\114\001\
\115\001\116\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\129\001\255\255\
\131\001\037\001\133\001\134\001\255\255\255\255\137\001\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\051\001\
\255\255\255\255\054\001\055\001\056\001\057\001\058\001\059\001\
\060\001\061\001\062\001\063\001\064\001\160\001\161\001\255\255\
\255\255\164\001\165\001\005\001\006\001\007\001\008\001\009\001\
\255\255\172\001\255\255\013\001\014\001\015\001\255\255\017\001\
\018\001\255\255\255\255\255\255\255\255\255\255\024\001\255\255\
\255\255\255\255\255\255\255\255\030\001\031\001\032\001\033\001\
\034\001\255\255\255\255\255\255\038\001\039\001\255\255\255\255\
\255\255\255\255\044\001\255\255\255\255\047\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\058\001\059\001\060\001\255\255\255\255\255\255\255\255\065\001\
\066\001\067\001\068\001\069\001\070\001\071\001\072\001\073\001\
\074\001\075\001\076\001\077\001\078\001\079\001\080\001\081\001\
\082\001\083\001\084\001\085\001\086\001\087\001\088\001\089\001\
\090\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\107\001\108\001\109\001\255\255\111\001\255\255\255\255\
\114\001\115\001\116\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\129\001\
\255\255\131\001\255\255\133\001\134\001\255\255\255\255\137\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\255\255\
\255\255\255\255\054\001\055\001\056\001\057\001\058\001\059\001\
\060\001\061\001\062\001\063\001\064\001\255\255\160\001\161\001\
\255\255\255\255\164\001\165\001\005\001\006\001\007\001\008\001\
\009\001\255\255\172\001\255\255\013\001\014\001\015\001\255\255\
\017\001\018\001\255\255\255\255\255\255\255\255\255\255\024\001\
\255\255\255\255\255\255\255\255\255\255\030\001\031\001\032\001\
\033\001\034\001\255\255\255\255\255\255\038\001\039\001\255\255\
\255\255\255\255\255\255\044\001\255\255\255\255\047\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\058\001\059\001\060\001\255\255\255\255\255\255\255\255\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\079\001\080\001\
\081\001\082\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\107\001\108\001\109\001\255\255\111\001\255\255\
\255\255\114\001\115\001\116\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\129\001\255\255\131\001\255\255\133\001\134\001\255\255\255\255\
\137\001\083\001\084\001\085\001\086\001\087\001\088\001\089\001\
\090\001\091\001\092\001\093\001\094\001\095\001\096\001\097\001\
\098\001\099\001\100\001\101\001\102\001\255\255\255\255\160\001\
\161\001\255\255\255\255\164\001\165\001\005\001\006\001\007\001\
\008\001\009\001\255\255\172\001\255\255\013\001\014\001\015\001\
\255\255\017\001\018\001\255\255\255\255\255\255\255\255\255\255\
\024\001\255\255\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\038\001\039\001\
\255\255\255\255\255\255\255\255\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\058\001\059\001\060\001\255\255\255\255\255\255\
\255\255\065\001\066\001\067\001\068\001\069\001\070\001\071\001\
\072\001\073\001\074\001\075\001\076\001\077\001\078\001\079\001\
\080\001\081\001\082\001\083\001\084\001\085\001\086\001\087\001\
\088\001\089\001\090\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\107\001\108\001\109\001\255\255\111\001\
\255\255\255\255\114\001\115\001\116\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\129\001\255\255\131\001\255\255\133\001\134\001\255\255\
\255\255\137\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\255\255\255\255\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\061\001\062\001\063\001\064\001\255\255\255\255\
\160\001\161\001\255\255\255\255\164\001\165\001\005\001\006\001\
\007\001\008\001\009\001\255\255\172\001\255\255\013\001\014\001\
\255\255\016\001\017\001\018\001\255\255\020\001\255\255\022\001\
\255\255\024\001\025\001\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\038\001\
\039\001\255\255\255\255\042\001\255\255\044\001\255\255\255\255\
\047\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\058\001\059\001\060\001\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\091\001\255\255\093\001\255\255\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\102\001\
\255\255\104\001\105\001\106\001\107\001\108\001\109\001\110\001\
\111\001\255\255\255\255\114\001\115\001\116\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\129\001\130\001\131\001\255\255\133\001\134\001\
\135\001\255\255\137\001\138\001\139\001\255\255\255\255\255\255\
\143\001\255\255\145\001\146\001\147\001\148\001\149\001\150\001\
\151\001\152\001\255\255\255\255\155\001\255\255\157\001\255\255\
\159\001\160\001\161\001\162\001\163\001\164\001\165\001\166\001\
\255\255\168\001\005\001\006\001\007\001\008\001\009\001\255\255\
\255\255\255\255\013\001\014\001\255\255\016\001\017\001\018\001\
\255\255\020\001\255\255\022\001\255\255\024\001\025\001\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\038\001\039\001\255\255\255\255\042\001\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\058\001\
\059\001\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\255\255\093\001\255\255\095\001\096\001\097\001\098\001\
\099\001\100\001\101\001\102\001\255\255\104\001\105\001\106\001\
\107\001\108\001\109\001\110\001\111\001\255\255\255\255\114\001\
\115\001\116\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\129\001\130\001\
\131\001\255\255\133\001\134\001\135\001\255\255\137\001\255\255\
\139\001\255\255\255\255\255\255\143\001\255\255\145\001\146\001\
\147\001\148\001\149\001\150\001\151\001\152\001\255\255\255\255\
\155\001\255\255\157\001\255\255\159\001\160\001\161\001\162\001\
\163\001\164\001\165\001\166\001\255\255\168\001\005\001\006\001\
\007\001\008\001\009\001\255\255\255\255\255\255\013\001\014\001\
\255\255\016\001\017\001\018\001\255\255\020\001\255\255\255\255\
\255\255\024\001\255\255\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\038\001\
\039\001\255\255\255\255\042\001\255\255\044\001\255\255\255\255\
\047\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\058\001\059\001\060\001\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\091\001\255\255\093\001\255\255\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\102\001\
\255\255\104\001\105\001\106\001\107\001\108\001\109\001\110\001\
\111\001\255\255\255\255\114\001\115\001\116\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\129\001\130\001\131\001\255\255\133\001\134\001\
\135\001\255\255\137\001\255\255\255\255\255\255\141\001\255\255\
\143\001\255\255\145\001\146\001\147\001\148\001\149\001\150\001\
\151\001\152\001\255\255\255\255\155\001\255\255\157\001\255\255\
\159\001\160\001\161\001\162\001\163\001\164\001\165\001\166\001\
\255\255\168\001\005\001\006\001\007\001\008\001\009\001\255\255\
\255\255\255\255\013\001\014\001\255\255\016\001\017\001\018\001\
\255\255\020\001\255\255\255\255\255\255\024\001\255\255\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\038\001\039\001\255\255\255\255\042\001\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\058\001\
\059\001\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\255\255\093\001\255\255\095\001\096\001\097\001\098\001\
\099\001\100\001\101\001\102\001\255\255\104\001\105\001\106\001\
\107\001\108\001\109\001\110\001\111\001\255\255\255\255\114\001\
\115\001\116\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\129\001\130\001\
\131\001\255\255\133\001\134\001\135\001\255\255\137\001\255\255\
\255\255\255\255\141\001\255\255\143\001\255\255\145\001\146\001\
\147\001\148\001\149\001\150\001\151\001\152\001\255\255\255\255\
\155\001\255\255\157\001\255\255\159\001\160\001\161\001\162\001\
\163\001\164\001\165\001\166\001\255\255\168\001\005\001\006\001\
\007\001\008\001\009\001\255\255\255\255\255\255\013\001\014\001\
\255\255\016\001\017\001\018\001\255\255\020\001\255\255\255\255\
\255\255\024\001\255\255\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\038\001\
\039\001\255\255\255\255\042\001\255\255\044\001\255\255\255\255\
\047\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\058\001\059\001\060\001\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\091\001\255\255\093\001\255\255\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\102\001\
\255\255\104\001\105\001\106\001\107\001\108\001\109\001\110\001\
\111\001\255\255\255\255\114\001\115\001\116\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\129\001\130\001\131\001\255\255\133\001\134\001\
\135\001\255\255\137\001\255\255\255\255\255\255\141\001\255\255\
\143\001\255\255\145\001\146\001\147\001\148\001\149\001\150\001\
\151\001\152\001\255\255\255\255\155\001\255\255\157\001\255\255\
\159\001\160\001\161\001\162\001\163\001\164\001\165\001\166\001\
\255\255\168\001\005\001\006\001\007\001\008\001\009\001\255\255\
\255\255\255\255\013\001\014\001\255\255\016\001\017\001\018\001\
\255\255\020\001\255\255\255\255\255\255\024\001\255\255\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\038\001\039\001\255\255\255\255\042\001\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\058\001\
\059\001\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\255\255\093\001\255\255\095\001\096\001\097\001\098\001\
\099\001\100\001\101\001\102\001\255\255\104\001\105\001\106\001\
\107\001\108\001\109\001\110\001\111\001\255\255\255\255\114\001\
\115\001\116\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\129\001\130\001\
\131\001\255\255\133\001\134\001\135\001\255\255\137\001\255\255\
\255\255\255\255\255\255\255\255\143\001\255\255\145\001\146\001\
\147\001\148\001\149\001\150\001\151\001\152\001\255\255\255\255\
\155\001\255\255\157\001\255\255\159\001\160\001\161\001\162\001\
\163\001\164\001\165\001\166\001\255\255\168\001\005\001\006\001\
\007\001\008\001\009\001\255\255\255\255\255\255\013\001\014\001\
\255\255\255\255\017\001\018\001\255\255\020\001\255\255\255\255\
\255\255\024\001\255\255\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\038\001\
\039\001\255\255\255\255\042\001\255\255\044\001\255\255\255\255\
\047\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\058\001\059\001\060\001\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\091\001\255\255\093\001\255\255\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\102\001\
\255\255\104\001\105\001\106\001\107\001\108\001\109\001\255\255\
\111\001\255\255\255\255\114\001\115\001\116\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\129\001\130\001\131\001\255\255\133\001\134\001\
\255\255\255\255\137\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\152\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\160\001\161\001\162\001\163\001\164\001\165\001\166\001\
\255\255\168\001\005\001\006\001\007\001\008\001\009\001\255\255\
\255\255\255\255\013\001\014\001\255\255\255\255\017\001\018\001\
\255\255\020\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\038\001\039\001\255\255\255\255\042\001\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\058\001\
\059\001\060\001\255\255\255\255\255\255\014\001\255\255\255\255\
\017\001\018\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\030\001\255\255\032\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\091\001\255\255\093\001\255\255\095\001\096\001\097\001\098\001\
\099\001\100\001\101\001\102\001\255\255\104\001\105\001\106\001\
\107\001\108\001\109\001\255\255\111\001\255\255\255\255\255\255\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\255\255\130\001\
\255\255\255\255\255\255\255\255\255\255\255\255\137\001\255\255\
\255\255\090\001\255\255\255\255\255\255\255\255\145\001\005\001\
\006\001\007\001\008\001\009\001\255\255\152\001\255\255\013\001\
\014\001\255\255\255\255\017\001\018\001\255\255\020\001\162\001\
\163\001\164\001\165\001\255\255\255\255\168\001\255\255\255\255\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\038\001\039\001\255\255\255\255\042\001\134\001\044\001\255\255\
\137\001\047\001\255\255\255\255\255\255\255\255\045\001\046\001\
\047\001\048\001\049\001\050\001\058\001\059\001\060\001\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\255\255\164\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\091\001\255\255\093\001\
\255\255\095\001\096\001\097\001\098\001\099\001\100\001\101\001\
\102\001\255\255\104\001\105\001\106\001\107\001\108\001\109\001\
\255\255\111\001\255\255\255\255\255\255\255\255\005\001\006\001\
\007\001\008\001\009\001\255\255\255\255\255\255\013\001\014\001\
\255\255\255\255\017\001\018\001\130\001\255\255\255\255\255\255\
\255\255\024\001\255\255\137\001\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\038\001\
\039\001\255\255\152\001\042\001\255\255\044\001\255\255\255\255\
\047\001\255\255\255\255\255\255\162\001\163\001\164\001\165\001\
\255\255\255\255\168\001\058\001\059\001\060\001\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\255\255\255\255\255\255\014\001\
\255\255\255\255\017\001\018\001\255\255\020\001\255\255\255\255\
\255\255\255\255\255\255\255\255\107\001\108\001\109\001\255\255\
\111\001\032\001\255\255\114\001\115\001\116\001\255\255\255\255\
\255\255\255\255\041\001\255\255\255\255\044\001\255\255\255\255\
\047\001\255\255\129\001\255\255\131\001\255\255\133\001\134\001\
\255\255\255\255\137\001\255\255\255\255\060\001\255\255\255\255\
\005\001\006\001\007\001\008\001\009\001\255\255\255\255\255\255\
\013\001\014\001\255\255\255\255\017\001\018\001\255\255\255\255\
\255\255\160\001\161\001\024\001\255\255\164\001\165\001\166\001\
\255\255\030\001\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\038\001\039\001\255\255\255\255\255\255\255\255\044\001\
\255\255\255\255\047\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\058\001\059\001\060\001\
\255\255\120\001\255\255\255\255\065\001\066\001\067\001\068\001\
\069\001\070\001\071\001\072\001\073\001\074\001\075\001\076\001\
\077\001\078\001\137\001\255\255\255\255\255\255\255\255\255\255\
\085\001\086\001\087\001\088\001\089\001\090\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\164\001\107\001\108\001\
\109\001\255\255\111\001\255\255\255\255\114\001\115\001\116\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\129\001\255\255\131\001\255\255\
\255\255\134\001\255\255\255\255\137\001\255\255\255\255\255\255\
\255\255\005\001\006\001\007\001\008\001\009\001\255\255\255\255\
\255\255\013\001\014\001\255\255\255\255\017\001\018\001\255\255\
\020\001\255\255\022\001\160\001\161\001\025\001\255\255\164\001\
\165\001\255\255\255\255\031\001\032\001\033\001\034\001\255\255\
\255\255\255\255\038\001\039\001\255\255\255\255\255\255\255\255\
\044\001\255\255\255\255\047\001\005\001\006\001\007\001\008\001\
\009\001\255\255\255\255\255\255\013\001\014\001\058\001\059\001\
\060\001\018\001\255\255\020\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\031\001\032\001\
\033\001\034\001\255\255\255\255\255\255\038\001\039\001\255\255\
\255\255\255\255\255\255\044\001\255\255\255\255\047\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\058\001\059\001\060\001\255\255\255\255\255\255\107\001\
\108\001\109\001\255\255\111\001\255\255\255\255\005\001\006\001\
\007\001\008\001\009\001\255\255\255\255\255\255\013\001\014\001\
\255\255\255\255\255\255\018\001\255\255\255\255\255\255\255\255\
\023\001\255\255\255\255\255\255\255\255\137\001\255\255\255\255\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\038\001\
\039\001\255\255\107\001\108\001\109\001\044\001\111\001\255\255\
\047\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\164\001\165\001\255\255\058\001\059\001\060\001\255\255\255\255\
\255\255\046\001\047\001\048\001\049\001\050\001\051\001\255\255\
\137\001\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\255\255\255\255\255\255\255\255\
\005\001\006\001\007\001\008\001\009\001\255\255\255\255\255\255\
\013\001\014\001\255\255\164\001\165\001\018\001\255\255\020\001\
\255\255\255\255\255\255\255\255\107\001\108\001\109\001\255\255\
\111\001\255\255\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\038\001\039\001\255\255\255\255\255\255\255\255\044\001\
\255\255\255\255\047\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\137\001\255\255\255\255\058\001\059\001\060\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\005\001\006\001\007\001\008\001\009\001\255\255\
\255\255\255\255\013\001\014\001\255\255\164\001\165\001\018\001\
\255\255\255\255\255\255\255\255\023\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\038\001\039\001\255\255\107\001\108\001\
\109\001\044\001\111\001\255\255\047\001\005\001\006\001\007\001\
\008\001\009\001\255\255\255\255\255\255\013\001\014\001\058\001\
\059\001\060\001\018\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\137\001\255\255\255\255\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\038\001\039\001\
\255\255\255\255\042\001\255\255\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\164\001\
\165\001\255\255\058\001\059\001\060\001\255\255\255\255\255\255\
\107\001\108\001\109\001\255\255\111\001\255\255\255\255\005\001\
\006\001\007\001\008\001\009\001\255\255\255\255\255\255\013\001\
\014\001\255\255\255\255\255\255\018\001\255\255\255\255\255\255\
\255\255\023\001\255\255\255\255\255\255\255\255\137\001\255\255\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\038\001\039\001\255\255\107\001\108\001\109\001\044\001\111\001\
\014\001\047\001\255\255\255\255\018\001\255\255\255\255\255\255\
\255\255\164\001\165\001\255\255\058\001\059\001\060\001\255\255\
\255\255\255\255\032\001\255\255\255\255\255\255\255\255\255\255\
\255\255\137\001\255\255\255\255\255\255\255\255\044\001\255\255\
\255\255\047\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\005\001\006\001\007\001\008\001\009\001\060\001\255\255\
\255\255\013\001\014\001\255\255\164\001\165\001\018\001\019\001\
\255\255\255\255\255\255\255\255\255\255\107\001\108\001\109\001\
\255\255\111\001\255\255\031\001\032\001\033\001\034\001\255\255\
\255\255\255\255\038\001\039\001\255\255\255\255\255\255\255\255\
\044\001\255\255\255\255\047\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\137\001\255\255\255\255\058\001\059\001\
\060\001\255\255\255\255\255\255\005\001\006\001\007\001\008\001\
\009\001\255\255\120\001\255\255\013\001\014\001\255\255\255\255\
\255\255\018\001\019\001\255\255\255\255\255\255\164\001\165\001\
\255\255\255\255\255\255\137\001\255\255\255\255\031\001\032\001\
\033\001\034\001\255\255\255\255\255\255\038\001\039\001\255\255\
\255\255\255\255\255\255\044\001\255\255\255\255\047\001\107\001\
\108\001\109\001\255\255\111\001\255\255\255\255\164\001\255\255\
\255\255\058\001\059\001\060\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\137\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\005\001\006\001\007\001\
\008\001\009\001\255\255\255\255\255\255\013\001\014\001\255\255\
\255\255\255\255\018\001\255\255\255\255\255\255\255\255\255\255\
\164\001\165\001\107\001\108\001\109\001\255\255\111\001\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\038\001\039\001\
\255\255\255\255\255\255\255\255\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\137\001\255\255\058\001\059\001\060\001\255\255\255\255\255\255\
\005\001\006\001\007\001\008\001\009\001\255\255\255\255\255\255\
\013\001\014\001\255\255\255\255\255\255\018\001\255\255\255\255\
\255\255\022\001\255\255\164\001\165\001\255\255\255\255\255\255\
\255\255\255\255\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\038\001\039\001\255\255\255\255\255\255\255\255\044\001\
\255\255\255\255\047\001\107\001\108\001\109\001\255\255\111\001\
\255\255\255\255\255\255\255\255\255\255\058\001\059\001\060\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\137\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\005\001\006\001\007\001\008\001\009\001\255\255\255\255\
\255\255\013\001\014\001\255\255\255\255\255\255\018\001\255\255\
\020\001\255\255\255\255\255\255\164\001\165\001\107\001\255\255\
\109\001\255\255\111\001\031\001\032\001\033\001\034\001\255\255\
\255\255\255\255\038\001\039\001\255\255\255\255\255\255\255\255\
\044\001\255\255\255\255\047\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\137\001\255\255\058\001\059\001\
\060\001\255\255\255\255\255\255\005\001\006\001\007\001\008\001\
\009\001\255\255\255\255\255\255\013\001\014\001\255\255\255\255\
\255\255\018\001\255\255\020\001\255\255\255\255\255\255\164\001\
\165\001\255\255\255\255\255\255\255\255\255\255\031\001\032\001\
\033\001\034\001\255\255\255\255\255\255\038\001\039\001\255\255\
\255\255\255\255\255\255\044\001\255\255\255\255\047\001\107\001\
\255\255\109\001\255\255\111\001\255\255\255\255\255\255\255\255\
\255\255\058\001\059\001\060\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\137\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\005\001\006\001\007\001\
\008\001\009\001\255\255\255\255\255\255\013\001\014\001\255\255\
\255\255\255\255\018\001\255\255\255\255\255\255\255\255\255\255\
\164\001\165\001\107\001\255\255\109\001\255\255\111\001\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\038\001\039\001\
\255\255\255\255\255\255\255\255\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\137\001\255\255\058\001\059\001\060\001\255\255\014\001\255\255\
\255\255\255\255\018\001\019\001\255\255\021\001\022\001\023\001\
\255\255\255\255\255\255\027\001\255\255\255\255\255\255\255\255\
\032\001\255\255\255\255\164\001\165\001\255\255\255\255\255\255\
\255\255\255\255\042\001\255\255\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\053\001\255\255\255\255\
\255\255\255\255\255\255\107\001\060\001\109\001\014\001\111\001\
\255\255\255\255\018\001\019\001\255\255\021\001\022\001\023\001\
\255\255\255\255\255\255\027\001\255\255\255\255\255\255\255\255\
\032\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\137\001\042\001\255\255\044\001\255\255\255\255\047\001\
\255\255\255\255\255\255\255\255\255\255\053\001\255\255\255\255\
\255\255\014\001\255\255\255\255\060\001\018\001\019\001\255\255\
\021\001\022\001\023\001\255\255\164\001\165\001\027\001\255\255\
\120\001\255\255\122\001\032\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\042\001\255\255\044\001\
\255\255\137\001\047\001\255\255\255\255\141\001\255\255\255\255\
\053\001\014\001\255\255\255\255\255\255\018\001\019\001\060\001\
\021\001\022\001\023\001\255\255\255\255\255\255\027\001\255\255\
\255\255\255\255\255\255\032\001\164\001\255\255\166\001\255\255\
\120\001\255\255\122\001\171\001\255\255\042\001\255\255\044\001\
\255\255\255\255\047\001\255\255\255\255\255\255\255\255\255\255\
\053\001\137\001\255\255\255\255\014\001\141\001\255\255\060\001\
\018\001\019\001\255\255\021\001\022\001\023\001\255\255\255\255\
\255\255\027\001\255\255\255\255\255\255\255\255\032\001\255\255\
\255\255\255\255\255\255\120\001\164\001\122\001\166\001\255\255\
\042\001\255\255\044\001\171\001\255\255\047\001\255\255\255\255\
\255\255\255\255\255\255\053\001\137\001\255\255\255\255\014\001\
\141\001\255\255\060\001\018\001\019\001\255\255\021\001\022\001\
\023\001\255\255\255\255\255\255\027\001\255\255\255\255\255\255\
\255\255\032\001\255\255\120\001\255\255\122\001\255\255\164\001\
\255\255\166\001\255\255\042\001\255\255\044\001\171\001\255\255\
\047\001\255\255\255\255\255\255\137\001\255\255\053\001\255\255\
\141\001\255\255\017\001\255\255\255\255\060\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\030\001\
\255\255\255\255\255\255\255\255\255\255\255\255\120\001\164\001\
\122\001\166\001\255\255\255\255\255\255\255\255\171\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\137\001\
\255\255\255\255\255\255\141\001\255\255\255\255\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\255\255\120\001\164\001\122\001\166\001\014\001\085\001\255\255\
\017\001\171\001\089\001\090\001\255\255\092\001\255\255\024\001\
\255\255\255\255\137\001\255\255\255\255\030\001\141\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\042\001\255\255\255\255\255\255\116\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\164\001\255\255\166\001\
\255\255\128\001\255\255\255\255\171\001\255\255\255\255\134\001\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\079\001\080\001\
\081\001\082\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\131\004\132\004\133\004\134\004\135\004\136\004\
\137\004\138\004\139\004\140\004\141\004\142\004\143\004\144\004\
\145\004\146\004\147\004\148\004\149\004\110\001\255\255\255\255\
\255\255\114\001\115\001\116\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\129\001\255\255\131\001\255\255\133\001\134\001\135\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\143\001\255\255\
\145\001\146\001\147\001\148\001\149\001\150\001\151\001\255\255\
\255\255\255\255\155\001\255\255\157\001\255\255\159\001\160\001\
\161\001\255\255\255\255\014\001\255\255\166\001\017\001\018\001\
\255\255\255\255\255\255\022\001\255\255\024\001\255\255\255\255\
\255\255\255\255\255\255\030\001\255\255\032\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\041\001\042\001\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\114\001\
\115\001\116\001\255\255\016\001\017\001\120\001\255\255\255\255\
\255\255\255\255\255\255\024\001\255\255\255\255\129\001\255\255\
\131\001\030\001\133\001\134\001\255\255\255\255\137\001\255\255\
\255\255\255\255\141\001\255\255\255\255\042\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\160\001\161\001\255\255\
\255\255\164\001\255\255\166\001\065\001\066\001\067\001\068\001\
\069\001\070\001\071\001\072\001\073\001\074\001\075\001\076\001\
\077\001\078\001\079\001\080\001\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\110\001\255\255\255\255\255\255\114\001\115\001\116\001\
\117\001\118\001\119\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\127\001\255\255\129\001\255\255\131\001\255\255\
\133\001\134\001\135\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\143\001\255\255\145\001\146\001\147\001\148\001\
\149\001\150\001\151\001\255\255\255\255\255\255\155\001\255\255\
\157\001\255\255\159\001\160\001\161\001\255\255\255\255\014\001\
\255\255\166\001\017\001\018\001\255\255\255\255\255\255\022\001\
\255\255\024\001\255\255\255\255\027\001\255\255\255\255\030\001\
\255\255\032\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\044\001\255\255\255\255\
\047\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\060\001\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\114\001\115\001\116\001\255\255\255\255\
\255\255\120\001\255\255\014\001\255\255\255\255\017\001\018\001\
\255\255\255\255\129\001\255\255\131\001\024\001\133\001\134\001\
\255\255\255\255\137\001\030\001\255\255\032\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\042\001\
\255\255\044\001\255\255\255\255\047\001\255\255\255\255\255\255\
\255\255\160\001\161\001\255\255\255\255\164\001\255\255\255\255\
\255\255\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\114\001\
\115\001\116\001\255\255\016\001\017\001\120\001\255\255\255\255\
\021\001\255\255\255\255\024\001\255\255\255\255\129\001\255\255\
\131\001\030\001\133\001\134\001\255\255\255\255\137\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\160\001\161\001\255\255\
\255\255\164\001\255\255\255\255\065\001\066\001\067\001\068\001\
\069\001\070\001\071\001\072\001\073\001\074\001\075\001\076\001\
\077\001\078\001\079\001\080\001\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\255\255\092\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\113\001\114\001\115\001\116\001\
\255\255\016\001\017\001\255\255\255\255\255\255\021\001\255\255\
\255\255\024\001\255\255\255\255\129\001\255\255\131\001\030\001\
\133\001\134\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\160\001\161\001\255\255\255\255\255\255\
\255\255\166\001\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\255\255\092\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\113\001\114\001\115\001\116\001\255\255\016\001\
\017\001\255\255\255\255\255\255\021\001\255\255\255\255\024\001\
\255\255\255\255\129\001\255\255\131\001\030\001\133\001\134\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\160\001\161\001\255\255\255\255\255\255\255\255\166\001\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\079\001\080\001\
\081\001\082\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\255\255\092\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\113\001\114\001\115\001\116\001\255\255\016\001\017\001\255\255\
\255\255\255\255\021\001\255\255\255\255\024\001\255\255\255\255\
\129\001\255\255\131\001\030\001\133\001\134\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\160\001\
\161\001\255\255\255\255\255\255\255\255\166\001\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\255\255\092\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\113\001\114\001\
\115\001\116\001\255\255\016\001\017\001\255\255\255\255\255\255\
\255\255\255\255\255\255\024\001\255\255\255\255\129\001\255\255\
\131\001\030\001\133\001\134\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\014\001\
\255\255\255\255\017\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\160\001\161\001\030\001\
\255\255\032\001\255\255\166\001\065\001\066\001\067\001\068\001\
\069\001\070\001\071\001\072\001\073\001\074\001\075\001\076\001\
\077\001\078\001\079\001\080\001\081\001\082\001\083\001\084\001\
\085\001\086\001\087\001\088\001\089\001\090\001\255\255\092\001\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\255\255\255\255\255\255\255\255\255\255\114\001\115\001\116\001\
\255\255\255\255\014\001\090\001\255\255\017\001\255\255\255\255\
\255\255\255\255\255\255\255\255\129\001\255\255\131\001\255\255\
\133\001\134\001\030\001\255\255\032\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\128\001\255\255\160\001\161\001\255\255\255\255\134\001\
\255\255\166\001\137\001\255\255\255\255\065\001\066\001\067\001\
\068\001\069\001\070\001\071\001\072\001\073\001\074\001\075\001\
\076\001\077\001\078\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\164\001\090\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\014\001\255\255\
\018\001\019\001\255\255\021\001\022\001\255\255\255\255\025\001\
\255\255\027\001\028\001\029\001\255\255\255\255\255\255\033\001\
\034\001\255\255\134\001\037\001\255\255\137\001\255\255\041\001\
\255\255\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\255\255\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\064\001\255\255\
\164\001\065\001\066\001\067\001\068\001\069\001\070\001\071\001\
\072\001\073\001\074\001\075\001\076\001\077\001\078\001\079\001\
\080\001\081\001\082\001\083\001\084\001\085\001\086\001\087\001\
\088\001\089\001\090\001\091\001\092\001\093\001\094\001\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\102\001\255\255\
\104\001\105\001\106\001\107\001\108\001\109\001\110\001\255\255\
\255\255\113\001\114\001\115\001\116\001\117\001\118\001\119\001\
\120\001\255\255\255\255\255\255\255\255\255\255\126\001\127\001\
\128\001\129\001\130\001\131\001\132\001\133\001\134\001\255\255\
\015\001\018\001\017\001\141\001\255\255\022\001\255\255\255\255\
\255\255\024\001\255\255\255\255\255\255\255\255\255\255\030\001\
\033\001\034\001\035\001\036\001\255\255\038\001\039\001\255\255\
\160\001\040\001\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\051\001\255\255\255\255\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\064\001\
\255\255\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\108\001\109\001\255\255\255\255\255\255\
\255\255\255\255\255\255\114\001\115\001\116\001\015\001\255\255\
\017\001\255\255\019\001\255\255\255\255\255\255\255\255\024\001\
\255\255\255\255\129\001\255\255\131\001\030\001\133\001\134\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\160\001\161\001\255\255\255\255\255\255\255\255\255\255\
\065\001\066\001\067\001\068\001\069\001\070\001\071\001\072\001\
\073\001\074\001\075\001\076\001\077\001\078\001\079\001\080\001\
\081\001\082\001\083\001\084\001\085\001\086\001\087\001\088\001\
\089\001\090\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\115\001\116\001\015\001\255\255\017\001\255\255\
\255\255\255\255\255\255\255\255\255\255\024\001\255\255\255\255\
\129\001\255\255\131\001\030\001\133\001\134\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\160\001\
\161\001\255\255\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\114\001\
\115\001\116\001\017\001\255\255\255\255\255\255\255\255\255\255\
\255\255\024\001\255\255\255\255\255\255\255\255\129\001\030\001\
\131\001\255\255\133\001\134\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\017\001\255\255\255\255\255\255\255\255\
\255\255\255\255\024\001\255\255\255\255\160\001\161\001\255\255\
\030\001\255\255\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\065\001\066\001\067\001\068\001\069\001\
\070\001\071\001\072\001\073\001\074\001\075\001\076\001\077\001\
\078\001\255\255\255\255\114\001\115\001\116\001\255\255\085\001\
\086\001\087\001\088\001\089\001\090\001\255\255\255\255\255\255\
\255\255\017\001\129\001\255\255\131\001\255\255\133\001\134\001\
\024\001\255\255\255\255\255\255\255\255\255\255\030\001\255\255\
\255\255\255\255\255\255\255\255\114\001\115\001\116\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\160\001\161\001\129\001\255\255\131\001\255\255\255\255\
\134\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\065\001\066\001\067\001\068\001\069\001\070\001\071\001\
\072\001\073\001\074\001\075\001\076\001\077\001\078\001\255\255\
\255\255\255\255\160\001\161\001\255\255\085\001\086\001\087\001\
\088\001\089\001\090\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\114\001\115\001\116\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\129\001\255\255\131\001\255\255\255\255\134\001\255\255\
\255\255\255\255\255\255\018\001\255\255\255\255\255\255\022\001\
\255\255\255\255\025\001\255\255\027\001\255\255\029\001\255\255\
\255\255\255\255\033\001\034\001\035\001\036\001\037\001\255\255\
\160\001\161\001\041\001\042\001\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\255\255\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001\018\001\017\001\255\255\255\255\022\001\255\255\
\255\255\025\001\255\255\027\001\255\255\029\001\255\255\255\255\
\030\001\033\001\034\001\035\001\036\001\037\001\255\255\255\255\
\255\255\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\255\255\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\064\001\255\255\255\255\065\001\066\001\067\001\068\001\069\001\
\070\001\071\001\072\001\073\001\074\001\075\001\076\001\077\001\
\078\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\087\001\088\001\089\001\090\001\255\255\141\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\114\001\115\001\116\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\005\001\006\001\007\001\008\001\255\255\255\255\
\134\001\255\255\255\255\014\001\255\255\141\001\017\001\018\001\
\019\001\020\001\021\001\255\255\255\255\255\255\255\255\255\255\
\027\001\255\255\255\255\255\255\255\255\255\255\033\001\034\001\
\035\001\036\001\037\001\255\255\039\001\255\255\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\255\255\255\255\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\061\001\062\001\063\001\064\001\255\255\255\255\
\255\255\005\001\006\001\007\001\008\001\255\255\255\255\255\255\
\255\255\255\255\014\001\255\255\255\255\017\001\018\001\019\001\
\020\001\021\001\255\255\255\255\255\255\255\255\255\255\027\001\
\255\255\255\255\255\255\094\001\255\255\033\001\034\001\035\001\
\036\001\037\001\101\001\039\001\255\255\041\001\042\001\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\051\001\
\255\255\255\255\054\001\055\001\056\001\057\001\058\001\059\001\
\060\001\061\001\062\001\063\001\064\001\255\255\255\255\255\255\
\005\001\006\001\007\001\008\001\255\255\255\255\255\255\255\255\
\255\255\014\001\255\255\255\255\017\001\018\001\019\001\020\001\
\021\001\255\255\255\255\255\255\255\255\255\255\027\001\255\255\
\255\255\255\255\094\001\255\255\033\001\034\001\035\001\036\001\
\037\001\101\001\039\001\255\255\041\001\255\255\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\051\001\255\255\
\255\255\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\064\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\018\001\019\001\255\255\255\255\022\001\
\255\255\255\255\025\001\255\255\027\001\255\255\029\001\255\255\
\255\255\094\001\033\001\034\001\035\001\036\001\037\001\255\255\
\101\001\255\255\255\255\255\255\043\001\044\001\045\001\046\001\
\047\001\048\001\049\001\050\001\051\001\052\001\255\255\054\001\
\055\001\056\001\057\001\058\001\059\001\060\001\061\001\062\001\
\063\001\064\001"

let yynames_const = "\
  "

let yynames_block = "\
  TUnknown\000\
  TCommentSpace\000\
  TCommentNewline\000\
  TComment\000\
  TInt\000\
  TFloat\000\
  TChar\000\
  TString\000\
  TQuote\000\
  TPct\000\
  TFormat\000\
  TSubString\000\
  TDecimal\000\
  TIdent\000\
  TKRParam\000\
  Tconstructorname\000\
  TypedefIdent\000\
  TOPar\000\
  TCPar\000\
  TOBrace\000\
  TCBrace\000\
  TOCro\000\
  TCCro\000\
  TOCroCro\000\
  TDot\000\
  TColonColon\000\
  TComma\000\
  TNoComma\000\
  TPtrOp\000\
  TQualType\000\
  TQualExp\000\
  TQualId\000\
  TInc\000\
  TDec\000\
  TAssign\000\
  TEq\000\
  TWhy\000\
  TTilde\000\
  TBang\000\
  TEllipsis\000\
  TDotDot\000\
  TPtVirg\000\
  TOrLog\000\
  TAndLog\000\
  TOr\000\
  TXor\000\
  TAnd\000\
  TEqEq\000\
  TNotEq\000\
  TInf\000\
  TSup\000\
  TInf3\000\
  TSup3\000\
  TInfEq\000\
  TSupEq\000\
  TShl\000\
  TShr\000\
  TPlus\000\
  TMinus\000\
  TMul\000\
  TDiv\000\
  TMod\000\
  TMax\000\
  TMin\000\
  Tchar\000\
  Tshort\000\
  Tint\000\
  Tdouble\000\
  Tfloat\000\
  Tcomplex\000\
  Tlong\000\
  Tunsigned\000\
  Tsigned\000\
  Tvoid\000\
  Tsize_t\000\
  Tssize_t\000\
  Tptrdiff_t\000\
  TautoType\000\
  Tauto\000\
  Tregister\000\
  Textern\000\
  Tstatic\000\
  Talignas\000\
  Ttypedef\000\
  Tconst\000\
  Tvolatile\000\
  Tstruct\000\
  Tunion\000\
  Tenum\000\
  Tdecimal\000\
  Texec\000\
  Ttemplate\000\
  Tbreak\000\
  Telse\000\
  Tswitch\000\
  Tcase\000\
  Tcontinue\000\
  Tfor\000\
  Tdo\000\
  Ttry\000\
  Tif\000\
  Twhile\000\
  Tcatch\000\
  Treturn\000\
  Tgoto\000\
  Tdefault\000\
  Tsizeof\000\
  Tnew\000\
  Tdelete\000\
  Tusing\000\
  Tdefined\000\
  TOParCplusplusInit\000\
  Tnamespace\000\
  Tcpp_struct\000\
  Tcpp_union\000\
  Tclass\000\
  Tprivate\000\
  Tpublic\000\
  Tprotected\000\
  Toperator\000\
  TTemplateStart\000\
  TTemplateEnd\000\
  TTemplateEndSup\000\
  TTemplateEndTemplateEnd\000\
  TTemplateEndTemplateEndTemplateEnd\000\
  Tfinal\000\
  Tvirtual\000\
  Ttypename\000\
  Trestrict\000\
  Tasm\000\
  Tattribute\000\
  TattributeNoarg\000\
  Tinline\000\
  Ttypeof\000\
  TDefine\000\
  TCppEscapedNewline\000\
  TCppConcatOp\000\
  TOParDefine\000\
  TOBraceDefineInit\000\
  TIdentDefine\000\
  TDefEOL\000\
  TInclude\000\
  TIncludeStart\000\
  TIncludeFilename\000\
  TIfdef\000\
  TIfdefelif\000\
  TIfdefelse\000\
  TEndif\000\
  TIfdefBool\000\
  TIfdefMisc\000\
  TIfdefVersion\000\
  TUifdef\000\
  TUelseif\000\
  TUendif\000\
  TUndef\000\
  TPrePragma\000\
  TPragma\000\
  TPragmaString\000\
  TCppDirectiveOther\000\
  TMacroAttr\000\
  TMacroAttrArgs\000\
  TMacroStmt\000\
  TMacroIdStmt\000\
  TMacroIdentBuilder\000\
  TMacroString\000\
  TMacroDecl\000\
  TMacroDeclConst\000\
  TMacroIterator\000\
  TCommentSkipTagStart\000\
  TCommentSkipTagEnd\000\
  TCParEOL\000\
  TAction\000\
  TCommentMisc\000\
  TCommentCpp\000\
  EOF\000\
  TTODO\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'translation_unit) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 795 "parsing_c/parser_c.mly"
                          ( _1 )
# 5190 "parsing_c/parser_c.ml"
               : Ast_c.program))
; (fun __caml_parser_env ->
    Obj.repr(
# 799 "parsing_c/parser_c.mly"
     ( [] )
# 5196 "parsing_c/parser_c.ml"
               : 'translation_unit))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'translation_unit) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'external_declaration) in
    Obj.repr(
# 801 "parsing_c/parser_c.mly"
     ( !LP._lexer_hint.context_stack <- [LP.InTopLevel]; _1 @ [_2] )
# 5204 "parsing_c/parser_c.ml"
               : 'translation_unit))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'translation_unit) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'translation_unit) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 803 "parsing_c/parser_c.mly"
     ( !LP._lexer_hint.context_stack <- [LP.InTopLevel];
       _1 @ [Namespace (_5, [_2; snd _3; _4; _6])] )
# 5217 "parsing_c/parser_c.ml"
               : 'translation_unit))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'translation_unit) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'translation_unit) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 806 "parsing_c/parser_c.mly"
     ( !LP._lexer_hint.context_stack <- [LP.InTopLevel];
       _1 @ [Namespace (_4, [_2; _3; _5])] )
# 5229 "parsing_c/parser_c.ml"
               : 'translation_unit))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 819 "parsing_c/parser_c.mly"
                ( _1 )
# 5236 "parsing_c/parser_c.ml"
               : 'ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 820 "parsing_c/parser_c.mly"
                ( _1 )
# 5243 "parsing_c/parser_c.ml"
               : 'ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 824 "parsing_c/parser_c.mly"
                ( _1 )
# 5250 "parsing_c/parser_c.ml"
               : 'identifier))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 833 "parsing_c/parser_c.mly"
     ( RegularName (mk_string_wrap _1) )
# 5257 "parsing_c/parser_c.ml"
               : 'identifier_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident_extra_cpp) in
    Obj.repr(
# 834 "parsing_c/parser_c.mly"
                   ( _1 )
# 5264 "parsing_c/parser_c.ml"
               : 'identifier_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 838 "parsing_c/parser_c.mly"
     ( RegularName (mk_string_wrap _1) )
# 5271 "parsing_c/parser_c.ml"
               : 'ident_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 840 "parsing_c/parser_c.mly"
     ( RegularName (mk_string_wrap _1) )
# 5278 "parsing_c/parser_c.ml"
               : 'ident_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident_extra_cpp) in
    Obj.repr(
# 841 "parsing_c/parser_c.mly"
                   ( _1 )
# 5285 "parsing_c/parser_c.ml"
               : 'ident_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier_cpp_list) in
    Obj.repr(
# 845 "parsing_c/parser_c.mly"
     (
       CppConcatenatedName (
         match _3 with
         | [] -> raise (Impossible 87)
         | (x,concatnull)::xs ->
             assert (concatnull = []);
             (mk_string_wrap _1, [])::(x,[_2])::xs
       )
   )
# 5302 "parsing_c/parser_c.ml"
               : 'ident_extra_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 855 "parsing_c/parser_c.mly"
     ( CppVariadicName (fst _2, [_1; snd _2]) )
# 5310 "parsing_c/parser_c.ml"
               : 'ident_extra_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'param_define_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 857 "parsing_c/parser_c.mly"
     ( CppIdentBuilder ((fst _1, [snd _1;_2;_4]), _3) )
# 5320 "parsing_c/parser_c.ml"
               : 'ident_extra_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'qual_id) in
    Obj.repr(
# 858 "parsing_c/parser_c.mly"
                   ( QualName _2 )
# 5328 "parsing_c/parser_c.ml"
               : 'ident_extra_cpp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident_or_kwd) in
    Obj.repr(
# 861 "parsing_c/parser_c.mly"
                ( [_1, []] )
# 5335 "parsing_c/parser_c.ml"
               : 'identifier_cpp_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'identifier_cpp_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ident_or_kwd) in
    Obj.repr(
# 862 "parsing_c/parser_c.mly"
                                                 ( _1 @ [_3, [_2]] )
# 5344 "parsing_c/parser_c.ml"
               : 'identifier_cpp_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 865 "parsing_c/parser_c.mly"
         ( [RegularName (mk_string_wrap _1), []] )
# 5351 "parsing_c/parser_c.ml"
               : 'qual_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 866 "parsing_c/parser_c.mly"
                     ( [RegularName (mk_string_wrap _2), [_1]] )
# 5359 "parsing_c/parser_c.ml"
               : 'qual_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'qual_id) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 867 "parsing_c/parser_c.mly"
                             ( _1 @ [RegularName (mk_string_wrap _3), [_2]] )
# 5368 "parsing_c/parser_c.ml"
               : 'qual_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 870 "parsing_c/parser_c.mly"
          ( mk_string_wrap _1 )
# 5375 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 871 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5382 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 872 "parsing_c/parser_c.mly"
        ( mk_info_string _1 )
# 5389 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 873 "parsing_c/parser_c.mly"
              ( mk_info_string _1 )
# 5396 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 874 "parsing_c/parser_c.mly"
                   ( mk_info_string _1 )
# 5403 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 875 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5410 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 876 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5417 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 877 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5424 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 878 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5431 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 879 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5438 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 880 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5445 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 881 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5452 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 882 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5459 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 883 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5466 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 884 "parsing_c/parser_c.mly"
               ( mk_info_string _1 )
# 5473 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 885 "parsing_c/parser_c.mly"
              ( mk_info_string _1 )
# 5480 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 886 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5487 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 887 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5494 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 888 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5501 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 889 "parsing_c/parser_c.mly"
       ( mk_info_string _1 )
# 5508 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 890 "parsing_c/parser_c.mly"
        ( mk_info_string _1 )
# 5515 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 891 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5522 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 892 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5529 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 893 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5536 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 894 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5543 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 895 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5550 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 896 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5557 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 897 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5564 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 898 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5571 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 899 "parsing_c/parser_c.mly"
        ( mk_info_string _1 )
# 5578 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 900 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5585 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 901 "parsing_c/parser_c.mly"
       ( mk_info_string _1 )
# 5592 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 902 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5599 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 903 "parsing_c/parser_c.mly"
        ( mk_info_string _1 )
# 5606 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 904 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5613 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.info)) in
    Obj.repr(
# 905 "parsing_c/parser_c.mly"
              ( mk_string_wrap _1 )
# 5620 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 906 "parsing_c/parser_c.mly"
              ( mk_info_string _1 )
# 5627 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 907 "parsing_c/parser_c.mly"
        ( mk_info_string _1 )
# 5634 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 908 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5641 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 909 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5648 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 910 "parsing_c/parser_c.mly"
              ( mk_info_string _1 )
# 5655 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 911 "parsing_c/parser_c.mly"
              ( mk_info_string _1 )
# 5662 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 912 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5669 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 913 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5676 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 914 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5683 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 915 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5690 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 916 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5697 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 917 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5704 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 918 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5711 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 919 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5718 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 920 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5725 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 921 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5732 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 922 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5739 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 923 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5746 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 924 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5753 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 925 "parsing_c/parser_c.mly"
            ( mk_info_string _1 )
# 5760 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 926 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5767 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 927 "parsing_c/parser_c.mly"
           ( mk_info_string _1 )
# 5774 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 928 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5781 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 929 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5788 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 930 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5795 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 931 "parsing_c/parser_c.mly"
         ( mk_info_string _1 )
# 5802 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 932 "parsing_c/parser_c.mly"
             ( mk_info_string _1 )
# 5809 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 933 "parsing_c/parser_c.mly"
          ( mk_info_string _1 )
# 5816 "parsing_c/parser_c.ml"
               : 'ident_or_kwd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 940 "parsing_c/parser_c.mly"
                           ( _1 )
# 5823 "parsing_c/parser_c.ml"
               : Ast_c.expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 941 "parsing_c/parser_c.mly"
                           ( mk_e (Sequence (_1,_3)) [_2] )
# 5832 "parsing_c/parser_c.ml"
               : Ast_c.expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cond_expr) in
    Obj.repr(
# 944 "parsing_c/parser_c.mly"
                                 ( _1 )
# 5839 "parsing_c/parser_c.ml"
               : 'assign_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'unary_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.assignOp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 945 "parsing_c/parser_c.mly"
                                  ( mk_e(Assignment (_1, _2, _3)) [])
# 5848 "parsing_c/parser_c.ml"
               : 'assign_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'unary_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 946 "parsing_c/parser_c.mly"
                                  ( mk_e (Assignment (_1, (SimpleAssign, [_2]),_3)) [])
# 5857 "parsing_c/parser_c.ml"
               : 'assign_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 951 "parsing_c/parser_c.mly"
     ( _1 )
# 5864 "parsing_c/parser_c.ml"
               : 'cond_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'gcc_opt_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'cond_expr) in
    Obj.repr(
# 953 "parsing_c/parser_c.mly"
     ( mk_e (CondExpr (_1,_3,_5)) [_2;_4] )
# 5875 "parsing_c/parser_c.ml"
               : 'cond_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_initialiser_opt) in
    Obj.repr(
# 956 "parsing_c/parser_c.mly"
     (
      let (ty,par2) = _2 in
      let (init,par3) = _3 in
      mk_e (New (None, ty, init)) (_1 :: par2 @ par3) )
# 5887 "parsing_c/parser_c.ml"
               : 'cond_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'placement_params) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_initialiser_opt) in
    Obj.repr(
# 963 "parsing_c/parser_c.mly"
     (
      let (pp,par1) = _2 in
      let (ty,par2) = _3 in
      let (init,par3) = _4 in
      mk_e (New (pp, ty, init)) (_1 :: par1 @ par2 @ par3)
    )
# 5902 "parsing_c/parser_c.ml"
               : 'cond_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list_ne_without_paramdecl) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 971 "parsing_c/parser_c.mly"
                                                  ( (Some _2, [_1;_3] ) )
# 5911 "parsing_c/parser_c.ml"
               : 'placement_params))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 974 "parsing_c/parser_c.mly"
                                 ( (Some _2, [_1;_3] ) )
# 5920 "parsing_c/parser_c.ml"
               : 'cpp_initialiser_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 975 "parsing_c/parser_c.mly"
                                 ( (Some _2, [_1;_3] ) )
# 5929 "parsing_c/parser_c.ml"
               : 'cpp_initialiser_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 976 "parsing_c/parser_c.mly"
                                 ( (None, []) )
# 5935 "parsing_c/parser_c.ml"
               : 'cpp_initialiser_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'simple_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 979 "parsing_c/parser_c.mly"
                           ( (fixSimpleTypeForCPPType _2, [_1;_3]) )
# 5944 "parsing_c/parser_c.ml"
               : 'cpp_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_type_noparen) in
    Obj.repr(
# 980 "parsing_c/parser_c.mly"
                    ( (_1,[]) )
# 5951 "parsing_c/parser_c.ml"
               : 'cpp_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'simple_type) in
    Obj.repr(
# 983 "parsing_c/parser_c.mly"
               ( fixSimpleTypeForCPPType _1 )
# 5958 "parsing_c/parser_c.ml"
               : 'cpp_type_noparen))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier_cpp) in
    Obj.repr(
# 985 "parsing_c/parser_c.mly"
     ( let st = (Right3 (TypeName (_1, Ast_c.noTypedefDef())),[]) in
       fixSimpleTypeForCPPType st )
# 5966 "parsing_c/parser_c.ml"
               : 'cpp_type_noparen))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expr) in
    Obj.repr(
# 989 "parsing_c/parser_c.mly"
                                 ( _1 )
# 5973 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 990 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Mul,[_2]), _3)) [] )
# 5982 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 991 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Div, [_2]), _3)) [] )
# 5991 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 992 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Min, [_2]), _3)) [] )
# 6000 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 993 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Max, [_2]), _3)) [] )
# 6009 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 994 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Mod, [_2]), _3)) [] )
# 6018 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 995 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Plus, [_2]), _3)) [] )
# 6027 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 996 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Minus, [_2]), _3)) [] )
# 6036 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 997 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith DecLeft, [_2]), _3)) [] )
# 6045 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 998 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith DecRight, [_2]), _3)) [] )
# 6054 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 999 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical Inf, [_2]), _3)) [] )
# 6063 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1000 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical Sup, [_2]), _3)) [] )
# 6072 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1001 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical InfEq, [_2]), _3)) [] )
# 6081 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1002 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical SupEq, [_2]), _3)) [] )
# 6090 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1003 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical Eq, [_2]), _3)) [] )
# 6099 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1004 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical NotEq, [_2]), _3)) [] )
# 6108 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1005 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith And, [_2]), _3)) [] )
# 6117 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1006 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Or, [_2]), _3)) [] )
# 6126 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1007 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Arith Xor, [_2]), _3)) [] )
# 6135 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1008 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical AndLog, [_2]), _3)) [] )
# 6144 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr) in
    Obj.repr(
# 1009 "parsing_c/parser_c.mly"
                                 ( mk_e(Binary (_1, (Logical OrLog, [_2]), _3)) [] )
# 6153 "parsing_c/parser_c.ml"
               : 'arith_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expr) in
    Obj.repr(
# 1013 "parsing_c/parser_c.mly"
                                 ( _1 )
# 6160 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1014 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Mul,[_2]), _3)) [] )
# 6169 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1015 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Div, [_2]), _3)) [] )
# 6178 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1016 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Min, [_2]), _3)) [] )
# 6187 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1017 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Max, [_2]), _3)) [] )
# 6196 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1018 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Mod, [_2]), _3)) [] )
# 6205 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1019 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Plus, [_2]), _3)) [] )
# 6214 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1020 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Minus, [_2]), _3)) [] )
# 6223 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1021 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith DecLeft, [_2]), _3)) [] )
# 6232 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1022 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith DecRight, [_2]), _3)) [] )
# 6241 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1023 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical Inf, [_2]), _3)) [] )
# 6250 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1024 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical InfEq, [_2]), _3)) [] )
# 6259 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1025 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical SupEq, [_2]), _3)) [] )
# 6268 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1026 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical Eq, [_2]), _3)) [] )
# 6277 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1027 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical NotEq, [_2]), _3)) [] )
# 6286 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1028 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith And, [_2]), _3)) [] )
# 6295 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1029 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Or, [_2]), _3)) [] )
# 6304 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1030 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Arith Xor, [_2]), _3)) [] )
# 6313 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1031 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical AndLog, [_2]), _3)) [] )
# 6322 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'arith_expr_nosup) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 1032 "parsing_c/parser_c.mly"
                                             ( mk_e(Binary (_1, (Logical OrLog, [_2]), _3)) [] )
# 6331 "parsing_c/parser_c.ml"
               : 'arith_expr_nosup))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expr) in
    Obj.repr(
# 1035 "parsing_c/parser_c.mly"
                                     ( _1 )
# 6338 "parsing_c/parser_c.ml"
               : 'cast_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'topar2) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.fullType) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'tcpar2) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expr) in
    Obj.repr(
# 1037 "parsing_c/parser_c.mly"
   ( mk_e(Cast (_2, _4)) [_1;_3] )
# 6348 "parsing_c/parser_c.ml"
               : 'cast_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'postfix_expr) in
    Obj.repr(
# 1045 "parsing_c/parser_c.mly"
                                   ( _1 )
# 6355 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expr) in
    Obj.repr(
# 1046 "parsing_c/parser_c.mly"
                                   ( mk_e(Infix (_2, Inc))    [_1] )
# 6363 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expr) in
    Obj.repr(
# 1047 "parsing_c/parser_c.mly"
                                   ( mk_e(Infix (_2, Dec))    [_1] )
# 6371 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'unary_op) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expr) in
    Obj.repr(
# 1048 "parsing_c/parser_c.mly"
                                   ( mk_e(Unary (_2, fst _1)) [snd _1] )
# 6379 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expr) in
    Obj.repr(
# 1049 "parsing_c/parser_c.mly"
                                   ( mk_e(SizeOfExpr (_2))    [_1] )
# 6387 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'topar2) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.fullType) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar2) in
    Obj.repr(
# 1051 "parsing_c/parser_c.mly"
     ( mk_e (SizeOfType _3) [_1;_2;_4] )
# 6397 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expr) in
    Obj.repr(
# 1052 "parsing_c/parser_c.mly"
                                   ( mk_e(Delete(false, _2))  [_1] )
# 6405 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expr) in
    Obj.repr(
# 1053 "parsing_c/parser_c.mly"
                                   ( mk_e(Delete(true, _4))   [_1;_2;_3] )
# 6415 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'identifier_cpp) in
    Obj.repr(
# 1054 "parsing_c/parser_c.mly"
                                   ( mk_e(Defined _2)         [_1] )
# 6423 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'identifier_cpp) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1056 "parsing_c/parser_c.mly"
 ( mk_e(Defined _3) [_1;_2;_4] )
# 6433 "parsing_c/parser_c.ml"
               : 'unary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1059 "parsing_c/parser_c.mly"
          ( GetRef,     _1 )
# 6440 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1060 "parsing_c/parser_c.mly"
          ( DeRef,      _1 )
# 6447 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1061 "parsing_c/parser_c.mly"
          ( UnPlus,     _1 )
# 6454 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1062 "parsing_c/parser_c.mly"
          ( UnMinus,    _1 )
# 6461 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1063 "parsing_c/parser_c.mly"
          ( Tilde,      _1 )
# 6468 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1064 "parsing_c/parser_c.mly"
          ( Not,        _1 )
# 6475 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1068 "parsing_c/parser_c.mly"
           ( GetRefLabel, _1 )
# 6482 "parsing_c/parser_c.ml"
               : 'unary_op))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_expr) in
    Obj.repr(
# 1071 "parsing_c/parser_c.mly"
                         (_1)
# 6489 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'qual_type) in
    Obj.repr(
# 1072 "parsing_c/parser_c.mly"
                         ( snd _2 () )
# 6497 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list_ne) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1074 "parsing_c/parser_c.mly"
     ( mk_e(ArrayAccess (_1, _3)) [_2;_4] )
# 6507 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1076 "parsing_c/parser_c.mly"
     ( mk_e(FunCall (_1, _3)) [_2;_4] )
# 6517 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1078 "parsing_c/parser_c.mly"
     ( mk_e(FunCall (_1, _3)) [_2;_4] )
# 6527 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ident_cpp) in
    Obj.repr(
# 1079 "parsing_c/parser_c.mly"
                                 ( mk_e(RecordAccess   (_1,_3)) [_2] )
# 6536 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ident_cpp) in
    Obj.repr(
# 1080 "parsing_c/parser_c.mly"
                                 ( mk_e(RecordPtAccess (_1,_3)) [_2] )
# 6545 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1081 "parsing_c/parser_c.mly"
                              ( mk_e(Postfix (_1, Inc)) [_2] )
# 6553 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expr) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1082 "parsing_c/parser_c.mly"
                              ( mk_e(Postfix (_1, Dec)) [_2] )
# 6561 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'topar2) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.fullType) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'tcpar2) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'outer_initialize_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1086 "parsing_c/parser_c.mly"
     ( mk_e(Constructor (_2, (_5 _4 _6))) [_1;_3] )
# 6573 "parsing_c/parser_c.ml"
               : 'postfix_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * (Ast_c.sign * Ast_c.base)) * Ast_c.info) in
    Obj.repr(
# 1090 "parsing_c/parser_c.mly"
    ( let (str,(sign,base)) = fst _1 in
      mk_e(Constant (Int (str,Si(sign,base)))) [snd _1] )
# 6581 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.floatType) * Ast_c.info) in
    Obj.repr(
# 1092 "parsing_c/parser_c.mly"
           ( mk_e(Constant (Float  (fst _1))) [snd _1] )
# 6588 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1093 "parsing_c/parser_c.mly"
           ( mk_e(Constant (String (fst _1))) [snd _1] )
# 6595 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : (string * Ast_c.isWchar) * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'string_fragments) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1095 "parsing_c/parser_c.mly"
     ( let ((fullstring,isW),lqinfo) = _1 in
       let (_,rqinfo) = _3 in
       mk_e (Ast_c.StringConstant(_2, fullstring, isW)) [lqinfo;rqinfo] )
# 6606 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1098 "parsing_c/parser_c.mly"
           ( mk_e(Constant (Char   (fst _1))) [snd _1] )
# 6613 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * string (*n*) * string (*p*)) * Ast_c.info) in
    Obj.repr(
# 1099 "parsing_c/parser_c.mly"
            ( let (a,b,c) = fst _1 in
              mk_e(Constant (DecimalConst (a,b,c))) [snd _1] )
# 6621 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1101 "parsing_c/parser_c.mly"
                    ( mk_e(ParenExpr (_2)) [_1;_3] )
# 6630 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.info)) in
    Obj.repr(
# 1104 "parsing_c/parser_c.mly"
                ( mk_e(Constant (MultiString [fst _1])) [snd _1] )
# 6637 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string_elem) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'string_list) in
    Obj.repr(
# 1106 "parsing_c/parser_c.mly"
     ( mk_e(Constant (MultiString ["TODO: MultiString"])) (_1 @ _2) )
# 6645 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'compound) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1109 "parsing_c/parser_c.mly"
                         ( mk_e(StatementExpr (_2)) [_1;_3] )
# 6654 "parsing_c/parser_c.ml"
               : 'primary_expr_without_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier_cpp) in
    Obj.repr(
# 1112 "parsing_c/parser_c.mly"
                   ( mk_e(Ident  (_1)) [] )
# 6661 "parsing_c/parser_c.ml"
               : 'primary_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_expr_without_ident) in
    Obj.repr(
# 1113 "parsing_c/parser_c.mly"
                              ( _1 )
# 6668 "parsing_c/parser_c.ml"
               : 'primary_expr))
; (fun __caml_parser_env ->
    Obj.repr(
# 1116 "parsing_c/parser_c.mly"
               ( [] )
# 6674 "parsing_c/parser_c.ml"
               : 'string_fragments))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string_fragment) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'string_fragments) in
    Obj.repr(
# 1117 "parsing_c/parser_c.mly"
                                    ( _1 :: _2 )
# 6682 "parsing_c/parser_c.ml"
               : 'string_fragments))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'string_format) in
    Obj.repr(
# 1120 "parsing_c/parser_c.mly"
                      ( Ast_c.FormatFragment(_2), [_1] )
# 6690 "parsing_c/parser_c.ml"
               : 'string_fragment))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 1121 "parsing_c/parser_c.mly"
              ( Ast_c.ConstantFragment(fst _1), [snd _1] )
# 6697 "parsing_c/parser_c.ml"
               : 'string_fragment))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 1124 "parsing_c/parser_c.mly"
           ( Ast_c.ConstantFormat(fst _1), [snd _1] )
# 6704 "parsing_c/parser_c.ml"
               : 'string_format))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 1133 "parsing_c/parser_c.mly"
               ( Left _1 )
# 6711 "parsing_c/parser_c.ml"
               : 'argument_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter_decl_arg) in
    Obj.repr(
# 1134 "parsing_c/parser_c.mly"
                      ( Right (ArgType _1) )
# 6718 "parsing_c/parser_c.ml"
               : 'argument_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'action_higherordermacro_ne) in
    Obj.repr(
# 1135 "parsing_c/parser_c.mly"
                              ( Right (ArgAction _1) )
# 6725 "parsing_c/parser_c.ml"
               : 'argument_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_expr_without_ident) in
    Obj.repr(
# 1138 "parsing_c/parser_c.mly"
                              ( Left _1 )
# 6732 "parsing_c/parser_c.ml"
               : 'argument_ne_without_paramdecl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'action_higherordermacro_ne) in
    Obj.repr(
# 1139 "parsing_c/parser_c.mly"
                              ( Right (ArgAction _1) )
# 6739 "parsing_c/parser_c.ml"
               : 'argument_ne_without_paramdecl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 1142 "parsing_c/parser_c.mly"
               ( Left _1 )
# 6746 "parsing_c/parser_c.ml"
               : 'argument))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter_decl_arg) in
    Obj.repr(
# 1143 "parsing_c/parser_c.mly"
                      ( Right (ArgType _1) )
# 6753 "parsing_c/parser_c.ml"
               : 'argument))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'action_higherordermacro) in
    Obj.repr(
# 1145 "parsing_c/parser_c.mly"
                           ( Right (ArgAction _1) )
# 6760 "parsing_c/parser_c.ml"
               : 'argument))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'taction_list_ne) in
    Obj.repr(
# 1149 "parsing_c/parser_c.mly"
     ( if _1=[]
       then ActMisc [fakeAfterInfo()]
       else ActMisc _1
     )
# 6770 "parsing_c/parser_c.ml"
               : 'action_higherordermacro_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'taction_list) in
    Obj.repr(
# 1157 "parsing_c/parser_c.mly"
     ( if _1=[]
       then ActMisc [fakeAfterInfo()]
       else ActMisc _1
     )
# 6780 "parsing_c/parser_c.ml"
               : 'action_higherordermacro))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cond_expr) in
    Obj.repr(
# 1168 "parsing_c/parser_c.mly"
                      ( _1  )
# 6787 "parsing_c/parser_c.ml"
               : 'const_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1171 "parsing_c/parser_c.mly"
              ( et "topar2" (); _1  )
# 6794 "parsing_c/parser_c.ml"
               : 'topar2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1172 "parsing_c/parser_c.mly"
              ( et "tcpar2" (); _1 (*TODO? et ? sure ? c pas dt plutot ? *) )
# 6801 "parsing_c/parser_c.ml"
               : 'tcpar2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'statement2) in
    Obj.repr(
# 1180 "parsing_c/parser_c.mly"
                      ( mk_st (fst _1) (snd _1) )
# 6808 "parsing_c/parser_c.ml"
               : Ast_c.statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'labeled) in
    Obj.repr(
# 1183 "parsing_c/parser_c.mly"
                   ( Labeled      (fst _1), snd _1 )
# 6815 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 1184 "parsing_c/parser_c.mly"
                   ( Compound     (fst _1), snd _1 )
# 6822 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'expr_statement) in
    Obj.repr(
# 1185 "parsing_c/parser_c.mly"
                   ( ExprStatement(fst _1), snd _1 )
# 6829 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'selection) in
    Obj.repr(
# 1186 "parsing_c/parser_c.mly"
                   ( Selection    (fst _1), snd _1 @ [postfakeInfo(snd _1)] )
# 6836 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.iteration * Ast_c.info list) in
    Obj.repr(
# 1187 "parsing_c/parser_c.mly"
                   ( Iteration    (fst _1), snd _1 @ [postfakeInfo(snd _1)] )
# 6843 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'jump) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1188 "parsing_c/parser_c.mly"
                   ( Jump         (fst _1), snd _1 @ [_2] )
# 6851 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'asmbody) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1191 "parsing_c/parser_c.mly"
                                                ( Asm _3, [_1;_2;_4;_5] )
# 6862 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'asmbody) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1192 "parsing_c/parser_c.mly"
                                                ( Asm _4, [_1;_2;_3;_5;_6] )
# 6874 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1195 "parsing_c/parser_c.mly"
                                              (
   let fn = mk_e(Ident (RegularName (mk_string_wrap _1))) [] in
   ExprStatement (Some(mk_e (FunCall (fn, _3)) [_2;_4])), [fakeAfterInfo()] )
# 6886 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.info)) in
    Obj.repr(
# 1198 "parsing_c/parser_c.mly"
                ( MacroStmt, [snd _1] )
# 6893 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'exec_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1200 "parsing_c/parser_c.mly"
                                      ( Exec(_3), [_1;snd _2;_4] )
# 6903 "parsing_c/parser_c.ml"
               : 'statement2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'ident_cpp) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'sw_stat_or_decl) in
    Obj.repr(
# 1207 "parsing_c/parser_c.mly"
                                              ( Label (_1, _3),  [_2] )
# 6912 "parsing_c/parser_c.ml"
               : 'labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'const_expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'sw_stat_or_decl) in
    Obj.repr(
# 1208 "parsing_c/parser_c.mly"
                                              ( Case (_2, _4),       [_1; _3] )
# 6922 "parsing_c/parser_c.ml"
               : 'labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'const_expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'const_expr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'sw_stat_or_decl) in
    Obj.repr(
# 1210 "parsing_c/parser_c.mly"
     ( CaseRange (_2, _4, _6), [_1;_3;_5] )
# 6934 "parsing_c/parser_c.ml"
               : 'labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'sw_stat_or_decl) in
    Obj.repr(
# 1211 "parsing_c/parser_c.mly"
                                         ( Default _3,             [_1; _2] )
# 6943 "parsing_c/parser_c.ml"
               : 'labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 1214 "parsing_c/parser_c.mly"
             ( mk_st (Decl (_1 Ast_c.LocalDecl)) Ast_c.noii )
# 6950 "parsing_c/parser_c.ml"
               : 'sw_stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 1215 "parsing_c/parser_c.mly"
             ( _1 )
# 6957 "parsing_c/parser_c.ml"
               : 'sw_stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'ident_cpp) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1226 "parsing_c/parser_c.mly"
     ( Label (_1, (mk_st (ExprStatement None) Ast_c.noii)), [_2] )
# 6965 "parsing_c/parser_c.ml"
               : 'end_labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1228 "parsing_c/parser_c.mly"
     ( Case (_2, (mk_st (ExprStatement None) Ast_c.noii)), [_1;_3] )
# 6974 "parsing_c/parser_c.ml"
               : 'end_labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1230 "parsing_c/parser_c.mly"
     ( Default (mk_st (ExprStatement None) Ast_c.noii),    [_1; _2] )
# 6982 "parsing_c/parser_c.ml"
               : 'end_labeled))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'compound2) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace) in
    Obj.repr(
# 1236 "parsing_c/parser_c.mly"
                                    ( _2, [_1; _3]  )
# 6991 "parsing_c/parser_c.ml"
               : 'compound))
; (fun __caml_parser_env ->
    Obj.repr(
# 1248 "parsing_c/parser_c.mly"
                     ( ([]) )
# 6997 "parsing_c/parser_c.ml"
               : 'compound2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'stat_or_decl_list) in
    Obj.repr(
# 1249 "parsing_c/parser_c.mly"
                     ( _1 )
# 7004 "parsing_c/parser_c.ml"
               : 'compound2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'stat_or_decl) in
    Obj.repr(
# 1253 "parsing_c/parser_c.mly"
                                  ( [_1] )
# 7011 "parsing_c/parser_c.ml"
               : 'stat_or_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'end_labeled) in
    Obj.repr(
# 1255 "parsing_c/parser_c.mly"
                ( [StmtElem (mk_st (Labeled  (fst _1)) (snd _1))] )
# 7018 "parsing_c/parser_c.ml"
               : 'stat_or_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stat_or_decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'stat_or_decl_list) in
    Obj.repr(
# 1257 "parsing_c/parser_c.mly"
                                  ( _1 :: _2 )
# 7026 "parsing_c/parser_c.ml"
               : 'stat_or_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 1260 "parsing_c/parser_c.mly"
             ( StmtElem (mk_st (Decl (_1 Ast_c.LocalDecl)) Ast_c.noii) )
# 7033 "parsing_c/parser_c.ml"
               : 'stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 1261 "parsing_c/parser_c.mly"
             ( StmtElem _1 )
# 7040 "parsing_c/parser_c.ml"
               : 'stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'function_definition) in
    Obj.repr(
# 1264 "parsing_c/parser_c.mly"
                       ( StmtElem (mk_st (NestedFunc _1) Ast_c.noii) )
# 7047 "parsing_c/parser_c.ml"
               : 'stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.cpp_directive) in
    Obj.repr(
# 1268 "parsing_c/parser_c.mly"
     ( CppDirectiveStmt _1 )
# 7054 "parsing_c/parser_c.ml"
               : 'stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_directive) in
    Obj.repr(
# 1270 "parsing_c/parser_c.mly"
     ( IfdefStmt _1 )
# 7061 "parsing_c/parser_c.ml"
               : 'stat_or_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1274 "parsing_c/parser_c.mly"
                               ( None,    [_1] )
# 7068 "parsing_c/parser_c.ml"
               : 'expr_statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1275 "parsing_c/parser_c.mly"
                               ( Some _1, [_2] )
# 7076 "parsing_c/parser_c.ml"
               : 'expr_statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_decl) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 1279 "parsing_c/parser_c.mly"
   ( let (st,braces) = _5 in
     let wrappedst = (Compound st,braces) in
     (_3,wrappedst), [_1;_2;_4] )
# 7089 "parsing_c/parser_c.ml"
               : 'handler))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'handler) in
    Obj.repr(
# 1285 "parsing_c/parser_c.mly"
                               ( [_1] )
# 7096 "parsing_c/parser_c.ml"
               : 'handler_sequence))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'handler_sequence) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'handler) in
    Obj.repr(
# 1286 "parsing_c/parser_c.mly"
                               ( _1@[_2] )
# 7104 "parsing_c/parser_c.ml"
               : 'handler_sequence))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1290 "parsing_c/parser_c.mly"
     ( If (_3, _5, (mk_st (ExprStatement None) Ast_c.noii)),   [_1;_2;_4] )
# 7115 "parsing_c/parser_c.ml"
               : 'selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.expression) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : 'cpp_ifdef_statement) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1292 "parsing_c/parser_c.mly"
     ( If (_3, _5, _7),  [_1;_2;_4;_6] )
# 7128 "parsing_c/parser_c.ml"
               : 'selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 1294 "parsing_c/parser_c.mly"
     ( Switch (_3,_5),   [_1;_2;_4]  )
# 7139 "parsing_c/parser_c.ml"
               : 'selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 8 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 7 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.expression) in
    let _5 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.statement) in
    let _7 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _8 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _9 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 1297 "parsing_c/parser_c.mly"
     ( Ifdef_Ite (_4,_6,_9), [_1;_2;_3;_5;_7;_8] )
# 7154 "parsing_c/parser_c.ml"
               : 'selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 10 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 9 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 8 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 7 : Ast_c.expression) in
    let _5 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.statement) in
    let _7 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _8 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _9 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.statement) in
    let _10 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _11 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 1300 "parsing_c/parser_c.mly"
     ( Ifdef_Ite2 (_4,_6,_9,_11), [_1;_2;_3;_5;_7;_8;_10] )
# 7171 "parsing_c/parser_c.ml"
               : 'selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'compound) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'handler_sequence) in
    Obj.repr(
# 1303 "parsing_c/parser_c.mly"
   (
     let (st,braces) = _2 in
     let wrappedst = (Compound st,braces) in
     TryCatch (wrappedst,_3), [_1] )
# 7183 "parsing_c/parser_c.ml"
               : 'selection))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1310 "parsing_c/parser_c.mly"
     ( While (_3,_5),                [_1;_2;_4] )
# 7194 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1312 "parsing_c/parser_c.mly"
     ( DoWhile (_2,_5),              [_1;_3;_4;_6;_7] )
# 7207 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'expr_statement) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'expr_statement) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1314 "parsing_c/parser_c.mly"
     ( For (ForExp (_3,_4,(None, [])),_6),    [_1;_2;_5])
# 7219 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'expr_statement) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'expr_statement) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1316 "parsing_c/parser_c.mly"
     ( For (ForExp (_3,_4,(Some _5, [])),_7), [_1;_2;_6] )
# 7232 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'decl) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'expr_statement) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1319 "parsing_c/parser_c.mly"
     ( For (ForDecl((_3 Ast_c.LocalDecl),_4,(None, [])),_6),    [_1;_2;_5])
# 7244 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'decl) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'expr_statement) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.expression) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1321 "parsing_c/parser_c.mly"
     ( For (ForDecl((_3 Ast_c.LocalDecl),_4,(Some _5, [])),_7), [_1;_2;_6] )
# 7257 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'decl_spec) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : 'declaratorifn) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : 'initialize) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1323 "parsing_c/parser_c.mly"
     ( let decl = (* should share with code in decl2 *)
         let di = (fst _3, _4, NoInit) in
         create_decls _3 [di,[]] _5 Ast_c.LocalDecl in
       For (ForRange(decl,_6),_8), [_1;_2;_7] )
# 7274 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement) in
    Obj.repr(
# 1329 "parsing_c/parser_c.mly"
     ( MacroIteration (fst _1, _3, _5), [snd _1;_2;_4] )
# 7285 "parsing_c/parser_c.ml"
               : Ast_c.iteration * Ast_c.info list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident_cpp) in
    Obj.repr(
# 1333 "parsing_c/parser_c.mly"
                    ( Goto (_2),  [_1] )
# 7293 "parsing_c/parser_c.ml"
               : 'jump))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1334 "parsing_c/parser_c.mly"
                ( Continue,       [_1] )
# 7300 "parsing_c/parser_c.ml"
               : 'jump))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1335 "parsing_c/parser_c.mly"
                ( Break,          [_1] )
# 7307 "parsing_c/parser_c.ml"
               : 'jump))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1336 "parsing_c/parser_c.mly"
                ( Return,         [_1] )
# 7314 "parsing_c/parser_c.ml"
               : 'jump))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.expression) in
    Obj.repr(
# 1337 "parsing_c/parser_c.mly"
                ( ReturnExpr _2,  [_1] )
# 7322 "parsing_c/parser_c.ml"
               : 'jump))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.expression) in
    Obj.repr(
# 1338 "parsing_c/parser_c.mly"
                   ( GotoComputed _3, [_1;_2] )
# 7331 "parsing_c/parser_c.ml"
               : 'jump))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : (string * Ast_c.isWchar) * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'string_fragments) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1347 "parsing_c/parser_c.mly"
     ( let ((fullstring,isW),lqinfo) = _1 in
       let (_,rqinfo) = _3 in
       let inner = List.map snd _2 in
       lqinfo :: List.concat inner @ [rqinfo] )
# 7343 "parsing_c/parser_c.ml"
               : 'string_elem))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1351 "parsing_c/parser_c.mly"
           ( [snd _1] )
# 7350 "parsing_c/parser_c.ml"
               : 'string_elem))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.info)) in
    Obj.repr(
# 1353 "parsing_c/parser_c.mly"
                ( [snd _1] )
# 7357 "parsing_c/parser_c.ml"
               : 'string_elem))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'colon_asm_list) in
    Obj.repr(
# 1357 "parsing_c/parser_c.mly"
                               ( _1, _2 )
# 7365 "parsing_c/parser_c.ml"
               : 'asmbody))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'string_list) in
    Obj.repr(
# 1358 "parsing_c/parser_c.mly"
               ( _1, [] )
# 7372 "parsing_c/parser_c.ml"
               : 'asmbody))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'colon_option_list) in
    Obj.repr(
# 1361 "parsing_c/parser_c.mly"
                                     ( Colon _2, [_1]   )
# 7380 "parsing_c/parser_c.ml"
               : 'colon_asm))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1364 "parsing_c/parser_c.mly"
                                ( ColonMisc, [snd _1] )
# 7387 "parsing_c/parser_c.ml"
               : 'colon_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : (string * Ast_c.isWchar) * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'asm_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1365 "parsing_c/parser_c.mly"
                                ( ColonExpr _3, [snd _1; _2;_4] )
# 7397 "parsing_c/parser_c.ml"
               : 'colon_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : (string * Ast_c.isWchar) * Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'asm_expr) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1368 "parsing_c/parser_c.mly"
     ( ColonExpr _6, [_1;snd _2;_3;snd _4; _5; _7 ] )
# 7410 "parsing_c/parser_c.ml"
               : 'colon_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 1369 "parsing_c/parser_c.mly"
                                    ( ColonMisc, [snd _1] )
# 7417 "parsing_c/parser_c.ml"
               : 'colon_option))
; (fun __caml_parser_env ->
    Obj.repr(
# 1370 "parsing_c/parser_c.mly"
                                    ( ColonMisc, [] )
# 7423 "parsing_c/parser_c.ml"
               : 'colon_option))
; (fun __caml_parser_env ->
    Obj.repr(
# 1374 "parsing_c/parser_c.mly"
                ( [] )
# 7429 "parsing_c/parser_c.ml"
               : 'exec_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'identifier_cpp) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'exec_ident) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'exec_list) in
    Obj.repr(
# 1376 "parsing_c/parser_c.mly"
      ( (ExecEval (_3 (mk_e (Ident _2) [])), [_1]) :: _4 )
# 7439 "parsing_c/parser_c.ml"
               : 'exec_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exec_ident2) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exec_list) in
    Obj.repr(
# 1378 "parsing_c/parser_c.mly"
      ( (ExecToken, [snd _1]) :: _2 @ _3 )
# 7448 "parsing_c/parser_c.ml"
               : 'exec_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'token) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'exec_list) in
    Obj.repr(
# 1379 "parsing_c/parser_c.mly"
                    ( (ExecToken, [_1]) :: _2 )
# 7456 "parsing_c/parser_c.ml"
               : 'exec_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1382 "parsing_c/parser_c.mly"
    ( function prev -> prev )
# 7462 "parsing_c/parser_c.ml"
               : 'exec_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exec_ident) in
    Obj.repr(
# 1384 "parsing_c/parser_c.mly"
     ( function prev ->
       let fld = RegularName (mk_string_wrap _2) in
       _3 (mk_e(RecordAccess   (prev,fld)) [_1]) )
# 7473 "parsing_c/parser_c.ml"
               : 'exec_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exec_ident) in
    Obj.repr(
# 1388 "parsing_c/parser_c.mly"
     ( function prev ->
       let fld = RegularName (mk_string_wrap _2) in
       _3 (mk_e(RecordPtAccess   (prev,fld)) [_1]) )
# 7484 "parsing_c/parser_c.ml"
               : 'exec_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'argument_list_ne) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'exec_ident) in
    Obj.repr(
# 1392 "parsing_c/parser_c.mly"
     ( function prev ->
       _4 (mk_e(ArrayAccess   (prev,_2)) [_1;_3]) )
# 7495 "parsing_c/parser_c.ml"
               : 'exec_ident))
; (fun __caml_parser_env ->
    Obj.repr(
# 1396 "parsing_c/parser_c.mly"
    ( [] )
# 7501 "parsing_c/parser_c.ml"
               : 'exec_ident2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exec_ident2) in
    Obj.repr(
# 1398 "parsing_c/parser_c.mly"
    ( (ExecToken, [_1]) :: (ExecToken, [snd _2]) :: _3 )
# 7510 "parsing_c/parser_c.ml"
               : 'exec_ident2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 1400 "parsing_c/parser_c.mly"
                      ( _1 )
# 7517 "parsing_c/parser_c.ml"
               : 'asm_expr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1403 "parsing_c/parser_c.mly"
            ( _1 )
# 7524 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1404 "parsing_c/parser_c.mly"
            ( _1 )
# 7531 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1405 "parsing_c/parser_c.mly"
            ( _1 )
# 7538 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1406 "parsing_c/parser_c.mly"
            ( _1 )
# 7545 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1407 "parsing_c/parser_c.mly"
            ( _1 )
# 7552 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1408 "parsing_c/parser_c.mly"
            ( _1 )
# 7559 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1409 "parsing_c/parser_c.mly"
            ( _1 )
# 7566 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1410 "parsing_c/parser_c.mly"
            ( _1 )
# 7573 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1411 "parsing_c/parser_c.mly"
            ( _1 )
# 7580 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1412 "parsing_c/parser_c.mly"
            ( _1 )
# 7587 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.assignOp) in
    Obj.repr(
# 1413 "parsing_c/parser_c.mly"
            ( List.hd (snd _1) )
# 7594 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1415 "parsing_c/parser_c.mly"
            ( _1 )
# 7601 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1416 "parsing_c/parser_c.mly"
            ( _1 )
# 7608 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1417 "parsing_c/parser_c.mly"
            ( _1 )
# 7615 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1418 "parsing_c/parser_c.mly"
            ( _1 )
# 7622 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1419 "parsing_c/parser_c.mly"
            ( _1 )
# 7629 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1420 "parsing_c/parser_c.mly"
            ( _1 )
# 7636 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1422 "parsing_c/parser_c.mly"
            ( _1 )
# 7643 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1423 "parsing_c/parser_c.mly"
            ( _1 )
# 7650 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1424 "parsing_c/parser_c.mly"
            ( _1 )
# 7657 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1425 "parsing_c/parser_c.mly"
            ( _1 )
# 7664 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1426 "parsing_c/parser_c.mly"
            ( _1 )
# 7671 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1427 "parsing_c/parser_c.mly"
            ( _1 )
# 7678 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1428 "parsing_c/parser_c.mly"
            ( _1 )
# 7685 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1430 "parsing_c/parser_c.mly"
            ( _1 )
# 7692 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1431 "parsing_c/parser_c.mly"
            ( _1 )
# 7699 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1434 "parsing_c/parser_c.mly"
            ( _1 )
# 7706 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1435 "parsing_c/parser_c.mly"
            ( _1 )
# 7713 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1439 "parsing_c/parser_c.mly"
            ( _1 )
# 7720 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1440 "parsing_c/parser_c.mly"
            ( _1 )
# 7727 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1441 "parsing_c/parser_c.mly"
            ( _1 )
# 7734 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 1443 "parsing_c/parser_c.mly"
                 ( snd _1 )
# 7741 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1445 "parsing_c/parser_c.mly"
            ( _1 )
# 7748 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1446 "parsing_c/parser_c.mly"
            ( _1 )
# 7755 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * (Ast_c.sign * Ast_c.base)) * Ast_c.info) in
    Obj.repr(
# 1447 "parsing_c/parser_c.mly"
            ( snd _1 )
# 7762 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.floatType) * Ast_c.info) in
    Obj.repr(
# 1448 "parsing_c/parser_c.mly"
            ( snd _1 )
# 7769 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1449 "parsing_c/parser_c.mly"
            ( snd _1 )
# 7776 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.isWchar) * Ast_c.info) in
    Obj.repr(
# 1450 "parsing_c/parser_c.mly"
            ( snd _1 )
# 7783 "parsing_c/parser_c.ml"
               : 'token))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1461 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType Void),            [_1] )
# 7790 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1462 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType (IntType CChar)), [_1])
# 7797 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1463 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType (IntType (Si (Signed,CInt)))), [_1])
# 7804 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1464 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType (FloatType CFloat)),  [_1])
# 7811 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1465 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType (FloatType CDouble)), [_1] )
# 7818 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1466 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType (FloatType CUnknownComplex)), [_1] )
# 7825 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1467 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType SizeType),            [_1] )
# 7832 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1468 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType SSizeType),           [_1] )
# 7839 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1469 "parsing_c/parser_c.mly"
                        ( Right3 (BaseType PtrDiffType),         [_1] )
# 7846 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1470 "parsing_c/parser_c.mly"
                        ( Middle3 Short,  [_1])
# 7853 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1471 "parsing_c/parser_c.mly"
                        ( Middle3 Long,   [_1])
# 7860 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1472 "parsing_c/parser_c.mly"
                        ( Left3 Signed,   [_1])
# 7867 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1473 "parsing_c/parser_c.mly"
                        ( Left3 UnSigned, [_1])
# 7874 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'const_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1475 "parsing_c/parser_c.mly"
     ( Right3 (Decimal(_3,Some _5)), [_1;_2;_4;_6] )
# 7886 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1477 "parsing_c/parser_c.mly"
     ( Right3 (Decimal(_3,None)), [_1;_2;_4] )
# 7896 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1478 "parsing_c/parser_c.mly"
             (
     let can_auto_type =
      let open Flag in
       match !c_plus_plus with
         Off -> false
       | On None -> true
       | On (Some i) -> i >= 2011
     in
     if can_auto_type
     then (Right3 AutoType, [_1])
     else
       let i = Ast_c.parse_info_of_info _1 in
       raise (Semantic("auto is not a valid C type, try using the --c++ option",
                       i)) )
# 7916 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'assign_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1507 "parsing_c/parser_c.mly"
                                   ( Right3 (TypeOfExpr (_3)), [_1;_2;_4] )
# 7926 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.fullType) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1508 "parsing_c/parser_c.mly"
                                   ( Right3 (TypeOfType _3), [_1;_2;_4] )
# 7936 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 1510 "parsing_c/parser_c.mly"
     ( let name = RegularName (mk_string_wrap _1) in
       Right3 (TypeName (name, Ast_c.noTypedefDef())),[] )
# 7944 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'qual_type) in
    Obj.repr(
# 1512 "parsing_c/parser_c.mly"
                       ( fst _2 () )
# 7952 "parsing_c/parser_c.ml"
               : 'simple_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 1516 "parsing_c/parser_c.mly"
     ( let tyval _ =
       let name = RegularName (mk_string_wrap _1) in
       Right3 (TypeName (name, Ast_c.noTypedefDef())),[] in
     let expval _ = mk_e(Ident  (RegularName (mk_string_wrap _1))) [] in
     (tyval,expval) )
# 7963 "parsing_c/parser_c.ml"
               : 'qual_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'qual_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 1522 "parsing_c/parser_c.mly"
     ( 
       let name = RegularName (mk_string_wrap _3) in
       let front = Some (fixSimpleTypeForCPPType (fst _1 ())) in
       let tyval _ = Right3 (QualifiedType (front, name)), [_2] in
       let expval _ = mk_e(QualifiedAccess (front, name)) [_2] in
       (tyval,expval) )
# 7977 "parsing_c/parser_c.ml"
               : 'qual_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 1529 "parsing_c/parser_c.mly"
     ( let name = RegularName (mk_string_wrap _2) in
     let tyval _ = Right3 (QualifiedType (None, name)), [_1] in
     let expval _ = mk_e(QualifiedAccess (None, name)) [_1] in
     (tyval,expval) )
# 7988 "parsing_c/parser_c.ml"
               : 'qual_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'qual_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1534 "parsing_c/parser_c.mly"
     ( let tyval _ =
       let tname = fst _1 () in
       Right3 (TemplateType (fixSimpleTypeForCPPType tname, _3)),[_2;_4] in
     let expval _ = mk_e(TemplateInst (snd _1 (), _3)) [_2;_4] in
     (tyval,expval) )
# 8002 "parsing_c/parser_c.ml"
               : 'qual_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'simple_type) in
    Obj.repr(
# 1542 "parsing_c/parser_c.mly"
                 ( _1 )
# 8009 "parsing_c/parser_c.ml"
               : 'type_spec2_without_braces))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'enum_ident_independant) in
    Obj.repr(
# 1543 "parsing_c/parser_c.mly"
                            ( Right3 (fst _1), snd _1 )
# 8016 "parsing_c/parser_c.ml"
               : 'type_spec2_without_braces))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'struct_or_union_spec) in
    Obj.repr(
# 1545 "parsing_c/parser_c.mly"
                        ( Right3 (fst _1), snd _1 )
# 8023 "parsing_c/parser_c.ml"
               : 'type_spec2_with_braces))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'enum_spec) in
    Obj.repr(
# 1546 "parsing_c/parser_c.mly"
                        ( Right3 (fst _1), snd _1 )
# 8030 "parsing_c/parser_c.ml"
               : 'type_spec2_with_braces))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec2_without_braces) in
    Obj.repr(
# 1553 "parsing_c/parser_c.mly"
                                  ( dt "type" (); _1   )
# 8037 "parsing_c/parser_c.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec2_with_braces) in
    Obj.repr(
# 1554 "parsing_c/parser_c.mly"
                                  ( dt "type" (); _1   )
# 8044 "parsing_c/parser_c.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1561 "parsing_c/parser_c.mly"
             ( {const=true  ; volatile=false; restrict=false}, _1 )
# 8051 "parsing_c/parser_c.ml"
               : 'type_qualif))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1562 "parsing_c/parser_c.mly"
             ( {const=false ; volatile=true ; restrict=false},  _1 )
# 8058 "parsing_c/parser_c.ml"
               : 'type_qualif))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1564 "parsing_c/parser_c.mly"
             ( {const=false; volatile=false; restrict=true},  _1 )
# 8065 "parsing_c/parser_c.ml"
               : 'type_qualif))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_gcc) in
    Obj.repr(
# 1572 "parsing_c/parser_c.mly"
                 ( _1 )
# 8072 "parsing_c/parser_c.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attr_arg) in
    Obj.repr(
# 1574 "parsing_c/parser_c.mly"
            ( Attribute _1, [] )
# 8079 "parsing_c/parser_c.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.info)) in
    Obj.repr(
# 1577 "parsing_c/parser_c.mly"
              ( MacroAttr (fst _1), [snd _1] )
# 8086 "parsing_c/parser_c.ml"
               : 'attr_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1579 "parsing_c/parser_c.mly"
     ( MacroAttrArgs (fst _1,_3),[snd _1;_2;_4] )
# 8096 "parsing_c/parser_c.ml"
               : 'attr_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1581 "parsing_c/parser_c.mly"
     ( MacroAttrArgs (fst _1,_3),[snd _1;_2;_4] )
# 8106 "parsing_c/parser_c.ml"
               : 'attr_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'tdouble_opar_gcc_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tdouble_cpar_gcc_attr) in
    Obj.repr(
# 1585 "parsing_c/parser_c.mly"
     ( GccAttribute _3, [_1]@_2@_4 )
# 8116 "parsing_c/parser_c.ml"
               : 'attribute_gcc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'tdouble_ocro_cxx_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tdouble_ccro_cxx_attr) in
    Obj.repr(
# 1587 "parsing_c/parser_c.mly"
     ( CxxAttribute _2, _1@_3 )
# 8125 "parsing_c/parser_c.ml"
               : 'attribute_gcc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'tdouble_ocro_cxx_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'ident_cpp) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'tdouble_ccro_cxx_attr) in
    Obj.repr(
# 1590 "parsing_c/parser_c.mly"
     ( CxxAttributeUsing (_3,_5), _1@(_2::_4::_6) )
# 8137 "parsing_c/parser_c.ml"
               : 'attribute_gcc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pointer) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'direct_d) in
    Obj.repr(
# 1605 "parsing_c/parser_c.mly"
                    ( (fst _2, fun x -> x +> _1 +> snd _2) )
# 8145 "parsing_c/parser_c.ml"
               : 'declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'direct_d) in
    Obj.repr(
# 1606 "parsing_c/parser_c.mly"
                    ( _1 )
# 8152 "parsing_c/parser_c.ml"
               : 'declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pointer) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'direct_d_fn) in
    Obj.repr(
# 1609 "parsing_c/parser_c.mly"
                       ( (fst _2, fun x -> x +> _1 +> snd _2) )
# 8160 "parsing_c/parser_c.ml"
               : 'declarator_fn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'direct_d_fn) in
    Obj.repr(
# 1610 "parsing_c/parser_c.mly"
                       ( _1 )
# 8167 "parsing_c/parser_c.ml"
               : 'declarator_fn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'tmul) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'type_qualif_list) in
    Obj.repr(
# 1616 "parsing_c/parser_c.mly"
     ( let (attr,tq) = _2 in
       (fun x ->
	  let (_,_,cur) = (* not sure - which & does the qualified go with? *)
	    List.fold_left
	      (fun prev ptr ->
		mk_ty (Pointer prev) [ptr])
	      x _1 in
	 (tq.qualifD, attr, cur)) )
# 8182 "parsing_c/parser_c.ml"
               : 'pointer))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'tmul) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'type_qualif_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'pointer) in
    Obj.repr(
# 1625 "parsing_c/parser_c.mly"
     ( let (attr,tq) = _2 in
       (fun x ->
	 let (_,_,cur) =
	   List.fold_left
	     (fun prev ptr ->
	       mk_ty (Pointer prev) [ptr])
	     x _1 in
	 _3 (tq.qualifD, attr, cur)) )
# 8198 "parsing_c/parser_c.ml"
               : 'pointer))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1635 "parsing_c/parser_c.mly"
        ( [_1] )
# 8205 "parsing_c/parser_c.ml"
               : 'tmul))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1637 "parsing_c/parser_c.mly"
     ( if !Flag.c_plus_plus <> Flag.Off
     then [_1]
     else
       let i = Ast_c.parse_info_of_info _1 in
       raise (Semantic("& not allowed in C types, try -c++ option", i)) )
# 8216 "parsing_c/parser_c.ml"
               : 'tmul))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1643 "parsing_c/parser_c.mly"
     ( if !Flag.c_plus_plus <> Flag.Off
     then [_1]
     else
       let i = Ast_c.parse_info_of_info _1 in
       raise (Semantic("&& not allowed in C types, try -c++ option", i)) )
# 8227 "parsing_c/parser_c.ml"
               : 'tmul))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier_cpp) in
    Obj.repr(
# 1651 "parsing_c/parser_c.mly"
     ( (_1, fun x -> x) )
# 8234 "parsing_c/parser_c.ml"
               : 'direct_d))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'operator_c_plus_plus) in
    Obj.repr(
# 1653 "parsing_c/parser_c.mly"
     ( (_1, fun x -> x) )
# 8241 "parsing_c/parser_c.ml"
               : 'direct_d))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1655 "parsing_c/parser_c.mly"
     ( (fst _2, fun x -> mk_ty (ParenType ((snd _2) x)) [_1;_3]) )
# 8250 "parsing_c/parser_c.ml"
               : 'direct_d))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'direct_d) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'tocro) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tccro) in
    Obj.repr(
# 1657 "parsing_c/parser_c.mly"
     ( (fst _1,fun x->(snd _1) (mk_ty (Array (None,x)) [_2;_3])) )
# 8259 "parsing_c/parser_c.ml"
               : 'direct_d))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'direct_d) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'tocro) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tccro) in
    Obj.repr(
# 1659 "parsing_c/parser_c.mly"
     ( (fst _1,fun x->(snd _1) (mk_ty (Array (Some _3,x)) [_2;_4])) )
# 8269 "parsing_c/parser_c.ml"
               : 'direct_d))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'direct_d) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'topar) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'parameter_type_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar) in
    Obj.repr(
# 1667 "parsing_c/parser_c.mly"
     ( (fst _1,fun x->(snd _1)
       (mk_ty (FunctionType (x, _3)) [_2;_4]))
     )
# 8281 "parsing_c/parser_c.ml"
               : 'direct_d_fn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_op) in
    Obj.repr(
# 1672 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;snd _2]) )
# 8289 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1673 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8297 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1674 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8305 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1675 "parsing_c/parser_c.mly"
                      ( Operator (true,  [_1;_2]) )
# 8313 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1676 "parsing_c/parser_c.mly"
                      ( Operator (true,  [_1;_2]) )
# 8321 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1677 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8329 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1678 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8337 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1679 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8345 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1680 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8353 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1681 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8361 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1682 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8369 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1683 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8377 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1684 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8385 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1685 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8393 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1686 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8401 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1687 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8409 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1688 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8417 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1689 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8425 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1690 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8433 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1691 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8441 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1692 "parsing_c/parser_c.mly"
                         ( Operator (false, [_1;_2;_3]) )
# 8450 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1693 "parsing_c/parser_c.mly"
                         ( Operator (false, [_1;_2;_3]) )
# 8459 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.assignOp) in
    Obj.repr(
# 1694 "parsing_c/parser_c.mly"
                      ( Operator (false, _1::snd _2) )
# 8467 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1695 "parsing_c/parser_c.mly"
                      ( Operator (false, [_1;_2]) )
# 8475 "parsing_c/parser_c.ml"
               : 'operator_c_plus_plus))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1701 "parsing_c/parser_c.mly"
             ( et "tocro" ();_1 )
# 8482 "parsing_c/parser_c.ml"
               : 'tocro))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1702 "parsing_c/parser_c.mly"
             ( dt "tccro" ();_1 )
# 8489 "parsing_c/parser_c.ml"
               : 'tccro))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'pointer) in
    Obj.repr(
# 1706 "parsing_c/parser_c.mly"
                                      ( _1 )
# 8496 "parsing_c/parser_c.ml"
               : 'abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'direct_abstract_declarator) in
    Obj.repr(
# 1707 "parsing_c/parser_c.mly"
                                      ( _1 )
# 8503 "parsing_c/parser_c.ml"
               : 'abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pointer) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'direct_abstract_declarator) in
    Obj.repr(
# 1709 "parsing_c/parser_c.mly"
     ( fun x -> x +> _1 +> _2 )
# 8511 "parsing_c/parser_c.ml"
               : 'abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abstract_declarator) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1713 "parsing_c/parser_c.mly"
     ( fun x -> mk_ty (ParenType (_2 x)) [_1;_3] )
# 8520 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1716 "parsing_c/parser_c.mly"
     ( fun x -> mk_ty (Array (None, x)) [_1;_2] )
# 8528 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1718 "parsing_c/parser_c.mly"
     ( fun x -> mk_ty (Array (Some _2, x)) [_1;_3] )
# 8537 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'direct_abstract_declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1720 "parsing_c/parser_c.mly"
     ( fun x -> _1 (mk_ty (Array (None, x))  [_2;_3]) )
# 8546 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'direct_abstract_declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1722 "parsing_c/parser_c.mly"
     ( fun x -> _1 (mk_ty (Array (Some _3,x))  [_2;_4]) )
# 8556 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'topar) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'parameter_type_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar) in
    Obj.repr(
# 1724 "parsing_c/parser_c.mly"
     ( fun x -> mk_ty (FunctionType (x, _2))  [_1;_3] )
# 8565 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'direct_abstract_declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'topar) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'parameter_type_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar) in
    Obj.repr(
# 1735 "parsing_c/parser_c.mly"
     ( fun x -> _1 (mk_ty (FunctionType (x, _3)) [_2;_4]) )
# 8575 "parsing_c/parser_c.ml"
               : 'direct_abstract_declarator))
; (fun __caml_parser_env ->
    Obj.repr(
# 1741 "parsing_c/parser_c.mly"
                                   ( ([], (false, [])))
# 8581 "parsing_c/parser_c.ml"
               : 'parameter_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter_list) in
    Obj.repr(
# 1742 "parsing_c/parser_c.mly"
                                   ( (_1, (false, [])))
# 8588 "parsing_c/parser_c.ml"
               : 'parameter_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1743 "parsing_c/parser_c.mly"
                                   ( (_1, (true,  [_2;_3])) )
# 8597 "parsing_c/parser_c.ml"
               : 'parameter_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 1747 "parsing_c/parser_c.mly"
            (
     let name = RegularName (mk_string_wrap _1) in
     LP.add_ident (str_of_name name);
     { p_namei = Some name;
       p_type = mk_ty NoType [];
       p_register = (false, []);
       p_endattr = Ast_c.noattr;
     }
   )
# 8612 "parsing_c/parser_c.ml"
               : 'parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorp) in
    Obj.repr(
# 1757 "parsing_c/parser_c.mly"
     ( LP.kr_impossible();
       let ((returnType,hasreg),iihasreg) = fixDeclSpecForParam _1 in
       let endattrs = (fst _2) in
       let (name, ftyp) = snd _2 in
       { p_namei = Some (name);
         p_type = ftyp returnType;
         p_register = (hasreg, iihasreg);
         p_endattr = endattrs;
       }
     )
# 8629 "parsing_c/parser_c.ml"
               : 'parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abstract_declaratorp) in
    Obj.repr(
# 1768 "parsing_c/parser_c.mly"
     ( LP.kr_impossible();
       let ((returnType,hasreg), iihasreg) = fixDeclSpecForParam _1 in
       let endattrs = Ast_c.noattr in
       { p_namei = None;
         p_type = _2 returnType;
         p_register = hasreg, iihasreg;
         p_endattr = endattrs;
       }
     )
# 8645 "parsing_c/parser_c.ml"
               : 'parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 1778 "parsing_c/parser_c.mly"
     ( let ((returnType,hasreg), iihasreg) = fixDeclSpecForParam _1 in
       { p_namei = None;
         p_type = returnType;
         p_register = hasreg, iihasreg;
         p_endattr = Ast_c.noattr;
       }
     )
# 8658 "parsing_c/parser_c.ml"
               : 'parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 1787 "parsing_c/parser_c.mly"
            (
     let name = RegularName (mk_string_wrap _1) in
     LP.add_ident (str_of_name name);
     { p_namei = Some name;
       p_type = mk_ty NoType [];
       p_register = (false, []);
       p_endattr = Ast_c.noattr;
     }
   )
# 8673 "parsing_c/parser_c.ml"
               : 'parameter_decl_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorp) in
    Obj.repr(
# 1797 "parsing_c/parser_c.mly"
     ( LP.kr_impossible();
       let ((returnType,hasreg),iihasreg) = fixDeclSpecForArg _1 in
       let endattrs = (fst _2) in
       let (name, ftyp) = snd _2 in
       { p_namei = Some (name);
         p_type = ftyp returnType;
         p_register = (hasreg, iihasreg);
         p_endattr = endattrs;
       }
     )
# 8690 "parsing_c/parser_c.ml"
               : 'parameter_decl_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abstract_declaratorp) in
    Obj.repr(
# 1808 "parsing_c/parser_c.mly"
     ( LP.kr_impossible();
       let ((returnType,hasreg), iihasreg) = fixDeclSpecForArg _1 in
       let endattrs = Ast_c.noattr in
       { p_namei = None;
         p_type = _2 returnType;
         p_register = hasreg, iihasreg;
         p_endattr = endattrs;
       }
     )
# 8706 "parsing_c/parser_c.ml"
               : 'parameter_decl_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 1818 "parsing_c/parser_c.mly"
     ( let ((returnType,hasreg), iihasreg) = fixDeclSpecForArg _1 in
       { p_namei = None;
         p_type = returnType;
         p_register = hasreg, iihasreg;
         p_endattr = Ast_c.noattr;
       }
     )
# 8719 "parsing_c/parser_c.ml"
               : 'parameter_decl_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 1828 "parsing_c/parser_c.mly"
     ( let id = RegularName (mk_string_wrap _2) in
       TypenameOrClassParam((id,None),[_1]) )
# 8728 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'ident) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec) in
    Obj.repr(
# 1831 "parsing_c/parser_c.mly"
     ( let id = RegularName (mk_string_wrap _2) in
       let ds = ([], addTypeD (_4, nullDecl)) in
       let ((returnType,_hasreg), _iihasreg) = fixDeclSpecForParam ds in
       TypenameOrClassParam((id,Some returnType),[_1;_3]) )
# 8741 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 1836 "parsing_c/parser_c.mly"
     ( let id = RegularName (mk_string_wrap _2) in
       TypenameOrClassParam((id,None),[_1]) )
# 8750 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'ident) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec) in
    Obj.repr(
# 1839 "parsing_c/parser_c.mly"
     ( let id = RegularName (mk_string_wrap _2) in
       let ds = ([], addTypeD (_4, nullDecl)) in
       let ((returnType,_hasreg), _iihasreg) = fixDeclSpecForParam ds in
       TypenameOrClassParam((id,Some returnType),[_1;_3]) )
# 8763 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec2_without_braces) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorp) in
    Obj.repr(
# 1844 "parsing_c/parser_c.mly"
     ( let ds = ([], addTypeD (_1, nullDecl)) in
       let ((returnType,_hasreg),_iihasreg) = fixDeclSpecForParam ds in
       let (name, ftyp) = snd _2 in
       VarNameParam((ftyp returnType,name,None),[]) )
# 8774 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'type_spec2_without_braces) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'declaratorp) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'initialize_arg) in
    Obj.repr(
# 1850 "parsing_c/parser_c.mly"
     ( let ds = ([], addTypeD (_1, nullDecl)) in
       let ((returnType,_hasreg),_iihasreg) = fixDeclSpecForParam ds in
       let (name, ftyp) = snd _2 in
       VarNameParam((ftyp returnType,name,Some _4),[_3]) )
# 8787 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec2_without_braces) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorp) in
    Obj.repr(
# 1855 "parsing_c/parser_c.mly"
     ( let ty  = ([], addTypeD (_2,nullDecl)) in
       let cst = {const=true  ; volatile=false; restrict=false}, _1 in
       let ds  = (fst ty, addQualifD  (cst, snd ty)) in
       let ((returnType,_hasreg),_iihasreg) = fixDeclSpecForParam ds in
       let (name, ftyp) = snd _3 in
       VarNameParam((ftyp returnType,name,None),[]) )
# 8801 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'type_spec2_without_braces) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'declaratorp) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'initialize_arg) in
    Obj.repr(
# 1862 "parsing_c/parser_c.mly"
     ( let ty  = ([], addTypeD (_2,nullDecl)) in
       let cst = {const=true  ; volatile=false; restrict=false}, _1 in
       let ds  = (fst ty, addQualifD  (cst, snd ty)) in
       let ((returnType,_hasreg),_iihasreg) = fixDeclSpecForParam ds in
       let (name, ftyp) = snd _3 in
       VarNameParam((ftyp returnType,name,Some _5),[_4]) )
# 8817 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'template_parameter_list_ne) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'template_parameter_decl2) in
    Obj.repr(
# 1869 "parsing_c/parser_c.mly"
     ( TemplateParam((_3,_5),[_1;_2;_4]) )
# 8828 "parsing_c/parser_c.ml"
               : 'template_parameter_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter_decl2) in
    Obj.repr(
# 1875 "parsing_c/parser_c.mly"
                                ( et "param" ();  _1 )
# 8835 "parsing_c/parser_c.ml"
               : 'parameter_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'template_parameter_decl2) in
    Obj.repr(
# 1876 "parsing_c/parser_c.mly"
                                                  ( et "param" ();  _1 )
# 8842 "parsing_c/parser_c.ml"
               : 'template_parameter_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 1881 "parsing_c/parser_c.mly"
               ( LP.add_ident (str_of_name (fst _1)); _2, _1 )
# 8850 "parsing_c/parser_c.ml"
               : 'declaratorp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator_fn) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 1883 "parsing_c/parser_c.mly"
               ( LP.add_ident (str_of_name (fst _1)); _2, _1 )
# 8858 "parsing_c/parser_c.ml"
               : 'declaratorp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abstract_declarator) in
    Obj.repr(
# 1886 "parsing_c/parser_c.mly"
                       ( _1 )
# 8865 "parsing_c/parser_c.ml"
               : 'abstract_declaratorp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec) in
    Obj.repr(
# 1896 "parsing_c/parser_c.mly"
                                ( ([], addTypeD (_1, nullDecl)) )
# 8872 "parsing_c/parser_c.ml"
               : 'spec_qualif_list2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_qualif) in
    Obj.repr(
# 1897 "parsing_c/parser_c.mly"
                                ( ([], {nullDecl with qualifD = (fst _1,[snd _1])}))
# 8879 "parsing_c/parser_c.ml"
               : 'spec_qualif_list2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute) in
    Obj.repr(
# 1898 "parsing_c/parser_c.mly"
                                ( ([_1], nullDecl) )
# 8886 "parsing_c/parser_c.ml"
               : 'spec_qualif_list2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'spec_qualif_list) in
    Obj.repr(
# 1899 "parsing_c/parser_c.mly"
                                ( (fst _2, addTypeD (_1,snd _2)) )
# 8894 "parsing_c/parser_c.ml"
               : 'spec_qualif_list2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_qualif) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'spec_qualif_list) in
    Obj.repr(
# 1900 "parsing_c/parser_c.mly"
                                ( (fst _2, addQualifD (_1,snd _2)) )
# 8902 "parsing_c/parser_c.ml"
               : 'spec_qualif_list2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'spec_qualif_list) in
    Obj.repr(
# 1901 "parsing_c/parser_c.mly"
                                ( ([_1]@(fst _2), snd _2) )
# 8910 "parsing_c/parser_c.ml"
               : 'spec_qualif_list2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'spec_qualif_list2) in
    Obj.repr(
# 1903 "parsing_c/parser_c.mly"
                                               (  dt "spec_qualif" (); _1 )
# 8917 "parsing_c/parser_c.ml"
               : 'spec_qualif_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1907 "parsing_c/parser_c.mly"
               ( (Ast_c.noattr,nullDecl) )
# 8923 "parsing_c/parser_c.ml"
               : 'type_qualif_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_qualif_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'type_qualif) in
    Obj.repr(
# 1908 "parsing_c/parser_c.mly"
                                ( (fst _1,addQualifD (_2,snd _1)) )
# 8931 "parsing_c/parser_c.ml"
               : 'type_qualif_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_qualif_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attribute) in
    Obj.repr(
# 1909 "parsing_c/parser_c.mly"
                                ( ((fst _1)@[_2],snd _1) )
# 8939 "parsing_c/parser_c.ml"
               : 'type_qualif_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'spec_qualif_list) in
    Obj.repr(
# 1917 "parsing_c/parser_c.mly"
     ( let (returnType, _) = fixDeclSpecForDecl _1 in returnType )
# 8946 "parsing_c/parser_c.ml"
               : Ast_c.fullType))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'spec_qualif_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abstract_declaratort) in
    Obj.repr(
# 1919 "parsing_c/parser_c.mly"
     ( let (returnType, _) = fixDeclSpecForDecl _1 in _2 returnType )
# 8954 "parsing_c/parser_c.ml"
               : Ast_c.fullType))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abstract_declarator) in
    Obj.repr(
# 1922 "parsing_c/parser_c.mly"
                       ( _1 )
# 8961 "parsing_c/parser_c.ml"
               : 'abstract_declaratort))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1932 "parsing_c/parser_c.mly"
     ( function local ->
       let (returnType,storage) = fixDeclSpecForDecl _1 in
       let iistart = Ast_c.fakeBeforeInfo() in
       DeclList ([{v_namei = None; v_type = returnType;
                   v_storage = unwrap storage; v_local = local;
		   v_attr = Ast_c.noattr;
                   v_endattr = []; v_type_bis = ref None;
                },[]],
                (_2::iistart::snd storage))
     )
# 8978 "parsing_c/parser_c.ml"
               : 'decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'init_declarator_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1942 "parsing_c/parser_c.mly"
                                          ( create_decls _1 _2 _3 )
# 8987 "parsing_c/parser_c.ml"
               : 'decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'attributes_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1947 "parsing_c/parser_c.mly"
     ( function _ ->
       MacroDecl
	 ((NoSto, [], fst _1, _3, _5, true),
          (snd _1::_2::_4::_6::fakeBeforeInfo()::[])) )
# 9002 "parsing_c/parser_c.ml"
               : 'decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : 'attributes_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : 'teq) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'initialize) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1954 "parsing_c/parser_c.mly"
     ( function _ ->
       MacroDeclInit
	 ((NoSto, [], fst _1, _3, _5, _7),
	  (snd _1::_2::_4::_6::_8::fakeBeforeInfo()::[])) )
# 9019 "parsing_c/parser_c.ml"
               : 'decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : (string * Ast_c.info)) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'macro_argument_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'attributes_opt) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1960 "parsing_c/parser_c.mly"
     ( function _ ->
       let (attrs,(sto,stoii)) = fixDeclSpecForMacroDecl _1 in
       MacroDecl
	 ((sto, attrs, fst _2, _4, _6, true),
          (snd _2::_3::_5::_7::fakeBeforeInfo()::stoii)) )
# 9036 "parsing_c/parser_c.ml"
               : 'decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 8 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 7 : (string * Ast_c.info)) in
    let _3 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 5 : 'macro_argument_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 3 : 'attributes_opt) in
    let _7 = (Parsing.peek_val __caml_parser_env 2 : 'teq) in
    let _8 = (Parsing.peek_val __caml_parser_env 1 : 'initialize) in
    let _9 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1969 "parsing_c/parser_c.mly"
     ( function _ ->
       let (attrs,(sto,stoii)) = fixDeclSpecForMacroDecl _1 in
       MacroDeclInit
	 ((sto, attrs, fst _2, _4, _6, _8),
	  (snd _2::_3::_5::_7::_9::fakeBeforeInfo()::stoii)) )
# 9055 "parsing_c/parser_c.ml"
               : 'decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'storage_class_spec) in
    Obj.repr(
# 1977 "parsing_c/parser_c.mly"
                      ( ([], {nullDecl with storageD = (fst _1, [snd _1]) }) )
# 9062 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec) in
    Obj.repr(
# 1978 "parsing_c/parser_c.mly"
                      ( ([], addTypeD (_1,nullDecl)) )
# 9069 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_qualif) in
    Obj.repr(
# 1979 "parsing_c/parser_c.mly"
                      ( ([], {nullDecl with qualifD  = (fst _1, [snd _1]) }) )
# 9076 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1980 "parsing_c/parser_c.mly"
                      ( ([], {nullDecl with inlineD = (true, [_1]) }) )
# 9083 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'align_class_prod) in
    Obj.repr(
# 1981 "parsing_c/parser_c.mly"
                      ( ([], {nullDecl with alignD = (fst _1, snd _1) }) )
# 9090 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute) in
    Obj.repr(
# 1982 "parsing_c/parser_c.mly"
                      ( ([_1], nullDecl) )
# 9097 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'storage_class_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 1983 "parsing_c/parser_c.mly"
                                 ( (fst _2, addStorageD (_1, snd _2)) )
# 9105 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_qualif) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 1984 "parsing_c/parser_c.mly"
                                 ( (fst _2, addQualifD  (_1, snd _2)) )
# 9113 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'align_class_prod) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 1985 "parsing_c/parser_c.mly"
                                 ( (fst _2, addAlignD   (_1, snd _2)) )
# 9121 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 1986 "parsing_c/parser_c.mly"
                                 ( (fst _2, addInlineD ((true, _1), snd _2)) )
# 9129 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 1987 "parsing_c/parser_c.mly"
                                 ( (_1::(fst _2), snd _2) )
# 9137 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 1988 "parsing_c/parser_c.mly"
                                 ( (fst _2, addTypeD    (_1, snd _2)) )
# 9145 "parsing_c/parser_c.ml"
               : 'decl_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1996 "parsing_c/parser_c.mly"
 (  Ast_c.Align(_3), [_1;_2;_4] )
# 9155 "parsing_c/parser_c.ml"
               : 'align_class_prod))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 1999 "parsing_c/parser_c.mly"
                ( Sto Static,  _1 )
# 9162 "parsing_c/parser_c.ml"
               : 'storage_class_spec_nt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2000 "parsing_c/parser_c.mly"
                ( Sto Extern,  _1 )
# 9169 "parsing_c/parser_c.ml"
               : 'storage_class_spec_nt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2002 "parsing_c/parser_c.mly"
     (
      let can_auto_storage =
        let open Flag in
        match !c_plus_plus with
          Off | On None -> true
        | On (Some i) -> i < 2011
      in
      if can_auto_storage
      then (Sto Auto, _1)
      else
        let i = Ast_c.parse_info_of_info _1 in
        raise
          (Semantic
            ("auto is not a valid storage since C++11, \
              try removing the version specification on the --c++ option \
              or removing the whole option",
             i))
     )
# 9193 "parsing_c/parser_c.ml"
               : 'storage_class_spec_nt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2020 "parsing_c/parser_c.mly"
                ( Sto Register,_1 )
# 9200 "parsing_c/parser_c.ml"
               : 'storage_class_spec_nt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'storage_class_spec_nt) in
    Obj.repr(
# 2023 "parsing_c/parser_c.mly"
                         ( _1 )
# 9207 "parsing_c/parser_c.ml"
               : 'storage_class_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2024 "parsing_c/parser_c.mly"
                ( StoTypedef,  _1 )
# 9214 "parsing_c/parser_c.ml"
               : 'storage_class_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl2) in
    Obj.repr(
# 2031 "parsing_c/parser_c.mly"
                         ( et "decl" (); _1 )
# 9221 "parsing_c/parser_c.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec2) in
    Obj.repr(
# 2032 "parsing_c/parser_c.mly"
                         ( dt "declspec" (); _1  )
# 9228 "parsing_c/parser_c.ml"
               : 'decl_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorifn) in
    Obj.repr(
# 2038 "parsing_c/parser_c.mly"
                                ( (Ast_c.noattr, _1, NoInit) )
# 9235 "parsing_c/parser_c.ml"
               : 'init_declarator2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'declaratorifn) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'teq) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initialize) in
    Obj.repr(
# 2039 "parsing_c/parser_c.mly"
                                ( (Ast_c.noattr, _1, ValInit(_3, [_2])) )
# 9244 "parsing_c/parser_c.ml"
               : 'init_declarator2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'declaratori) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'topar_ini_cxx) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'valinit) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar_ini) in
    Obj.repr(
# 2042 "parsing_c/parser_c.mly"
     ( (Ast_c.noattr, _1, _3 _2 _4) )
# 9254 "parsing_c/parser_c.ml"
               : 'init_declarator2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'declaratori) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_ini) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'valinit) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_ini) in
    Obj.repr(
# 2044 "parsing_c/parser_c.mly"
     ( (Ast_c.noattr, _1, _3 _2 _4) )
# 9264 "parsing_c/parser_c.ml"
               : 'init_declarator2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorifn) in
    Obj.repr(
# 2054 "parsing_c/parser_c.mly"
                                ( (Ast_c.noattr, _1, NoInit) )
# 9271 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attributes) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorifn) in
    Obj.repr(
# 2055 "parsing_c/parser_c.mly"
                                ( (_1, _2, NoInit) )
# 9279 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'declaratorifn) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'teq) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initialize) in
    Obj.repr(
# 2056 "parsing_c/parser_c.mly"
                                ( (Ast_c.noattr, _1, ValInit(_3, [_2])) )
# 9288 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'attributes) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'declaratorifn) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'teq) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'initialize) in
    Obj.repr(
# 2057 "parsing_c/parser_c.mly"
                                           ( (_1, _2, ValInit(_4, [_3])) )
# 9298 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'declaratori) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'topar_ini_cxx) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'valinit) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar_ini) in
    Obj.repr(
# 2060 "parsing_c/parser_c.mly"
     ( (Ast_c.noattr, _1, _3 _2 _4) )
# 9308 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'attributes) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'declaratori) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'topar_ini_cxx) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'valinit) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar_ini) in
    Obj.repr(
# 2062 "parsing_c/parser_c.mly"
     ( (_1, _2, _4 _3 _5) )
# 9319 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'declaratori) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_ini) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'valinit) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_ini) in
    Obj.repr(
# 2064 "parsing_c/parser_c.mly"
     ( (Ast_c.noattr, _1, _3 _2 _4) )
# 9329 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'attributes) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'declaratori) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_ini) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'valinit) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_ini) in
    Obj.repr(
# 2066 "parsing_c/parser_c.mly"
     ( (_1, _2, _4 _3 _5) )
# 9340 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2071 "parsing_c/parser_c.mly"
          ( et "teq" (); _1 )
# 9347 "parsing_c/parser_c.ml"
               : 'teq))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'init_declarator2) in
    Obj.repr(
# 2073 "parsing_c/parser_c.mly"
                                   ( dt "init" (); _1 )
# 9354 "parsing_c/parser_c.ml"
               : 'init_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'init_declarator_attrs2) in
    Obj.repr(
# 2074 "parsing_c/parser_c.mly"
                                              ( dt "init_attrs" (); _1 )
# 9361 "parsing_c/parser_c.ml"
               : 'init_declarator_attrs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 2083 "parsing_c/parser_c.mly"
     ( LP.add_ident (str_of_name (fst _1)); _1, _2 )
# 9369 "parsing_c/parser_c.ml"
               : 'declaratori))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'gcc_asm_decl) in
    Obj.repr(
# 2086 "parsing_c/parser_c.mly"
     ( LP.add_ident (str_of_name (fst _1)); _1, [] )
# 9377 "parsing_c/parser_c.ml"
               : 'declaratori))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 2090 "parsing_c/parser_c.mly"
     ( LP.add_ident (str_of_name (fst _1)); _1, _2 )
# 9385 "parsing_c/parser_c.ml"
               : 'declaratorifn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'gcc_asm_decl) in
    Obj.repr(
# 2093 "parsing_c/parser_c.mly"
     ( LP.add_ident (str_of_name (fst _1)); _1, [] )
# 9393 "parsing_c/parser_c.ml"
               : 'declaratorifn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator_fn) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 2095 "parsing_c/parser_c.mly"
     ( LP.add_ident (str_of_name (fst _1)); _1, _2 )
# 9401 "parsing_c/parser_c.ml"
               : 'declaratorifn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator_fn) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'gcc_asm_decl) in
    Obj.repr(
# 2098 "parsing_c/parser_c.mly"
     ( LP.add_ident (str_of_name (fst _1)); _1, [] )
# 9409 "parsing_c/parser_c.ml"
               : 'declaratorifn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'asmbody) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2101 "parsing_c/parser_c.mly"
                                         (  )
# 9419 "parsing_c/parser_c.ml"
               : 'gcc_asm_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'asmbody) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2102 "parsing_c/parser_c.mly"
                                        (  )
# 9430 "parsing_c/parser_c.ml"
               : 'gcc_asm_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assign_expr) in
    Obj.repr(
# 2108 "parsing_c/parser_c.mly"
     ( InitExpr _1,                [] )
# 9437 "parsing_c/parser_c.ml"
               : 'initialize))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_ini) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'outer_initialize_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_ini) in
    Obj.repr(
# 2110 "parsing_c/parser_c.mly"
     ( _2 _1 _3 )
# 9446 "parsing_c/parser_c.ml"
               : 'initialize))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'arith_expr_nosup) in
    Obj.repr(
# 2114 "parsing_c/parser_c.mly"
     ( InitExpr _1,                [] )
# 9453 "parsing_c/parser_c.ml"
               : 'initialize_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_ini) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'outer_initialize_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_ini) in
    Obj.repr(
# 2116 "parsing_c/parser_c.mly"
     ( _2 _1 _3 )
# 9462 "parsing_c/parser_c.ml"
               : 'initialize_arg))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'initialize2) in
    Obj.repr(
# 2127 "parsing_c/parser_c.mly"
                                        ( [_1, []] )
# 9469 "parsing_c/parser_c.ml"
               : 'initialize_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'initialize_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initialize2) in
    Obj.repr(
# 2128 "parsing_c/parser_c.mly"
                                        ( (_3, [_2])::_1 )
# 9478 "parsing_c/parser_c.ml"
               : 'initialize_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'initialize_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initialize2) in
    Obj.repr(
# 2129 "parsing_c/parser_c.mly"
                                        ( (_3, [_2])::_1 )
# 9487 "parsing_c/parser_c.ml"
               : 'initialize_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 2132 "parsing_c/parser_c.mly"
               ( fun lb rb -> InitList [], [lb;rb] )
# 9493 "parsing_c/parser_c.ml"
               : 'outer_initialize_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'initialize_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'gcc_comma_opt_struct) in
    Obj.repr(
# 2134 "parsing_c/parser_c.mly"
     ( fun lb rb -> InitList (List.rev _1),   [lb;rb] @ snd _2 )
# 9501 "parsing_c/parser_c.ml"
               : 'outer_initialize_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'outer_initialize_list) in
    Obj.repr(
# 2137 "parsing_c/parser_c.mly"
                        ( fun lb rb -> ValInit(_1 lb rb,[]) )
# 9508 "parsing_c/parser_c.ml"
               : 'valinit))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cond_expr) in
    Obj.repr(
# 2142 "parsing_c/parser_c.mly"
     ( InitExpr _1,   [] )
# 9515 "parsing_c/parser_c.ml"
               : 'initialize2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_ini) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'outer_initialize_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_ini) in
    Obj.repr(
# 2144 "parsing_c/parser_c.mly"
     ( _2 _1 _3 )
# 9524 "parsing_c/parser_c.ml"
               : 'initialize2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'designator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initialize2) in
    Obj.repr(
# 2148 "parsing_c/parser_c.mly"
     ( InitDesignators (_1, _3), [_2] )
# 9533 "parsing_c/parser_c.ml"
               : 'initialize2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'ident) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initialize2) in
    Obj.repr(
# 2152 "parsing_c/parser_c.mly"
     ( InitFieldOld (fst _1, _3),     [snd _1; _2] )
# 9542 "parsing_c/parser_c.ml"
               : 'initialize2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 2163 "parsing_c/parser_c.mly"
     ( DesignatorField (fst _2), [_1;snd _2] )
# 9550 "parsing_c/parser_c.ml"
               : 'designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2165 "parsing_c/parser_c.mly"
     ( DesignatorIndex (_2),  [_1;_3] )
# 9559 "parsing_c/parser_c.ml"
               : 'designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'const_expr) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2167 "parsing_c/parser_c.mly"
     ( DesignatorRange (_2, _4),  [_1;_3;_5] )
# 9570 "parsing_c/parser_c.ml"
               : 'designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2175 "parsing_c/parser_c.mly"
          (  true, [_1] )
# 9577 "parsing_c/parser_c.ml"
               : 'gcc_comma_opt_struct))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2176 "parsing_c/parser_c.mly"
            (  false, [_1] )
# 9584 "parsing_c/parser_c.ml"
               : 'gcc_comma_opt_struct))
; (fun __caml_parser_env ->
    Obj.repr(
# 2177 "parsing_c/parser_c.mly"
                    ( false, [fakeAfterInfo() +> Ast_c.rewrap_str ","]  )
# 9590 "parsing_c/parser_c.ml"
               : 'gcc_comma_opt_struct))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : 'cpp_struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : 'ident) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'optfinal) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : 'base_classes) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_struct) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_struct_decl_list_gcc) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_struct) in
    Obj.repr(
# 2186 "parsing_c/parser_c.mly"
     ( StructUnion (fst _1, Some (fst _2), _3, _5, _7),  [snd _1;snd _2;_4;_6;_8]  )
# 9604 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'cpp_struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'ident) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'optfinal) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_struct) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_struct_decl_list_gcc) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_struct) in
    Obj.repr(
# 2188 "parsing_c/parser_c.mly"
     ( StructUnion (fst _1, Some (fst _2), _3, [], _5),  [snd _1;snd _2;_4;_6]  )
# 9616 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'ident) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_struct) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'struct_decl_list_gcc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_struct) in
    Obj.repr(
# 2190 "parsing_c/parser_c.mly"
     ( StructUnion (fst _1, Some (fst _2), None, [], _4),  [snd _1;snd _2;_3;_5]  )
# 9627 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'cpp_struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'base_classes) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_struct) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_struct_decl_list_gcc) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_struct) in
    Obj.repr(
# 2193 "parsing_c/parser_c.mly"
     ( StructUnion (fst _1, None, None, _3, _5), [snd _1;_2;_4;_6] )
# 9639 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'cpp_struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_struct) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_struct_decl_list_gcc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_struct) in
    Obj.repr(
# 2195 "parsing_c/parser_c.mly"
     ( StructUnion (fst _1, None, None, [], _3), [snd _1;_2;_4] )
# 9649 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'tobrace_struct) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'struct_decl_list_gcc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_struct) in
    Obj.repr(
# 2197 "parsing_c/parser_c.mly"
     ( StructUnion (fst _1, None, None, [], _3), [snd _1;_2;_4] )
# 9659 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 2199 "parsing_c/parser_c.mly"
     ( StructUnionName (fst _1, fst _2), [snd _1;snd _2] )
# 9667 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_struct_or_union) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 2201 "parsing_c/parser_c.mly"
     ( StructUnionName (fst _1, fst _2), [snd _1;snd _2] )
# 9675 "parsing_c/parser_c.ml"
               : 's_or_u_spec2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2204 "parsing_c/parser_c.mly"
             ( Struct, _1 )
# 9682 "parsing_c/parser_c.ml"
               : 'struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2205 "parsing_c/parser_c.mly"
             ( Union, _1 )
# 9689 "parsing_c/parser_c.ml"
               : 'struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes) in
    Obj.repr(
# 2207 "parsing_c/parser_c.mly"
                        ( Struct, _1 (* TODO *) )
# 9697 "parsing_c/parser_c.ml"
               : 'struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes) in
    Obj.repr(
# 2208 "parsing_c/parser_c.mly"
                        ( Union, _1  (* TODO *) )
# 9705 "parsing_c/parser_c.ml"
               : 'struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2211 "parsing_c/parser_c.mly"
                 ( Struct, _1 )
# 9712 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2212 "parsing_c/parser_c.mly"
                 ( Union, _1 )
# 9719 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2213 "parsing_c/parser_c.mly"
                 ( Class, _1 )
# 9726 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes) in
    Obj.repr(
# 2215 "parsing_c/parser_c.mly"
                            ( Struct, _1 (* TODO *) )
# 9734 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes) in
    Obj.repr(
# 2216 "parsing_c/parser_c.mly"
                            ( Union, _1  (* TODO *) )
# 9742 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes) in
    Obj.repr(
# 2217 "parsing_c/parser_c.mly"
                            ( Class, _1  (* TODO *) )
# 9750 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'field_declaration) in
    Obj.repr(
# 2221 "parsing_c/parser_c.mly"
                     ( DeclarationField _1 )
# 9757 "parsing_c/parser_c.ml"
               : 'struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2222 "parsing_c/parser_c.mly"
           ( EmptyField _1  )
# 9764 "parsing_c/parser_c.ml"
               : 'struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'identifier) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'attributes_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2228 "parsing_c/parser_c.mly"
     ( MacroDeclField ((fst _1, _3, _5), [snd _1;_2;_4;_6;fakeBeforeInfo()]) )
# 9776 "parsing_c/parser_c.ml"
               : 'struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : (string * Ast_c.info)) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'attributes_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2231 "parsing_c/parser_c.mly"
     ( MacroDeclField ((fst _1, _3, _5), [snd _1;_2;_4;_6;fakeBeforeInfo()]) )
# 9788 "parsing_c/parser_c.ml"
               : 'struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.cpp_directive) in
    Obj.repr(
# 2235 "parsing_c/parser_c.mly"
     ( CppDirectiveStruct _1 )
# 9795 "parsing_c/parser_c.ml"
               : 'struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_directive) in
    Obj.repr(
# 2237 "parsing_c/parser_c.mly"
     ( IfdefStruct _1 )
# 9802 "parsing_c/parser_c.ml"
               : 'struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'function_definition) in
    Obj.repr(
# 2243 "parsing_c/parser_c.mly"
                                     ( FunctionField _1 )
# 9809 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 2245 "parsing_c/parser_c.mly"
     ( match _1 Ast_c.NotLocalDecl with
       DeclList (onedecllist,odii) ->
	 DeclarationField
	   (FieldDeclList
	      (onedecllist +>
	       (List.map
		  (fun (dec,comma) ->
		    (Simple(dec.v_storage, dec.v_attr,dec.v_namei, dec.v_type, dec.v_endattr),comma))),
	       odii))
     | MacroDecl ((NoSto, [], s, es, attrs, true), ([iis;lp;rp;iiend;ifakestart] as ii)) ->
	 MacroDeclField ((s, es, attrs), ii)
     | MacroDecl ((sto, preattrs, s, es, attrs, true), ii (*iis::lp::rp::iiend::ifakestart::iisto*)) ->
	 let iis = List.hd ii in
	 raise (Semantic ("storage or preattrs unexpected in field",Ast_c.parse_info_of_info iis))
     | MacroDecl ((sto, preattrs, s, es, attrs, false), ii (*iis::lp::rp::ifakestart::iisto*)) ->
	 let iis = List.hd ii in
	 raise (Semantic ("no semicolon case not supported",Ast_c.parse_info_of_info iis))
     | MacroDeclInit ((NoSto, [], s, es, attrs, ini), ([iis;lp;rp;eq;iiend;ifakestart] as ii)) ->
	 MacroDeclFieldInit ((s, es, attrs, ini), ii)
     | MacroDeclInit ((sto, preattrs, s, es, attrs, ini), ii(*iis::lp::rp::eq::iiend::ifakestart::iisto*)) ->
	 let iis = List.hd ii in
	 raise (Semantic ("storage unexpected in field",Ast_c.parse_info_of_info iis))
     )
# 9838 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2268 "parsing_c/parser_c.mly"
           ( EmptyField _1  )
# 9845 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'c_plus_plus_constructor_decl) in
    Obj.repr(
# 2274 "parsing_c/parser_c.mly"
                                ( ConstructDestructField _1 )
# 9852 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.cpp_directive) in
    Obj.repr(
# 2278 "parsing_c/parser_c.mly"
     ( CppDirectiveStruct _1 )
# 9859 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_directive) in
    Obj.repr(
# 2280 "parsing_c/parser_c.mly"
     ( IfdefStruct _1 )
# 9866 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2283 "parsing_c/parser_c.mly"
                      ( PublicLabel [_1;_2] )
# 9874 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2284 "parsing_c/parser_c.mly"
                      ( ProtectedLabel [_1;_2] )
# 9882 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2285 "parsing_c/parser_c.mly"
                      ( PrivateLabel [_1;_2] )
# 9890 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : 'pre_member_function) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : 'parameter_type_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : 'constr_inits) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'post_constructor) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2290 "parsing_c/parser_c.mly"
     ( (* allowing constr_inits solves a parser conflict, because we don't know if
       a ; will be reached *)
       assert (_6 = ([],[]));
       (ConstructorDecl (_1,fst _2, _4, _7)), [snd _2;_3;_5;_8;fakeBeforeInfo()] )
# 9907 "parsing_c/parser_c.ml"
               : 'c_plus_plus_constructor_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : 'pre_member_function) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : 'parameter_type_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'post_constructor) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2295 "parsing_c/parser_c.mly"
     ( (DestructorDecl (_1, fst _3, _5, _7)), [_2;snd _3;_4;_6;_8;fakeBeforeInfo()] )
# 9921 "parsing_c/parser_c.ml"
               : 'c_plus_plus_constructor_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : 'pre_member_function) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : 'parameter_type_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : 'constr_inits) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'post_constructor) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 2298 "parsing_c/parser_c.mly"
     ( (ConstructorDef (_1, fst _2, _4, _6, _7, fst _8)),
       (snd _2) :: _3 :: _5 :: snd _8 @[fakeBeforeInfo()] )
# 9936 "parsing_c/parser_c.ml"
               : 'c_plus_plus_constructor_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : 'pre_member_function) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : 'parameter_type_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'post_constructor) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 2301 "parsing_c/parser_c.mly"
     ( (DestructorDef (_1, fst _3, _5, _7, fst _8)),
       _2 :: snd _3 :: _4 :: _6 :: snd _8 @[fakeBeforeInfo()] )
# 9951 "parsing_c/parser_c.ml"
               : 'c_plus_plus_constructor_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'constructor_init_list) in
    Obj.repr(
# 2305 "parsing_c/parser_c.mly"
                                ( _2,[_1] )
# 9959 "parsing_c/parser_c.ml"
               : 'constr_inits))
; (fun __caml_parser_env ->
    Obj.repr(
# 2306 "parsing_c/parser_c.mly"
              ( ([],[]) )
# 9965 "parsing_c/parser_c.ml"
               : 'constr_inits))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'constructor_init) in
    Obj.repr(
# 2309 "parsing_c/parser_c.mly"
                    ( [_1,[]] )
# 9972 "parsing_c/parser_c.ml"
               : 'constructor_init_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'constructor_init_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'constructor_init) in
    Obj.repr(
# 2310 "parsing_c/parser_c.mly"
                                                 ( _1 @ [_3,    [_2]] )
# 9981 "parsing_c/parser_c.ml"
               : 'constructor_init_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'ident_cpp) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2313 "parsing_c/parser_c.mly"
                                       ( ((_1,_3),[_2;_4]) )
# 9991 "parsing_c/parser_c.ml"
               : 'constructor_init))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'ident_cpp) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2314 "parsing_c/parser_c.mly"
                                           ( ((_1,_3),[_2;_4]) )
# 10001 "parsing_c/parser_c.ml"
               : 'constructor_init))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2317 "parsing_c/parser_c.mly"
              ( (true, [_1]) )
# 10008 "parsing_c/parser_c.ml"
               : 'pre_member_function))
; (fun __caml_parser_env ->
    Obj.repr(
# 2318 "parsing_c/parser_c.mly"
              ( (false, []) )
# 10014 "parsing_c/parser_c.ml"
               : 'pre_member_function))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2321 "parsing_c/parser_c.mly"
              ( (true, [_1]) )
# 10021 "parsing_c/parser_c.ml"
               : 'post_constructor))
; (fun __caml_parser_env ->
    Obj.repr(
# 2322 "parsing_c/parser_c.mly"
              ( (false, []) )
# 10027 "parsing_c/parser_c.ml"
               : 'post_constructor))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2325 "parsing_c/parser_c.mly"
              ( Some _1 )
# 10034 "parsing_c/parser_c.ml"
               : 'optfinal))
; (fun __caml_parser_env ->
    Obj.repr(
# 2326 "parsing_c/parser_c.mly"
              ( None )
# 10040 "parsing_c/parser_c.ml"
               : 'optfinal))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'struct_declarator_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2330 "parsing_c/parser_c.mly"
     (
       let (returnType,storage) = fixDeclSpecForDecl _1 in
       (if fst3 (unwrap storage) <> NoSto
       then
	 raise
	   (Semantic
	      ("field_declaration: case 1: parsing don't allow this",
	       Ast_c.parse_info_of_info _3)));

       let iistart = Ast_c.fakeBeforeInfo() in (* for parallel with DeclList *)
       FieldDeclList (_2 +> (List.map (fun (f, iivirg) ->
         f returnType, iivirg))
                         ,[_3;iistart])
         (* don't need to check if typedef or func initialised cos
          * grammar don't allow typedef nor initialiser in struct
          *)
     )
# 10065 "parsing_c/parser_c.ml"
               : 'field_declaration))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2349 "parsing_c/parser_c.mly"
     (
       (* gccext: allow empty elements if it is a structdef or enumdef *)
       let (returnType,storage) = fixDeclSpecForDecl _1 in
       (if fst3 (unwrap storage) <> NoSto
       then
	 raise
	   (Semantic
	      ("field_declaration: case 2: parsing don't allow this",
	       Ast_c.parse_info_of_info _2)));

       let iistart = Ast_c.fakeBeforeInfo() in (* for parallel with DeclList *)
       FieldDeclList
	 ([(Simple ((NoSto,false,NoAlign), [], None, returnType, Ast_c.noattr)) , []], [_2;iistart])
     )
# 10086 "parsing_c/parser_c.ml"
               : 'field_declaration))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'simple_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'dotdot) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'const_expr2) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2366 "parsing_c/parser_c.mly"
     ( let ty = ([], addTypeD (_1, nullDecl)) in
       let decl = [(fun x -> BitField (None, x, _2, _3)),[]] in
       let (returnType,storage) = fixDeclSpecForDecl ty in
       (if fst3 (unwrap storage) <> NoSto
       then
	 raise
	   (Semantic
	      ("field_declaration: case 3: parsing don't allow this",
	       Ast_c.parse_info_of_info _2)));

       let iistart = Ast_c.fakeBeforeInfo() in (* for parallel with DeclList *)
       FieldDeclList (decl +> (List.map (fun (f, iivirg) ->
         f returnType, iivirg))
                         ,[_4;iistart])
     )
# 10110 "parsing_c/parser_c.ml"
               : 'field_declaration))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 2384 "parsing_c/parser_c.mly"
     ( (fun x -> Simple   ((NoSto,false,NoAlign), [], Some (fst _1,NoInit), (snd _1) x, _2)) )
# 10118 "parsing_c/parser_c.ml"
               : 'struct_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'declarator) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'dotdot) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'const_expr2) in
    Obj.repr(
# 2386 "parsing_c/parser_c.mly"
     ( (fun x -> BitField (Some (fst _1), ((snd _1) x), _2, _3)) )
# 10127 "parsing_c/parser_c.ml"
               : 'struct_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator_fn) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 2388 "parsing_c/parser_c.mly"
     ( (fun x -> Simple   ((NoSto,false,NoAlign), [], Some (fst _1,NoInit), (snd _1) x, _2)) )
# 10135 "parsing_c/parser_c.ml"
               : 'struct_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'declarator_fn) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'dotdot) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'const_expr2) in
    Obj.repr(
# 2390 "parsing_c/parser_c.mly"
     ( (fun x -> BitField (Some (fst _1), ((snd _1) x), _2, _3)) )
# 10144 "parsing_c/parser_c.ml"
               : 'struct_declarator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 's_or_u_spec2) in
    Obj.repr(
# 2395 "parsing_c/parser_c.mly"
                                   ( dt "su" (); _1 )
# 10151 "parsing_c/parser_c.ml"
               : 'struct_or_union_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'struct_or_union2) in
    Obj.repr(
# 2396 "parsing_c/parser_c.mly"
                                  ( et "su" (); _1 )
# 10158 "parsing_c/parser_c.ml"
               : 'struct_or_union))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_struct_or_union2) in
    Obj.repr(
# 2397 "parsing_c/parser_c.mly"
                                          ( et "su" (); _1 )
# 10165 "parsing_c/parser_c.ml"
               : 'cpp_struct_or_union))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'struct_decl2) in
    Obj.repr(
# 2398 "parsing_c/parser_c.mly"
                           ( et "struct" (); _1 )
# 10172 "parsing_c/parser_c.ml"
               : 'struct_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_struct_decl2) in
    Obj.repr(
# 2399 "parsing_c/parser_c.mly"
                                   ( et "struct" (); _1 )
# 10179 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2401 "parsing_c/parser_c.mly"
                 ( et "dotdot" (); _1 )
# 10186 "parsing_c/parser_c.ml"
               : 'dotdot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'const_expr) in
    Obj.repr(
# 2402 "parsing_c/parser_c.mly"
                        ( dt "const_expr2" (); _1 )
# 10193 "parsing_c/parser_c.ml"
               : 'const_expr2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'struct_decl_list) in
    Obj.repr(
# 2405 "parsing_c/parser_c.mly"
                     ( _1 )
# 10200 "parsing_c/parser_c.ml"
               : 'struct_decl_list_gcc))
; (fun __caml_parser_env ->
    Obj.repr(
# 2406 "parsing_c/parser_c.mly"
                         ( [] )
# 10206 "parsing_c/parser_c.ml"
               : 'struct_decl_list_gcc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_struct_decl_list) in
    Obj.repr(
# 2409 "parsing_c/parser_c.mly"
                         ( _1 )
# 10213 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl_list_gcc))
; (fun __caml_parser_env ->
    Obj.repr(
# 2410 "parsing_c/parser_c.mly"
                         ( [] )
# 10219 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl_list_gcc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'enum_ident) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'enum_base) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'tobrace_enum) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'enumerator_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'gcc_comma_opt_struct) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'tcbrace_enum) in
    Obj.repr(
# 2419 "parsing_c/parser_c.mly"
     (
      let (ty, td) = Common.default (None, []) (function x -> x) _2 in
      let (enumname, ii) = _1 in
      let tmp =
       (dt "spec_qualif" ();
	(addTypeD(
	     (dt "type" (); (Right3 enumname, ii)),nullDecl))) in
      let (returnType, _) = fixDeclSpecForDecl ([],tmp) in
      let comma_opt =
	if List.length _4 = 0
	then [] else snd _5 in
      (EnumDef (returnType, ty, _4), td@[_3;_6] @ comma_opt)
    )
# 10243 "parsing_c/parser_c.ml"
               : 'enum_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'enum_key) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 2435 "parsing_c/parser_c.mly"
     (
      let rt = ((Some (fst _2), _3),       [_1; snd _2; snd _3]) in
      let ((key, ident), ii) = rt in
      (EnumName (key, Some (fst ident)), ii)
    )
# 10256 "parsing_c/parser_c.ml"
               : 'enum_ident_independant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ident) in
    Obj.repr(
# 2441 "parsing_c/parser_c.mly"
     (
      let rt = ((None, _2),       [_1; snd _2]) in
      let ((key, ident), ii) = rt in
      (EnumName (key, Some (fst ident)), ii)
    )
# 10268 "parsing_c/parser_c.ml"
               : 'enum_ident_independant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'enum_key) in
    Obj.repr(
# 2449 "parsing_c/parser_c.mly"
     (
      (EnumName (Some (fst _2), None), [_1; snd _2])
    )
# 10278 "parsing_c/parser_c.ml"
               : 'enum_ident_dependant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2453 "parsing_c/parser_c.mly"
     (
      (EnumName (None, None), [_1])
    )
# 10287 "parsing_c/parser_c.ml"
               : 'enum_ident_dependant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'enum_ident_independant) in
    Obj.repr(
# 2458 "parsing_c/parser_c.mly"
                           ( _1 )
# 10294 "parsing_c/parser_c.ml"
               : 'enum_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'enum_ident_dependant) in
    Obj.repr(
# 2459 "parsing_c/parser_c.mly"
                           ( _1 )
# 10301 "parsing_c/parser_c.ml"
               : 'enum_ident))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'simple_type) in
    Obj.repr(
# 2463 "parsing_c/parser_c.mly"
     ( let tmp =
       (dt "spec_qualif" ();
	([],(addTypeD(
	     (dt "type" (); _2),nullDecl)))) in
     let (returnType, _) = fixDeclSpecForDecl tmp in
     Some (Some returnType, [_1]) )
# 10314 "parsing_c/parser_c.ml"
               : 'enum_base))
; (fun __caml_parser_env ->
    Obj.repr(
# 2469 "parsing_c/parser_c.mly"
               ( None )
# 10320 "parsing_c/parser_c.ml"
               : 'enum_base))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2472 "parsing_c/parser_c.mly"
               ( et "su" (); (Struct, _1) )
# 10327 "parsing_c/parser_c.ml"
               : 'enum_key))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2473 "parsing_c/parser_c.mly"
          ( et "su" (); (Class, _1) )
# 10334 "parsing_c/parser_c.ml"
               : 'enum_key))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'idente) in
    Obj.repr(
# 2476 "parsing_c/parser_c.mly"
                          ( _1, None     )
# 10341 "parsing_c/parser_c.ml"
               : 'enumerator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'idente) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'const_expr) in
    Obj.repr(
# 2477 "parsing_c/parser_c.mly"
                          ( _1, Some (_2, _3) )
# 10350 "parsing_c/parser_c.ml"
               : 'enumerator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident_cpp) in
    Obj.repr(
# 2484 "parsing_c/parser_c.mly"
                  ( LP.add_ident (str_of_name _1); _1 )
# 10357 "parsing_c/parser_c.ml"
               : 'idente))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'function_def) in
    Obj.repr(
# 2491 "parsing_c/parser_c.mly"
                                     ( fixFunc _1 )
# 10364 "parsing_c/parser_c.ml"
               : 'function_definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.cpp_directive) in
    Obj.repr(
# 2495 "parsing_c/parser_c.mly"
                                    ( )
# 10371 "parsing_c/parser_c.ml"
               : 'cpp_directive_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_directive_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.cpp_directive) in
    Obj.repr(
# 2496 "parsing_c/parser_c.mly"
                                    ( )
# 10379 "parsing_c/parser_c.ml"
               : 'cpp_directive_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'start_fun) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 2499 "parsing_c/parser_c.mly"
                           ( LP.del_scope(); (_1, _2, None) )
# 10387 "parsing_c/parser_c.ml"
               : 'function_def))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'start_fun) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_directive_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 2500 "parsing_c/parser_c.mly"
                                         ( LP.del_scope(); (_1, _3, None) )
# 10396 "parsing_c/parser_c.ml"
               : 'function_def))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'start_fun2) in
    Obj.repr(
# 2508 "parsing_c/parser_c.mly"
  ( LP.new_scope();
    let (fn, endattrs) = _1 in
    fix_add_params_ident fn;
    (* toreput? !LP._lexer_hint.toplevel <- false;  *)
    (fn,endattrs)
  )
# 10408 "parsing_c/parser_c.ml"
               : 'start_fun))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'declaratorfd) in
    Obj.repr(
# 2516 "parsing_c/parser_c.mly"
     ( let (returnType,storage) = fixDeclSpecForFuncDef _1 in
       let (id, endattrs) = _2 in
       (fst id, fixOldCDecl ((snd id) returnType), storage, [], []), endattrs
     )
# 10419 "parsing_c/parser_c.ml"
               : 'start_fun2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ctor_dtor) in
    Obj.repr(
# 2520 "parsing_c/parser_c.mly"
              ( _1, [] )
# 10426 "parsing_c/parser_c.ml"
               : 'start_fun2))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'topar) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'parameter_type_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tcpar) in
    Obj.repr(
# 2523 "parsing_c/parser_c.mly"
                                                    (
     let id = RegularName (mk_string_wrap _1) in
     let ret = mk_ty NoType [] in
     let ty = mk_ty (FunctionType (ret, _3)) [_2;_4] in
     let storage = ((NoSto,false,NoAlign),[]) in
     (id, ty, storage, [], []) )
# 10441 "parsing_c/parser_c.ml"
               : 'ctor_dtor))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'topar) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'parameter_type_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'tcpar) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'constr_extra_list) in
    Obj.repr(
# 2529 "parsing_c/parser_c.mly"
                                                                              (
     let id = RegularName (mk_string_wrap _1) in
     let ret = mk_ty NoType [] in
     let ty = mk_ty (FunctionType (ret, _3)) [_2;_4] in
     let storage = ((NoSto,false,NoAlign),[]) in
     (id, ty, storage, [_5], _6) )
# 10458 "parsing_c/parser_c.ml"
               : 'ctor_dtor))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2538 "parsing_c/parser_c.mly"
     ( let fn = mk_e(Ident (RegularName (mk_string_wrap _1))) [] in
       (mk_e(FunCall (fn, _3)) [_2;_4]) )
# 10469 "parsing_c/parser_c.ml"
               : 'constr_extra))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2541 "parsing_c/parser_c.mly"
     ( let fn = mk_e(Ident (RegularName (mk_string_wrap _1))) [] in
       (mk_e(FunCall (fn, _3)) [_2;_4]) )
# 10480 "parsing_c/parser_c.ml"
               : 'constr_extra))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'declarator_fn) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attributes_opt) in
    Obj.repr(
# 2559 "parsing_c/parser_c.mly"
   ( et "declaratorfd" (); _1, _2 )
# 10488 "parsing_c/parser_c.ml"
               : 'declaratorfd))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : (Ast_c.info * bool ref)) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : (string * Ast_c.info)) in
    Obj.repr(
# 2567 "parsing_c/parser_c.mly"
     (
       let (i1, in_ifdef) = _1 in
       let (s, i2) = _2 in

       (* redo some lexing work :( *)
       let inc_file =
         match () with
         | _ when s =~ "^\"\\(.*\\)\"$" ->
             Local (Common.split "/" (matched1 s))
         | _ when s =~ "^\\<\\(.*\\)\\>$" ->
             NonLocal (Common.split "/" (matched1 s))
         | _ ->
             Weird s
       in
       Include { i_include = (inc_file, [i1;i2]);
                 i_rel_pos = Ast_c.noRelPos();
                 i_overall_rel_pos = Ast_c.noRelPos();
                 i_is_in_ifdef = !in_ifdef;
                 i_content = Ast_c.noi_content;
       }
     )
# 10516 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : (string * Ast_c.info)) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'define_val) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2590 "parsing_c/parser_c.mly"
     ( let name = fst _2 in
       Define ((name, [_1; snd _2;_4]),
	       (DefineVar, (_3 (Ast_c.is_fake _1) (Left name)))) )
# 10528 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : (string * Ast_c.info)) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'call_param_define_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'define_val) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2600 "parsing_c/parser_c.mly"
     ( LP.restore_typedef_state();
       Data.clear_define_params();
       let name = fst _2 in
       Define
         ((name, [_1; snd _2; _7]),
           (DefineFunc (_4, [_3;_5]), (_6 (Ast_c.is_fake _1) (Right name))))
     )
# 10547 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : (string * Ast_c.info)) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2609 "parsing_c/parser_c.mly"
     ( Define((fst _2, [_1; snd _2; _3]), (Undef,DefineEmpty)) )
# 10556 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'pragma_strings) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2612 "parsing_c/parser_c.mly"
     ( Pragma((RegularName (mk_string_wrap _2),_3),[_1;_4]) )
# 10566 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2614 "parsing_c/parser_c.mly"
                      ( OtherDirective ([_1]) )
# 10573 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_type_noparen) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2618 "parsing_c/parser_c.mly"
     ( let (s,i1) = _2 in
       LP.add_typedef_root s i1;
       let name = RegularName (mk_string_wrap _2) in
       UsingTypename ((name, _5), [_1;_3;_4;_6]) )
# 10588 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_type_noparen) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2623 "parsing_c/parser_c.mly"
     ( let (s,i1) = _2 in
       LP.add_typedef_root s i1;
       let name = RegularName (mk_string_wrap _2) in
       UsingTypename ((name, _4), [_1;_3;_5]) )
# 10602 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_type_noparen) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2628 "parsing_c/parser_c.mly"
     ( let name = RegularName (mk_string_wrap _2) in
       UsingTypename ((name, _5), [_1;_3;_4;_6]) )
# 10615 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_type_noparen) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2631 "parsing_c/parser_c.mly"
     ( let name = RegularName (mk_string_wrap _2) in
       UsingTypename ((name, _4), [_1;_3;_5]) )
# 10627 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'identifier_cpp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2634 "parsing_c/parser_c.mly"
     ( UsingMember (_2, [_1;_3]) )
# 10636 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'identifier_cpp) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2636 "parsing_c/parser_c.mly"
     ( UsingNamespace (_3, [_1;_2;_4]) )
# 10646 "parsing_c/parser_c.ml"
               : Ast_c.cpp_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 2639 "parsing_c/parser_c.mly"
                 ( [(fst _1, [snd _1])] )
# 10653 "parsing_c/parser_c.ml"
               : 'pragma_strings))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'pragma_strings) in
    Obj.repr(
# 2640 "parsing_c/parser_c.mly"
                                ( (fst _1, [snd _1])::_2 )
# 10661 "parsing_c/parser_c.ml"
               : 'pragma_strings))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.expression) in
    Obj.repr(
# 2646 "parsing_c/parser_c.mly"
             ( fun _ _ -> DefineExpr _1 )
# 10668 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 2647 "parsing_c/parser_c.mly"
             ( fun _ _ -> DefineStmt _1 )
# 10675 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 2648 "parsing_c/parser_c.mly"
             ( fun _ _ -> DefineStmt (mk_st (Decl (_1 Ast_c.NotLocalDecl)) Ast_c.noii) )
# 10682 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 2651 "parsing_c/parser_c.mly"
     ( fun isfake name ->
       match _1 with
	 ((_::_) as a, d) when d = nullDecl ->
	   (if not isfake (* fake is for category test *)
	   then
	     (match name with
	       Left name ->
		 Data.add_special_name name Data.Attr
	     | Right name ->
		 Data.add_special_name name Data.AttrArgs));
	   DefineAttr a
       | _ ->
	   let returnType = fixDeclSpecForMacro _1 in
	   DefineType returnType
     )
# 10703 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abstract_declarator) in
    Obj.repr(
# 2667 "parsing_c/parser_c.mly"
     ( fun _ _ ->
       let returnType = fixDeclSpecForMacro _1 in
       let typ = _2 returnType in
       DefineType typ
     )
# 10715 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stat_or_decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'stat_or_decl_list) in
    Obj.repr(
# 2674 "parsing_c/parser_c.mly"
     ( fun _ _ ->
         DefineMulti
	 (List.map
	    (function
		StmtElem e -> e
	      | _ -> failwith "unexpected statement for DefineMulti")
	    (_1 :: _2)) )
# 10729 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'function_definition) in
    Obj.repr(
# 2682 "parsing_c/parser_c.mly"
                       ( fun _ _ -> DefineFunction _1 )
# 10736 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'outer_initialize_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'comma_opt) in
    Obj.repr(
# 2685 "parsing_c/parser_c.mly"
    ( fun isfake -> function Left name | Right name ->
      (if not isfake && _4 <> [] then Data.add_special_name name Data.CommaInit);
      let (init,ii) = _2 _1 _3 in
      DefineInit (init, ii @ _4) )
# 10749 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.expression) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2692 "parsing_c/parser_c.mly"
     (
       (* TOREPUT
       if fst $5 <> "0"
       then pr2 "WEIRD: in macro and have not a while(0)";
       *)
       fun _ _ -> DefineDoWhileZero ((_2,_5),   [_1;_3;_4;_6])
     )
# 10767 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'asmbody) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2700 "parsing_c/parser_c.mly"
                                         ( fun _ _ -> DefineTodo )
# 10777 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'asmbody) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2701 "parsing_c/parser_c.mly"
                                         ( fun _ _ -> DefineTodo )
# 10788 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'designator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'initialize2) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'gcc_comma_opt_struct) in
    Obj.repr(
# 2704 "parsing_c/parser_c.mly"
     ( fun isfake -> function Left name | Right name ->
       let e1 = InitDesignators (_1, _3), [_2] in
       (if not isfake && fst _4 then Data.add_special_name name Data.CommaInit);
       DefineInit (InitListNoBrace [e1, []], snd _4) )
# 10801 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'designator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'initialize2) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'initialize_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'gcc_comma_opt_struct) in
    Obj.repr(
# 2709 "parsing_c/parser_c.mly"
     ( fun isfake -> function Left name | Right name ->
       let e1 = InitDesignators (_1, _3), [_2] in
       (if not isfake && fst _6 then Data.add_special_name name Data.CommaInit);
       match List.rev _5 with
	 (first,[])::rest ->
	   DefineInit(InitListNoBrace ((e1,[])::(first,[_4])::rest), snd _6)
       | _ -> failwith "malformed list" )
# 10819 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    Obj.repr(
# 2717 "parsing_c/parser_c.mly"
                   ( fun _ _ -> DefineEmpty )
# 10825 "parsing_c/parser_c.ml"
               : 'define_val))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 2723 "parsing_c/parser_c.mly"
                        ( mk_string_wrap _1 )
# 10832 "parsing_c/parser_c.ml"
               : 'param_define))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ast_c.info) in
    Obj.repr(
# 2724 "parsing_c/parser_c.mly"
                        ( mk_string_wrap _1 )
# 10839 "parsing_c/parser_c.ml"
               : 'param_define))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2725 "parsing_c/parser_c.mly"
                        ( "...", [_1] )
# 10846 "parsing_c/parser_c.ml"
               : 'param_define))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2726 "parsing_c/parser_c.mly"
                        ( fst _1, [snd _1; _2] )
# 10854 "parsing_c/parser_c.ml"
               : 'param_define))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2727 "parsing_c/parser_c.mly"
                          ( fst _1, [snd _1; _2] )
# 10862 "parsing_c/parser_c.ml"
               : 'param_define))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2729 "parsing_c/parser_c.mly"
                        ( "register", [_1] )
# 10869 "parsing_c/parser_c.ml"
               : 'param_define))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'ifdef) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_ifdef_statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement_tail) in
    Obj.repr(
# 2736 "parsing_c/parser_c.mly"
     ( IfdefStmt1 ((_1::fst _3), (_2::snd _3)), [] )
# 10878 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.statement) in
    Obj.repr(
# 2737 "parsing_c/parser_c.mly"
             (_1)
# 10885 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'ifdefelse) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_ifdef_statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'endif) in
    Obj.repr(
# 2740 "parsing_c/parser_c.mly"
                                       ( [_1;_3], [_2] )
# 10894 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_statement_tail))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'ifdefelif) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_ifdef_statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_statement_tail) in
    Obj.repr(
# 2742 "parsing_c/parser_c.mly"
   ( (_1::fst _3), (_2::snd _3) )
# 10903 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_statement_tail))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (Ast_c.ifdef_guard * (int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2746 "parsing_c/parser_c.mly"
     ( let (cond,tag,ii) = _1 in
       IfdefDirective ((Ifdef cond, IfdefTag (Common.some !tag)),  [ii]) )
# 10911 "parsing_c/parser_c.ml"
               : 'ifdef))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : ((int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2751 "parsing_c/parser_c.mly"
     ( let (tag,ii) = _1 in
       IfdefDirective ((IfdefElse, IfdefTag (Common.some !tag)), [ii]) )
# 10919 "parsing_c/parser_c.ml"
               : 'ifdefelse))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (Ast_c.ifdef_guard * (int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2756 "parsing_c/parser_c.mly"
     ( let (cond,tag,ii) = _1 in
       IfdefDirective ((IfdefElseif cond, IfdefTag (Common.some !tag)), [ii]) )
# 10927 "parsing_c/parser_c.ml"
               : 'ifdefelif))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : ((int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2761 "parsing_c/parser_c.mly"
     ( let (tag,ii) = _1 in
       IfdefDirective ((IfdefEndif, IfdefTag (Common.some !tag)), [ii]) )
# 10935 "parsing_c/parser_c.ml"
               : 'endif))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ifdef) in
    Obj.repr(
# 2765 "parsing_c/parser_c.mly"
         ( _1 )
# 10942 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ifdefelse) in
    Obj.repr(
# 2766 "parsing_c/parser_c.mly"
             ( _1 )
# 10949 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ifdefelif) in
    Obj.repr(
# 2767 "parsing_c/parser_c.mly"
             ( _1 )
# 10956 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'endif) in
    Obj.repr(
# 2768 "parsing_c/parser_c.mly"
         ( _1 )
# 10963 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (bool * (int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2771 "parsing_c/parser_c.mly"
     ( let (_b, tag,ii) = _1 in
       IfdefDirective ((Ifdef Gnone, IfdefTag (Common.some !tag)), [ii]) )
# 10971 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (bool * (int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2774 "parsing_c/parser_c.mly"
     ( let (_b, tag,ii) = _1 in
       IfdefDirective ((Ifdef Gnone, IfdefTag (Common.some !tag)), [ii]) )
# 10979 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (bool * (int * int) option ref * Ast_c.info)) in
    Obj.repr(
# 2777 "parsing_c/parser_c.mly"
     ( let (_b, tag,ii) = _1 in
       IfdefDirective ((Ifdef Gnone, IfdefTag (Common.some !tag)), [ii]) )
# 10987 "parsing_c/parser_c.ml"
               : 'cpp_ifdef_directive))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'identifier) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'attributes_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2788 "parsing_c/parser_c.mly"
     (
       if args_are_params _3
       then
	 (* if all args are params, assume it is a prototype of a function
	    with no return type *)
	 let parameters = args_to_params _3 None in
	 let paramlist = (parameters, (false, [])) in (* no varargs *)
	 let id = RegularName (mk_string_wrap _1) in
	 let ret =
	   warning [_2] "type defaults to 'int'"
	     (mk_ty defaultInt [fakeAfterInfo()]) in
	 let ty =
	   fixOldCDecl (mk_ty (FunctionType (ret, paramlist)) [_2;_4]) in
	 let attrs = Ast_c.noattr in
	 let sto = (NoSto, false, NoAlign), [] in
	 let iistart = Ast_c.fakeBeforeInfo() in
	 Declaration(
	 DeclList ([{v_namei = Some (id,NoInit); v_type = ty;
                      v_storage = unwrap sto; v_local = NotLocalDecl;
                      v_attr = attrs; v_endattr = _5;
		      v_type_bis = ref None;
                    },[]],
                   (_6::iistart::snd sto)))
       else
	 Declaration
	   (MacroDecl
             ((NoSto, [], fst _1, _3, _5, true),
              [snd _1;_2;_4;_6;fakeBeforeInfo()]))
           (* old: MacroTop (fst $1, $3,    [snd $1;$2;$4;$5])  *)
     )
# 11028 "parsing_c/parser_c.ml"
               : 'cpp_other))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'identifier) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'compound) in
    Obj.repr(
# 2822 "parsing_c/parser_c.mly"
                                                       (
   let parameters = args_to_params _3 (Some (snd _1)) in
   let paramlist = (parameters, (false, [])) in (* no varargs *)
   let fninfo =
     let id = RegularName (mk_string_wrap _1) in
     let ret =
       warning [_2] "type defaults to 'int'"
	 (mk_ty defaultInt [fakeAfterInfo()]) in
     let ty = mk_ty (FunctionType (ret, paramlist)) [_2;_4] in
     let sto = (NoSto, false, NoAlign), [] in
     (id, fixOldCDecl ty, sto, [], []) in
   let fundef = fixFunc ((fninfo, []), _5, None) in
   Definition fundef
 )
# 11052 "parsing_c/parser_c.ml"
               : 'cpp_other))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'macro_argument_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2839 "parsing_c/parser_c.mly"
     ( Declaration
	 (MacroDecl
           ((NoSto, [], fst _1, _3, Ast_c.noattr, false),
            [snd _1;_2;_4;Ast_c.fakeBeforeInfo()])) )
# 11065 "parsing_c/parser_c.ml"
               : 'cpp_other))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'identifier) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2845 "parsing_c/parser_c.mly"
                      ( EmptyDef [snd _1;_2] )
# 11073 "parsing_c/parser_c.ml"
               : 'cpp_other))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'template_parameter_list_ne) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'external_declaration) in
    Obj.repr(
# 2855 "parsing_c/parser_c.mly"
     ( TemplateDefinition(_3,_5,[_1;_2;_4]) )
# 11084 "parsing_c/parser_c.ml"
               : 'external_declaration))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'function_definition) in
    Obj.repr(
# 2856 "parsing_c/parser_c.mly"
                                     ( Definition _1 )
# 11091 "parsing_c/parser_c.ml"
               : 'external_declaration))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 2857 "parsing_c/parser_c.mly"
                                     ( Declaration (_1 Ast_c.NotLocalDecl) )
# 11098 "parsing_c/parser_c.ml"
               : 'external_declaration))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'translation_unit) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2862 "parsing_c/parser_c.mly"
     ( !LP._lexer_hint.context_stack <- [LP.InTopLevel];
       Namespace (_4, [_1; snd _2; _3; _5]) )
# 11110 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'translation_unit) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2866 "parsing_c/parser_c.mly"
     ( !LP._lexer_hint.context_stack <- [LP.InTopLevel];
       Namespace (_3, [_1; _2; _4]) )
# 11121 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'external_declaration) in
    Obj.repr(
# 2869 "parsing_c/parser_c.mly"
                                                ( _1 )
# 11128 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.cpp_directive) in
    Obj.repr(
# 2873 "parsing_c/parser_c.mly"
     ( CppTop _1 )
# 11135 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_other) in
    Obj.repr(
# 2875 "parsing_c/parser_c.mly"
     ( _1 )
# 11142 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_ifdef_directive) in
    Obj.repr(
# 2877 "parsing_c/parser_c.mly"
     ( IfdefTop _1 )
# 11149 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'asmbody) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2880 "parsing_c/parser_c.mly"
                                                ( EmptyDef [_1;_2;_4;_5] )
# 11160 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2887 "parsing_c/parser_c.mly"
              ( EmptyDef [_1] )
# 11167 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2890 "parsing_c/parser_c.mly"
              ( FinalDef _1 )
# 11174 "parsing_c/parser_c.ml"
               : Ast_c.toplevel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'base_class_name) in
    Obj.repr(
# 2897 "parsing_c/parser_c.mly"
                                ( ClassName _1,   [] )
# 11181 "parsing_c/parser_c.ml"
               : 'base_class))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'base_class_name) in
    Obj.repr(
# 2898 "parsing_c/parser_c.mly"
                                ( CPublic _2,   [_1] )
# 11189 "parsing_c/parser_c.ml"
               : 'base_class))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'base_class_name) in
    Obj.repr(
# 2899 "parsing_c/parser_c.mly"
                                ( CProtected _2,[_1] )
# 11197 "parsing_c/parser_c.ml"
               : 'base_class))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'base_class_name) in
    Obj.repr(
# 2900 "parsing_c/parser_c.mly"
                                ( CPrivate _2,  [_1] )
# 11205 "parsing_c/parser_c.ml"
               : 'base_class))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ident_cpp) in
    Obj.repr(
# 2903 "parsing_c/parser_c.mly"
                                ( _1 )
# 11212 "parsing_c/parser_c.ml"
               : 'base_class_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'base_class) in
    Obj.repr(
# 2906 "parsing_c/parser_c.mly"
              ( [_1,[]] )
# 11219 "parsing_c/parser_c.ml"
               : 'base_classes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'base_classes) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'base_class) in
    Obj.repr(
# 2907 "parsing_c/parser_c.mly"
                                  ( _1 @ [_3,    [_2]] )
# 11228 "parsing_c/parser_c.ml"
               : 'base_classes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2913 "parsing_c/parser_c.mly"
                  ( LP.push_context LP.InFunction; LP.new_scope (); _1 )
# 11235 "parsing_c/parser_c.ml"
               : 'tobrace))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2914 "parsing_c/parser_c.mly"
                  ( LP.pop_context();              LP.del_scope (); _1 )
# 11242 "parsing_c/parser_c.ml"
               : 'tcbrace))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2916 "parsing_c/parser_c.mly"
                      ( LP.push_context LP.InEnum; _1 )
# 11249 "parsing_c/parser_c.ml"
               : 'tobrace_enum))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2917 "parsing_c/parser_c.mly"
                      ( LP.pop_context (); _1 )
# 11256 "parsing_c/parser_c.ml"
               : 'tcbrace_enum))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2919 "parsing_c/parser_c.mly"
                     ( LP.push_context LP.InInitializer; _1 )
# 11263 "parsing_c/parser_c.ml"
               : 'tobrace_ini))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2920 "parsing_c/parser_c.mly"
                     ( LP.pop_context (); _1 )
# 11270 "parsing_c/parser_c.ml"
               : 'tcbrace_ini))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2922 "parsing_c/parser_c.mly"
                                  ( LP.push_context LP.InInitializer; _1 )
# 11277 "parsing_c/parser_c.ml"
               : 'topar_ini_cxx))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2923 "parsing_c/parser_c.mly"
                 ( LP.pop_context (); _1 )
# 11284 "parsing_c/parser_c.ml"
               : 'tcpar_ini))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2925 "parsing_c/parser_c.mly"
                        ( LP.push_context LP.InStruct; _1)
# 11291 "parsing_c/parser_c.ml"
               : 'tobrace_struct))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2926 "parsing_c/parser_c.mly"
                        ( LP.pop_context (); _1 )
# 11298 "parsing_c/parser_c.ml"
               : 'tcbrace_struct))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'param_define_list) in
    Obj.repr(
# 2930 "parsing_c/parser_c.mly"
     ( LP.save_typedef_state();
       Data.set_define_params (List.map (fun x -> Ast_c.unwrap (fst x)) _1);
       _1 )
# 11307 "parsing_c/parser_c.ml"
               : 'call_param_define_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2935 "parsing_c/parser_c.mly"
     ( LP.new_scope ();et "topar" ();
       LP.push_context LP.InParameter;
       _1
     )
# 11317 "parsing_c/parser_c.ml"
               : 'topar))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2940 "parsing_c/parser_c.mly"
     ( LP.del_scope ();dt "tcpar" ();
       LP.pop_context ();
       _1
     )
# 11327 "parsing_c/parser_c.ml"
               : 'tcpar))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2946 "parsing_c/parser_c.mly"
                                   ( LP.push_context LP.InGccAttribute; [_1;_2] )
# 11335 "parsing_c/parser_c.ml"
               : 'tdouble_opar_gcc_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2947 "parsing_c/parser_c.mly"
                                   ( LP.pop_context (); [_1;_2] )
# 11343 "parsing_c/parser_c.ml"
               : 'tdouble_cpar_gcc_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2948 "parsing_c/parser_c.mly"
                                ( LP.push_context LP.InGccAttribute; [_1] )
# 11350 "parsing_c/parser_c.ml"
               : 'tdouble_ocro_cxx_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 2949 "parsing_c/parser_c.mly"
                                   ( LP.pop_context (); [_1;_2] )
# 11358 "parsing_c/parser_c.ml"
               : 'tdouble_ccro_cxx_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'string_elem) in
    Obj.repr(
# 2983 "parsing_c/parser_c.mly"
               ( _1 )
# 11365 "parsing_c/parser_c.ml"
               : 'string_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'string_elem) in
    Obj.repr(
# 2984 "parsing_c/parser_c.mly"
                           ( _1 @ _2 )
# 11373 "parsing_c/parser_c.ml"
               : 'string_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'colon_asm) in
    Obj.repr(
# 2987 "parsing_c/parser_c.mly"
             ( [_1] )
# 11380 "parsing_c/parser_c.ml"
               : 'colon_asm_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'colon_asm_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'colon_asm) in
    Obj.repr(
# 2988 "parsing_c/parser_c.mly"
                             ( _1 @ [_2] )
# 11388 "parsing_c/parser_c.ml"
               : 'colon_asm_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'colon_option) in
    Obj.repr(
# 2991 "parsing_c/parser_c.mly"
                ( [_1, []] )
# 11395 "parsing_c/parser_c.ml"
               : 'colon_option_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'colon_option_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'colon_option) in
    Obj.repr(
# 2992 "parsing_c/parser_c.mly"
                                         ( _1 @ [_3, [_2]] )
# 11404 "parsing_c/parser_c.ml"
               : 'colon_option_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'constr_extra) in
    Obj.repr(
# 2995 "parsing_c/parser_c.mly"
                                         ( [_1, []] )
# 11411 "parsing_c/parser_c.ml"
               : 'constr_extra_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'constr_extra_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'constr_extra) in
    Obj.repr(
# 2996 "parsing_c/parser_c.mly"
                                         ( _1 @ [_3,    [_2]] )
# 11420 "parsing_c/parser_c.ml"
               : 'constr_extra_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 2999 "parsing_c/parser_c.mly"
               ( [] )
# 11426 "parsing_c/parser_c.ml"
               : 'argument_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'argument_list_ne) in
    Obj.repr(
# 3000 "parsing_c/parser_c.mly"
                    ( _1 )
# 11433 "parsing_c/parser_c.ml"
               : 'argument_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'argument_ne) in
    Obj.repr(
# 3003 "parsing_c/parser_c.mly"
                                         ( [_1, []] )
# 11440 "parsing_c/parser_c.ml"
               : 'argument_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'argument_list_ne) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'argument) in
    Obj.repr(
# 3004 "parsing_c/parser_c.mly"
                                    ( _1 @ [_3,    [_2]] )
# 11449 "parsing_c/parser_c.ml"
               : 'argument_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'argument_ne_without_paramdecl) in
    Obj.repr(
# 3007 "parsing_c/parser_c.mly"
                                                         ( [_1, []] )
# 11456 "parsing_c/parser_c.ml"
               : 'argument_list_ne_without_paramdecl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'argument_list_ne) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'argument_ne_without_paramdecl) in
    Obj.repr(
# 3008 "parsing_c/parser_c.mly"
                                                         ( _1 @ [_3,    [_2]] )
# 11465 "parsing_c/parser_c.ml"
               : 'argument_list_ne_without_paramdecl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'argument) in
    Obj.repr(
# 3012 "parsing_c/parser_c.mly"
                                      ( [_1, []] )
# 11472 "parsing_c/parser_c.ml"
               : 'macro_argument_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'macro_argument_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'argument) in
    Obj.repr(
# 3013 "parsing_c/parser_c.mly"
                                       ( _1 @ [_3,    [_2]] )
# 11481 "parsing_c/parser_c.ml"
               : 'macro_argument_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'struct_decl) in
    Obj.repr(
# 3023 "parsing_c/parser_c.mly"
                                 ( [_1] )
# 11488 "parsing_c/parser_c.ml"
               : 'struct_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'struct_decl_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'struct_decl) in
    Obj.repr(
# 3024 "parsing_c/parser_c.mly"
                                 ( _1 @ [_2] )
# 11496 "parsing_c/parser_c.ml"
               : 'struct_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_struct_decl) in
    Obj.repr(
# 3027 "parsing_c/parser_c.mly"
                                     ( [_1] )
# 11503 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_struct_decl_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cpp_struct_decl) in
    Obj.repr(
# 3028 "parsing_c/parser_c.mly"
                                         ( _1 @ [_2] )
# 11511 "parsing_c/parser_c.ml"
               : 'cpp_struct_decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'struct_declarator) in
    Obj.repr(
# 3032 "parsing_c/parser_c.mly"
                                                   ( [_1,           []] )
# 11518 "parsing_c/parser_c.ml"
               : 'struct_declarator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'struct_declarator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_directive_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'struct_declarator) in
    Obj.repr(
# 3034 "parsing_c/parser_c.mly"
     ( _1 @ [_4, [_2]] )
# 11528 "parsing_c/parser_c.ml"
               : 'struct_declarator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'struct_declarator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'struct_declarator) in
    Obj.repr(
# 3035 "parsing_c/parser_c.mly"
                                                   ( _1 @ [_3,     [_2]] )
# 11537 "parsing_c/parser_c.ml"
               : 'struct_declarator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'enumerator) in
    Obj.repr(
# 3039 "parsing_c/parser_c.mly"
                                     ( [_1,          []]   )
# 11544 "parsing_c/parser_c.ml"
               : 'enumerator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'enumerator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_directive_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'enumerator) in
    Obj.repr(
# 3041 "parsing_c/parser_c.mly"
     ( _1 @ [_4, [_2]] )
# 11554 "parsing_c/parser_c.ml"
               : 'enumerator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enumerator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'enumerator) in
    Obj.repr(
# 3042 "parsing_c/parser_c.mly"
                                     ( _1 @ [_3,    [_2]] )
# 11563 "parsing_c/parser_c.ml"
               : 'enumerator_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 3043 "parsing_c/parser_c.mly"
                                     ( [] )
# 11569 "parsing_c/parser_c.ml"
               : 'enumerator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'init_declarator) in
    Obj.repr(
# 3047 "parsing_c/parser_c.mly"
                                              ( [_1,[]] )
# 11576 "parsing_c/parser_c.ml"
               : 'init_declarator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'init_declarator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'cpp_directive_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'init_declarator_attrs) in
    Obj.repr(
# 3049 "parsing_c/parser_c.mly"
     ( _1 @ [_4, [_2]] )
# 11586 "parsing_c/parser_c.ml"
               : 'init_declarator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'init_declarator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'init_declarator_attrs) in
    Obj.repr(
# 3050 "parsing_c/parser_c.mly"
                                                     ( _1 @ [_3, [_2]] )
# 11595 "parsing_c/parser_c.ml"
               : 'init_declarator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter_decl) in
    Obj.repr(
# 3054 "parsing_c/parser_c.mly"
                                        ( [_1, []] )
# 11602 "parsing_c/parser_c.ml"
               : 'parameter_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'parameter_decl) in
    Obj.repr(
# 3055 "parsing_c/parser_c.mly"
                                        ( _1 @ [_3,  [_2]] )
# 11611 "parsing_c/parser_c.ml"
               : 'parameter_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'template_parameter_decl) in
    Obj.repr(
# 3058 "parsing_c/parser_c.mly"
                                                          ( [_1, []] )
# 11618 "parsing_c/parser_c.ml"
               : 'template_parameter_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'template_parameter_list_ne) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'template_parameter_decl) in
    Obj.repr(
# 3059 "parsing_c/parser_c.mly"
                                                             ( _1 @ [_3,  [_2]] )
# 11627 "parsing_c/parser_c.ml"
               : 'template_parameter_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 3062 "parsing_c/parser_c.mly"
                           ( [_1] )
# 11634 "parsing_c/parser_c.ml"
               : 'taction_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'taction_list_ne) in
    Obj.repr(
# 3063 "parsing_c/parser_c.mly"
                           ( _1 :: _2 )
# 11642 "parsing_c/parser_c.ml"
               : 'taction_list_ne))
; (fun __caml_parser_env ->
    Obj.repr(
# 3071 "parsing_c/parser_c.mly"
                        ( [] )
# 11648 "parsing_c/parser_c.ml"
               : 'taction_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'taction_list) in
    Obj.repr(
# 3072 "parsing_c/parser_c.mly"
                        ( _1 :: _2 )
# 11656 "parsing_c/parser_c.ml"
               : 'taction_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 3075 "parsing_c/parser_c.mly"
                   ( [] )
# 11662 "parsing_c/parser_c.ml"
               : 'param_define_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'param_define) in
    Obj.repr(
# 3076 "parsing_c/parser_c.mly"
                                          ( [_1, []] )
# 11669 "parsing_c/parser_c.ml"
               : 'param_define_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'param_define_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Ast_c.info) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'param_define) in
    Obj.repr(
# 3077 "parsing_c/parser_c.mly"
                                          ( _1 @ [_3, [_2]] )
# 11678 "parsing_c/parser_c.ml"
               : 'param_define_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'designator) in
    Obj.repr(
# 3080 "parsing_c/parser_c.mly"
              ( [_1] )
# 11685 "parsing_c/parser_c.ml"
               : 'designator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'designator_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'designator) in
    Obj.repr(
# 3081 "parsing_c/parser_c.mly"
                              ( _1 @ [_2] )
# 11693 "parsing_c/parser_c.ml"
               : 'designator_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute) in
    Obj.repr(
# 3084 "parsing_c/parser_c.mly"
             ( [_1] )
# 11700 "parsing_c/parser_c.ml"
               : 'attribute_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attribute) in
    Obj.repr(
# 3085 "parsing_c/parser_c.mly"
                            ( _1 @ [_2] )
# 11708 "parsing_c/parser_c.ml"
               : 'attribute_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_list) in
    Obj.repr(
# 3087 "parsing_c/parser_c.mly"
                           ( _1 )
# 11715 "parsing_c/parser_c.ml"
               : 'attributes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_list) in
    Obj.repr(
# 3089 "parsing_c/parser_c.mly"
                               ( _1 )
# 11722 "parsing_c/parser_c.ml"
               : 'attributes_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 3090 "parsing_c/parser_c.mly"
                               ( [] )
# 11728 "parsing_c/parser_c.ml"
               : 'attributes_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.info) in
    Obj.repr(
# 3093 "parsing_c/parser_c.mly"
          (  [_1] )
# 11735 "parsing_c/parser_c.ml"
               : 'comma_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 3094 "parsing_c/parser_c.mly"
                    (  []  )
# 11741 "parsing_c/parser_c.ml"
               : 'comma_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Ast_c.expression) in
    Obj.repr(
# 3103 "parsing_c/parser_c.mly"
               ( Some _1 )
# 11748 "parsing_c/parser_c.ml"
               : 'gcc_opt_expr))
; (fun __caml_parser_env ->
    Obj.repr(
# 3104 "parsing_c/parser_c.mly"
                   ( None  )
# 11754 "parsing_c/parser_c.ml"
               : 'gcc_opt_expr))
(* Entry main *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry celem *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry statement *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry expr *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry type_name *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry cpp_directive *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry iteration *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let main (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Ast_c.program)
let celem (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : Ast_c.toplevel)
let statement (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 3 lexfun lexbuf : Ast_c.statement)
let expr (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 4 lexfun lexbuf : Ast_c.expression)
let type_name (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 5 lexfun lexbuf : Ast_c.fullType)
let cpp_directive (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 6 lexfun lexbuf : Ast_c.cpp_directive)
let iteration (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 7 lexfun lexbuf : Ast_c.iteration * Ast_c.info list)
