# 7 "parsing_cocci/lexer_script.mll"
 
open Parser_cocci_menhir
module D = Data
module Ast = Ast_cocci
exception Lexical of string
let tok = Lexing.lexeme
let language = ref ""
let inc_line _ = Lexer_cocci.line := !Lexer_cocci.line + 1

let in_comment = ref false

# 14 "parsing_cocci/lexer_script.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\242\255\243\255\244\255\001\000\001\000\252\255\253\255\
    \001\000\010\000\019\000\057\000\004\000\245\255\246\255\251\255\
    \005\000\065\000\252\255\002\000\254\255\255\255\253\255\006\000\
    \253\255\254\255\255\255";
  Lexing.lex_backtrk =
   "\255\255\255\255\255\255\255\255\006\000\005\000\255\255\255\255\
    \001\000\000\000\000\000\000\000\008\000\255\255\255\255\255\255\
    \007\000\255\255\255\255\003\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255";
  Lexing.lex_default =
   "\009\000\000\000\000\000\000\000\255\255\255\255\000\000\000\000\
    \255\255\009\000\009\000\011\000\012\000\000\000\000\000\000\000\
    \016\000\018\000\000\000\255\255\000\000\000\000\000\000\024\000\
    \000\000\000\000\000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\006\000\006\000\006\000\006\000\255\255\255\255\
    \025\000\025\000\025\000\025\000\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\000\000\003\000\011\000\022\000\000\000\000\000\002\000\
    \008\000\007\000\010\000\014\000\255\255\026\000\000\000\004\000\
    \016\000\255\255\255\255\255\255\000\000\255\255\000\000\000\000\
    \000\000\255\255\255\255\255\255\013\000\000\000\000\000\000\000\
    \005\000\015\000\255\255\255\255\012\000\012\000\012\000\000\000\
    \000\000\000\000\255\255\020\000\020\000\020\000\020\000\000\000\
    \000\000\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\012\000\000\000\000\000\000\000\000\000\
    \012\000\012\000\012\000\021\000\000\000\000\000\000\000\000\000\
    \012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\019\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\000\000\000\000\255\255\255\255\255\255\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\000\000\000\000\000\000\012\000\016\000\
    \023\000\023\000\023\000\023\000\009\000\009\000\009\000\009\000\
    \255\255\255\255\255\255\255\255\255\255\010\000\010\000\010\000\
    \010\000\255\255\000\000\000\000\019\000\255\255\255\255\000\000\
    \000\000\000\000\000\000\008\000\009\000\023\000\255\255\000\000\
    \004\000\009\000\009\000\009\000\255\255\010\000\255\255\255\255\
    \255\255\009\000\010\000\010\000\010\000\255\255\255\255\255\255\
    \000\000\005\000\010\000\011\000\011\000\011\000\011\000\255\255\
    \255\255\255\255\009\000\017\000\017\000\017\000\017\000\255\255\
    \255\255\255\255\255\255\010\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\011\000\255\255\255\255\255\255\255\255\
    \011\000\011\000\011\000\017\000\255\255\255\255\255\255\255\255\
    \011\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\011\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\017\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\012\000\016\000\023\000\255\255\
    \255\255\255\255\009\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\010\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\011\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\017\000";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec token lexbuf =
   __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 27 "parsing_cocci/lexer_script.mll"
           ( TScriptData (tok lexbuf) )
# 136 "parsing_cocci/lexer_script.ml"

  | 1 ->
# 28 "parsing_cocci/lexer_script.mll"
        ( TScriptData (tok lexbuf) )
# 141 "parsing_cocci/lexer_script.ml"

  | 2 ->
# 29 "parsing_cocci/lexer_script.mll"
        ( TScriptData (tok lexbuf) )
# 146 "parsing_cocci/lexer_script.ml"

  | 3 ->
# 31 "parsing_cocci/lexer_script.mll"
      ( inc_line();
	let text = tok lexbuf in
	let text =
	  if !language = "ocaml"
	  then
	    Printf.sprintf "%s# %d \"%s\"%s"
	      text !Lexer_cocci.line !Lexer_cocci.file text
	  else text in
	TScriptData text )
# 159 "parsing_cocci/lexer_script.ml"

  | 4 ->
# 40 "parsing_cocci/lexer_script.mll"
         ( TArobArob )
# 164 "parsing_cocci/lexer_script.ml"

  | 5 ->
# 41 "parsing_cocci/lexer_script.mll"
         ( TArob )
# 169 "parsing_cocci/lexer_script.ml"

  | 6 ->
# 42 "parsing_cocci/lexer_script.mll"
         ( TScriptData (tok lexbuf) )
# 174 "parsing_cocci/lexer_script.ml"

  | 7 ->
# 43 "parsing_cocci/lexer_script.mll"
                   ( token lexbuf )
# 179 "parsing_cocci/lexer_script.ml"

  | 8 ->
# 44 "parsing_cocci/lexer_script.mll"
                   ( token lexbuf )
# 184 "parsing_cocci/lexer_script.ml"

  | 9 ->
# 46 "parsing_cocci/lexer_script.mll"
         ( in_comment := true; TScriptData (tok lexbuf) )
# 189 "parsing_cocci/lexer_script.ml"

  | 10 ->
# 47 "parsing_cocci/lexer_script.mll"
         ( in_comment := false; TScriptData (tok lexbuf) )
# 194 "parsing_cocci/lexer_script.ml"

  | 11 ->
# 48 "parsing_cocci/lexer_script.mll"
         ( TScriptData (Printf.sprintf "\"%s\"" (string lexbuf)) )
# 199 "parsing_cocci/lexer_script.ml"

  | 12 ->
# 49 "parsing_cocci/lexer_script.mll"
         ( if !in_comment
           then TScriptData (tok lexbuf)
           else TScriptData (Printf.sprintf "'%s'" (cstring lexbuf)) )
# 206 "parsing_cocci/lexer_script.ml"

  | 13 ->
# 52 "parsing_cocci/lexer_script.mll"
         ( EOF )
# 211 "parsing_cocci/lexer_script.ml"

  | 14 ->
# 53 "parsing_cocci/lexer_script.mll"
      ( raise (Lexical ("unrecognised symbol, in token rule:"^tok lexbuf)) )
# 216 "parsing_cocci/lexer_script.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and string lexbuf =
   __ocaml_lex_string_rec lexbuf 17
and __ocaml_lex_string_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 57 "parsing_cocci/lexer_script.mll"
                        ( "" )
# 228 "parsing_cocci/lexer_script.ml"

  | 1 ->
let
# 58 "parsing_cocci/lexer_script.mll"
                                 x
# 234 "parsing_cocci/lexer_script.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 59 "parsing_cocci/lexer_script.mll"
    ( inc_line(); (Printf.sprintf "%c" x) ^ string lexbuf )
# 238 "parsing_cocci/lexer_script.ml"

  | 2 ->
# 60 "parsing_cocci/lexer_script.mll"
                        ( "\\\"" ^ string lexbuf )
# 243 "parsing_cocci/lexer_script.ml"

  | 3 ->
let
# 61 "parsing_cocci/lexer_script.mll"
          x
# 249 "parsing_cocci/lexer_script.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 61 "parsing_cocci/lexer_script.mll"
                        ( (String.make 1 x) ^ string lexbuf )
# 253 "parsing_cocci/lexer_script.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_string_rec lexbuf __ocaml_lex_state

and cstring lexbuf =
   __ocaml_lex_cstring_rec lexbuf 23
and __ocaml_lex_cstring_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 64 "parsing_cocci/lexer_script.mll"
                        ( "" )
# 265 "parsing_cocci/lexer_script.ml"

  | 1 ->
let
# 65 "parsing_cocci/lexer_script.mll"
                                 x
# 271 "parsing_cocci/lexer_script.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 66 "parsing_cocci/lexer_script.mll"
    ( inc_line(); (Printf.sprintf "%c" x) ^ cstring lexbuf )
# 275 "parsing_cocci/lexer_script.ml"

  | 2 ->
let
# 67 "parsing_cocci/lexer_script.mll"
          x
# 281 "parsing_cocci/lexer_script.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 67 "parsing_cocci/lexer_script.mll"
                        ( (String.make 1 x) ^ cstring lexbuf )
# 285 "parsing_cocci/lexer_script.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_cstring_rec lexbuf __ocaml_lex_state

;;

