"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppserviceConfig = exports.LoggingOptsSchema = void 0;
exports.read = read;
const typebox_1 = require("@sinclair/typebox");
const fs = __importStar(require("fs"));
const js_yaml_1 = require("js-yaml");
const value_1 = require("@sinclair/typebox/value");
function read(configPath) {
    const content = fs.readFileSync(configPath, "utf8");
    const jsonParsed = (0, js_yaml_1.load)(content);
    const decodedConfig = value_1.Value.Decode(exports.AppserviceConfig, jsonParsed);
    return decodedConfig;
}
exports.LoggingOptsSchema = typebox_1.Type.Object({
    console: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Literal("debug"),
        typebox_1.Type.Literal("info"),
        typebox_1.Type.Literal("warn"),
        typebox_1.Type.Literal("error"),
        typebox_1.Type.Literal("trace"),
        typebox_1.Type.Literal("off"),
    ], { description: "The log level used by the console output." })),
    json: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: "Should the logs be outputted in JSON format, for consumption by a collector.",
    })),
    colorize: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: "Should the logs color-code the level strings in the output.",
    })),
    timestampFormat: typebox_1.Type.Optional(typebox_1.Type.String({
        description: "Timestamp format used in the log output.",
        default: "HH:mm:ss:SSS",
    })),
});
exports.AppserviceConfig = typebox_1.Type.Object({
    homeserver: typebox_1.Type.Object({
        domain: typebox_1.Type.String({
            description: "The domain of the homeserver that is found at the end of mxids",
        }),
        url: typebox_1.Type.String({
            description: "The url to use to access the client server api e.g. 'https://matrix-client.matrix.org'",
        }),
    }, {
        description: "Details for the homeserver the appservice will be serving ",
    }),
    db: typebox_1.Type.Object({
        connectionString: typebox_1.Type.String({
            description: "Postgres connection string",
        }),
    }, { description: "Details for the database backend" }),
    webAPI: typebox_1.Type.Object({
        port: typebox_1.Type.Number({
            description: "Port number for the web API used to access the appservice via the widget",
        }),
    }, {
        description: "Config for the web api used to access the appservice via the widget",
    }),
    adminRoom: typebox_1.Type.String({
        description: "The admin room for the appservice bot. Not called managementRoom like draupnir on purpose, so they're not mixed in code somehow.",
    }),
    roomStateBackingStore: typebox_1.Type.Optional(typebox_1.Type.Object({
        enabled: typebox_1.Type.Boolean(),
    }, {
        description: "Store room state using sqlite to improve startup time when Synapse responds slowly to requests for `/state`.",
    })),
    dataPath: typebox_1.Type.String({
        description: "A directory where the appservice can storestore persistent data.",
        default: "/data/storage",
    }),
    logging: typebox_1.Type.Optional(exports.LoggingOptsSchema),
});
//# sourceMappingURL=config.js.map