"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
const matrix_protection_suite_1 = require("matrix-protection-suite");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
class StandardEventConsequencesRenderer {
    constructor(description, messageCollector, capability) {
        this.description = description;
        this.messageCollector = messageCollector;
        this.capability = capability;
        this.requiredEventPermissions = this.capability.requiredEventPermissions;
        this.requiredPermissions = this.capability.requiredPermissions;
        this.requiredStatePermissions = this.capability.requiredStatePermissions;
        // nothing to do.
    }
    async consequenceForEvent(roomID, eventID, reason) {
        const capabilityResult = await this.capability.consequenceForEvent(roomID, eventID, reason);
        const title = (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
            "Redacting ",
            matrix_basic_types_1.Permalinks.forEvent(roomID, eventID),
            "."));
        if ((0, matrix_protection_suite_1.isError)(capabilityResult)) {
            this.messageCollector.addOneliner(this.description, this.capability, (0, mps_interface_adaptor_1.renderFailedSingularConsequence)(this.description, title, capabilityResult.error));
            return capabilityResult;
        }
        this.messageCollector.addOneliner(this.description, this.capability, title);
        return capabilityResult;
    }
}
(0, matrix_protection_suite_1.describeCapabilityRenderer)({
    name: "StandardEventConsequences",
    description: "Renders the standard event consequences capability",
    interface: "EventConsequences",
    factory(description, draupnir, capability) {
        return new StandardEventConsequencesRenderer(description, draupnir.capabilityMessageRenderer, capability);
    },
    isDefaultForInterface: true,
});
(0, matrix_protection_suite_1.describeCapabilityContextGlue)({
    name: "StandardEventConsequences",
    glueMethod: function (protectionDescription, draupnir, capabilityProvider) {
        return capabilityProvider.factory(protectionDescription, {
            eventRedacter: draupnir.clientPlatform.toRoomEventRedacter(),
        });
    },
});
//# sourceMappingURL=StandardEventConsequencesRenderer.js.map