"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirSafeModeCommand = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const SafeModeCause_1 = require("../safemode/SafeModeCause");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
exports.DraupnirSafeModeCommand = (0, interface_manager_1.describeCommand)({
    summary: "Enter into safe mode.",
    parameters: [],
    async executor({ safeModeToggle }, info) {
        return safeModeToggle.switchToSafeMode({
            reason: SafeModeCause_1.SafeModeReason.ByRequest,
            user: info.commandSender,
        }, { sendStatusOnStart: true });
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirSafeModeCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=SafeModeCommand.js.map