import { CommandDescription } from "../Command";
import { CommandMeta } from "../Command/CommandMeta";
/**
 * This is used to add glue code to take what is essentially a god context into a more specific
 * attenuated one that can be unit tested easily.
 * So basically, rather than giving a command the entirity of Draupnir, we can
 * give it juts the capability to ban a user. Which simplifies test setup.
 */
export type AdaptorContextToCommandContextTranslationFunction<AdaptorContext, CommandContext> = (adaptorContext: AdaptorContext) => CommandContext;
export interface AdaptorContextToCommandContextTranslator<AdaptorContext> {
    translateContext<TCommandMeta extends CommandMeta>(commandDescription: CommandDescription<TCommandMeta>, adaptorContext: AdaptorContext): TCommandMeta["Context"];
    registerTranslation<TCommandMeta extends CommandMeta>(commandDescription: CommandDescription<TCommandMeta>, translationFunction: AdaptorContextToCommandContextTranslationFunction<AdaptorContext, TCommandMeta["Context"]>): AdaptorContextToCommandContextTranslator<AdaptorContext>;
}
export declare class StandardAdaptorContextToCommandContextTranslator<AdaptorContext> implements AdaptorContextToCommandContextTranslator<AdaptorContext> {
    private readonly translators;
    translateContext<TCommandMeta extends CommandMeta>(commandDescription: CommandDescription<TCommandMeta>, adaptorContext: AdaptorContext): TCommandMeta["Context"];
    registerTranslation<TCommandMeta extends CommandMeta>(commandDescription: CommandDescription<TCommandMeta>, translationFunction: AdaptorContextToCommandContextTranslationFunction<AdaptorContext, TCommandMeta["Context"]>): AdaptorContextToCommandContextTranslator<AdaptorContext>;
}
//# sourceMappingURL=AdaptorContextToCommandContextTranslator.d.ts.map