"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DirectParsedKeywords = exports.StandardParsedKeywords = void 0;
/**
 * A read only map of keywords to their associated properties.
 */
class StandardParsedKeywords {
    constructor(description, keywords) {
        this.description = description;
        this.keywords = keywords;
    }
    getKeywordValue(keyword, defaultValue = undefined) {
        const keywordDescription = this.description.keywordDescriptions[keyword];
        if (keywordDescription === undefined) {
            throw new TypeError(`${keyword} is not a keyword that has been described for this command.`);
        }
        const value = this.keywords.get(keyword);
        if (value === true) {
            return value;
        }
        else if (value !== undefined) {
            return value.object;
        }
        else {
            return defaultValue;
        }
    }
}
exports.StandardParsedKeywords = StandardParsedKeywords;
class DirectParsedKeywords {
    constructor(description, keywords) {
        this.description = description;
        this.keywords = keywords;
        // nothing to do.
    }
    getKeywordValue(keyword, defaultValue) {
        const keywordDescription = this.description.keywordDescriptions[keyword];
        if (keywordDescription === undefined) {
            throw new TypeError(`${keyword} is not a keyword that has been described for this command.`);
        }
        const value = this.keywords[keyword];
        if (value === undefined) {
            return defaultValue;
        }
        else {
            return value;
        }
    }
}
exports.DirectParsedKeywords = DirectParsedKeywords;
//# sourceMappingURL=ParsedKeywords.js.map