"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: MIT
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_result_1 = require("@gnuxie/typescript-result");
const MatrixRoomReference_1 = require("./MatrixRoomReference");
it("Parses a MatrixRoomID", function () {
    const url = "https://matrix.to/#/!foo:example.com?via=example.com";
    const parseResult = MatrixRoomReference_1.MatrixRoomReference.fromPermalink(url);
    if ((0, typescript_result_1.isError)(parseResult)) {
        throw new TypeError(`Stuff is broken mare`);
    }
    expect(parseResult.ok.toRoomIDOrAlias()).toBe("!foo:example.com");
});
it("Parses a MatrixRoomReference to an event", function () {
    const url = "https://matrix.to/#/!ljEauqZaRNkUHrjWpz%3Alocalhost%3A9999/%24Krd34VAtqnAi1GHL0CRVYBiMN4KTCaWEF_Zn3021kr8";
    const parseResult = MatrixRoomReference_1.MatrixEventReference.fromPermalink(url);
    if ((0, typescript_result_1.isError)(parseResult)) {
        throw new TypeError(`Stuff is broken mare`);
    }
    expect(parseResult.ok.eventID).toBe("$Krd34VAtqnAi1GHL0CRVYBiMN4KTCaWEF_Zn3021kr8");
});
//# sourceMappingURL=Permalinks.test.js.map