import { StringEventID, StringRoomID, StringUserID } from "@the-draupnir-project/matrix-basic-types";
import { ActionException, ActionResult, ClientPlatform, RoomEvent, RoomMessageSender } from "matrix-protection-suite";
import { MatrixReactionHandler } from "./MatrixReactionHandler";
import { BasicInvocationInformation, DocumentNode, InvocationInformationFromEventContext, MatrixInterfaceEventsFromDeadDocument, MatrixInterfaceRendererFailedCB, StandardAdaptorContextToCommandContextTranslator, StandardMatrixInterfaceAdaptor } from "@the-draupnir-project/interface-manager";
import { promptDefault, promptSuggestions } from "./MatrixPromptForAccept";
import { Result } from "@gnuxie/typescript-result";
export interface MatrixEventContext {
    roomID: StringRoomID;
    event: RoomEvent;
}
export type MatrixAdaptorContext = {
    readonly clientPlatform: ClientPlatform;
    readonly clientUserID: StringUserID;
    readonly reactionHandler: MatrixReactionHandler;
    readonly commandRoomID: StringRoomID;
};
export declare function sendMatrixEventsFromDeadDocument(messageSender: RoomMessageSender, roomID: StringRoomID, document: DocumentNode, { replyToEvent, additionalContent, }: {
    replyToEvent?: undefined | RoomEvent;
    additionalContent?: Record<string, unknown>;
}): Promise<ActionResult<StringEventID[]>>;
export declare const matrixEventsFromDeadDocument: MatrixInterfaceEventsFromDeadDocument<MatrixAdaptorContext, MatrixEventContext>;
export declare const MPSCommandDispatcherCallbacks: {
    commandFailedCB(_info: BasicInvocationInformation, command: import("@the-draupnir-project/interface-manager").Command, error: import("matrix-protection-suite").ActionError): void;
    commandUncaughtErrorCB(info: BasicInvocationInformation, body: string, error: Error): void;
    logCurrentCommandCB(info: BasicInvocationInformation, commandParts: import("@the-draupnir-project/interface-manager").Presentation<unknown>[]): void;
    convertUncaughtErrorToResultError(error: Error): ActionException;
    commandNormaliser(body: string): string;
};
export declare const rendererFailedCB: MatrixInterfaceRendererFailedCB<MatrixAdaptorContext, MatrixEventContext>;
export declare const MPSMatrixInterfaceAdaptorCallbacks: Readonly<{
    promptDefault: typeof promptDefault;
    promptSuggestions: typeof promptSuggestions;
    defaultRenderer: ({ clientPlatform, commandRoomID }: MatrixAdaptorContext, { event }: MatrixEventContext, _command: import("@the-draupnir-project/interface-manager").Command, result: Result<unknown>) => Promise<Result<void>>;
    matrixEventsFromDeadDocument: MatrixInterfaceEventsFromDeadDocument<MatrixAdaptorContext, MatrixEventContext>;
    rendererFailedCB: MatrixInterfaceRendererFailedCB<MatrixAdaptorContext, MatrixEventContext>;
    matrixEventsFromConfirmationPrompt: (adaptorContext: MatrixAdaptorContext, { event }: MatrixEventContext, command: import("@the-draupnir-project/interface-manager").CompleteCommand, document: DocumentNode) => Promise<ActionResult<void>>;
}>;
export declare const invocationInformationFromMatrixEventcontext: InvocationInformationFromEventContext<MatrixEventContext>;
export declare const MPSContextToCommandContextTranslator: StandardAdaptorContextToCommandContextTranslator<MatrixAdaptorContext>;
export declare const MPSMatrixInterfaceAdaptor: StandardMatrixInterfaceAdaptor<MatrixAdaptorContext, MatrixEventContext>;
//# sourceMappingURL=MPSMatrixInterfaceAdaptor.d.ts.map