import { RoomEvent } from '../MatrixTypes/Events';
import { PolicyRoomManager } from '../PolicyList/PolicyRoomManger';
import { EventReport } from '../Reporting/EventReport';
import { RoomMembershipManager } from '../Membership/RoomMembershipManager';
import { RoomStateManager } from '../StateTracking/StateRevisionIssuer';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export interface Client {
    readonly clientUserID: StringUserID;
    readonly roomStateManager: RoomStateManager;
    readonly policyRoomManager: PolicyRoomManager;
    readonly roomMembershipManager: RoomMembershipManager;
    /**
     * This should be called by the associated `ClientRooms`,
     * so that any membership changes can be properly processed and verified.
     * @param roomID The room ID that there was an event within.
     * @param event The event.
     */
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
    handleEventReport(report: EventReport): void;
}
//# sourceMappingURL=Client.d.ts.map