import { ActionResult } from '../Interface/Action';
import { RoomEvent } from '../MatrixTypes/Events';
import { AbstractClientRooms, ClientRooms } from './ClientRooms';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export type JoinedRoomsSafe = () => Promise<ActionResult<StringRoomID[]>>;
/**
 * An implementation of `ClientRooms` that will work for both bots and appservice
 * intents.
 */
export declare class StandardClientRooms extends AbstractClientRooms implements ClientRooms {
    private readonly joinedRoomsThunk;
    private readonly roomPauser;
    private readonly preemptivelyJoinedRooms;
    private readonly joinedRoomsCallLock;
    protected constructor(joinedRoomsThunk: JoinedRoomsSafe, ...rest: ConstructorParameters<typeof AbstractClientRooms>);
    /**
     * Create a clientRooms, initializing the joinedRoomsSet.
     * @param clientUserID The Matrix UserID of the client.
     * @param joinedRoomsThunk A thunk that returns the rooms the user is joined to.
     * @returns A new ClientRooms instance.
     */
    static makeClientRooms(clientUserID: StringUserID, joinedRoomsThunk: JoinedRoomsSafe): Promise<ActionResult<ClientRooms>>;
    get allPreemptedRooms(): StringRoomID[];
    isPreemptivelyJoinedRoom(roomID: StringRoomID): boolean;
    preemptTimelineJoin(roomID: StringRoomID): void;
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
    private handleRoomJoin;
    private handleRoomLeave;
    private checkRoomTask;
    private handleRoomChange;
}
//# sourceMappingURL=StandardClientRooms.d.ts.map