/**
 * Exposes a single method to check whether a key is a duplicate (has this event been seen before?).
 * If the key is unique, the next time the mehod is called it will mark the key as a duplicate.
 *
 */
export interface Deduplicator<Key> {
    /**
     * If the deduplicator hasn't seen the key before, then the key is not a duplicate.
     * If the deduplicator has seen the key before, then the key is a duplicate.
     * Once a key has been given to the method, it will be marked as a duplicate.
     */
    isDuplicate(key: Key): boolean;
}
export declare class StandardDeduplicator<Key> implements Deduplicator<Key> {
    private readonly keySet;
    private readonly queue;
    private readonly queueMaxSize;
    constructor(queueMaxSize?: number);
    isDuplicate(key: Key): boolean;
}
//# sourceMappingURL=Deduplicator.d.ts.map