import { TSchema } from '@sinclair/typebox';
import { EDStatic } from '../Interface/Static';
export declare const EmptyContent: import("@sinclair/typebox").TObject<{}>;
export type EmptyContent = EDStatic<typeof EmptyContent>;
export type Event<Content extends TSchema = typeof EmptyContent> = EDStatic<ReturnType<typeof Event<Content>>>;
export declare const Event: <Content extends TSchema>(Content: Content) => import("@sinclair/typebox").TObject<{
    content: Content;
    type: import("@sinclair/typebox").TString;
}>;
export type UnsignedData = EDStatic<typeof UnsignedData>;
export declare const UnsignedData: import("@sinclair/typebox").TObject<{
    age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
    redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
}>;
export type SyncRoomEvent<Content extends TSchema = typeof EmptyContent> = EDStatic<ReturnType<typeof SyncRoomEvent<Content>>>;
export declare const SyncRoomEvent: <Content extends TSchema>(Content: Content) => import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: Content;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>;
export type RoomEvent<Content extends TSchema = typeof EmptyContent> = EDStatic<ReturnType<typeof RoomEvent<Content>>>;
export declare const RoomEvent: <Content extends TSchema>(Content: Content) => import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: Content;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>;
export type SyncStateEvent<Content extends TSchema = typeof EmptyContent> = EDStatic<ReturnType<typeof SyncStateEvent<Content>>>;
export declare const SyncStateEvent: <Content extends TSchema>(Content: Content) => import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: Content;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>;
export type StateEvent<Content extends TSchema = typeof EmptyContent> = EDStatic<ReturnType<typeof StateEvent<Content>>>;
export declare const StateEvent: <Content extends TSchema>(Content: Content) => import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: Content;
    type: import("@sinclair/typebox").TString;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
}>]>;
export type StrippedStateEvent = EDStatic<typeof StrippedStateEvent>;
export declare const StrippedStateEvent: import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TUnknown;
    state_key: import("@sinclair/typebox").TString;
    type: import("@sinclair/typebox").TString;
    sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
}>;
//# sourceMappingURL=Events.d.ts.map