"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TombstoneEvent = exports.TombstoneEventContent = void 0;
// Copyright 2025 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
const typebox_1 = require("@sinclair/typebox");
const Events_1 = require("./Events");
const StringlyTypedMatrix_1 = require("./StringlyTypedMatrix");
exports.TombstoneEventContent = typebox_1.Type.Partial(typebox_1.Type.Object({
    body: typebox_1.Type.String({ description: 'A server-defined message.' }),
    replacement_room: typebox_1.Type.Union([StringlyTypedMatrix_1.StringRoomIDSchema], {
        description: 'The room ID of the new room the client should be visiting.',
    }),
}));
exports.TombstoneEvent = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.StateEvent)(exports.TombstoneEventContent), ['state_key', 'type']),
    typebox_1.Type.Object({
        state_key: typebox_1.Type.String({
            description: 'A zero-length string.',
            pattern: '^$',
        }),
        type: typebox_1.Type.Union([typebox_1.Type.Literal('m.room.tombstone')]),
    }),
]);
//# sourceMappingURL=Tombstone.js.map