"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeRoomMembershipManager = void 0;
const Action_1 = require("../Interface/Action");
// TODO: This sucks and should be backed by the RoomStateManager only.
//       I should hope that by now the concrete version in MPSForBotSDK
//       can just be moved here and replace this.
class FakeRoomMembershipManager {
    constructor(roomMembershipRevisionIssuers = []) {
        this.roomMembershipRevisionIssuers = new Map();
        for (const issuer of roomMembershipRevisionIssuers) {
            this.roomMembershipRevisionIssuers.set(issuer.room.toRoomIDOrAlias(), issuer);
        }
    }
    async getRoomMembershipRevisionIssuer(room) {
        const issuer = this.roomMembershipRevisionIssuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            return Action_1.ActionError.Result(`Canont find the room ${room.toRoomIDOrAlias()}`);
        }
        return (0, Action_1.Ok)(issuer);
    }
    getRoomMembershipEvents(_room) {
        throw new TypeError(`The FakeRoomMembershipManager is not capable of fetching MembershipEvents`);
    }
    // These methods are for reflecting on the Fake side of the FakeRoomMembershipManager.
    getFakeRoomMembershpRevisionIssuer(room) {
        const issuer = this.roomMembershipRevisionIssuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            throw new TypeError(`You haven't yet given the room ${room.toPermalink()} to the FakeRoomMembershipManager`);
        }
        return issuer;
    }
    addIssuer(issuer) {
        this.roomMembershipRevisionIssuers.set(issuer.room.toRoomIDOrAlias(), issuer);
    }
}
exports.FakeRoomMembershipManager = FakeRoomMembershipManager;
//# sourceMappingURL=FakeRoomMembershipManager.js.map