import { MatrixGlob } from '@the-draupnir-project/matrix-basic-types';
import { PolicyRuleEvent, PolicyRuleType, UnredactedPolicyContent } from '../MatrixTypes/PolicyEvents';
import { Result } from '@gnuxie/typescript-result';
export declare enum Recommendation {
    Ban = "m.ban",
    /**
     * This is a rule that recommends allowing a user to participate.
     * Used for the construction of allow lists.
     */
    Allow = "org.matrix.mjolnir.allow",
    /**
     * This recommendation is to takedown the entity and is usually reserved
     * for content that needs to be removed asap.
     */
    Takedown = "org.matrix.msc4204.takedown",
    Unknown = "unknown"
}
export declare function normaliseRecommendation(recommendation: string): Recommendation;
export declare function makeReversedHashedPolicy(entity: string, hashedPolicy: HashedLiteralPolicyRule): LiteralPolicyRule;
export declare function parsePolicyRule(event: Omit<PolicyRuleEvent, 'content'> & {
    content: UnredactedPolicyContent;
}): Result<PolicyRule>;
export declare enum PolicyRuleMatchType {
    Literal = "literal",
    Glob = "glob",
    HashedLiteral = "hashed-literal"
}
type PolicyRuleBase = {
    readonly recommendation: Recommendation;
    readonly reason?: string;
    readonly kind: PolicyRuleType;
    readonly sourceEvent: PolicyRuleEvent;
    readonly matchType: PolicyRuleMatchType;
    readonly isReversedFromHashedPolicy?: boolean;
};
export type LiteralPolicyRule = PolicyRuleBase & {
    readonly entity: string;
    readonly matchType: PolicyRuleMatchType.Literal;
    readonly reason: string;
    isMatch(entity: string): boolean;
};
export type GlobPolicyRule = PolicyRuleBase & {
    readonly entity: string;
    readonly glob: MatrixGlob;
    readonly matchType: PolicyRuleMatchType.Glob;
    isMatch(entity: string): boolean;
};
export type HashedLiteralPolicyRule = PolicyRuleBase & {
    readonly hashes: Record<string, string>;
    readonly matchType: PolicyRuleMatchType.HashedLiteral;
};
export type PolicyRule = LiteralPolicyRule | GlobPolicyRule | HashedLiteralPolicyRule;
export type EntityPolicyRule = LiteralPolicyRule | GlobPolicyRule;
export {};
//# sourceMappingURL=PolicyRule.d.ts.map