import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomStateEventSender } from '../../../Client/RoomStateEventSender';
import { ActionResult } from '../../../Interface/Action';
import { ProtectedRoomsSet } from '../../ProtectedRoomsSet';
import { Capability } from '../CapabilityProvider';
import { RoomSetResult } from './RoomSetResult';
import { ServerConsequences } from './ServerConsequences';
import './ServerConsequences';
import { PolicyListRevisionIssuer } from '../../../PolicyList/PolicyListRevisionIssuer';
export declare class ServerACLConequences implements ServerConsequences, Capability {
    private readonly protectedRoomsSet;
    readonly requiredPermissions: never[];
    readonly requiredEventPermissions: never[];
    readonly requiredStatePermissions: string[];
    private readonly queue;
    constructor(stateEventSender: RoomStateEventSender, protectedRoomsSet: ProtectedRoomsSet);
    private applyPolicyRevisionToSet;
    consequenceForServersInRoom(roomID: StringRoomID, revisionIssuer: PolicyListRevisionIssuer): Promise<ActionResult<boolean>>;
    consequenceForServersInRoomSet(revisionIssuer: PolicyListRevisionIssuer): Promise<ActionResult<RoomSetResult>>;
    unbanServerFromRoomSet(serverName: string, _reason: string): Promise<ActionResult<RoomSetResult>>;
}
export type ServerACLConsequencesContext = {
    stateEventSender: RoomStateEventSender;
    protectedRoomsSet: ProtectedRoomsSet;
};
//# sourceMappingURL=ServerACLConsequences.d.ts.map