"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const ɵRepository = __importStar(require("ts-auto-mock/repository"));
const ɵExtension = __importStar(require("ts-auto-mock/extension"));
const ɵMerge = __importStar(require("ts-auto-mock/merge"));
const ɵRandom = __importStar(require("ts-auto-mock/random"));
ɵRepository.ɵRepository.instance.registerFactory("@OkResult_1", function (t) { return (function () { var d = {}, m = { "isOkay": !0 }; Object.defineProperties(m, {
    "ok": { get() { return d.hasOwnProperty("ok") ? d["ok"] : d["ok"] = (function () {
            const generic = t.find(generic => {
                return generic.i.indexOf("@OkResult_1Ok") >= 0;
            });
            if (generic) {
                return generic.w();
            }
            return null;
        })(); }, set(v) { d["ok"] = v; }, enumerable: !0 },
    "match": { get() { return d.hasOwnProperty("match") ? d["match"] : d["match"] = ɵExtension.Provider.instance.getMethod("match", () => {
            return (function () {
                const generic = t.find(generic => {
                    return generic.i.indexOf("@match_1T") >= 0;
                });
                if (generic) {
                    return generic.w();
                }
                return null;
            })();
        }); }, set(v) { d["match"] = v; }, enumerable: !0 },
    "expect": { get() { return d.hasOwnProperty("expect") ? d["expect"] : d["expect"] = ɵExtension.Provider.instance.getMethod("expect", () => {
            return null;
        }); }, set(v) { d["expect"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
ɵRepository.ɵRepository.instance.registerFactory("@Result_1", function (t) { return ɵRepository.ɵRepository.instance.getFactory("@OkResult_1")([{
        i: ["@OkResult_1Ok"],
        w: function () { return (function () {
            const generic = t.find(generic => {
                return generic.i.indexOf("@Result_1Ok") >= 0;
            });
            if (generic) {
                return generic.w();
            }
            return null;
        })(); }
    }]); });
ɵRepository.ɵRepository.instance.registerFactory("@StringEventID_1", function (t) { return void 0; });
ɵRepository.ɵRepository.instance.registerFactory("@ResultError_1", function (t) { return (function () { var d = {}, m = { "message": "", "mostRelevantElaboration": "" }; Object.defineProperties(m, {
    "elaborate": { get() { return d.hasOwnProperty("elaborate") ? d["elaborate"] : d["elaborate"] = ɵExtension.Provider.instance.getMethod("elaborate", () => {
            return ɵRepository.ɵRepository.instance.getFactory("@ResultError_1")(t);
        }); }, set(v) { d["elaborate"] = v; }, enumerable: !0 },
    "getElaborations": { get() { return d.hasOwnProperty("getElaborations") ? d["getElaborations"] : d["getElaborations"] = ɵExtension.Provider.instance.getMethod("getElaborations", () => {
            return [];
        }); }, set(v) { d["getElaborations"] = v; }, enumerable: !0 },
    "toReadableString": { get() { return d.hasOwnProperty("toReadableString") ? d["toReadableString"] : d["toReadableString"] = ɵExtension.Provider.instance.getMethod("toReadableString", () => {
            return "";
        }); }, set(v) { d["toReadableString"] = v; }, enumerable: !0 },
    "toString": { get() { return d.hasOwnProperty("toString") ? d["toString"] : d["toString"] = ɵExtension.Provider.instance.getMethod("toString", () => {
            return "";
        }); }, set(v) { d["toString"] = v; }, enumerable: !0 },
    "toExpectError": { get() { return d.hasOwnProperty("toExpectError") ? d["toExpectError"] : d["toExpectError"] = ɵExtension.Provider.instance.getMethod("toExpectError", () => {
            return void 0;
        }); }, set(v) { d["toExpectError"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
ɵRepository.ɵRepository.instance.registerFactory("@RoomStateEventSender_1", function (t) { return (function () { var d = {}, m = {}; Object.defineProperties(m, {
    "sendStateEvent": { get() { return d.hasOwnProperty("sendStateEvent") ? d["sendStateEvent"] : d["sendStateEvent"] = ɵExtension.Provider.instance.getMethod("sendStateEvent", () => {
            return Promise.resolve(ɵRepository.ɵRepository.instance.getFactory("@Result_1")([{
                    i: ["@Result_1Ok"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@StringEventID_1")([]); }
                }, {
                    i: ["@Result_1Error"],
                    w: function () { return ɵRepository.ɵRepository.instance.getFactory("@ResultError_1")([]); }
                }]));
        }); }, set(v) { d["sendStateEvent"] = v; }, enumerable: !0 }
}); Object.defineProperty(m, ɵExtension.ɵMarker.instance.get(), { value: !0 }); return m; })(); });
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const ts_auto_mock_1 = require("ts-auto-mock");
const PolicyEvents_1 = require("../../../MatrixTypes/PolicyEvents");
const PolicyRule_1 = require("../../../PolicyList/PolicyRule");
const DeclareRoomState_1 = require("../../../StateTracking/DeclareRoomState");
const EventGeneration_1 = require("../../../TestUtilities/EventGeneration");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const typescript_result_1 = require("@gnuxie/typescript-result");
const ServerACLConsequences_1 = require("./ServerACLConsequences");
const StandardPolicyListRevision_1 = require("../../../PolicyList/StandardPolicyListRevision");
test('Adding and removing server policies causes the servers to be banned', async function () {
    const badServer = 'badpeople.example.com';
    const policyRoom = (0, EventGeneration_1.randomRoomID)([]);
    const protectedRoom = (0, EventGeneration_1.randomRoomID)([]);
    const { protectedRoomsSet, roomStateManager } = await (0, DeclareRoomState_1.describeProtectedRoomsSet)({
        rooms: [
            {
                room: protectedRoom,
            },
        ],
        lists: [
            {
                room: policyRoom,
                policyDescriptions: [
                    {
                        entity: badServer,
                        recommendation: PolicyRule_1.Recommendation.Ban,
                        type: PolicyEvents_1.PolicyRuleType.Server,
                    },
                ],
            },
        ],
    });
    const policyRevisionIssuer = protectedRoomsSet.watchedPolicyRooms.revisionIssuer;
    const protectedRoomIssuer = (await roomStateManager.getRoomStateRevisionIssuer(protectedRoom)).expect('Should be able to find the revision issuer');
    const fakeStateEventSender = ɵMerge.ɵMerge.merge(ɵRepository.ɵRepository.instance.getFactory("@RoomStateEventSender_1")([]), {
        async sendStateEvent(rawRoom, stateType, stateKey, content) {
            const room = typeof rawRoom === 'string'
                ? matrix_basic_types_1.MatrixRoomReference.fromRoomID(rawRoom)
                : rawRoom;
            const event = (0, DeclareRoomState_1.describeStateEvent)({
                state_key: stateKey,
                type: stateType,
                content,
                sender: (0, EventGeneration_1.randomUserID)(),
            });
            roomStateManager.appendStateEvents(room, [event]);
            return (0, typescript_result_1.Ok)(event.event_id);
        },
    });
    const serverConsequences = new ServerACLConsequences_1.ServerACLConequences(fakeStateEventSender, protectedRoomsSet);
    const initialACLResult = (await serverConsequences.consequenceForServersInRoom(protectedRoom.toRoomIDOrAlias(), policyRevisionIssuer)).expect('Should be able to set the initial ACL');
    expect(initialACLResult).toBe(true);
    const initialACLEvent = protectedRoomIssuer.currentRevision.getStateEvent('m.room.server_acl', '');
    if (initialACLEvent === undefined) {
        throw new TypeError('Should be able to find the initial ACL event');
    }
    expect(initialACLEvent.content.deny).toContain(badServer);
    const removeResult = (await serverConsequences.consequenceForServersInRoom(protectedRoom.toRoomIDOrAlias(), {
        currentRevision: StandardPolicyListRevision_1.StandardPolicyListRevision.blankRevision(),
    })).expect('Should be able to remove the ACL');
    expect(removeResult).toBe(true);
    const removedACLEvent = protectedRoomIssuer.currentRevision.getStateEvent('m.room.server_acl', '');
    if (removedACLEvent === undefined) {
        throw new TypeError('Should be able to find the removed ACL event');
    }
    expect(removedACLEvent.content.deny).not.toContain(badServer);
});
//# sourceMappingURL=ServerACLConsequences.test.js.map