"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimulatedUserConsequences = void 0;
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
const CapabilityProvider_1 = require("../CapabilityProvider");
const StandardUserConsequences_1 = require("./StandardUserConsequences");
const FakeRoomBanner = Object.freeze({
    banUser(_room, _userID, _reason) {
        return Promise.resolve((0, typescript_result_1.Ok)(undefined));
    },
});
const FakeRoomUnbanner = Object.freeze({
    unbanUser(_room, _userID, _reason) {
        return Promise.resolve((0, typescript_result_1.Ok)(undefined));
    },
});
class SimulatedUserConsequences {
    constructor(setMembership) {
        this.setMembership = setMembership;
        this.requiredPermissions = [];
        this.requiredEventPermissions = [];
        this.requiredStatePermissions = [];
        this.isSimulated = true;
        this.simulatedCapability = new StandardUserConsequences_1.StandardUserConsequences(FakeRoomBanner, FakeRoomUnbanner, this.setMembership);
        // nothing to do.
    }
    async consequenceForUserInRoom(roomID, user, reason) {
        return await this.simulatedCapability.consequenceForUserInRoom(roomID, user, reason);
    }
    async consequenceForUsersInRoom(roomID, users) {
        return await this.simulatedCapability.consequenceForUsersInRoom(roomID, users);
    }
    async consequenceForUsersInRoomSet(users) {
        return await this.simulatedCapability.consequenceForUsersInRoomSet(users);
    }
    async unbanUserFromRoomSet(userID, reason) {
        return await this.simulatedCapability.unbanUserFromRoomSet(userID, reason);
    }
}
exports.SimulatedUserConsequences = SimulatedUserConsequences;
(0, CapabilityProvider_1.describeCapabilityProvider)({
    name: 'SimulatedUserConsequences',
    description: 'Simulates banning users from the protected rooms set, but has no real effects',
    interface: 'UserConsequences',
    isSimulated: true,
    factory(_description, context) {
        return new SimulatedUserConsequences(context.setMembership);
    },
});
//# sourceMappingURL=SimulatedUserConsequences.js.map