"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const Action_1 = require("../../Interface/Action");
const FakePersistentMatrixData_1 = require("../../Interface/FakePersistentMatrixData");
const PolicyEvents_1 = require("../../MatrixTypes/PolicyEvents");
const PolicyRule_1 = require("../../PolicyList/PolicyRule");
const DeclareRoomState_1 = require("../../StateTracking/DeclareRoomState");
const FakePolicyRoomManager_1 = require("../../StateTracking/FakePolicyRoomManager");
const MjolnirPolicyRoomsConfig_1 = require("./MjolnirPolicyRoomsConfig");
const DummyClientPlatform_1 = require("../../Client/DummyClientPlatform");
const StandardWatchedPolicyRooms_1 = require("../WatchedPolicyRooms/StandardWatchedPolicyRooms");
test('That creating a MjolnirPolicyRoomsConfig will correctly load rooms that already have policies in them', async function () {
    const targetUser = '@spam:example.com';
    const policyRoom = (0, DeclareRoomState_1.describeRoom)({
        policyDescriptions: [
            {
                entity: targetUser,
                type: PolicyEvents_1.PolicyRuleType.User,
            },
        ],
    });
    const policyRoomManager = new FakePolicyRoomManager_1.FakePolicyRoomManager([
        policyRoom.policyRevisionIssuer,
    ]);
    const policyListConfigAccountData = new FakePersistentMatrixData_1.FakePersistentConfigBackend({
        references: [policyRoom.policyRevisionIssuer.room.toPermalink()],
    });
    const policyRoomsConfigResult = await MjolnirPolicyRoomsConfig_1.MjolnirPolicyRoomsConfig.createFromStore(policyListConfigAccountData, DummyClientPlatform_1.DummyRoomJoiner);
    if ((0, Action_1.isError)(policyRoomsConfigResult)) {
        throw new TypeError(`Couldn't create the fake policy rooms config to setup the test`);
    }
    const watchedPolicyRooms = (await StandardWatchedPolicyRooms_1.StandardWatchedPolicyRooms.create(policyRoomsConfigResult.ok, policyRoomManager, DummyClientPlatform_1.DummyRoomJoiner)).expect('Should be able to create the watched policy rooms with the mjolnir config');
    expect(watchedPolicyRooms.currentRevision.allRules().length).toBe(1);
    expect(watchedPolicyRooms.currentRevision.findRuleMatchingEntity(targetUser, {
        type: PolicyEvents_1.PolicyRuleType.User,
        recommendation: PolicyRule_1.Recommendation.Ban,
        searchHashedRules: false,
    })).toBeDefined();
});
//# sourceMappingURL=MjolnirPolicyRoomsConfig.test.js.map