"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractProtection = void 0;
exports.registerProtection = registerProtection;
exports.findProtection = findProtection;
exports.describeProtection = describeProtection;
exports.getAllProtections = getAllProtections;
const CapabilitySet_1 = require("./Capability/CapabilitySet");
const CapabilityInterface_1 = require("./Capability/CapabilityInterface");
const CapabilityProvider_1 = require("./Capability/CapabilityProvider");
const ConfigDescription_1 = require("../Config/ConfigDescription");
const typebox_1 = require("@sinclair/typebox");
class AbstractProtection {
    constructor(description, capabilitySet, protectedRoomsSet, permissions) {
        var _a, _b, _c;
        this.description = description;
        this.capabilitySet = capabilitySet;
        this.protectedRoomsSet = protectedRoomsSet;
        this.clientEventPermissions = (_a = permissions.requiredEventPermissions) !== null && _a !== void 0 ? _a : [];
        this.clientPermissions = (_b = permissions.requiredPermissions) !== null && _b !== void 0 ? _b : [];
        this.clientStatePermissions = (_c = permissions.requiredStatePermissions) !== null && _c !== void 0 ? _c : [];
    }
    get requiredEventPermissions() {
        return [
            ...this.clientEventPermissions,
            ...(0, CapabilitySet_1.capabilitySetEventPermissions)(this.capabilitySet),
        ];
    }
    get requiredPermissions() {
        return [
            ...this.clientPermissions,
            ...(0, CapabilitySet_1.capabilitySetPermissions)(this.capabilitySet),
        ];
    }
    get requiredStatePermissions() {
        return [
            ...this.clientStatePermissions,
            ...(0, CapabilitySet_1.capabilitySetStatePermissions)(this.capabilitySet),
        ];
    }
}
exports.AbstractProtection = AbstractProtection;
const PROTECTIONS = new Map();
function registerProtection(description) {
    if (PROTECTIONS.has(description.name)) {
        throw new TypeError(`There is already a protection registered with the name ${description.name}`);
    }
    PROTECTIONS.set(description.name, description);
    return description;
}
function findProtection(name) {
    return PROTECTIONS.get(name);
}
function describeProtection({ name, description, capabilityInterfaces, defaultCapabilities, factory, configSchema, }) {
    const capabilityInterfaceSet = (0, CapabilityInterface_1.findCapabilityInterfaceSet)(capabilityInterfaces);
    const defaultCapabilitySet = (0, CapabilityProvider_1.findCapabilityProviderSet)(defaultCapabilities);
    const protectionDescription = {
        name,
        description,
        capabilities: capabilityInterfaceSet,
        defaultCapabilities: defaultCapabilitySet,
        factory,
        protectionSettings: new ConfigDescription_1.StandardConfigDescription(configSchema !== null && configSchema !== void 0 ? configSchema : typebox_1.Type.Object({})),
    };
    registerProtection(protectionDescription);
    return protectionDescription;
}
function getAllProtections() {
    return PROTECTIONS.values();
}
//# sourceMappingURL=Protection.js.map