import { ActionResult } from '../../Interface/Action';
import { AbstractProtection, Protection, ProtectionDescription } from '../Protection';
import { MembershipChange } from '../../Membership/MembershipChange';
import { RoomMembershipRevision } from '../../Membership/MembershipRevision';
import { ProtectedRoomsSet } from '../ProtectedRoomsSet';
import { UserConsequences } from '../Capability/StandardCapability/UserConsequences';
import '../Capability/StandardCapability/UserConsequences';
import '../Capability/StandardCapability/StandardUserConsequences';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { UnknownConfig } from '../../Config/ConfigDescription';
import { SetMembershipPolicyRevision } from '../../MembershipPolicies/MembershipPolicyRevision';
export type MemberBanSynchronisationProtectionDescription = ProtectionDescription<unknown, UnknownConfig, MemberBanSynchronisationProtectionCapabilities>;
export declare class MemberBanSynchronisationProtection extends AbstractProtection<MemberBanSynchronisationProtectionDescription> implements Protection<MemberBanSynchronisationProtectionDescription> {
    private readonly userConsequences;
    constructor(description: MemberBanSynchronisationProtectionDescription, capabilities: MemberBanSynchronisationProtectionCapabilities, protectedRoomsSet: ProtectedRoomsSet);
    handleSetMembershipPolicyMatchesChange(revision: SetMembershipPolicyRevision): void;
    handleMembershipChange(revision: RoomMembershipRevision, changes: MembershipChange[]): Promise<ActionResult<void>>;
    synchroniseWithRevision(revision: SetMembershipPolicyRevision): Promise<ActionResult<void>>;
    handlePermissionRequirementsMet(room: MatrixRoomID): void;
}
export type MemberBanSynchronisationProtectionCapabilities = {
    userConsequences: UserConsequences;
};
//# sourceMappingURL=MemberBanSynchronisation.d.ts.map